### CVE-2018-8120

#### Describe

An elevation of privilege vulnerability exists in Windows when the Win32k component fails to properly handle objects in memory, aka "Win32k Elevation of Privilege Vulnerability." 

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 7           | x86/x64          | SP1     |        | &#10004; |
| Windows Server 2008 | x86/x64          | SP2     |        |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8120
```

#### Utilization

CompilerEnvironment

- VS2019（V120）X64 Release
- VS2019（V120）X32 Release，Need to remove shellcode.asm after compiling

Test system Windows 7 SP1 x64

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2018-8120_win7_x64.gif)

#### Analyze
- https://github.com/EVOL4/CVE-2018-8120/blob/master/CVE-2018-8120.md
- https://b2ahex.github.io/blog/2018/05/15/8120%E5%88%86%E6%9E%90/index.html
- https://paper.seebug.org/614/
- https://xz.aliyun.com/t/8667
- http://xz.aliyun.com/t/5966