### CVE-2018-8120

#### 描述

Microsoft Windows中存在提权漏洞，该漏洞源于Win32k组件NtUserSetImeInfoEx函数内部SetImeInfoEx函数的没有正确的处理内存中的空指针对象。攻击者可利用该空指针漏洞在内核模式下以提升的权限执行任意代码。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 7           | x86/x64          | SP1     |        | &#10004; |
| Windows Server 2008 | x86/x64          | SP2     |        |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8120
```

#### 利用方式

编译环境

- VS2019（V120）X64 Release
- VS2019（V120）X32 Release，需要移除shellcode.asm这个文件后编译

当前测试系统Windows 7 SP1 x64

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2018-8120_win7_x64.gif)

#### 分析文章
- https://github.com/EVOL4/CVE-2018-8120/blob/master/CVE-2018-8120.md
- https://b2ahex.github.io/blog/2018/05/15/8120%E5%88%86%E6%9E%90/index.html
- https://paper.seebug.org/614/
- https://xz.aliyun.com/t/8667
- http://xz.aliyun.com/t/5966