### CVE-2016-7255

#### 描述

如果 Windows 内核模式驱动程序无法正确处理内存中对象，则会存在多个特权提升漏洞。成功利用此漏洞的攻击者可以在内核模式下运行任意代码。攻击者可随后安装程序；查看、更改或删除数据；或者创建拥有完全用户权限的新帐户。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        | &#10004; |
| Windows 10          | x86/x64          | 1511    |        | &#10004; |
| Windows 10          | x86/x64          | 1607    |        |                    |
| Windows 7           | x86/x64          |         | SP1    | &#10004; |
| Windows 8.1         | x86/x64          |         |        | &#10004; |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    | &#10004; |
| Windows Server 2008 | x86/x64          | R2      | SP1    | &#10004; |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Vista       |                  |         | SP2    |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2016-7255
```

#### 利用方式

编译环境

- VS2019（V140）X64 Release

该漏洞通杀所有受影响的系统X64版本，有三个EXP可以使用，目前`windows_7_8_10_2008_x64`文件夹内的文件和`CVE-2016-7255.ps1`通杀所有系统，`CVE-2016-7255_windows_2008_x64`文件夹内文件在Windows Server 2008 R2 SP1 x64上可以使用，Windows 7 SP1 x64系统上会导致蓝屏

通过ps脚本进行演示，直接上GIF图

![3](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-7255_win7_x86.gif) 

#### 分析文章
- https://www.anquanke.com/post/id/85232