#pragma once
#include "stdafx.h"

#define UP 2
#define DOWN 0

typedef void*(NTAPI *lHMValidateHandle)(HWND h, int type);

//from https://www.reactos.org/wiki/Techwiki:Win32k/HEAD
typedef struct _HEAD
{
	HANDLE h;
	DWORD  cLockObj;
} HEAD, *PHEAD;

typedef struct _THROBJHEAD
{
	HEAD h;
	PVOID pti;
} THROBJHEAD, *PTHROBJHEAD;
//
typedef struct _THRDESKHEAD
{
	THROBJHEAD h;
	PVOID    rpdesk;
	PVOID       pSelf;   // points to the kernel mode address
} THRDESKHEAD, *PTHRDESKHEAD;

typedef struct _PROCOBJHEAD
{
	HEAD h;
	DWORD hTaskWow;
} PROCOBJHEAD, *PPROCOBJHEAD;
//
typedef struct _PROCDESKHEAD
{
	PROCOBJHEAD h;
	PVOID    rpdesk;
	PVOID       pSelf;
} PROCDESKHEAD, *PPROCDESKHEAD;

typedef struct _PROCMARKHEAD
{
	PROCOBJHEAD h;
	PVOID ppi;
} PROCMARKHEAD, *PPROCMARKHEAD;

//from https://www.reactos.org/wiki/Techwiki:Win32k/LARGE_UNICODE_STRING
typedef struct _LARGE_UNICODE_STRING
{
	ULONG Length;           // 000
	ULONG MaximumLength : 31; // 004
	ULONG bAnsi : 1;          // 004
	PWSTR Buffer;           // 008
} LARGE_UNICODE_STRING, *PLARGE_UNICODE_STRING;