#include <Windows.h>
#include <stdio.h>
#pragma comment(lib, "user32")
#pragma comment(lib, "kernel32")

typedef struct _EPROCESS_QUOTA_ENTRY
{
	ULONG      Usage;
	ULONG      Limit;
	ULONG      Peak;
	ULONG      Return;
} EPROCESS_QUOTA_ENTRY, *PEPROCESS_QUOTA_ENTRY;

typedef struct _EPROCESS_QUOTA_BLOCK {
	EPROCESS_QUOTA_ENTRY    QuotaEntry[3];
	LIST_ENTRY              QuotaList;
	ULONG                   ReferenceCount;
	ULONG                   ProcessCount;
} EPROCESS_QUOTA_BLOCK, *PEPROCESS_QUOTA_BLOCK;

typedef struct _HANDLEENTRY{
    PVOID  phead;       
    ULONG  pOwner;      
    BYTE  bType;        
    BYTE  bFlags;       
    WORD  wUniq;       
}HANDLEENTRY,*PHANDLEENTRY;

typedef struct _SERVERINFO{   
    DWORD dwSRVIFlags;
	DWORD cHandleEntries;   
    WORD wSRVIFlags;      
    WORD wRIPPID;         
    WORD wRIPError;

    
}SERVERINFO,*PSERVERINFO;

typedef struct _SHAREDINFO{
    PSERVERINFO psi;      
    PHANDLEENTRY aheList;
	ULONG HeEntrySize; // Win7 - not present in WinXP?
    ULONG_PTR pDispInfo;      
    ULONG_PTR ulSharedDelta;
	ULONG_PTR awmControl; // Not in XP
    ULONG_PTR DefWindowMsgs; // Not in XP
    ULONG_PTR DefWindowSpecMsgs; // Not in XP
}SHAREDINFO,*PSHAREDINFO;

FARPROC NtAllocateVirtualMemory;
FARPROC NtFreeVirtualMemory;

typedef struct ThreadData {
	HWND unicodeWindow;
    HWND ansiWindow;
	HWND ansiKernelWindow;
	ULONG_PTR ptr;
} ThreadData, *PThreadData;

typedef struct _EPROCESS
{
	PVOID Pcb;	//   +0x000 Pcb              : _KPROCESS
	PVOID ProcessLock;	//   +0x098 ProcessLock      : _EX_PUSH_LOCK
	PVOID CreateTime;	//	+0x0a0 CreateTime       : _LARGE_INTEGER
    PVOID ExitTime;	//	+0x0a8 ExitTime         : _LARGE_INTEGER
	PVOID RundownProtect;	// +0x0b0 RundownProtect   : _EX_RUNDOWN_REF
	PVOID UniqueProcessId; //+0x0b4 UniqueProcessId  : Ptr32 Void
	PVOID ActiveProcessLinks; //+0x0b8 ActiveProcessLinks : _LIST_ENTRY
	PVOID ProcessQuotaUsage; //+0x0c0 ProcessQuotaUsage : [2] Uint4B
	PVOID ProcessQuotaPeak; //+0x0c8 ProcessQuotaPeak : [2] Uint4B
	PVOID CommitCharge; //+0x0d0 CommitCharge     : Uint4B
	PVOID QuotaBlock; //+0x0d4 QuotaBlock       : Ptr32 _EPROCESS_QUOTA_BLOCK
	// Rest We dont care about
}EPROCESS, *PEPROCESS;
