#pragma once

#include <Windows.h>
#include <string>

class FileOpLock
{
public:
	typedef void(*UserCallback)();
	static FileOpLock* CreateLock(const std::wstring& name, FileOpLock::UserCallback cb, HANDLE hfile);
	//the new functions work with an available handle since the installer is calling
	//SetSecurityFile we will not be able to acquire a new handle
	//it took time to modify them since they're sensitive however I did it
	//the new function are :
	//CreateLock() override
	static FileOpLock* CreateLock(const std::wstring& name, FileOpLock::UserCallback cb);
	void WaitForLock(UINT Timeout);

	~FileOpLock();
private:

	HANDLE g_hFile;
	OVERLAPPED g_o;
	REQUEST_OPLOCK_INPUT_BUFFER g_inputBuffer;
	REQUEST_OPLOCK_OUTPUT_BUFFER g_outputBuffer;
	HANDLE g_hLockCompleted;
	PTP_WAIT g_wait;
	UserCallback _cb;

	FileOpLock(UserCallback cb);

	static void CALLBACK WaitCallback(PTP_CALLBACK_INSTANCE Instance,
		PVOID Parameter, PTP_WAIT Wait,
		TP_WAIT_RESULT WaitResult);
	static void CALLBACK WaitCallback2(PTP_CALLBACK_INSTANCE Instance,
		PVOID Parameter, PTP_WAIT Wait,
		TP_WAIT_RESULT WaitResult);
	void DoWaitCallback();
	void DoWaitCallbackt();
	bool BeginLock(const std::wstring& filename, HANDLE hfile);
	bool BeginLock(const std::wstring& name);

};

