package net.katagaitai.phpscan.php.builtin;

import net.katagaitai.phpscan.compiler.BuiltinBase;
import net.katagaitai.phpscan.interpreter.Interpreter;
import net.katagaitai.phpscan.symbol.SymbolOperator;

public class Standard_defines extends BuiltinBase {
	public Standard_defines(Interpreter ip) {
		super(ip);
		SymbolOperator operator = ip.getOperator();
		putConstant("\\CONNECTION_ABORTED", operator.createSymbol(1));
		putConstant("\\CONNECTION_NORMAL", operator.createSymbol(0));
		putConstant("\\CONNECTION_TIMEOUT", operator.createSymbol(2));
		putConstant("\\INI_USER", operator.createSymbol(1));
		putConstant("\\INI_PERDIR", operator.createSymbol(2));
		putConstant("\\INI_SYSTEM", operator.createSymbol(4));
		putConstant("\\INI_ALL", operator.createSymbol(7));
		putConstant("\\INI_SCANNER_NORMAL", operator.createSymbol(0));
		putConstant("\\INI_SCANNER_TYPED", operator.createSymbol(2));
		putConstant("\\INI_SCANNER_RAW", operator.createSymbol(1));
		putConstant("\\PHP_URL_SCHEME", operator.createSymbol(0));
		putConstant("\\PHP_URL_HOST", operator.createSymbol(1));
		putConstant("\\PHP_URL_PORT", operator.createSymbol(2));
		putConstant("\\PHP_URL_USER", operator.createSymbol(3));
		putConstant("\\PHP_URL_PASS", operator.createSymbol(4));
		putConstant("\\PHP_URL_PATH", operator.createSymbol(5));
		putConstant("\\PHP_URL_QUERY", operator.createSymbol(6));
		putConstant("\\PHP_URL_FRAGMENT", operator.createSymbol(7));
		putConstant("\\M_E", operator.createSymbol(2.718281828459));
		putConstant("\\M_LOG2E", operator.createSymbol(1.442695040889));
		putConstant("\\M_LOG10E", operator.createSymbol(0.43429448190325));
		putConstant("\\M_LN2", operator.createSymbol(0.69314718055995));
		putConstant("\\M_LN10", operator.createSymbol(2.302585092994));
		putConstant("\\M_PI", operator.createSymbol(3.1415926535898));
		putConstant("\\M_PI_2", operator.createSymbol(1.5707963267949));
		putConstant("\\M_PI_4", operator.createSymbol(0.78539816339745));
		putConstant("\\M_1_PI", operator.createSymbol(0.31830988618379));
		putConstant("\\M_2_PI", operator.createSymbol(0.63661977236758));
		putConstant("\\M_SQRTPI", operator.createSymbol(1.7724538509055));
		putConstant("\\M_2_SQRTPI", operator.createSymbol(1.1283791670955));
		putConstant("\\M_LNPI", operator.createSymbol(1.1447298858494));
		putConstant("\\M_EULER", operator.createSymbol(0.57721566490153));
		putConstant("\\M_SQRT2", operator.createSymbol(1.4142135623731));
		putConstant("\\M_SQRT1_2", operator.createSymbol(0.70710678118655));
		putConstant("\\M_SQRT3", operator.createSymbol(1.7320508075689));
		putConstant("\\INF", operator.createSymbol(Double.POSITIVE_INFINITY));
		putConstant("\\NAN", operator.createSymbol(Double.NaN));
		putConstant("\\PHP_ROUND_HALF_UP", operator.createSymbol(1));
		putConstant("\\PHP_ROUND_HALF_DOWN", operator.createSymbol(2));
		putConstant("\\PHP_ROUND_HALF_EVEN", operator.createSymbol(3));
		putConstant("\\PHP_ROUND_HALF_ODD", operator.createSymbol(4));
		putConstant("\\INFO_GENERAL", operator.createSymbol(1));
		putConstant("\\INFO_CREDITS", operator.createSymbol(2));
		putConstant("\\INFO_CONFIGURATION", operator.createSymbol(4));
		putConstant("\\INFO_MODULES", operator.createSymbol(8));
		putConstant("\\INFO_ENVIRONMENT", operator.createSymbol(16));
		putConstant("\\INFO_VARIABLES", operator.createSymbol(32));
		putConstant("\\INFO_LICENSE", operator.createSymbol(64));
		putConstant("\\INFO_ALL", operator.createSymbol(4294967295L));
		putConstant("\\CREDITS_GROUP", operator.createSymbol(1));
		putConstant("\\CREDITS_GENERAL", operator.createSymbol(2));
		putConstant("\\CREDITS_SAPI", operator.createSymbol(4));
		putConstant("\\CREDITS_MODULES", operator.createSymbol(8));
		putConstant("\\CREDITS_DOCS", operator.createSymbol(16));
		putConstant("\\CREDITS_FULLPAGE", operator.createSymbol(32));
		putConstant("\\CREDITS_QA", operator.createSymbol(64));
		putConstant("\\CREDITS_ALL", operator.createSymbol(4294967295L));
		putConstant("\\HTML_SPECIALCHARS", operator.createSymbol(0));
		putConstant("\\HTML_ENTITIES", operator.createSymbol(1));
		putConstant("\\ENT_COMPAT", operator.createSymbol(2));
		putConstant("\\ENT_QUOTES", operator.createSymbol(3));
		putConstant("\\ENT_NOQUOTES", operator.createSymbol(0));
		putConstant("\\ENT_IGNORE", operator.createSymbol(4));
		putConstant("\\STR_PAD_LEFT", operator.createSymbol(0));
		putConstant("\\STR_PAD_RIGHT", operator.createSymbol(1));
		putConstant("\\STR_PAD_BOTH", operator.createSymbol(2));
		putConstant("\\PATHINFO_DIRNAME", operator.createSymbol(1));
		putConstant("\\PATHINFO_BASENAME", operator.createSymbol(2));
		putConstant("\\PATHINFO_EXTENSION", operator.createSymbol(4));
		putConstant("\\PATHINFO_FILENAME", operator.createSymbol(8));
		putConstant("\\CHAR_MAX", operator.createSymbol(127));
		putConstant("\\LC_CTYPE", operator.createSymbol(0));
		putConstant("\\LC_NUMERIC", operator.createSymbol(1));
		putConstant("\\LC_TIME", operator.createSymbol(2));
		putConstant("\\LC_COLLATE", operator.createSymbol(3));
		putConstant("\\LC_MONETARY", operator.createSymbol(4));
		putConstant("\\LC_ALL", operator.createSymbol(6));
		putConstant("\\LC_MESSAGES", operator.createSymbol(5));
		putConstant("\\SEEK_SET", operator.createSymbol(0));
		putConstant("\\SEEK_CUR", operator.createSymbol(1));
		putConstant("\\SEEK_END", operator.createSymbol(2));
		putConstant("\\LOCK_SH", operator.createSymbol(1));
		putConstant("\\LOCK_EX", operator.createSymbol(2));
		putConstant("\\LOCK_UN", operator.createSymbol(3));
		putConstant("\\LOCK_NB", operator.createSymbol(4));
		putConstant("\\STREAM_NOTIFY_CONNECT", operator.createSymbol(2));
		putConstant("\\STREAM_NOTIFY_AUTH_REQUIRED", operator.createSymbol(3));
		putConstant("\\STREAM_NOTIFY_AUTH_RESULT", operator.createSymbol(10));
		putConstant("\\STREAM_NOTIFY_MIME_TYPE_IS", operator.createSymbol(4));
		putConstant("\\STREAM_NOTIFY_FILE_SIZE_IS", operator.createSymbol(5));
		putConstant("\\STREAM_NOTIFY_REDIRECTED", operator.createSymbol(6));
		putConstant("\\STREAM_NOTIFY_PROGRESS", operator.createSymbol(7));
		putConstant("\\STREAM_NOTIFY_FAILURE", operator.createSymbol(9));
		putConstant("\\STREAM_NOTIFY_COMPLETED", operator.createSymbol(8));
		putConstant("\\STREAM_NOTIFY_RESOLVE", operator.createSymbol(1));
		putConstant("\\STREAM_NOTIFY_SEVERITY_INFO", operator.createSymbol(0));
		putConstant("\\STREAM_NOTIFY_SEVERITY_WARN", operator.createSymbol(1));
		putConstant("\\STREAM_NOTIFY_SEVERITY_ERR", operator.createSymbol(2));
		putConstant("\\STREAM_FILTER_READ", operator.createSymbol(1));
		putConstant("\\STREAM_FILTER_WRITE", operator.createSymbol(2));
		putConstant("\\STREAM_FILTER_ALL", operator.createSymbol(3));
		putConstant("\\STREAM_CLIENT_PERSISTENT", operator.createSymbol(1));
		putConstant("\\STREAM_CLIENT_ASYNC_CONNECT", operator.createSymbol(2));
		putConstant("\\STREAM_CLIENT_CONNECT", operator.createSymbol(4));
		putConstant("\\STREAM_SHUT_RD", operator.createSymbol(0));
		putConstant("\\STREAM_SHUT_WR", operator.createSymbol(1));
		putConstant("\\STREAM_SHUT_RDWR", operator.createSymbol(2));
		putConstant("\\STREAM_PF_INET", operator.createSymbol(2));
		putConstant("\\STREAM_PF_INET6", operator.createSymbol(10));
		putConstant("\\STREAM_PF_UNIX", operator.createSymbol(1));
		putConstant("\\STREAM_IPPROTO_IP", operator.createSymbol(0));
		putConstant("\\STREAM_IPPROTO_TCP", operator.createSymbol(6));
		putConstant("\\STREAM_IPPROTO_UDP", operator.createSymbol(17));
		putConstant("\\STREAM_IPPROTO_ICMP", operator.createSymbol(1));
		putConstant("\\STREAM_IPPROTO_RAW", operator.createSymbol(255));
		putConstant("\\STREAM_SOCK_STREAM", operator.createSymbol(1));
		putConstant("\\STREAM_SOCK_DGRAM", operator.createSymbol(2));
		putConstant("\\STREAM_SOCK_RAW", operator.createSymbol(3));
		putConstant("\\STREAM_SOCK_SEQPACKET", operator.createSymbol(5));
		putConstant("\\STREAM_SOCK_RDM", operator.createSymbol(4));
		putConstant("\\STREAM_PEEK", operator.createSymbol(2));
		putConstant("\\STREAM_OOB", operator.createSymbol(1));
		putConstant("\\STREAM_SERVER_BIND", operator.createSymbol(4));
		putConstant("\\STREAM_SERVER_LISTEN", operator.createSymbol(8));
		putConstant("\\FILE_USE_INCLUDE_PATH", operator.createSymbol(1));
		putConstant("\\FILE_IGNORE_NEW_LINES", operator.createSymbol(2));
		putConstant("\\FILE_SKIP_EMPTY_LINES", operator.createSymbol(4));
		putConstant("\\FILE_APPEND", operator.createSymbol(8));
		putConstant("\\FILE_NO_DEFAULT_CONTEXT", operator.createSymbol(16));
		putConstant("\\FILE_TEXT", operator.createSymbol(0));
		putConstant("\\FILE_BINARY", operator.createSymbol(0));
		putConstant("\\FNM_NOESCAPE", operator.createSymbol(2));
		putConstant("\\FNM_PATHNAME", operator.createSymbol(1));
		putConstant("\\FNM_PERIOD", operator.createSymbol(4));
		putConstant("\\FNM_CASEFOLD", operator.createSymbol(16));
		putConstant("\\PSFS_PASS_ON", operator.createSymbol(2));
		putConstant("\\PSFS_FEED_ME", operator.createSymbol(1));
		putConstant("\\PSFS_ERR_FATAL", operator.createSymbol(0));
		putConstant("\\PSFS_FLAG_NORMAL", operator.createSymbol(0));
		putConstant("\\PSFS_FLAG_FLUSH_INC", operator.createSymbol(1));
		putConstant("\\PSFS_FLAG_FLUSH_CLOSE", operator.createSymbol(2));
		putConstant("\\ABDAY_1", operator.createSymbol(131072));
		putConstant("\\ABDAY_2", operator.createSymbol(131073));
		putConstant("\\ABDAY_3", operator.createSymbol(131074));
		putConstant("\\ABDAY_4", operator.createSymbol(131075));
		putConstant("\\ABDAY_5", operator.createSymbol(131076));
		putConstant("\\ABDAY_6", operator.createSymbol(131077));
		putConstant("\\ABDAY_7", operator.createSymbol(131078));
		putConstant("\\DAY_1", operator.createSymbol(131079));
		putConstant("\\DAY_2", operator.createSymbol(131080));
		putConstant("\\DAY_3", operator.createSymbol(131081));
		putConstant("\\DAY_4", operator.createSymbol(131082));
		putConstant("\\DAY_5", operator.createSymbol(131083));
		putConstant("\\DAY_6", operator.createSymbol(131084));
		putConstant("\\DAY_7", operator.createSymbol(131085));
		putConstant("\\ABMON_1", operator.createSymbol(131086));
		putConstant("\\ABMON_2", operator.createSymbol(131087));
		putConstant("\\ABMON_3", operator.createSymbol(131088));
		putConstant("\\ABMON_4", operator.createSymbol(131089));
		putConstant("\\ABMON_5", operator.createSymbol(131090));
		putConstant("\\ABMON_6", operator.createSymbol(131091));
		putConstant("\\ABMON_7", operator.createSymbol(131092));
		putConstant("\\ABMON_8", operator.createSymbol(131093));
		putConstant("\\ABMON_9", operator.createSymbol(131094));
		putConstant("\\ABMON_10", operator.createSymbol(131095));
		putConstant("\\ABMON_11", operator.createSymbol(131096));
		putConstant("\\ABMON_12", operator.createSymbol(131097));
		putConstant("\\MON_1", operator.createSymbol(131098));
		putConstant("\\MON_2", operator.createSymbol(131099));
		putConstant("\\MON_3", operator.createSymbol(131100));
		putConstant("\\MON_4", operator.createSymbol(131101));
		putConstant("\\MON_5", operator.createSymbol(131102));
		putConstant("\\MON_6", operator.createSymbol(131103));
		putConstant("\\MON_7", operator.createSymbol(131104));
		putConstant("\\MON_8", operator.createSymbol(131105));
		putConstant("\\MON_9", operator.createSymbol(131106));
		putConstant("\\MON_10", operator.createSymbol(131107));
		putConstant("\\MON_11", operator.createSymbol(131108));
		putConstant("\\MON_12", operator.createSymbol(131109));
		putConstant("\\AM_STR", operator.createSymbol(131110));
		putConstant("\\PM_STR", operator.createSymbol(131111));
		putConstant("\\D_T_FMT", operator.createSymbol(131112));
		putConstant("\\D_FMT", operator.createSymbol(131113));
		putConstant("\\T_FMT", operator.createSymbol(131114));
		putConstant("\\T_FMT_AMPM", operator.createSymbol(131115));
		putConstant("\\ERA", operator.createSymbol(131116));
		putConstant("\\ERA_D_T_FMT", operator.createSymbol(131120));
		putConstant("\\ERA_D_FMT", operator.createSymbol(131118));
		putConstant("\\ERA_T_FMT", operator.createSymbol(131121));
		putConstant("\\ALT_DIGITS", operator.createSymbol(131119));
		putConstant("\\CRNCYSTR", operator.createSymbol(262159));
		putConstant("\\RADIXCHAR", operator.createSymbol(65536));
		putConstant("\\THOUSEP", operator.createSymbol(65537));
		putConstant("\\YESEXPR", operator.createSymbol(327680));
		putConstant("\\NOEXPR", operator.createSymbol(327681));
		putConstant("\\CODESET", operator.createSymbol(14));
		putConstant("\\CRYPT_SALT_LENGTH", operator.createSymbol(123));
		putConstant("\\CRYPT_STD_DES", operator.createSymbol(1));
		putConstant("\\CRYPT_EXT_DES", operator.createSymbol(1));
		putConstant("\\CRYPT_MD5", operator.createSymbol(1));
		putConstant("\\CRYPT_BLOWFISH", operator.createSymbol(1));
		putConstant("\\CRYPT_SHA256", operator.createSymbol(1));
		putConstant("\\CRYPT_SHA512", operator.createSymbol(1));
		putConstant("\\DIRECTORY_SEPARATOR", operator.createSymbol("/"));
		putConstant("\\PATH_SEPARATOR", operator.createSymbol(":"));
		putConstant("\\GLOB_BRACE", operator.createSymbol(1024));
		putConstant("\\GLOB_MARK", operator.createSymbol(2));
		putConstant("\\GLOB_NOSORT", operator.createSymbol(4));
		putConstant("\\GLOB_NOCHECK", operator.createSymbol(16));
		putConstant("\\GLOB_NOESCAPE", operator.createSymbol(64));
		putConstant("\\GLOB_ERR", operator.createSymbol(1));
		putConstant("\\GLOB_ONLYDIR", operator.createSymbol(8192));
		putConstant("\\GLOB_AVAILABLE_FLAGS", operator.createSymbol(9303));
		putConstant("\\EXTR_OVERWRITE", operator.createSymbol(0));
		putConstant("\\EXTR_SKIP", operator.createSymbol(1));
		putConstant("\\EXTR_PREFIX_SAME", operator.createSymbol(2));
		putConstant("\\EXTR_PREFIX_ALL", operator.createSymbol(3));
		putConstant("\\EXTR_PREFIX_INVALID", operator.createSymbol(4));
		putConstant("\\EXTR_PREFIX_IF_EXISTS", operator.createSymbol(5));
		putConstant("\\EXTR_IF_EXISTS", operator.createSymbol(6));
		putConstant("\\EXTR_REFS", operator.createSymbol(256));
		putConstant("\\SORT_ASC", operator.createSymbol(4));
		putConstant("\\SORT_DESC", operator.createSymbol(3));
		putConstant("\\SORT_REGULAR", operator.createSymbol(0));
		putConstant("\\SORT_NUMERIC", operator.createSymbol(1));
		putConstant("\\SORT_STRING", operator.createSymbol(2));
		putConstant("\\SORT_LOCALE_STRING", operator.createSymbol(5));
		putConstant("\\CASE_LOWER", operator.createSymbol(0));
		putConstant("\\CASE_UPPER", operator.createSymbol(1));
		putConstant("\\COUNT_NORMAL", operator.createSymbol(0));
		putConstant("\\COUNT_RECURSIVE", operator.createSymbol(1));
		putConstant("\\ASSERT_ACTIVE", operator.createSymbol(1));
		putConstant("\\ASSERT_CALLBACK", operator.createSymbol(2));
		putConstant("\\ASSERT_BAIL", operator.createSymbol(3));
		putConstant("\\ASSERT_WARNING", operator.createSymbol(4));
		putConstant("\\ASSERT_QUIET_EVAL", operator.createSymbol(5));
		putConstant("\\STREAM_USE_PATH", operator.createSymbol(1));
		putConstant("\\STREAM_IGNORE_URL", operator.createSymbol(2));
		putConstant("\\STREAM_ENFORCE_SAFE_MODE", operator.createSymbol(4));
		putConstant("\\STREAM_REPORT_ERRORS", operator.createSymbol(8));
		putConstant("\\STREAM_MUST_SEEK", operator.createSymbol(16));
		putConstant("\\STREAM_URL_STAT_LINK", operator.createSymbol(1));
		putConstant("\\STREAM_URL_STAT_QUIET", operator.createSymbol(2));
		putConstant("\\STREAM_MKDIR_RECURSIVE", operator.createSymbol(1));
		putConstant("\\STREAM_IS_URL", operator.createSymbol(1));
		putConstant("\\STREAM_OPTION_BLOCKING", operator.createSymbol(1));
		putConstant("\\STREAM_OPTION_READ_TIMEOUT", operator.createSymbol(4));
		putConstant("\\STREAM_OPTION_READ_BUFFER", operator.createSymbol(2));
		putConstant("\\STREAM_OPTION_WRITE_BUFFER", operator.createSymbol(3));
		putConstant("\\STREAM_BUFFER_NONE", operator.createSymbol(0));
		putConstant("\\STREAM_BUFFER_LINE", operator.createSymbol(1));
		putConstant("\\STREAM_BUFFER_FULL", operator.createSymbol(2));
		putConstant("\\STREAM_CAST_AS_STREAM", operator.createSymbol(0));
		putConstant("\\STREAM_CAST_FOR_SELECT", operator.createSymbol(3));
		putConstant("\\IMAGETYPE_GIF", operator.createSymbol(1));
		putConstant("\\IMAGETYPE_JPEG", operator.createSymbol(2));
		putConstant("\\IMAGETYPE_PNG", operator.createSymbol(3));
		putConstant("\\IMAGETYPE_SWF", operator.createSymbol(4));
		putConstant("\\IMAGETYPE_PSD", operator.createSymbol(5));
		putConstant("\\IMAGETYPE_BMP", operator.createSymbol(6));
		putConstant("\\IMAGETYPE_TIFF_II", operator.createSymbol(7));
		putConstant("\\IMAGETYPE_TIFF_MM", operator.createSymbol(8));
		putConstant("\\IMAGETYPE_JPC", operator.createSymbol(9));
		putConstant("\\IMAGETYPE_JP2", operator.createSymbol(10));
		putConstant("\\IMAGETYPE_JPX", operator.createSymbol(11));
		putConstant("\\IMAGETYPE_JB2", operator.createSymbol(12));
		putConstant("\\IMAGETYPE_SWC", operator.createSymbol(13));
		putConstant("\\IMAGETYPE_IFF", operator.createSymbol(14));
		putConstant("\\IMAGETYPE_WBMP", operator.createSymbol(15));
		putConstant("\\IMAGETYPE_JPEG2000", operator.createSymbol(9));
		putConstant("\\IMAGETYPE_XBM", operator.createSymbol(16));
		putConstant("\\IMAGETYPE_ICO", operator.createSymbol(17));
		putConstant("\\IMAGETYPE_UNKNOWN", operator.createSymbol(0));
		putConstant("\\IMAGETYPE_COUNT", operator.createSymbol(18));
		putConstant("\\DNS_A", operator.createSymbol(1));
		putConstant("\\DNS_NS", operator.createSymbol(2));
		putConstant("\\DNS_CNAME", operator.createSymbol(16));
		putConstant("\\DNS_SOA", operator.createSymbol(32));
		putConstant("\\DNS_PTR", operator.createSymbol(2048));
		putConstant("\\DNS_HINFO", operator.createSymbol(4096));
		putConstant("\\DNS_MX", operator.createSymbol(16384));
		putConstant("\\DNS_TXT", operator.createSymbol(32768));
		putConstant("\\DNS_SRV", operator.createSymbol(33554432));
		putConstant("\\DNS_NAPTR", operator.createSymbol(67108864));
		putConstant("\\DNS_AAAA", operator.createSymbol(134217728));
		putConstant("\\DNS_A6", operator.createSymbol(16777216));
		putConstant("\\DNS_ANY", operator.createSymbol(268435456));
		putConstant("\\DNS_ALL", operator.createSymbol(251713587));
		putConstant("\\PHP_QUERY_RFC1738", operator.createSymbol(1));
		putConstant("\\PHP_QUERY_RFC3986", operator.createSymbol(2));
		putConstant("\\PHP_MANDIR", operator.createSymbol("/usr/local/php/php/man"));
		putConstant("\\PHP_BINARY", operator.createSymbol("/usr/local/php/bin/php"));
		putConstant("\\PHP_OUTPUT_HANDLER_WRITE", operator.createSymbol(0));
		putConstant("\\PHP_OUTPUT_HANDLER_FLUSH", operator.createSymbol(4));
		putConstant("\\PHP_OUTPUT_HANDLER_CLEAN", operator.createSymbol(2));
		putConstant("\\PHP_OUTPUT_HANDLER_FINAL", operator.createSymbol(8));
		putConstant("\\PHP_OUTPUT_HANDLER_CLEANABLE", operator.createSymbol(16));
		putConstant("\\PHP_OUTPUT_HANDLER_FLUSHABLE", operator.createSymbol(32));
		putConstant("\\PHP_OUTPUT_HANDLER_REMOVABLE", operator.createSymbol(64));
		putConstant("\\PHP_OUTPUT_HANDLER_STDFLAGS", operator.createSymbol(112));
		putConstant("\\PHP_OUTPUT_HANDLER_STARTED", operator.createSymbol(4096));
		putConstant("\\PHP_OUTPUT_HANDLER_DISABLED", operator.createSymbol(8192));
		putConstant("\\LIBXML_PEDANTIC", operator.createSymbol(128));
		putConstant("\\ZLIB_ENCODING_RAW", operator.createSymbol(-15));
		putConstant("\\ZLIB_ENCODING_GZIP", operator.createSymbol(31));
		putConstant("\\ZLIB_ENCODING_DEFLATE", operator.createSymbol(15));
		putConstant("\\FILTER_SANITIZE_FULL_SPECIAL_CHARS", operator.createSymbol(515));
		putConstant("\\SID", operator.createSymbol("name=ID"));
		putConstant("\\PHP_SESSION_DISABLED", operator.createSymbol(0));
		putConstant("\\PHP_SESSION_NONE", operator.createSymbol(1));
		putConstant("\\PHP_SESSION_ACTIVE", operator.createSymbol(2));
		putConstant("\\MCAST_JOIN_GROUP", operator.createSymbol(42));
		putConstant("\\MCAST_LEAVE_GROUP", operator.createSymbol(45));
		putConstant("\\MCAST_BLOCK_SOURCE", operator.createSymbol(43));
		putConstant("\\MCAST_UNBLOCK_SOURCE", operator.createSymbol(44));
		putConstant("\\MCAST_JOIN_SOURCE_GROUP", operator.createSymbol(46));
		putConstant("\\MCAST_LEAVE_SOURCE_GROUP", operator.createSymbol(47));
		putConstant("\\IP_MULTICAST_IF", operator.createSymbol(32));
		putConstant("\\IP_MULTICAST_TTL", operator.createSymbol(33));
		putConstant("\\IP_MULTICAST_LOOP", operator.createSymbol(34));
		putConstant("\\IPV6_MULTICAST_IF", operator.createSymbol(17));
		putConstant("\\IPV6_MULTICAST_HOPS", operator.createSymbol(18));
		putConstant("\\IPV6_MULTICAST_LOOP", operator.createSymbol(19));
		putConstant("\\IPPROTO_IP", operator.createSymbol(0));
		putConstant("\\IPPROTO_IPV6", operator.createSymbol(41));
		putConstant("\\ENT_SUBSTITUTE", operator.createSymbol(8));
		putConstant("\\ENT_DISALLOWED", operator.createSymbol(128));
		putConstant("\\ENT_HTML401", operator.createSymbol(0));
		putConstant("\\ENT_XML1", operator.createSymbol(16));
		putConstant("\\ENT_XHTML", operator.createSymbol(32));
		putConstant("\\ENT_HTML5", operator.createSymbol(48));
		putConstant("\\SCANDIR_SORT_ASCENDING", operator.createSymbol(0));
		putConstant("\\SCANDIR_SORT_DESCENDING", operator.createSymbol(1));
		putConstant("\\SCANDIR_SORT_NONE", operator.createSymbol(2));
		putConstant("\\SORT_NATURAL", operator.createSymbol(6));
		putConstant("\\SORT_FLAG_CASE", operator.createSymbol(8));
		putConstant("\\STREAM_META_TOUCH", operator.createSymbol(1));
		putConstant("\\STREAM_META_OWNER", operator.createSymbol(3));
		putConstant("\\STREAM_META_OWNER_NAME", operator.createSymbol(2));
		putConstant("\\STREAM_META_GROUP", operator.createSymbol(5));
		putConstant("\\STREAM_META_GROUP_NAME", operator.createSymbol(4));
		putConstant("\\STREAM_META_ACCESS", operator.createSymbol(6));
	}
}
