package net.katagaitai.phpscan;

import java.util.List;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;
import net.katagaitai.phpscan.command.Command;
import net.katagaitai.phpscan.interpreter.Interpreter;
import net.katagaitai.phpscan.interpreter.SourcePosition;
import net.katagaitai.phpscan.taint.Taint;

import com.google.common.collect.Lists;

@ToString
@EqualsAndHashCode
public class Vulnerability {
	@Getter
	private VulnerabilityCategory category;
	@Getter
	private List<SourcePosition> positionList;
	@Getter
	private List<SourcePosition> callStack;
	@Getter
	private List<String> commentList;
	@Getter
	private List<Command> commandList;

	public Vulnerability(VulnerabilityCategory category2, Interpreter ip, Taint taint) {
		category = category2;
		positionList = Lists.newArrayList(taint.getPositionList());
		callStack = Lists.newArrayList(ip.getCallStack());
		commentList = Lists.newArrayList(taint.getCommentList());
		commandList = Lists.newArrayList(taint.getCommandList());
	}
}
