<?php
// Start of password v.
/**
 * <p>
 * <b>PASSWORD_BCRYPT</b> is used to create new password
 * hashes using the <b>CRYPT_BLOWFISH</b> algorithm.
 * </p>
 * <p>
 * This will always result in a hash using the "$2y$" crypt format,
 * which is always 60 characters wide.
 * </p>
 * <p>
 * Supported Options:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <em>salt</em> - to manually provide a salt to use when hashing the password.
 * Note that this will override and prevent a salt from being automatically generated.
 * </p>
 * <p>
 * If omitted, a random salt will be generated by {@link "http://www.php.net/manual/en/function.password-hash.php" password_hash()} for
 * each password hashed. This is the intended mode of operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * <em>cost</em> - which denotes the algorithmic cost that should be used.
 * Examples of these values can be found on the {@link "http://www.php.net/manual/en/function.crypt.php crypt()"} page.
 * </p>
 * <p>
 * If ommitted, a default value of <em>10</em> will be used. This is a good
 * baseline cost, but you may want to consider increasing it depending on your hardware.
 * </p>
 * </li>
 * </ul>
 * @link http://www.php.net/manual/en/password.constants.php
 */
define("PASSWORD_DEFAULT", 1);

/**
 * <p>
 * The default algorithm to use for hashing if no algorithm is provided.
 * This may change in newer PHP releases when newer, stronger hashing
 * algorithms are supported.
 * </p>
 * <p>
 * It is worth noting that over time this constant can (and likely will)
 * change. Therefore you should be aware that the length of the resulting
 * hash can change. Therefore, if you use <b>PASSWORD_DEFAULT</b>
 * you should store the resulting hash in a way that can store more than 60
 * characters (255 is the recomended width).
 * </p>
 * <p>
 * Values for this constant:
 * </p>
 *<ul>
 * <li>
 * PHP 5.5.0 - <b>PASSWORD_BCRYPT</b>
 * </li>
 * </ul>
 */
define("PASSWORD_BCRYPT", 1);

/**
 * (PHP 5 &gt;= 5.5.0, PHP 5)<br/>
 *
 * Returns information about the given hash
 * @link http://www.php.net/manual/en/function.password-get-info.php
 * @param string $hash A hash created by password_hash().
 * @return array Returns an associative array with three elements:
 * <ul>
 * <li>
 * <em>algo</em>, which will match a
 * {@link http://www.php.net/manual/en/password.constants.php password algorithm constant}
 * </li>
 * <li>
 * <em>algoName</em>, which has the human readable name of the algorithm
 * </li>
 * <li>
 * <em>options</em>, which includes the options
 * provided when calling  @link http://www.php.net/manual/en/function.password-hash.php" password_hash()
 * </li>
 * </ul>
 */
function password_get_info ($hash) {}

/**
 * (PHP 5 &gt;= 5.5.0, PHP 5)<br/>
 *
 * Creates a password hash.
 * @link http://www.php.net/manual/en/function.password-hash.php
 * @param string $password The user's password.
 * @param int $algo A <a href="http://www.php.net/manual/en/password.constants.php" class="link">password algorithm constant</a>  denoting the algorithm to use when hashing the password.
 * @param array $options [optional] <p> An associative array containing options. See the <a href="http://www.php.net/manual/en/password.constants.php" class="link">password algorithm constants</a> for documentation on the supported options for each algorithm.
 * If omitted, a random salt will be created and the default cost will be used.
 * <b>Warning<b>
 * <p>
 * The salt option has been deprecated as of PHP 7.0.0. It is now
 * preferred to simply use the salt that is generated by default.
 * </p>
 * @return string|bool Returns the hashed password, or FALSE on failure.
 */
function password_hash ($password, $algo, $options = null) {}

/**
 * (PHP 5 &gt;= 5.5.0, PHP 5)<br/>
 *
 * Checks if the given hash matches the given options.
 * @link http://www.php.net/manual/en/function.password-needs-rehash.php
 * @param string $hash A hash created by password_hash().
 * @param int $algo A <a href="http://www.php.net/manual/en/password.constants.php" class="link">password algorithm constant</a> denoting the algorithm to use when hashing the password.
 * @param array $options [optional] <p> An associative array containing options. See the password algorithm constants for documentation on the supported options for each algorithm.
 * @return string Returns TRUE if the hash should be rehashed to match the given algo and options, or FALSE otherwise.
 */
function password_needs_rehash ($hash, $algo, $options = null) {}

/**
 * (PHP 5 &gt;= 5.5.0, PHP 5)<br/>
 *
 * Checks if the given hash matches the given options.
 * @link http://www.php.net/manual/en/function.password-verify.php
 * @param string $password The user's password.
 * @param string $hash A hash created by password_hash().
 * @return boolean Returns TRUE if the password and hash match, or FALSE otherwise.
 */
function password_verify ($password, $hash) {}

// End of password v.
