# Qt-calculator
## Introduction
Welcome to the Qt-calculator project!</br>
As the name suggests, we build a calculator with variety of commonly used functions, interacted by GUI.</br>
We use the Qt creator IDE to setup the project, due to its excellent internal build tools, especially for GUI. </br>
The calculator can be used on all platforms(although the GUI may differ on each platform).</br>



### requirements ✅
**Qt creator** or **Qmake** build system set up in your IDE

### Setting up Qt 💻
* Start by Installing the Qt SDK from [qt.io](https://www.qt.io/download).
* The Installer does not include any compiler on its default install. Make sure you select the fitting compiler.
* As mentioned above, Qt Creator is a sort of an IDE with internal build tools. So currently, it's a good idea to install this.
* We will not be using CMake since QMake comes bundled with the creator. 

## Contributing

The calculator is evolving each day, and yet there are always new features to implement, code to optimize, or documentation to add.
For this very reason, contributors(completely new ones or veterans) are more than welcome to make the changes.
If you wish to contribute, please read [CONTRIBUTING.md](https://github.com/Arsenic-ATG/Qt-calculator/blob/master/CONTRIBUTING.md) for details on the code of conduct and process for submitting pull requests to the repository.

### Get it running 🏃‍♂️
1. Clone/download the repository.

1. Open ```QtCalculator => calculator.pro``` using Qt creator. If you haven't downloaded qt creator, go back to the [**Setting up Qt 💻**](#setting-up-qt-) section

1. Once inside Qt creator click on ```configure Project``` options (it will configure the project according to your device/environment) 👇
![main screen](https://github.com/Arsenic-ATG/Qt-calculator/blob/master/screenshots/instructions.png)

### Publishing the changes 🔧
Before making the needed changes , follow these instructions (if you are familiar with github and its source control functions, you can skip this explanation)
1. Fork the repository(the button on the top-right of the page)
1. Create a new branch on the created fork(meaningful branch names are important)
1. Make the needed changes on this branch
1. Commit the changes to the branch.Right now they are saved on your local repository
    - make sure you summarize the changes you made , on the commit description
1. Push it to the online repository
1. Create a pull request , on which your changes from the branch commits are explained more deeply
1. your changes will be reviewed by the project maintainers.
1. Congratulations 🎉 , you made your first contribution to the project!



---
## screen shots 📸

```
- As QT renderer tries to render native looking application, the GUI would look slightly different on different platform
```

<details>
<summary>Click to see screenshots</summary>
<br>
    
![light mode screenshot](https://user-images.githubusercontent.com/94454456/228864882-e7d9558a-facc-4e7d-a48a-4c5c1f2912af.png)

![dark mode screenshot](https://user-images.githubusercontent.com/94454456/228865275-a596d267-f213-4a11-8d17-0c17a3bfcc73.png)

</details>


## License
Using MIT License
[![License](http://img.shields.io/:license-mit-blue.svg?style=flat-square)](http://badges.mit-license.org)

- **[MIT license](http://opensource.org/licenses/mit-license.php)**
- Copyright 2020 © <a href="https://github.com/Arsenic-ATG" target="_blank">Ankur Saini</a>.
