package team.hashbash.sangarodhak;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.LocationSettingsStatusCodes;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

public class SplashScreenActivity extends AppCompatActivity {

    final int GET_LOCATION = 12;
    LocationManager manager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash_screen);

        manager = (LocationManager) getApplicationContext().getSystemService(LOCATION_SERVICE);

        if (ActivityCompat.checkSelfPermission(getApplicationContext(), Manifest.permission.ACCESS_COARSE_LOCATION) == PackageManager.PERMISSION_GRANTED) {
            if (manager.isProviderEnabled(LocationManager.NETWORK_PROVIDER) || manager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (haveNetworkConnection() || !(getSharedPreferences(getString(R.string.pref_case_data), Context.MODE_PRIVATE).getString(getString(R.string.pref_case_data_state_total_cases), "jkl").equals("jkl")))
                            startActivity(new Intent(SplashScreenActivity.this, DashBoardActivity.class));
                        else
                            Toast.makeText(getApplicationContext(), "No Saved Data\nTurn on Internet", Toast.LENGTH_SHORT).show();
                        finish();
                    }
                }, 300);
            } else {
                Toast.makeText(getApplicationContext(), "GPS needs to be turned ON", Toast.LENGTH_SHORT).show();
                askGPSTurnOn();
            }
        } else {
            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.ACCESS_COARSE_LOCATION, Manifest.permission.ACCESS_FINE_LOCATION}, GET_LOCATION);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (requestCode == GET_LOCATION) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                if (manager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
                    if (haveNetworkConnection() || !(getSharedPreferences(getString(R.string.pref_case_data), Context.MODE_PRIVATE).getString(getString(R.string.pref_case_data_state_total_cases), "jkl").equals("jkl")))
                        startActivity(new Intent(SplashScreenActivity.this, DashBoardActivity.class));
                    else
                        Toast.makeText(getApplicationContext(), "No Saved Data\nTurn on Internet", Toast.LENGTH_SHORT).show();
                    finish();
                }
                else
                    askGPSTurnOn();
            } else {
                Toast.makeText(getApplicationContext(), "Give required permission", Toast.LENGTH_LONG).show();
                finish();
            }
        }
    }

    private void askGPSTurnOn() {
        LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder()
                .addLocationRequest(locationRequest);

        Task<LocationSettingsResponse> result =
                LocationServices.getSettingsClient(SplashScreenActivity.this).checkLocationSettings(builder.build());


        result.addOnCompleteListener(new OnCompleteListener<LocationSettingsResponse>() {
            @Override
            public void onComplete(@NonNull Task<LocationSettingsResponse> task) {
                try {
                    LocationSettingsResponse response = task.getResult(ApiException.class);
                    // All location settings are satisfied. The client can initialize location
                    // requests here.
                } catch (ApiException exception) {
                    switch (exception.getStatusCode()) {
                        case LocationSettingsStatusCodes.RESOLUTION_REQUIRED:
                            // Location settings are not satisfied. But could be fixed by showing the
                            // user a dialog.
                            try {
                                // Cast to a resolvable exception.
                                ResolvableApiException resolvable = (ResolvableApiException) exception;
                                // Show the dialog by calling startResolutionForResult(),
                                // and check the result in onActivityResult().
                                resolvable.startResolutionForResult(
                                        SplashScreenActivity.this,
                                        LocationRequest.PRIORITY_HIGH_ACCURACY);
                            } catch (IntentSender.SendIntentException e) {
                                // Ignore the error.
                            } catch (ClassCastException e) {
                                // Ignore, should be an impossible error.
                            }
                            break;
                        case LocationSettingsStatusCodes.SETTINGS_CHANGE_UNAVAILABLE:
                            // Location settings are not satisfied. However, we have no way to fix the
                            // settings so we won't show the dialog.
                            break;
                    }
                }
            }
        });
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == LocationRequest.PRIORITY_HIGH_ACCURACY) {
            switch (resultCode) {
                case Activity.RESULT_OK:
                    // All required changes were successfully made
                    if (haveNetworkConnection() || !(getSharedPreferences(getString(R.string.pref_case_data), Context.MODE_PRIVATE).getString(getString(R.string.pref_case_data_state_total_cases), "jkl").equals("jkl")))
                        startActivity(new Intent(SplashScreenActivity.this, DashBoardActivity.class));
                    else
                        Toast.makeText(getApplicationContext(), "No Saved Data\nTurn on Internet", Toast.LENGTH_SHORT).show();
                    finish();
                    break;
                case Activity.RESULT_CANCELED:
                    // The user was asked to change settings, but chose not to
                    if (getSharedPreferences(getString(R.string.pref_case_data), Context.MODE_PRIVATE).getString(getString(R.string.pref_case_data_state_total_cases), "jkl").equals("jkl")) {
                        Toast.makeText(getApplicationContext(), "No Saved Data", Toast.LENGTH_SHORT).show();
                        finish();
                    } else {
                        Toast.makeText(getApplicationContext(), "Displaying Saved Data", Toast.LENGTH_SHORT).show();
                        startActivity(new Intent(SplashScreenActivity.this, DashBoardActivity.class));
                        finish();
                    }
                    break;
                default:
                    break;
            }
        }
    }

    private boolean haveNetworkConnection() {
        boolean haveConnectedWifi = false;
        boolean haveConnectedMobile = false;

        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo[] netInfo = cm.getAllNetworkInfo();
        for (NetworkInfo ni : netInfo) {
            if (ni.getTypeName().equalsIgnoreCase("WIFI"))
                if (ni.isConnected())
                    haveConnectedWifi = true;
            if (ni.getTypeName().equalsIgnoreCase("MOBILE"))
                if (ni.isConnected())
                    haveConnectedMobile = true;
        }
        return haveConnectedWifi || haveConnectedMobile;
    }
}
