/*
 * Decompiled with CFR 0.152.
 */
package javazoom.spi.mpeg.sampled.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jl.decoder.Bitstream;
import javazoom.spi.mpeg.sampled.file.IcyListener;
import javazoom.spi.mpeg.sampled.file.MpegAudioFileFormat;
import javazoom.spi.mpeg.sampled.file.MpegAudioFormat;
import javazoom.spi.mpeg.sampled.file.MpegEncoding;
import javazoom.spi.mpeg.sampled.file.MpegFileFormatType;
import javazoom.spi.mpeg.sampled.file.tag.IcyInputStream;
import javazoom.spi.mpeg.sampled.file.tag.MP3Tag;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    public static final String VERSION = "MP3SPI 1.9.5";
    private final int SYNC = -2097152;
    private String weak = null;
    private final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{MpegEncoding.MPEG2L1, MpegEncoding.MPEG2L2, MpegEncoding.MPEG2L3}, {MpegEncoding.MPEG1L1, MpegEncoding.MPEG1L2, MpegEncoding.MPEG1L3}, {MpegEncoding.MPEG2DOT5L1, MpegEncoding.MPEG2DOT5L2, MpegEncoding.MPEG2DOT5L3}};
    public static int INITAL_READ_LENGTH = 4096000;
    private static int MARK_LIMIT = INITAL_READ_LENGTH + 1;
    private static final String[] id3v1genres;

    public MpegAudioFileReader() {
        super(MARK_LIMIT, true);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)VERSION);
        }
        try {
            this.weak = System.getProperty("mp3spi.weak");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        return super.getAudioFileFormat(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(URL): begin");
        }
        long l = -1L;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Icy-Metadata", "1");
        InputStream inputStream = uRLConnection.getInputStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream, l);
        }
        finally {
            inputStream.close();
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(URL): end");
        }
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        Object object;
        int n;
        int n2;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)">MpegAudioFileReader.getAudioFileFormat(InputStream inputStream, long mediaLength): begin");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Comparable<Boolean>> hashMap2 = new HashMap<String, Comparable<Boolean>>();
        int n3 = (int)l;
        int n4 = inputStream.available();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, MARK_LIMIT);
        byte[] byArray = new byte[22];
        pushbackInputStream.read(byArray);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)("InputStream : " + inputStream + " =>" + new String(byArray)));
        }
        if (byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70 && byArray[8] == 87 && byArray[9] == 65 && byArray[10] == 86 && byArray[11] == 69) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"RIFF/WAV stream found");
            }
            n2 = byArray[21] << 8 & 0xFF00 | byArray[20] & 0xFF;
            if (this.weak == null && n2 == 1) {
                throw new UnsupportedAudioFileException("WAV PCM stream found");
            }
        } else if (byArray[0] == 46 && byArray[1] == 115 && byArray[2] == 110 && byArray[3] == 100) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"AU stream found");
            }
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("AU stream found");
            }
        } else if (byArray[0] == 70 && byArray[1] == 79 && byArray[2] == 82 && byArray[3] == 77 && byArray[8] == 65 && byArray[9] == 73 && byArray[10] == 70 && byArray[11] == 70) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"AIFF stream found");
            }
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("AIFF stream found");
            }
        } else if (byArray[0] == 77 | byArray[0] == 109 && byArray[1] == 65 | byArray[1] == 97 && byArray[2] == 67 | byArray[2] == 99) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"APE stream found");
            }
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("APE stream found");
            }
        } else if (byArray[0] == 70 | byArray[0] == 102 && byArray[1] == 76 | byArray[1] == 108 && byArray[2] == 65 | byArray[2] == 97 && byArray[3] == 67 | byArray[3] == 99) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"FLAC stream found");
            }
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("FLAC stream found");
            }
        } else if (byArray[0] == 73 | byArray[0] == 105 && byArray[1] == 67 | byArray[1] == 99 && byArray[2] == 89 | byArray[2] == 121) {
            pushbackInputStream.unread(byArray);
            this.loadShoutcastInfo(pushbackInputStream, hashMap);
        } else if (byArray[0] == 79 | byArray[0] == 111 && byArray[1] == 71 | byArray[1] == 103 && byArray[2] == 71 | byArray[2] == 103) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"Ogg stream found");
            }
            if (this.weak == null) {
                throw new UnsupportedAudioFileException("Ogg stream found");
            }
        } else {
            pushbackInputStream.unread(byArray);
        }
        n2 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        float f = -1.0f;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        boolean bl = false;
        AudioFormat.Encoding encoding = null;
        try {
            Bitstream bitstream = new Bitstream((InputStream)pushbackInputStream);
            n = bitstream.header_pos();
            hashMap.put("mp3.header.pos", new Integer(n));
            object = bitstream.readFrame();
            n2 = object.version();
            if (n2 == 2) {
                hashMap.put("mp3.version.mpeg", Float.toString(2.5f));
            } else {
                hashMap.put("mp3.version.mpeg", Integer.toString(2 - n2));
            }
            n5 = object.layer();
            hashMap.put("mp3.version.layer", Integer.toString(n5));
            n6 = object.sample_frequency();
            n7 = object.mode();
            hashMap.put("mp3.mode", new Integer(n7));
            n13 = n7 == 3 ? 1 : 2;
            hashMap.put("mp3.channels", new Integer(n13));
            bl = object.vbr();
            hashMap2.put("vbr", new Boolean(bl));
            hashMap.put("mp3.vbr", new Boolean(bl));
            hashMap.put("mp3.vbr.scale", new Integer(object.vbr_scale()));
            n8 = object.calculate_framesize();
            hashMap.put("mp3.framesize.bytes", new Integer(n8));
            if (n8 < 0) {
                throw new UnsupportedAudioFileException("Invalid FrameSize : " + n8);
            }
            n10 = object.frequency();
            hashMap.put("mp3.frequency.hz", new Integer(n10));
            f = (float)(1.0 / (double)object.ms_per_frame() * 1000.0);
            hashMap.put("mp3.framerate.fps", new Float(f));
            if (f < 0.0f) {
                throw new UnsupportedAudioFileException("Invalid FrameRate : " + f);
            }
            int n16 = n3;
            if (n > 0 && n3 != -1 && n < n3) {
                n16 -= n;
            }
            if (n3 != -1) {
                hashMap.put("mp3.length.bytes", new Integer(n3));
                n11 = object.max_number_of_frames(n16);
                hashMap.put("mp3.length.frames", new Integer(n11));
            }
            n12 = object.bitrate();
            hashMap2.put("bitrate", new Integer(n12));
            hashMap.put("mp3.bitrate.nominal.bps", new Integer(n12));
            n14 = object.getSyncHeader();
            encoding = this.sm_aEncodings[n2][n5 - 1];
            hashMap.put("mp3.version.encoding", encoding.toString());
            if (n3 != -1) {
                n15 = Math.round(object.total_ms(n16));
                hashMap.put("duration", new Long((long)n15 * 1000L));
            }
            hashMap.put("mp3.copyright", new Boolean(object.copyright()));
            hashMap.put("mp3.original", new Boolean(object.original()));
            hashMap.put("mp3.crc", new Boolean(object.checksums()));
            hashMap.put("mp3.padding", new Boolean(object.padding()));
            InputStream inputStream2 = bitstream.getRawID3v2();
            if (inputStream2 != null) {
                hashMap.put("mp3.id3tag.v2", inputStream2);
                this.parseID3v2Frames(inputStream2, hashMap);
            }
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)object.toString());
            }
        }
        catch (Exception exception) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)("not a MPEG stream:" + exception.getMessage()));
            }
            throw new UnsupportedAudioFileException("not a MPEG stream:" + exception.getMessage());
        }
        int n17 = n14 >> 19 & 3;
        if (n17 == 1) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"not a MPEG stream: wrong version");
            }
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        n = n14 >> 10 & 3;
        if (n == 3) {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"not a MPEG stream: wrong sampling rate");
            }
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        if ((long)n4 == l && l != -1L) {
            object = (FileInputStream)inputStream;
            byte[] byArray2 = new byte[128];
            long l2 = ((FileInputStream)object).skip(inputStream.available() - byArray2.length);
            int n18 = ((FileInputStream)object).read(byArray2, 0, byArray2.length);
            if (byArray2[0] == 84 && byArray2[1] == 65 && byArray2[2] == 71) {
                this.parseID3v1Frames(byArray2, hashMap);
            }
        }
        object = new MpegAudioFormat(encoding, n10, -1, n13, -1, f, true, hashMap2);
        return new MpegAudioFileFormat(MpegFileFormatType.MP3, (AudioFormat)object, n11, n3, hashMap);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"getAudioInputStream(File file)");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(fileInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            throw iOException;
        }
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        Object object;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioInputStream(URL): begin");
        }
        long l = -1L;
        URLConnection uRLConnection = uRL.openConnection();
        boolean bl = false;
        int n = 4;
        byte[] byArray = new byte[n];
        uRLConnection.setRequestProperty("Icy-Metadata", "1");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        bufferedInputStream.mark(n);
        int n2 = bufferedInputStream.read(byArray, 0, n);
        if (n2 > 2 && byArray[0] == 73 | byArray[0] == 105 && byArray[1] == 67 | byArray[1] == 99 && byArray[2] == 89 | byArray[2] == 121) {
            bl = true;
        }
        bufferedInputStream.reset();
        Object object2 = null;
        if (bl) {
            object = new IcyInputStream(bufferedInputStream);
            ((IcyInputStream)object).addTagParseListener(IcyListener.getInstance());
            object2 = object;
        } else {
            object = uRLConnection.getHeaderField("icy-metaint");
            if (object != null) {
                IcyInputStream icyInputStream = new IcyInputStream((InputStream)bufferedInputStream, (String)object);
                icyInputStream.addTagParseListener(IcyListener.getInstance());
                object2 = icyInputStream;
            } else {
                object2 = bufferedInputStream;
            }
        }
        object = null;
        try {
            object = this.getAudioInputStream((InputStream)object2, l);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            ((InputStream)object2).close();
            throw unsupportedAudioFileException;
        }
        catch (IOException iOException) {
            ((InputStream)object2).close();
            throw iOException;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioInputStream(URL): end");
        }
        return object;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioInputStream(InputStream inputStream)");
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return super.getAudioInputStream(inputStream);
    }

    protected void parseID3v1Frames(byte[] byArray, HashMap hashMap) {
        String string;
        int n;
        int n2;
        String string2;
        block12: {
            if (TDebug.TraceAudioFileReader) {
                TDebug.out((String)"Parsing ID3v1");
            }
            string2 = null;
            try {
                string2 = new String(byArray, 0, byArray.length, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string2 = new String(byArray, 0, byArray.length);
                if (!TDebug.TraceAudioFileReader) break block12;
                TDebug.out((String)"Cannot use ISO-8859-1");
            }
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)("ID3v1 frame dump='" + string2 + "'"));
        }
        String string3 = this.chopSubstring(string2, n2 = 3, n2 += 30);
        String string4 = (String)hashMap.get("title");
        if ((string4 == null || string4.length() == 0) && string3 != null) {
            hashMap.put("title", string3);
        }
        String string5 = this.chopSubstring(string2, n2, n2 += 30);
        String string6 = (String)hashMap.get("author");
        if ((string6 == null || string6.length() == 0) && string5 != null) {
            hashMap.put("author", string5);
        }
        String string7 = this.chopSubstring(string2, n2, n2 += 30);
        String string8 = (String)hashMap.get("album");
        if ((string8 == null || string8.length() == 0) && string7 != null) {
            hashMap.put("album", string7);
        }
        String string9 = this.chopSubstring(string2, n2, n2 += 4);
        String string10 = (String)hashMap.get("year");
        if ((string10 == null || string10.length() == 0) && string9 != null) {
            hashMap.put("date", string9);
        }
        String string11 = this.chopSubstring(string2, n2, n2 += 28);
        String string12 = (String)hashMap.get("comment");
        if ((string12 == null || string12.length() == 0) && string11 != null) {
            hashMap.put("comment", string11);
        }
        String string13 = "" + (byArray[126] & 0xFF);
        String string14 = (String)hashMap.get("mp3.id3tag.track");
        if ((string14 == null || string14.length() == 0) && string13 != null) {
            hashMap.put("mp3.id3tag.track", string13);
        }
        if ((n = byArray[127] & 0xFF) >= 0 && n < id3v1genres.length && ((string = (String)hashMap.get("mp3.id3tag.genre")) == null || string.length() == 0)) {
            hashMap.put("mp3.id3tag.genre", id3v1genres[n]);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"ID3v1 parsed");
        }
    }

    private String chopSubstring(String string, int n, int n2) {
        String string2;
        block3: {
            string2 = null;
            try {
                string2 = string.substring(n, n2);
                int n3 = string2.indexOf(0);
                if (n3 != -1) {
                    string2 = string2.substring(0, n3);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (!TDebug.TraceAudioFileReader) break block3;
                TDebug.out((String)("Cannot chopSubString " + stringIndexOutOfBoundsException.getMessage()));
            }
        }
        return string2;
    }

    protected void parseID3v2Frames(InputStream inputStream, HashMap hashMap) {
        block41: {
            int n;
            byte[] byArray;
            block40: {
                if (TDebug.TraceAudioFileReader) {
                    TDebug.out((String)"Parsing ID3v2");
                }
                byArray = null;
                n = -1;
                try {
                    n = inputStream.available();
                    byArray = new byte[n];
                    inputStream.mark(n);
                    inputStream.read(byArray);
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceAudioFileReader) break block40;
                    TDebug.out((String)("Cannot parse ID3v2 :" + iOException.getMessage()));
                }
            }
            if (!"ID3".equals(new String(byArray, 0, 3))) {
                TDebug.out((String)"No ID3v2 header found!");
                return;
            }
            int n2 = byArray[3] & 0xFF;
            hashMap.put("mp3.id3tag.v2.version", String.valueOf(n2));
            if (n2 < 2 || n2 > 4) {
                TDebug.out((String)("Unsupported ID3v2 version " + n2 + "!"));
                return;
            }
            try {
                if (TDebug.TraceAudioFileReader) {
                    TDebug.out((String)("ID3v2 frame dump='" + new String(byArray, 0, byArray.length) + "'"));
                }
                String string = null;
                for (int i = 10; i < byArray.length && byArray[i] > 0; i += n) {
                    String string2;
                    if (n2 == 3 || n2 == 4) {
                        string2 = new String(byArray, i, 4);
                        n = byArray[i + 4] << 24 & 0xFF000000 | byArray[i + 5] << 16 & 0xFF0000 | byArray[i + 6] << 8 & 0xFF00 | byArray[i + 7] & 0xFF;
                        if (!string2.equals("TALB") && !string2.equals("TIT2") && !string2.equals("TYER") && !string2.equals("TPE1") && !string2.equals("TCOP") && !string2.equals("COMM") && !string2.equals("TCON") && !string2.equals("TRCK") && !string2.equals("TPOS") && !string2.equals("TDRC") && !string2.equals("TCOM") && !string2.equals("TIT1") && !string2.equals("TENC") && !string2.equals("TPUB") && !string2.equals("TPE2") && !string2.equals("TLEN") || (string = string2.equals("COMM") ? this.parseText(byArray, i, n, 5) : this.parseText(byArray, i += 10, n, 1)) == null || string.length() <= 0) continue;
                        if (string2.equals("TALB")) {
                            hashMap.put("album", string);
                            continue;
                        }
                        if (string2.equals("TIT2")) {
                            hashMap.put("title", string);
                            continue;
                        }
                        if (string2.equals("TYER")) {
                            hashMap.put("date", string);
                            continue;
                        }
                        if (string2.equals("TDRC")) {
                            hashMap.put("date", string);
                            continue;
                        }
                        if (string2.equals("TPE1")) {
                            hashMap.put("author", string);
                            continue;
                        }
                        if (string2.equals("TCOP")) {
                            hashMap.put("copyright", string);
                            continue;
                        }
                        if (string2.equals("COMM")) {
                            hashMap.put("comment", string);
                            continue;
                        }
                        if (string2.equals("TCON")) {
                            hashMap.put("mp3.id3tag.genre", string);
                            continue;
                        }
                        if (string2.equals("TRCK")) {
                            hashMap.put("mp3.id3tag.track", string);
                            continue;
                        }
                        if (string2.equals("TPOS")) {
                            hashMap.put("mp3.id3tag.disc", string);
                            continue;
                        }
                        if (string2.equals("TCOM")) {
                            hashMap.put("mp3.id3tag.composer", string);
                            continue;
                        }
                        if (string2.equals("TIT1")) {
                            hashMap.put("mp3.id3tag.grouping", string);
                            continue;
                        }
                        if (string2.equals("TENC")) {
                            hashMap.put("mp3.id3tag.encoded", string);
                            continue;
                        }
                        if (string2.equals("TPUB")) {
                            hashMap.put("mp3.id3tag.publisher", string);
                            continue;
                        }
                        if (string2.equals("TPE2")) {
                            hashMap.put("mp3.id3tag.orchestra", string);
                            continue;
                        }
                        if (!string2.equals("TLEN")) continue;
                        hashMap.put("mp3.id3tag.length", string);
                        continue;
                    }
                    string2 = new String(byArray, i, 3);
                    n = 0 + (byArray[i + 3] << 16) + (byArray[i + 4] << 8) + byArray[i + 5];
                    if (!string2.equals("TAL") && !string2.equals("TT2") && !string2.equals("TP1") && !string2.equals("TYE") && !string2.equals("TRK") && !string2.equals("TPA") && !string2.equals("TCR") && !string2.equals("TCO") && !string2.equals("TCM") && !string2.equals("COM") && !string2.equals("TT1") && !string2.equals("TEN") && !string2.equals("TPB") && !string2.equals("TP2") && !string2.equals("TLE") || (string = string2.equals("COM") ? this.parseText(byArray, i, n, 5) : this.parseText(byArray, i += 6, n, 1)) == null || string.length() <= 0) continue;
                    if (string2.equals("TAL")) {
                        hashMap.put("album", string);
                        continue;
                    }
                    if (string2.equals("TT2")) {
                        hashMap.put("title", string);
                        continue;
                    }
                    if (string2.equals("TYE")) {
                        hashMap.put("date", string);
                        continue;
                    }
                    if (string2.equals("TP1")) {
                        hashMap.put("author", string);
                        continue;
                    }
                    if (string2.equals("TCR")) {
                        hashMap.put("copyright", string);
                        continue;
                    }
                    if (string2.equals("COM")) {
                        hashMap.put("comment", string);
                        continue;
                    }
                    if (string2.equals("TCO")) {
                        hashMap.put("mp3.id3tag.genre", string);
                        continue;
                    }
                    if (string2.equals("TRK")) {
                        hashMap.put("mp3.id3tag.track", string);
                        continue;
                    }
                    if (string2.equals("TPA")) {
                        hashMap.put("mp3.id3tag.disc", string);
                        continue;
                    }
                    if (string2.equals("TCM")) {
                        hashMap.put("mp3.id3tag.composer", string);
                        continue;
                    }
                    if (string2.equals("TT1")) {
                        hashMap.put("mp3.id3tag.grouping", string);
                        continue;
                    }
                    if (string2.equals("TEN")) {
                        hashMap.put("mp3.id3tag.encoded", string);
                        continue;
                    }
                    if (string2.equals("TPB")) {
                        hashMap.put("mp3.id3tag.publisher", string);
                        continue;
                    }
                    if (string2.equals("TP2")) {
                        hashMap.put("mp3.id3tag.orchestra", string);
                        continue;
                    }
                    if (!string2.equals("TLE")) continue;
                    hashMap.put("mp3.id3tag.length", string);
                }
            }
            catch (RuntimeException runtimeException) {
                if (!TDebug.TraceAudioFileReader) break block41;
                TDebug.out((String)("Cannot parse ID3v2 :" + runtimeException.getMessage()));
            }
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"ID3v2 parsed");
        }
    }

    protected String parseText(byte[] byArray, int n, int n2, int n3) {
        String string;
        block2: {
            string = null;
            try {
                String[] stringArray = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
                string = new String(byArray, n + n3, n2 - n3, stringArray[byArray[n]]);
                string = this.chopSubstring(string, 0, string.length());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!TDebug.TraceAudioFileReader) break block2;
                TDebug.out((String)("ID3v2 Encoding error :" + unsupportedEncodingException.getMessage()));
            }
        }
        return string;
    }

    protected void loadShoutcastInfo(InputStream inputStream, HashMap hashMap) throws IOException {
        MP3Tag[] mP3TagArray;
        IcyInputStream icyInputStream = new IcyInputStream(new BufferedInputStream(inputStream));
        HashMap hashMap2 = icyInputStream.getTagHash();
        MP3Tag mP3Tag = icyInputStream.getTag("icy-name");
        if (mP3Tag != null) {
            hashMap.put("title", ((String)mP3Tag.getValue()).trim());
        }
        if ((mP3TagArray = icyInputStream.getTags()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < mP3TagArray.length; ++i) {
                String string = mP3TagArray[i].getName();
                String string2 = ((String)icyInputStream.getTag(string).getValue()).trim();
                hashMap.put("mp3.shoutcast.metadata." + string, string2);
            }
        }
    }

    static {
        String string = System.getProperty("marklimit");
        if (string != null) {
            try {
                INITAL_READ_LENGTH = Integer.parseInt(string);
                MARK_LIMIT = INITAL_READ_LENGTH + 1;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        id3v1genres = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Brass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A Capela", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "BritPop", "Negerpunk", "Polsk Punk", "Beat", "Christian Gangsta Rap", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "SynthPop"};
    }
}

