/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import processing.core.PApplet;
import processing.sound.Analyzer;
import processing.sound.Engine;
import processing.sound.JSynWaveform;
import processing.sound.SoundObject;

public class Waveform
extends Analyzer {
    public float[] data;
    private JSynWaveform waveform;

    public Waveform(PApplet pApplet, int n) {
        super(pApplet);
        if (n <= 0) {
            Engine.printError("number of waveform frames needs to be greater than 0");
        } else {
            this.waveform = new JSynWaveform(n);
            this.data = new float[n];
        }
    }

    @Override
    protected void removeInput() {
        this.waveform.input.disconnectAll();
        this.input = null;
    }

    @Override
    protected void setInput(UnitOutputPort unitOutputPort) {
        Engine.getEngine().add((UnitGenerator)this.waveform);
        this.waveform.input.connect(unitOutputPort);
        this.waveform.start();
    }

    public float[] analyze() {
        return this.analyze(this.data);
    }

    public float[] analyze(float[] fArray) {
        if (this.input == null) {
            Engine.printWarning("this Waveform has no sound source connected to it, nothing to analyze");
        }
        this.waveform.calculateWaveform(fArray);
        return fArray;
    }

    @Override
    public void input(SoundObject soundObject) {
        super.input(soundObject);
    }
}

