/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.util.SampleLoader;
import fr.delthas.javamp3.Sound;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import processing.core.PApplet;
import processing.sound.AudioSample;
import processing.sound.Engine;

public class SoundFile
extends AudioSample {
    private static Map<String, FloatSample> SAMPLECACHE = new HashMap<String, FloatSample>();

    public SoundFile(PApplet pApplet, String string) {
        super(pApplet);
        this.sample = SAMPLECACHE.get(string);
        if (this.sample == null) {
            InputStream inputStream = pApplet.createInput(string);
            if (inputStream == null) {
                Engine.printError("unable to find file " + string);
                return;
            }
            try {
                this.sample = SampleLoader.loadFloatSample((InputStream)inputStream);
            }
            catch (IOException iOException) {
                try {
                    inputStream = pApplet.createInput(string);
                    try (Sound sound = new Sound(inputStream);){
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        sound.decodeFullyInto((OutputStream)byteArrayOutputStream);
                        float[] fArray = new float[byteArrayOutputStream.size() / 2];
                        SampleLoader.decodeLittleI16ToF32((byte[])byteArrayOutputStream.toByteArray(), (int)0, (int)byteArrayOutputStream.size(), (float[])fArray, (int)0);
                        this.sample = new FloatSample(fArray, sound.isStereo() ? 2 : 1);
                    }
                }
                catch (IOException iOException2) {
                    Engine.printError("unable to decode sound file " + string);
                    return;
                }
            }
            SAMPLECACHE.put(string, this.sample);
        }
        this.initiatePlayer();
    }

    @Override
    public int channels() {
        return super.channels();
    }

    @Override
    public void cue(float f) {
        super.cue(f);
    }

    @Override
    public float duration() {
        return super.duration();
    }

    @Override
    public int frames() {
        return super.frames();
    }

    @Override
    public void play() {
        super.play();
    }

    @Override
    public void play(float f) {
        super.play(f);
    }

    @Override
    public void play(float f, float f2) {
        super.play(f, f2);
    }

    @Override
    public void play(float f, float f2, float f3) {
        super.play(f, f2, f3);
    }

    @Override
    public void play(float f, float f2, float f3, float f4) {
        super.play(f, f2, f3, f4);
    }

    @Override
    public void play(float f, float f2, float f3, float f4, float f5) {
        super.play(f, f2, f3, f4, f5);
    }

    @Override
    public void jump(float f) {
        super.jump(f);
    }

    @Override
    public void pause() {
        super.pause();
    }

    @Override
    public boolean isPlaying() {
        return super.isPlaying();
    }

    @Override
    public void loop() {
        super.loop();
    }

    @Override
    public void loop(float f) {
        super.loop(f);
    }

    @Override
    public void loop(float f, float f2) {
        super.loop(f, f2);
    }

    @Override
    public void loop(float f, float f2, float f3) {
        super.loop(f, f2, f3);
    }

    @Override
    public void loop(float f, float f2, float f3, float f4) {
        super.loop(f, f2, f3, f4);
    }

    @Override
    public void amp(float f) {
        super.amp(f);
    }

    @Override
    public void pan(float f) {
        super.pan(f);
    }

    @Override
    public void rate(float f) {
        super.rate(f);
    }

    @Override
    public void stop() {
        super.stop();
    }
}

