/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.CameraState;
import peasy.DampedAction;
import peasy.InterpolationManager;
import peasy.InterpolationUtil;
import peasy.PeasyDragHandler;
import peasy.PeasyWheelHandler;
import peasy.org.apache.commons.math.geometry.CardanEulerSingularityException;
import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.RotationOrder;
import peasy.org.apache.commons.math.geometry.Vector3D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.opengl.PGraphicsOpenGL;

public class PeasyCam {
    public final String VERSION = "302";
    private static final Vector3D LOOK = Vector3D.plusK;
    private static final Vector3D UP = Vector3D.plusJ;
    private static final double SMALLEST_MINIMUM_DISTANCE = 0.01;
    private final PGraphics g;
    private final PApplet p;
    private final double startDistance;
    private final Vector3D startCenter;
    private boolean resetOnDoubleClick = true;
    private double minimumDistance = 1.0;
    private double maximumDistance = Double.MAX_VALUE;
    private final DampedAction rotateX;
    private final DampedAction rotateY;
    private final DampedAction rotateZ;
    private final DampedAction dampedZoom;
    private final DampedAction dampedPanX;
    private final DampedAction dampedPanY;
    private double distance;
    private Vector3D center;
    private Rotation rotation;
    private int[] viewport = new int[4];
    private Constraint dragConstraint = null;
    private Constraint permaConstraint = null;
    private final InterpolationManager rotationInterps = new InterpolationManager();
    private final InterpolationManager centerInterps = new InterpolationManager();
    private final InterpolationManager distanceInterps = new InterpolationManager();
    private final PeasyDragHandler panHandler;
    private PeasyDragHandler centerDragHandler = this.panHandler = new PeasyDragHandler(){

        @Override
        public void handleDrag(double d, double d2) {
            PeasyCam.this.dampedPanX.impulse(d / 8.0);
            PeasyCam.this.dampedPanY.impulse(d2 / 8.0);
        }
    };
    private final PeasyDragHandler rotateHandler;
    private PeasyDragHandler leftDragHandler = this.rotateHandler = new PeasyDragHandler(){

        @Override
        public void handleDrag(double d, double d2) {
            PeasyCam.this.mouseRotate(d, d2);
        }
    };
    private final PeasyDragHandler zoomHandler;
    private PeasyDragHandler rightDraghandler = this.zoomHandler = new PeasyDragHandler(){

        @Override
        public void handleDrag(double d, double d2) {
            PeasyCam.this.dampedZoom.impulse(d2 / 10.0);
        }
    };
    private final PeasyWheelHandler zoomWheelHandler;
    private PeasyWheelHandler wheelHandler = this.zoomWheelHandler = new PeasyWheelHandler(){

        @Override
        public void handleWheel(int n) {
            PeasyCam.this.dampedZoom.impulse(PeasyCam.this.wheelScale * (double)n);
        }
    };
    private double wheelScale = 1.0;
    private final PeasyEventListener peasyEventListener = new PeasyEventListener();
    private boolean isActive = false;
    private boolean pushedLights = false;

    public PeasyCam(PApplet pApplet, double d) {
        this(pApplet, pApplet.g, 0.0, 0.0, 0.0, d);
    }

    public PeasyCam(PApplet pApplet, double d, double d2, double d3, double d4) {
        this(pApplet, pApplet.g, d, d2, d3, d4);
    }

    public PeasyCam(PApplet pApplet, PGraphics pGraphics, double d) {
        this(pApplet, pGraphics, 0.0, 0.0, 0.0, d);
    }

    public PeasyCam(PApplet pApplet, PGraphics pGraphics, double d, double d2, double d3, double d4) {
        this.p = pApplet;
        this.g = pGraphics;
        this.startCenter = this.center = new Vector3D(d, d2, d3);
        this.startDistance = this.distance = Math.max(d4, 0.01);
        this.rotation = new Rotation();
        this.viewport[0] = 0;
        this.viewport[1] = 0;
        this.viewport[2] = pGraphics.width;
        this.viewport[3] = pGraphics.height;
        this.feed();
        this.rotateX = new DampedAction(this){

            @Override
            protected void behave(double d) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusI, d));
            }
        };
        this.rotateY = new DampedAction(this){

            @Override
            protected void behave(double d) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusJ, d));
            }
        };
        this.rotateZ = new DampedAction(this){

            @Override
            protected void behave(double d) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusK, d));
            }
        };
        this.dampedZoom = new DampedAction(this){

            @Override
            protected void behave(double d) {
                PeasyCam.this.mouseZoom(d);
            }
        };
        this.dampedPanX = new DampedAction(this){

            @Override
            protected void behave(double d) {
                PeasyCam.this.mousePan(d, 0.0);
            }
        };
        this.dampedPanY = new DampedAction(this){

            @Override
            protected void behave(double d) {
                PeasyCam.this.mousePan(0.0, d);
            }
        };
        this.setActive(true);
    }

    public void setActive(boolean bl) {
        if (bl == this.isActive) {
            return;
        }
        this.isActive = bl;
        if (this.isActive) {
            this.p.registerMethod("mouseEvent", (Object)this.peasyEventListener);
            this.p.registerMethod("keyEvent", (Object)this.peasyEventListener);
        } else {
            this.p.unregisterMethod("mouseEvent", (Object)this.peasyEventListener);
            this.p.unregisterMethod("keyEvent", (Object)this.peasyEventListener);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Deprecated
    public void setMouseControlled(boolean bl) {
        this.setActive(bl);
    }

    public double getWheelScale() {
        return this.wheelScale;
    }

    public void setWheelScale(double d) {
        this.wheelScale = d;
    }

    public PeasyDragHandler getPanDragHandler() {
        return this.panHandler;
    }

    public PeasyDragHandler getRotateDragHandler() {
        return this.rotateHandler;
    }

    public PeasyDragHandler getZoomDragHandler() {
        return this.zoomHandler;
    }

    public PeasyWheelHandler getZoomWheelHandler() {
        return this.zoomWheelHandler;
    }

    public void setLeftDragHandler(PeasyDragHandler peasyDragHandler) {
        this.leftDragHandler = peasyDragHandler;
    }

    public void setCenterDragHandler(PeasyDragHandler peasyDragHandler) {
        this.centerDragHandler = peasyDragHandler;
    }

    public void setRightDragHandler(PeasyDragHandler peasyDragHandler) {
        this.rightDraghandler = peasyDragHandler;
    }

    public PeasyWheelHandler getWheelHandler() {
        return this.wheelHandler;
    }

    public void setWheelHandler(PeasyWheelHandler peasyWheelHandler) {
        this.wheelHandler = peasyWheelHandler;
    }

    public String version() {
        return "302";
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.viewport[0] = n;
        this.viewport[1] = n2;
        this.viewport[2] = n3;
        this.viewport[3] = n4;
    }

    public int[] getViewport() {
        return this.viewport;
    }

    public PGraphics getCanvas() {
        return this.g;
    }

    public boolean insideViewport(double d, double d2) {
        float f = this.viewport[0];
        float f2 = f + (float)this.viewport[2];
        float f3 = this.viewport[1];
        float f4 = f3 + (float)this.viewport[3];
        return d > (double)f && d < (double)f2 && d2 > (double)f3 && d2 < (double)f4;
    }

    private void mouseZoom(double d) {
        double d2 = this.distance + d * this.distance * 0.02;
        if (d2 < this.minimumDistance) {
            d2 = this.minimumDistance;
            this.dampedZoom.stop();
        }
        if (d2 > this.maximumDistance) {
            d2 = this.maximumDistance;
            this.dampedZoom.stop();
        }
        this.safeSetDistance(d2);
    }

    private void mousePan(double d, double d2) {
        double d3 = this.distance * 0.0025;
        this.pan(this.dragConstraint == Constraint.PITCH ? 0.0 : -d * d3, this.dragConstraint == Constraint.YAW ? 0.0 : -d2 * d3);
    }

    private void mouseRotate(double d, double d2) {
        double d3 = -Math.pow(Math.log10(1.0 + this.distance), 0.5) * (double)0.00125f;
        double d4 = d * d3;
        double d5 = d2 * d3;
        double d6 = this.viewport[0];
        double d7 = this.viewport[1];
        double d8 = this.viewport[2];
        double d9 = this.viewport[3];
        double d10 = Math.min(Math.max(((double)this.p.mouseX - d6) / d8, 0.0), 1.0) * 2.0 - 1.0;
        double d11 = Math.min(Math.max(((double)this.p.mouseY - d7) / d9, 0.0), 1.0) * 2.0 - 1.0;
        if (this.dragConstraint == null || this.dragConstraint == Constraint.YAW || this.dragConstraint == Constraint.SUPPRESS_ROLL) {
            this.rotateY.impulse(d4 * (1.0 - d11 * d11));
        }
        if (this.dragConstraint == null || this.dragConstraint == Constraint.PITCH || this.dragConstraint == Constraint.SUPPRESS_ROLL) {
            this.rotateX.impulse(-d5 * (1.0 - d10 * d10));
        }
        if (this.dragConstraint == null || this.dragConstraint == Constraint.ROLL) {
            this.rotateZ.impulse(-d4 * d11);
            this.rotateZ.impulse(d5 * d10);
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        this.setDistance(d, 300L);
    }

    public void setDistance(double d, long l) {
        this.distanceInterps.startInterpolation(new DistanceInterp(d, l));
    }

    public float[] getLookAt() {
        return new float[]{(float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ()};
    }

    public void lookAt(double d, double d2, double d3) {
        this.centerInterps.startInterpolation(new CenterInterp(new Vector3D(d, d2, d3), 300L));
    }

    public void lookAt(double d, double d2, double d3, double d4) {
        this.lookAt(d, d2, d3);
        this.setDistance(d4);
    }

    public void lookAt(double d, double d2, double d3, long l) {
        this.lookAt(d, d2, d3, this.distance, l);
    }

    public void lookAt(double d, double d2, double d3, double d4, long l) {
        this.setState(new CameraState(this.rotation, new Vector3D(d, d2, d3), d4), l);
    }

    private void safeSetDistance(double d) {
        this.distance = Math.min(this.maximumDistance, Math.max(this.minimumDistance, d));
        this.feed();
    }

    public void feed() {
        Vector3D vector3D = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        Vector3D vector3D2 = this.rotation.applyTo(UP);
        this.g.camera((float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ(), (float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ(), (float)vector3D2.getX(), (float)vector3D2.getY(), (float)vector3D2.getZ());
    }

    static void apply(PGraphics pGraphics, Vector3D vector3D, Rotation rotation, double d) {
        Vector3D vector3D2 = rotation.applyTo(LOOK).scalarMultiply(d).add(vector3D);
        Vector3D vector3D3 = rotation.applyTo(UP);
        pGraphics.camera((float)vector3D2.getX(), (float)vector3D2.getY(), (float)vector3D2.getZ(), (float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ(), (float)vector3D3.getX(), (float)vector3D3.getY(), (float)vector3D3.getZ());
    }

    public float[] getPosition() {
        Vector3D vector3D = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        return new float[]{(float)vector3D.getX(), (float)vector3D.getY(), (float)vector3D.getZ()};
    }

    public void reset() {
        this.reset(300L);
    }

    public void reset(long l) {
        this.setState(new CameraState(new Rotation(), this.startCenter, this.startDistance), l);
    }

    public void pan(double d, double d2) {
        this.center = this.center.add(this.rotation.applyTo(new Vector3D(d, d2, 0.0)));
        this.feed();
    }

    public void rotateX(double d) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusI, d));
        this.feed();
    }

    public void rotateY(double d) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusJ, d));
        this.feed();
    }

    public void rotateZ(double d) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusK, d));
        this.feed();
    }

    PApplet getApplet() {
        return this.p;
    }

    public CameraState getState() {
        return new CameraState(this.rotation, this.center, this.distance);
    }

    public void setFreeRotationMode() {
        this.permaConstraint = null;
    }

    public void setYawRotationMode() {
        this.permaConstraint = Constraint.YAW;
    }

    public void setPitchRotationMode() {
        this.permaConstraint = Constraint.PITCH;
    }

    public void setRollRotationMode() {
        this.permaConstraint = Constraint.ROLL;
    }

    public void setSuppressRollRotationMode() {
        this.permaConstraint = Constraint.SUPPRESS_ROLL;
    }

    public void setMinimumDistance(double d) {
        this.minimumDistance = Math.max(d, 0.01);
        this.safeSetDistance(this.distance);
    }

    public void setMaximumDistance(double d) {
        this.maximumDistance = d;
        this.safeSetDistance(this.distance);
    }

    public void setResetOnDoubleClick(boolean bl) {
        this.resetOnDoubleClick = bl;
    }

    public void setState(CameraState cameraState) {
        this.setState(cameraState, 300L);
    }

    public void setState(CameraState cameraState, long l) {
        if (l > 0L) {
            this.rotationInterps.startInterpolation(new RotationInterp(cameraState.rotation, l));
            this.centerInterps.startInterpolation(new CenterInterp(cameraState.center, l));
            this.distanceInterps.startInterpolation(new DistanceInterp(cameraState.distance, l));
        } else {
            this.rotation = cameraState.rotation;
            this.center = cameraState.center;
            this.distance = cameraState.distance;
        }
        this.feed();
    }

    public void setRotations(double d, double d2, double d3) {
        this.rotationInterps.cancelInterpolation();
        this.rotation = new Rotation(RotationOrder.XYZ, d, d2, d3);
        this.feed();
    }

    public float[] getRotations() {
        try {
            double[] dArray = this.rotation.getAngles(RotationOrder.XYZ);
            return new float[]{(float)dArray[0], (float)dArray[1], (float)dArray[2]};
        }
        catch (CardanEulerSingularityException cardanEulerSingularityException) {
            try {
                double[] dArray = this.rotation.getAngles(RotationOrder.YXZ);
                return new float[]{(float)dArray[1], (float)dArray[0], (float)dArray[2]};
            }
            catch (CardanEulerSingularityException cardanEulerSingularityException2) {
                try {
                    double[] dArray = this.rotation.getAngles(RotationOrder.ZXY);
                    return new float[]{(float)dArray[2], (float)dArray[0], (float)dArray[1]};
                }
                catch (CardanEulerSingularityException cardanEulerSingularityException3) {
                    return new float[]{0.0f, 0.0f, 0.0f};
                }
            }
        }
    }

    public void beginHUD() {
        this.g.hint(2);
        this.g.pushMatrix();
        this.g.resetMatrix();
        if (this.g.isGL() && this.g.is3D()) {
            PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this.g;
            this.pushedLights = pGraphicsOpenGL.lights;
            pGraphicsOpenGL.lights = false;
            pGraphicsOpenGL.pushProjection();
            this.g.ortho(0.0f, (float)this.viewport[2], (float)(-this.viewport[3]), 0.0f, -3.4028235E38f, Float.MAX_VALUE);
        }
    }

    public void endHUD() {
        if (this.g.isGL() && this.g.is3D()) {
            PGraphicsOpenGL pGraphicsOpenGL = (PGraphicsOpenGL)this.g;
            pGraphicsOpenGL.popProjection();
            pGraphicsOpenGL.lights = this.pushedLights;
        }
        this.g.popMatrix();
        this.g.hint(-2);
    }

    class RotationInterp
    extends AbstractInterp {
        final Rotation startRotation;
        final Rotation endRotation;

        public RotationInterp(Rotation rotation, long l) {
            super(l);
            this.startRotation = PeasyCam.this.rotation;
            this.endRotation = rotation;
        }

        @Override
        void start() {
            PeasyCam.this.rotateX.stop();
            PeasyCam.this.rotateY.stop();
            PeasyCam.this.rotateZ.stop();
            super.start();
        }

        @Override
        protected void interp(double d) {
            PeasyCam.this.rotation = InterpolationUtil.slerp(this.startRotation, this.endRotation, d);
        }

        @Override
        protected void setEndState() {
            PeasyCam.this.rotation = this.endRotation;
        }
    }

    class CenterInterp
    extends AbstractInterp {
        private final Vector3D startCenter;
        private final Vector3D endCenter;

        public CenterInterp(Vector3D vector3D, long l) {
            super(l);
            this.startCenter = PeasyCam.this.center;
            this.endCenter = vector3D;
        }

        @Override
        protected void interp(double d) {
            PeasyCam.this.center = InterpolationUtil.smooth(this.startCenter, this.endCenter, d);
        }

        @Override
        protected void setEndState() {
            PeasyCam.this.center = this.endCenter;
        }
    }

    class DistanceInterp
    extends AbstractInterp {
        private final double startDistance;
        private final double endDistance;

        public DistanceInterp(double d, long l) {
            super(l);
            this.startDistance = PeasyCam.this.distance;
            this.endDistance = Math.min(PeasyCam.this.maximumDistance, Math.max(PeasyCam.this.minimumDistance, d));
        }

        @Override
        protected void interp(double d) {
            PeasyCam.this.distance = InterpolationUtil.smooth(this.startDistance, this.endDistance, d);
        }

        @Override
        protected void setEndState() {
            PeasyCam.this.distance = this.endDistance;
        }
    }

    public abstract class AbstractInterp {
        double startTime;
        final double timeInMillis;

        protected AbstractInterp(long l) {
            this.timeInMillis = l;
        }

        void start() {
            this.startTime = PeasyCam.this.p.millis();
            PeasyCam.this.p.registerMethod("draw", (Object)this);
        }

        void cancel() {
            PeasyCam.this.p.unregisterMethod("draw", (Object)this);
        }

        public void draw() {
            double d = ((double)PeasyCam.this.p.millis() - this.startTime) / this.timeInMillis;
            if (d > 0.99) {
                this.cancel();
                this.setEndState();
            } else {
                this.interp(d);
            }
            PeasyCam.this.feed();
        }

        protected abstract void interp(double var1);

        protected abstract void setEndState();
    }

    protected class PeasyEventListener {
        public boolean isActive = false;

        protected PeasyEventListener() {
        }

        public void keyEvent(KeyEvent keyEvent) {
            if (keyEvent.getAction() == 2 && keyEvent.isShiftDown()) {
                PeasyCam.this.dragConstraint = null;
            }
        }

        public void mouseEvent(MouseEvent mouseEvent) {
            switch (mouseEvent.getAction()) {
                case 1: {
                    if (!PeasyCam.this.insideViewport(((PeasyCam)PeasyCam.this).p.mouseX, ((PeasyCam)PeasyCam.this).p.mouseY)) break;
                    this.isActive = true;
                    break;
                }
                case 2: {
                    PeasyCam.this.dragConstraint = null;
                    this.isActive = false;
                    break;
                }
                case 3: {
                    if (!PeasyCam.this.insideViewport(((PeasyCam)PeasyCam.this).p.mouseX, ((PeasyCam)PeasyCam.this).p.mouseY) || !PeasyCam.this.resetOnDoubleClick || 2 != mouseEvent.getCount()) break;
                    PeasyCam.this.reset();
                    break;
                }
                case 8: {
                    if (PeasyCam.this.wheelHandler == null || !PeasyCam.this.insideViewport(((PeasyCam)PeasyCam.this).p.mouseX, ((PeasyCam)PeasyCam.this).p.mouseY)) break;
                    PeasyCam.this.wheelHandler.handleWheel(mouseEvent.getCount());
                    break;
                }
                case 4: {
                    if (!this.isActive) break;
                    double d = ((PeasyCam)PeasyCam.this).p.mouseX - ((PeasyCam)PeasyCam.this).p.pmouseX;
                    double d2 = ((PeasyCam)PeasyCam.this).p.mouseY - ((PeasyCam)PeasyCam.this).p.pmouseY;
                    if (mouseEvent.isShiftDown()) {
                        if (PeasyCam.this.dragConstraint == null && Math.abs(d - d2) > 1.0) {
                            PeasyCam.this.dragConstraint = Math.abs(d) > Math.abs(d2) ? Constraint.YAW : Constraint.PITCH;
                        }
                    } else if (PeasyCam.this.permaConstraint != null) {
                        PeasyCam.this.dragConstraint = PeasyCam.this.permaConstraint;
                    } else {
                        PeasyCam.this.dragConstraint = null;
                    }
                    int n = ((PeasyCam)PeasyCam.this).p.mouseButton;
                    if (PeasyCam.this.centerDragHandler != null && (n == 3 || n == 37 && mouseEvent.isMetaDown())) {
                        PeasyCam.this.centerDragHandler.handleDrag(d, d2);
                        break;
                    }
                    if (PeasyCam.this.leftDragHandler != null && n == 37) {
                        PeasyCam.this.leftDragHandler.handleDrag(d, d2);
                        break;
                    }
                    if (PeasyCam.this.rightDraghandler == null || n != 39) break;
                    PeasyCam.this.rightDraghandler.handleDrag(d, d2);
                }
            }
        }
    }

    private static enum Constraint {
        YAW,
        PITCH,
        ROLL,
        SUPPRESS_ROLL;

    }
}

