/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;

public class BeatDetect {
    public static final int FREQ_ENERGY = 0;
    public static final int SOUND_ENERGY = 1;
    private int algorithm;
    private int sampleRate;
    private int timeSize;
    private int valCnt;
    private float[] valGraph;
    private int sensitivity;
    private int insertAt;
    private boolean isOnset;
    private float[] eBuffer;
    private float[] dBuffer;
    private long timer;
    private boolean[] fIsOnset;
    private FFT spect;
    private float[][] feBuffer;
    private float[][] fdBuffer;
    private long[] fTimer;
    private float[] varGraph;
    private int varCnt;

    public BeatDetect() {
        this.sampleRate = 44100;
        this.timeSize = 1024;
        this.initSEResources();
        this.initGraphs();
        this.algorithm = 1;
        this.sensitivity = 10;
    }

    public BeatDetect(int timeSize, float sampleRate) {
        this.sampleRate = (int)sampleRate;
        this.timeSize = timeSize;
        this.initFEResources();
        this.initGraphs();
        this.algorithm = 0;
        this.sensitivity = 10;
    }

    public void detectMode(int algo) {
        if (algo < 0 || algo > 1) {
            Minim.error("Unrecognized detect mode, defaulting to SOUND_ENERGY.");
            algo = 1;
        }
        if (algo == 1) {
            if (this.algorithm == 0) {
                this.releaseFEResources();
                this.initSEResources();
                this.initGraphs();
                this.algorithm = algo;
            }
        } else if (this.algorithm == 1) {
            this.releaseSEResources();
            this.initFEResources();
            this.initGraphs();
            this.algorithm = 0;
        }
    }

    private void initGraphs() {
        this.varCnt = 0;
        this.valCnt = 0;
        this.valGraph = new float[512];
        this.varGraph = new float[512];
    }

    private void initSEResources() {
        this.isOnset = false;
        this.eBuffer = new float[this.sampleRate / this.timeSize];
        this.dBuffer = new float[this.sampleRate / this.timeSize];
        this.timer = System.currentTimeMillis();
        this.insertAt = 0;
    }

    private void initFEResources() {
        this.spect = new FFT(this.timeSize, this.sampleRate);
        this.spect.logAverages(60, 3);
        int numAvg = this.spect.avgSize();
        this.fIsOnset = new boolean[numAvg];
        this.feBuffer = new float[numAvg][this.sampleRate / this.timeSize];
        this.fdBuffer = new float[numAvg][this.sampleRate / this.timeSize];
        this.fTimer = new long[numAvg];
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.fTimer.length; ++i) {
            this.fTimer[i] = start;
        }
        this.insertAt = 0;
    }

    private void releaseSEResources() {
        this.isOnset = false;
        this.eBuffer = null;
        this.dBuffer = null;
        this.timer = 0L;
    }

    private void releaseFEResources() {
        this.spect = null;
        this.fIsOnset = null;
        this.feBuffer = null;
        this.fdBuffer = null;
        this.fTimer = null;
    }

    public void detect(AudioBuffer buffer) {
        this.detect(buffer.toArray());
    }

    public void detect(float[] buffer) {
        switch (this.algorithm) {
            case 1: {
                this.sEnergy(buffer);
                break;
            }
            case 0: {
                this.fEnergy(buffer);
            }
        }
    }

    public int detectSize() {
        if (this.algorithm == 0) {
            return this.spect.avgSize();
        }
        return 0;
    }

    @Deprecated
    public int dectectSize() {
        return this.detectSize();
    }

    public float getDetectCenterFrequency(int i) {
        if (this.algorithm == 0) {
            return this.spect.getAverageCenterFrequency(i);
        }
        return 0.0f;
    }

    public void setSensitivity(int millis) {
        if (millis < 0) {
            Minim.error("BeatDetect: sensitivity cannot be less than zero. Defaulting to 10.");
            this.sensitivity = 10;
        } else {
            this.sensitivity = millis;
        }
    }

    public boolean isOnset() {
        return this.isOnset;
    }

    public boolean isOnset(int i) {
        if (this.algorithm == 1) {
            return false;
        }
        return this.fIsOnset[i];
    }

    public boolean isKick() {
        if (this.algorithm == 1) {
            return false;
        }
        int upper = 6 >= this.spect.avgSize() ? this.spect.avgSize() : 6;
        return this.isRange(1, upper, 2);
    }

    public boolean isSnare() {
        if (this.algorithm == 1) {
            return false;
        }
        int lower = 8 >= this.spect.avgSize() ? this.spect.avgSize() : 8;
        int upper = this.spect.avgSize() - 1;
        int thresh = (upper - lower) / 3 + 1;
        return this.isRange(lower, upper, thresh);
    }

    public boolean isHat() {
        if (this.algorithm == 1) {
            return false;
        }
        int lower = this.spect.avgSize() - 7 < 0 ? 0 : this.spect.avgSize() - 7;
        int upper = this.spect.avgSize() - 1;
        return this.isRange(lower, upper, 1);
    }

    public boolean isRange(int low, int high, int threshold) {
        if (this.algorithm == 1) {
            return false;
        }
        int num = 0;
        for (int i = low; i < high + 1; ++i) {
            if (!this.isOnset(i)) continue;
            ++num;
        }
        return num >= threshold;
    }

    private void sEnergy(float[] samples) {
        float level = 0.0f;
        for (int i = 0; i < samples.length; ++i) {
            level += samples[i] * samples[i];
        }
        level /= (float)samples.length;
        level = (float)Math.sqrt(level);
        float instant = level * 100.0f;
        float E = this.average(this.eBuffer);
        float V = this.variance(this.eBuffer, E);
        float C = -0.0025714f * V + 1.5142857f;
        float diff = Math.max(instant - C * E, 0.0f);
        this.pushVal(diff);
        float dAvg = this.specAverage(this.dBuffer);
        float diff2 = Math.max(diff - dAvg, 0.0f);
        this.pushVar(diff2);
        if (System.currentTimeMillis() - this.timer < (long)this.sensitivity) {
            this.isOnset = false;
        } else if (diff2 > 0.0f && instant > 2.0f) {
            this.isOnset = true;
            this.timer = System.currentTimeMillis();
        } else {
            this.isOnset = false;
        }
        this.eBuffer[this.insertAt] = instant;
        this.dBuffer[this.insertAt] = diff;
        ++this.insertAt;
        if (this.insertAt == this.eBuffer.length) {
            this.insertAt = 0;
        }
    }

    private void fEnergy(float[] in) {
        this.spect.forward(in);
        for (int i = 0; i < this.feBuffer.length; ++i) {
            float instant = this.spect.getAvg(i);
            float E = this.average(this.feBuffer[i]);
            float V = this.variance(this.feBuffer[i], E);
            float C = -0.0025714f * V + 1.5142857f;
            float diff = Math.max(instant - C * E, 0.0f);
            float dAvg = this.specAverage(this.fdBuffer[i]);
            float diff2 = Math.max(diff - dAvg, 0.0f);
            if (System.currentTimeMillis() - this.fTimer[i] < (long)this.sensitivity) {
                this.fIsOnset[i] = false;
            } else if (diff2 > 0.0f) {
                this.fIsOnset[i] = true;
                this.fTimer[i] = System.currentTimeMillis();
            } else {
                this.fIsOnset[i] = false;
            }
            this.feBuffer[i][this.insertAt] = instant;
            this.fdBuffer[i][this.insertAt] = diff;
        }
        ++this.insertAt;
        if (this.insertAt == this.feBuffer[0].length) {
            this.insertAt = 0;
        }
    }

    private void pushVal(float v) {
        if (this.valCnt == this.valGraph.length) {
            this.valCnt = 0;
            this.valGraph = new float[this.valGraph.length];
        }
        this.valGraph[this.valCnt] = v;
        ++this.valCnt;
    }

    private void pushVar(float v) {
        if (this.varCnt == this.varGraph.length) {
            this.varCnt = 0;
            this.varGraph = new float[this.varGraph.length];
        }
        this.varGraph[this.varCnt] = v;
        ++this.varCnt;
    }

    private float average(float[] arr) {
        float avg = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            avg += arr[i];
        }
        return avg /= (float)arr.length;
    }

    private float specAverage(float[] arr) {
        float avg = 0.0f;
        float num = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] > 0.0f)) continue;
            avg += arr[i];
            num += 1.0f;
        }
        if (num > 0.0f) {
            avg /= num;
        }
        return avg;
    }

    private float variance(float[] arr, float val) {
        float V = 0.0f;
        for (int i = 0; i < arr.length; ++i) {
            V += (float)Math.pow(arr[i] - val, 2.0);
        }
        return V /= (float)arr.length;
    }
}

