/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.service.wallpaper.WallpaperService;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.os.ResultReceiver;
import android.support.wearable.watchface.WatchFaceService;
import android.view.LayoutInflater;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import processing.android.AppComponent;
import processing.android.PFragment;
import processing.android.PermissionRequestor;
import processing.android.ServiceEngine;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PSurface;

public class PSurfaceNone
implements PSurface,
PConstants {
    protected PApplet sketch;
    protected PGraphics graphics;
    protected AppComponent component;
    protected Activity activity;
    protected boolean surfaceReady;
    protected SurfaceView surfaceView;
    protected View view;
    protected WallpaperService wallpaper;
    protected WatchFaceService watchface;
    protected boolean requestedThreadStart = false;
    protected Thread thread;
    protected boolean paused;
    protected Object pauseObject = new Object();
    protected float frameRateTarget = 60.0f;
    protected long frameRatePeriod = 16666666L;

    @Override
    public AppComponent getComponent() {
        return this.component;
    }

    @Override
    public Context getContext() {
        if (this.component.getKind() == 0) {
            return this.activity;
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper;
        }
        if (this.component.getKind() == 2) {
            return this.watchface;
        }
        return null;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public ServiceEngine getEngine() {
        return this.component.getEngine();
    }

    @Override
    public View getRootView() {
        return this.view;
    }

    @Override
    public String getName() {
        if (this.component.getKind() == 0) {
            return this.activity.getComponentName().getPackageName();
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getPackageName();
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getPackageName();
        }
        return "";
    }

    @Override
    public View getResource(int id) {
        return this.activity.findViewById(id);
    }

    @Override
    public Rect getVisibleFrame() {
        Rect frame = new Rect();
        if (this.view != null) {
            this.view.getWindowVisibleDisplayFrame(frame);
        }
        return frame;
    }

    @Override
    public void dispose() {
        this.sketch = null;
        this.graphics = null;
        if (this.activity != null) {
            // empty if block
        }
        if (this.view != null) {
            this.view.destroyDrawingCache();
        }
        if (this.component != null) {
            this.component.dispose();
        }
        if (this.surfaceView != null) {
            this.surfaceView.getHolder().getSurface().release();
        }
    }

    @Override
    public void setRootView(View view) {
        this.view = view;
    }

    @Override
    public SurfaceView getSurfaceView() {
        return this.surfaceView;
    }

    @Override
    public SurfaceHolder getSurfaceHolder() {
        SurfaceView view = this.getSurfaceView();
        if (view == null) {
            return null;
        }
        return view.getHolder();
    }

    @Override
    public void initView(int sketchWidth, int sketchHeight) {
        if (this.component.getKind() == 0) {
            SurfaceView rootView;
            int displayWidth = this.component.getDisplayWidth();
            int displayHeight = this.component.getDisplayHeight();
            if (sketchWidth == displayWidth && sketchHeight == displayHeight) {
                rootView = this.getSurfaceView();
            } else {
                RelativeLayout overallLayout = new RelativeLayout((Context)this.activity);
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
                lp.addRule(13);
                LinearLayout layout = new LinearLayout((Context)this.activity);
                layout.addView((View)this.getSurfaceView(), sketchWidth, sketchHeight);
                overallLayout.addView((View)layout, (ViewGroup.LayoutParams)lp);
                overallLayout.setBackgroundColor(this.sketch.sketchWindowColor());
                rootView = overallLayout;
            }
            this.setRootView((View)rootView);
        } else if (this.component.getKind() == 1) {
            this.setRootView((View)this.getSurfaceView());
        }
    }

    @Override
    public void initView(int sketchWidth, int sketchHeight, boolean parentSize, LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup rootView = (ViewGroup)inflater.inflate(this.sketch.parentLayout, container, false);
        SurfaceView view = this.getSurfaceView();
        if (parentSize) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -1);
            lp.weight = 1.0f;
            lp.setMargins(0, 0, 0, 0);
            view.setPadding(0, 0, 0, 0);
            rootView.addView((View)view, (ViewGroup.LayoutParams)lp);
        } else {
            RelativeLayout layout = new RelativeLayout((Context)this.activity);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-2, -2);
            lp.addRule(13);
            layout.addView((View)view, sketchWidth, sketchHeight);
            rootView.addView((View)layout, (ViewGroup.LayoutParams)lp);
        }
        rootView.setBackgroundColor(this.sketch.sketchWindowColor());
        this.setRootView((View)rootView);
    }

    @Override
    public void startActivity(Intent intent) {
        this.component.startActivity(intent);
    }

    @Override
    public void runOnUiThread(Runnable action) {
        if (this.component.getKind() == 0) {
            this.activity.runOnUiThread(action);
        }
    }

    @Override
    public void setOrientation(int which) {
        if (this.component.getKind() == 0) {
            if (which == 1) {
                this.activity.setRequestedOrientation(1);
            } else if (which == 2) {
                this.activity.setRequestedOrientation(0);
            }
        }
    }

    @Override
    public void setHasOptionsMenu(boolean hasMenu) {
        if (this.component.getKind() == 0) {
            ((PFragment)this.component).setHasOptionsMenu(hasMenu);
        }
    }

    @Override
    public File getFilesDir() {
        if (this.component.getKind() == 0) {
            return this.activity.getFilesDir();
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getFilesDir();
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getFilesDir();
        }
        return null;
    }

    @Override
    public File getFileStreamPath(String path) {
        if (this.component.getKind() == 0) {
            return this.activity.getFileStreamPath(path);
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getFileStreamPath(path);
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getFileStreamPath(path);
        }
        return null;
    }

    @Override
    public InputStream openFileInput(String filename) {
        if (this.component.getKind() == 0) {
            try {
                return this.activity.openFileInput(filename);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public AssetManager getAssets() {
        if (this.component.getKind() == 0) {
            return this.activity.getAssets();
        }
        if (this.component.getKind() == 1) {
            return this.wallpaper.getBaseContext().getAssets();
        }
        if (this.component.getKind() == 2) {
            return this.watchface.getBaseContext().getAssets();
        }
        return null;
    }

    @Override
    public void setSystemUiVisibility(int visibility) {
        int kind = this.component.getKind();
        if (kind == 0 || kind == 1) {
            this.surfaceView.setSystemUiVisibility(visibility);
        }
    }

    @Override
    public void finish() {
        if (this.component == null) {
            return;
        }
        if (this.component.getKind() == 0) {
            this.activity.finish();
        } else if (this.component.getKind() == 1) {
            this.wallpaper.stopSelf();
        } else if (this.component.getKind() == 2) {
            this.watchface.stopSelf();
        }
    }

    public Thread createThread() {
        return new AnimationThread();
    }

    @Override
    public void startThread() {
        if (!this.surfaceReady) {
            this.requestedThreadStart = true;
            return;
        }
        if (this.thread != null) {
            throw new IllegalStateException("Thread already started in " + this.getClass().getSimpleName());
        }
        this.thread = this.createThread();
        this.thread.start();
        this.requestedThreadStart = false;
    }

    @Override
    public void pauseThread() {
        if (!this.surfaceReady) {
            return;
        }
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeThread() {
        if (!this.surfaceReady) {
            return;
        }
        if (this.thread == null) {
            this.thread = this.createThread();
            this.thread.start();
        }
        this.paused = false;
        Object object = this.pauseObject;
        synchronized (object) {
            this.pauseObject.notifyAll();
        }
    }

    @Override
    public boolean stopThread() {
        if (!this.surfaceReady) {
            return true;
        }
        if (this.thread == null) {
            return false;
        }
        this.thread.interrupt();
        this.thread = null;
        return true;
    }

    @Override
    public boolean isStopped() {
        return this.thread == null;
    }

    @Override
    public void setFrameRate(float fps) {
        this.frameRateTarget = fps;
        this.frameRatePeriod = (long)(1.0E9 / (double)this.frameRateTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPause() throws InterruptedException {
        Object object = this.pauseObject;
        synchronized (object) {
            while (this.paused) {
                this.pauseObject.wait();
            }
        }
    }

    protected void callDraw() {
        this.component.requestDraw();
        if (this.component.canDraw() && this.sketch != null) {
            this.sketch.handleDraw();
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        int res = ContextCompat.checkSelfPermission((Context)this.getContext(), (String)permission);
        return res == 0;
    }

    @Override
    public void requestPermissions(String[] permissions) {
        if (this.component.isService()) {
            final ServiceEngine eng = this.getEngine();
            if (eng != null) {
                ResultReceiver resultReceiver = new ResultReceiver(new Handler(Looper.getMainLooper())){

                    protected void onReceiveResult(int resultCode, Bundle resultData) {
                        String[] outPermissions = resultData.getStringArray("permissions");
                        int[] grantResults = resultData.getIntArray("grantResults");
                        eng.onRequestPermissionsResult(resultCode, outPermissions, grantResults);
                    }
                };
                Intent permIntent = new Intent(this.getContext(), PermissionRequestor.class);
                permIntent.putExtra("resultReceiver", (Parcelable)resultReceiver);
                permIntent.putExtra("permissions", permissions);
                permIntent.putExtra("requestCode", 1);
                permIntent.addFlags(0x10000000);
                this.startActivity(permIntent);
            }
        } else if (this.activity != null) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissions, (int)1);
        }
    }

    public class AnimationThread
    extends Thread {
        public AnimationThread() {
            super("Animation Thread");
        }

        @Override
        public void run() {
            long beforeTime = System.nanoTime();
            long overSleepTime = 0L;
            int noDelays = 0;
            int NO_DELAYS_PER_YIELD = 15;
            if (PSurfaceNone.this.sketch == null) {
                return;
            }
            PSurfaceNone.this.sketch.start();
            while (Thread.currentThread() == PSurfaceNone.this.thread && PSurfaceNone.this.sketch != null && !PSurfaceNone.this.sketch.finished) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    PSurfaceNone.this.checkPause();
                }
                catch (InterruptedException e) {
                    return;
                }
                PSurfaceNone.this.callDraw();
                long afterTime = System.nanoTime();
                long timeDiff = afterTime - beforeTime;
                long sleepTime = PSurfaceNone.this.frameRatePeriod - timeDiff - overSleepTime;
                if (sleepTime > 0L) {
                    try {
                        Thread.sleep(sleepTime / 1000000L, (int)(sleepTime % 1000000L));
                        noDelays = 0;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    overSleepTime = System.nanoTime() - afterTime - sleepTime;
                } else {
                    overSleepTime = 0L;
                    if (++noDelays > 15) {
                        Thread.yield();
                        noDelays = 0;
                    }
                }
                beforeTime = System.nanoTime();
            }
        }
    }
}

