/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.graphics.Matrix;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PMatrix2D;
import processing.core.PShape;
import processing.data.IntDict;
import processing.data.StringDict;
import processing.data.XML;

public class PShapeSVG
extends PShape {
    XML element;
    protected float opacity;
    float strokeOpacity;
    float fillOpacity;
    protected float svgWidth;
    protected float svgHeight;
    protected float svgSizeXY;
    protected Gradient strokeGradient;
    String strokeName;
    protected Gradient fillGradient;
    String fillName;
    protected static IntDict colorNames = new IntDict(new Object[][]{{"aqua", 65535}, {"black", 0}, {"blue", 255}, {"fuchsia", 0xFF00FF}, {"gray", 0x808080}, {"grey", 0x808080}, {"green", 32768}, {"lime", 65280}, {"maroon", 0x800000}, {"navy", 128}, {"olive", 0x808000}, {"purple", 0x800080}, {"red", 0xFF0000}, {"silver", 0xC0C0C0}, {"teal", 32896}, {"white", 0xFFFFFF}, {"yellow", 0xFFFF00}});
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;

    public PShapeSVG(XML svg) {
        this(null, svg, true);
        if (!svg.getName().equals("svg")) {
            if (svg.getName().toLowerCase().equals("html")) {
                throw new RuntimeException("This appears to be a web page, not an SVG file.");
            }
            throw new RuntimeException("The root node is not <svg>, it's <" + svg.getName() + ">");
        }
    }

    protected PShapeSVG(PShapeSVG parent, XML properties, boolean parseKids) {
        String displayStr;
        this.setParent(parent);
        if (properties.getName().equals("svg")) {
            String viewBoxStr;
            String unitWidth = properties.getString("width");
            String unitHeight = properties.getString("height");
            if (unitWidth != null) {
                this.width = PShapeSVG.parseUnitSize(unitWidth, 100.0f);
            }
            if (unitHeight != null) {
                this.height = PShapeSVG.parseUnitSize(unitHeight, 100.0f);
            }
            if ((viewBoxStr = properties.getString("viewBox")) != null) {
                float[] viewBox = PApplet.parseFloat(PApplet.splitTokens(viewBoxStr));
                if (unitWidth == null || unitHeight == null) {
                    this.width = viewBox[2];
                    this.height = viewBox[3];
                } else {
                    if (this.matrix == null) {
                        this.matrix = new PMatrix2D();
                    }
                    this.matrix.scale(this.width / viewBox[2], this.height / viewBox[3]);
                    this.matrix.translate(-viewBox[0], -viewBox[1]);
                }
            }
            if (this.width < 0.0f || this.height < 0.0f) {
                throw new RuntimeException("<svg>: width (" + this.width + ") and height (" + this.height + ") must not be negative.");
            }
            if ((unitWidth == null || unitHeight == null) && viewBoxStr == null) {
                PGraphics.showWarning("The width and/or height is not readable in the <svg> tag of this file.");
                this.width = 1.0f;
                this.height = 1.0f;
            }
            this.svgWidth = this.width;
            this.svgHeight = this.height;
            this.svgSizeXY = PApplet.sqrt((this.svgWidth * this.svgWidth + this.svgHeight * this.svgHeight) / 2.0f);
        }
        this.element = properties;
        this.name = properties.getString("id");
        if (this.name != null) {
            String[] m;
            while ((m = PApplet.match(this.name, "_x([A-Za-z0-9]{2})_")) != null) {
                char repair = (char)PApplet.unhex(m[1]);
                this.name = this.name.replace(m[0], "" + repair);
            }
        }
        this.visible = !(displayStr = properties.getString("display", "inline")).equals("none");
        String transformStr = properties.getString("transform");
        if (transformStr != null) {
            if (this.matrix == null) {
                this.matrix = PShapeSVG.parseTransform(transformStr);
            } else {
                this.matrix.preApply(PShapeSVG.parseTransform(transformStr));
            }
        }
        if (parseKids) {
            this.parseColors(properties);
            this.parseChildren(properties);
        }
    }

    protected void setParent(PShapeSVG parent) {
        this.parent = parent;
        if (parent == null) {
            this.stroke = false;
            this.strokeColor = -16777216;
            this.strokeWeight = 1.0f;
            this.strokeCap = 1;
            this.strokeJoin = 8;
            this.strokeGradient = null;
            this.strokeName = null;
            this.fill = true;
            this.fillColor = -16777216;
            this.fillGradient = null;
            this.fillName = null;
            this.strokeOpacity = 1.0f;
            this.fillOpacity = 1.0f;
            this.opacity = 1.0f;
        } else {
            this.stroke = parent.stroke;
            this.strokeColor = parent.strokeColor;
            this.strokeWeight = parent.strokeWeight;
            this.strokeCap = parent.strokeCap;
            this.strokeJoin = parent.strokeJoin;
            this.strokeGradient = parent.strokeGradient;
            this.strokeName = parent.strokeName;
            this.fill = parent.fill;
            this.fillColor = parent.fillColor;
            this.fillGradient = parent.fillGradient;
            this.fillName = parent.fillName;
            this.svgWidth = parent.svgWidth;
            this.svgHeight = parent.svgHeight;
            this.svgSizeXY = parent.svgSizeXY;
            this.opacity = parent.opacity;
        }
        this.rectMode = 0;
        this.ellipseMode = 0;
    }

    protected PShapeSVG createShape(PShapeSVG parent, XML properties, boolean parseKids) {
        return new PShapeSVG(parent, properties, parseKids);
    }

    protected void parseChildren(XML graphics) {
        XML[] elements = graphics.getChildren();
        this.children = new PShape[elements.length];
        this.childCount = 0;
        for (XML elem : elements) {
            PShape kid = this.parseChild(elem);
            if (kid == null) continue;
            this.addChild(kid);
        }
        this.children = (PShape[])PApplet.subset(this.children, 0, this.childCount);
    }

    protected PShape parseChild(XML elem) {
        String name = elem.getName();
        PShapeSVG shape = null;
        if (name != null) {
            if (name.equals("g")) {
                shape = this.createShape(this, elem, true);
            } else if (name.equals("defs")) {
                shape = this.createShape(this, elem, true);
            } else if (name.equals("line")) {
                shape = this.createShape(this, elem, true);
                shape.parseLine();
            } else if (name.equals("circle")) {
                shape = this.createShape(this, elem, true);
                shape.parseEllipse(true);
            } else if (name.equals("ellipse")) {
                shape = this.createShape(this, elem, true);
                shape.parseEllipse(false);
            } else if (name.equals("rect")) {
                shape = this.createShape(this, elem, true);
                shape.parseRect();
            } else if (name.equals("image")) {
                shape = this.createShape(this, elem, true);
                shape.parseImage();
            } else if (name.equals("polygon")) {
                shape = this.createShape(this, elem, true);
                shape.parsePoly(true);
            } else if (name.equals("polyline")) {
                shape = this.createShape(this, elem, true);
                shape.parsePoly(false);
            } else if (name.equals("path")) {
                shape = this.createShape(this, elem, true);
                shape.parsePath();
            } else {
                if (name.equals("radialGradient")) {
                    return new RadialGradient(this, elem);
                }
                if (name.equals("linearGradient")) {
                    return new LinearGradient(this, elem);
                }
                if (name.equals("font")) {
                    return new Font(this, elem);
                }
                if (name.equals("text")) {
                    return new Text(this, elem);
                }
                if (name.equals("tspan")) {
                    PGraphics.showWarning("tspan elements are not supported.");
                } else if (name.equals("filter")) {
                    PGraphics.showWarning("Filters are not supported.");
                } else if (name.equals("mask")) {
                    PGraphics.showWarning("Masks are not supported.");
                } else if (name.equals("pattern")) {
                    PGraphics.showWarning("Patterns are not supported.");
                } else if (!name.equals("stop") && !name.equals("sodipodi:namedview")) {
                    if (name.equals("metadata") || name.equals("title") || name.equals("desc")) {
                        return null;
                    }
                    if (!name.startsWith("#")) {
                        PGraphics.showWarning("Ignoring <" + name + "> tag.");
                    }
                }
            }
        }
        return shape;
    }

    protected void parseLine() {
        this.kind = 4;
        this.family = 101;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x1", this.svgWidth), PShapeSVG.getFloatWithUnit(this.element, "y1", this.svgHeight), PShapeSVG.getFloatWithUnit(this.element, "x2", this.svgWidth), PShapeSVG.getFloatWithUnit(this.element, "y2", this.svgHeight)};
    }

    protected void parseEllipse(boolean circle) {
        float rx;
        float ry;
        this.kind = 31;
        this.family = 101;
        this.params = new float[4];
        this.params[0] = PShapeSVG.getFloatWithUnit(this.element, "cx", this.svgWidth);
        this.params[1] = PShapeSVG.getFloatWithUnit(this.element, "cy", this.svgHeight);
        if (circle) {
            rx = ry = PShapeSVG.getFloatWithUnit(this.element, "r", this.svgSizeXY);
        } else {
            rx = PShapeSVG.getFloatWithUnit(this.element, "rx", this.svgWidth);
            ry = PShapeSVG.getFloatWithUnit(this.element, "ry", this.svgHeight);
        }
        this.params[0] = this.params[0] - rx;
        this.params[1] = this.params[1] - ry;
        this.params[2] = rx * 2.0f;
        this.params[3] = ry * 2.0f;
    }

    protected void parseRect() {
        this.kind = 30;
        this.family = 101;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x", this.svgWidth), PShapeSVG.getFloatWithUnit(this.element, "y", this.svgHeight), PShapeSVG.getFloatWithUnit(this.element, "width", this.svgWidth), PShapeSVG.getFloatWithUnit(this.element, "height", this.svgHeight)};
    }

    protected void parseImage() {
        this.kind = 30;
        this.textureMode = 1;
        this.family = 101;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x", this.svgWidth), PShapeSVG.getFloatWithUnit(this.element, "y", this.svgHeight), PShapeSVG.getFloatWithUnit(this.element, "width", this.svgWidth), PShapeSVG.getFloatWithUnit(this.element, "height", this.svgHeight)};
        this.imagePath = this.element.getString("xlink:href");
    }

    protected void parsePoly(boolean close) {
        this.family = 102;
        this.close = close;
        String pointsAttr = this.element.getString("points");
        if (pointsAttr != null) {
            Pattern pattern = Pattern.compile("([+-]?[\\d]+(\\.[\\d]+)?([eE][+-][\\d]+)?)(,?\\s*)([+-]?[\\d]+(\\.[\\d]+)?([eE][+-][\\d]+)?)");
            Matcher matcher = pattern.matcher(pointsAttr);
            this.vertexCount = 0;
            while (matcher.find()) {
                ++this.vertexCount;
            }
            matcher.reset();
            this.vertices = new float[this.vertexCount][2];
            for (int i = 0; i < this.vertexCount; ++i) {
                matcher.find();
                this.vertices[i][0] = Float.parseFloat(matcher.group(1));
                this.vertices[i][1] = Float.parseFloat(matcher.group(5));
            }
        }
    }

    protected void parsePath() {
        this.family = 102;
        this.kind = 0;
        String pathData = this.element.getString("d");
        if (pathData == null || PApplet.trim(pathData).length() == 0) {
            return;
        }
        char[] pathDataChars = pathData.toCharArray();
        StringBuilder pathBuffer = new StringBuilder();
        boolean lastSeparate = false;
        for (int i = 0; i < pathDataChars.length; ++i) {
            char c = pathDataChars[i];
            boolean separate = false;
            if (c == 'M' || c == 'm' || c == 'L' || c == 'l' || c == 'H' || c == 'h' || c == 'V' || c == 'v' || c == 'C' || c == 'c' || c == 'S' || c == 's' || c == 'Q' || c == 'q' || c == 'T' || c == 't' || c == 'A' || c == 'a' || c == 'Z' || c == 'z' || c == ',') {
                separate = true;
                if (i != 0) {
                    pathBuffer.append("|");
                }
            }
            if (c == 'Z' || c == 'z') {
                separate = false;
            }
            if (!(c != '-' || lastSeparate || i != 0 && pathDataChars[i - 1] == 'e')) {
                pathBuffer.append("|");
            }
            if (c != ',') {
                pathBuffer.append(c);
            }
            if (separate && c != ',' && c != '-') {
                pathBuffer.append("|");
            }
            lastSeparate = separate;
        }
        String[] pathTokens = PApplet.splitTokens(pathBuffer.toString(), "| \t\n\r\f\u00a0");
        this.vertices = new float[pathTokens.length][2];
        this.vertexCodes = new int[pathTokens.length];
        float cx = 0.0f;
        float cy = 0.0f;
        int i = 0;
        int implicitCommand = 0;
        boolean prevCurve = false;
        float movetoX = 0.0f;
        float movetoY = 0.0f;
        block22: while (i < pathTokens.length) {
            int c = pathTokens[i].charAt(0);
            if ((c >= 48 && c <= 57 || c == 45) && implicitCommand != 0) {
                c = implicitCommand;
                --i;
            } else {
                implicitCommand = c;
            }
            switch (c) {
                case 77: {
                    cx = PApplet.parseFloat(pathTokens[i + 1]);
                    cy = PApplet.parseFloat(pathTokens[i + 2]);
                    movetoX = cx;
                    movetoY = cy;
                    this.parsePathMoveto(cx, cy);
                    implicitCommand = 76;
                    i += 3;
                    continue block22;
                }
                case 109: {
                    movetoX = cx += PApplet.parseFloat(pathTokens[i + 1]);
                    movetoY = cy += PApplet.parseFloat(pathTokens[i + 2]);
                    this.parsePathMoveto(cx, cy);
                    implicitCommand = 108;
                    i += 3;
                    continue block22;
                }
                case 76: {
                    cx = PApplet.parseFloat(pathTokens[i + 1]);
                    cy = PApplet.parseFloat(pathTokens[i + 2]);
                    this.parsePathLineto(cx, cy);
                    i += 3;
                    continue block22;
                }
                case 108: {
                    this.parsePathLineto(cx += PApplet.parseFloat(pathTokens[i + 1]), cy += PApplet.parseFloat(pathTokens[i + 2]));
                    i += 3;
                    continue block22;
                }
                case 72: {
                    cx = PApplet.parseFloat(pathTokens[i + 1]);
                    this.parsePathLineto(cx, cy);
                    i += 2;
                    continue block22;
                }
                case 104: {
                    this.parsePathLineto(cx += PApplet.parseFloat(pathTokens[i + 1]), cy);
                    i += 2;
                    continue block22;
                }
                case 86: {
                    cy = PApplet.parseFloat(pathTokens[i + 1]);
                    this.parsePathLineto(cx, cy);
                    i += 2;
                    continue block22;
                }
                case 118: {
                    this.parsePathLineto(cx, cy += PApplet.parseFloat(pathTokens[i + 1]));
                    i += 2;
                    continue block22;
                }
                case 67: {
                    float ctrlX1 = PApplet.parseFloat(pathTokens[i + 1]);
                    float ctrlY1 = PApplet.parseFloat(pathTokens[i + 2]);
                    float ctrlX2 = PApplet.parseFloat(pathTokens[i + 3]);
                    float ctrlY2 = PApplet.parseFloat(pathTokens[i + 4]);
                    float endX = PApplet.parseFloat(pathTokens[i + 5]);
                    float endY = PApplet.parseFloat(pathTokens[i + 6]);
                    this.parsePathCurveto(ctrlX1, ctrlY1, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 7;
                    prevCurve = true;
                    continue block22;
                }
                case 99: {
                    float ctrlX1 = cx + PApplet.parseFloat(pathTokens[i + 1]);
                    float ctrlY1 = cy + PApplet.parseFloat(pathTokens[i + 2]);
                    float ctrlX2 = cx + PApplet.parseFloat(pathTokens[i + 3]);
                    float ctrlY2 = cy + PApplet.parseFloat(pathTokens[i + 4]);
                    float endX = cx + PApplet.parseFloat(pathTokens[i + 5]);
                    float endY = cy + PApplet.parseFloat(pathTokens[i + 6]);
                    this.parsePathCurveto(ctrlX1, ctrlY1, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 7;
                    prevCurve = true;
                    continue block22;
                }
                case 83: {
                    float px;
                    float ppy;
                    float ppx;
                    float ctrlY;
                    float ctrlX;
                    if (!prevCurve) {
                        ctrlX = cx;
                        ctrlY = cy;
                    } else {
                        ppx = this.vertices[this.vertexCount - 2][0];
                        ppy = this.vertices[this.vertexCount - 2][1];
                        px = this.vertices[this.vertexCount - 1][0];
                        float py = this.vertices[this.vertexCount - 1][1];
                        ctrlX = px + (px - ppx);
                        ctrlY = py + (py - ppy);
                    }
                    float ctrlX2 = PApplet.parseFloat(pathTokens[i + 1]);
                    float ctrlY2 = PApplet.parseFloat(pathTokens[i + 2]);
                    float endX = PApplet.parseFloat(pathTokens[i + 3]);
                    float endY = PApplet.parseFloat(pathTokens[i + 4]);
                    this.parsePathCurveto(ctrlX, ctrlY, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 5;
                    prevCurve = true;
                    continue block22;
                }
                case 115: {
                    float px;
                    float ppy;
                    float ppx;
                    float ctrlY;
                    float ctrlX;
                    if (!prevCurve) {
                        ctrlX = cx;
                        ctrlY = cy;
                    } else {
                        ppx = this.vertices[this.vertexCount - 2][0];
                        ppy = this.vertices[this.vertexCount - 2][1];
                        px = this.vertices[this.vertexCount - 1][0];
                        float py = this.vertices[this.vertexCount - 1][1];
                        ctrlX = px + (px - ppx);
                        ctrlY = py + (py - ppy);
                    }
                    float ctrlX2 = cx + PApplet.parseFloat(pathTokens[i + 1]);
                    float ctrlY2 = cy + PApplet.parseFloat(pathTokens[i + 2]);
                    float endX = cx + PApplet.parseFloat(pathTokens[i + 3]);
                    float endY = cy + PApplet.parseFloat(pathTokens[i + 4]);
                    this.parsePathCurveto(ctrlX, ctrlY, ctrlX2, ctrlY2, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 5;
                    prevCurve = true;
                    continue block22;
                }
                case 81: {
                    float ctrlX = PApplet.parseFloat(pathTokens[i + 1]);
                    float ctrlY = PApplet.parseFloat(pathTokens[i + 2]);
                    float endX = PApplet.parseFloat(pathTokens[i + 3]);
                    float endY = PApplet.parseFloat(pathTokens[i + 4]);
                    this.parsePathQuadto(ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 5;
                    prevCurve = true;
                    continue block22;
                }
                case 113: {
                    float ctrlX = cx + PApplet.parseFloat(pathTokens[i + 1]);
                    float ctrlY = cy + PApplet.parseFloat(pathTokens[i + 2]);
                    float endX = cx + PApplet.parseFloat(pathTokens[i + 3]);
                    float endY = cy + PApplet.parseFloat(pathTokens[i + 4]);
                    this.parsePathQuadto(ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 5;
                    prevCurve = true;
                    continue block22;
                }
                case 84: {
                    float px;
                    float ppy;
                    float ppx;
                    float ctrlY;
                    float ctrlX;
                    if (!prevCurve) {
                        ctrlX = cx;
                        ctrlY = cy;
                    } else {
                        ppx = this.vertices[this.vertexCount - 2][0];
                        ppy = this.vertices[this.vertexCount - 2][1];
                        px = this.vertices[this.vertexCount - 1][0];
                        float py = this.vertices[this.vertexCount - 1][1];
                        ctrlX = px + (px - ppx);
                        ctrlY = py + (py - ppy);
                    }
                    float endX = PApplet.parseFloat(pathTokens[i + 1]);
                    float endY = PApplet.parseFloat(pathTokens[i + 2]);
                    this.parsePathQuadto(ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 3;
                    prevCurve = true;
                    continue block22;
                }
                case 116: {
                    float px;
                    float ppy;
                    float ppx;
                    float ctrlY;
                    float ctrlX;
                    if (!prevCurve) {
                        ctrlX = cx;
                        ctrlY = cy;
                    } else {
                        ppx = this.vertices[this.vertexCount - 2][0];
                        ppy = this.vertices[this.vertexCount - 2][1];
                        px = this.vertices[this.vertexCount - 1][0];
                        float py = this.vertices[this.vertexCount - 1][1];
                        ctrlX = px + (px - ppx);
                        ctrlY = py + (py - ppy);
                    }
                    float endX = cx + PApplet.parseFloat(pathTokens[i + 1]);
                    float endY = cy + PApplet.parseFloat(pathTokens[i + 2]);
                    this.parsePathQuadto(ctrlX, ctrlY, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 3;
                    prevCurve = true;
                    continue block22;
                }
                case 65: {
                    float rx = PApplet.parseFloat(pathTokens[i + 1]);
                    float ry = PApplet.parseFloat(pathTokens[i + 2]);
                    float angle = PApplet.parseFloat(pathTokens[i + 3]);
                    boolean fa = PApplet.parseFloat(pathTokens[i + 4]) != 0.0f;
                    boolean fs = PApplet.parseFloat(pathTokens[i + 5]) != 0.0f;
                    float endX = PApplet.parseFloat(pathTokens[i + 6]);
                    float endY = PApplet.parseFloat(pathTokens[i + 7]);
                    this.parsePathArcto(cx, cy, rx, ry, angle, fa, fs, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 8;
                    prevCurve = true;
                    continue block22;
                }
                case 97: {
                    float rx = PApplet.parseFloat(pathTokens[i + 1]);
                    float ry = PApplet.parseFloat(pathTokens[i + 2]);
                    float angle = PApplet.parseFloat(pathTokens[i + 3]);
                    boolean fa = PApplet.parseFloat(pathTokens[i + 4]) != 0.0f;
                    boolean fs = PApplet.parseFloat(pathTokens[i + 5]) != 0.0f;
                    float endX = cx + PApplet.parseFloat(pathTokens[i + 6]);
                    float endY = cy + PApplet.parseFloat(pathTokens[i + 7]);
                    this.parsePathArcto(cx, cy, rx, ry, angle, fa, fs, endX, endY);
                    cx = endX;
                    cy = endY;
                    i += 8;
                    prevCurve = true;
                    continue block22;
                }
                case 90: 
                case 122: {
                    cx = movetoX;
                    cy = movetoY;
                    this.close = true;
                    ++i;
                    continue block22;
                }
            }
            String parsed = PApplet.join(PApplet.subset(pathTokens, 0, i), ",");
            String unparsed = PApplet.join(PApplet.subset(pathTokens, i), ",");
            System.err.println("parsed: " + parsed);
            System.err.println("unparsed: " + unparsed);
            throw new RuntimeException("shape command not handled: " + pathTokens[i]);
        }
    }

    private void parsePathVertex(float x, float y) {
        if (this.vertexCount == this.vertices.length) {
            float[][] temp = new float[this.vertexCount << 1][2];
            System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
            this.vertices = temp;
        }
        this.vertices[this.vertexCount][0] = x;
        this.vertices[this.vertexCount][1] = y;
        ++this.vertexCount;
    }

    private void parsePathCode(int what) {
        if (this.vertexCodeCount == this.vertexCodes.length) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = what;
    }

    private void parsePathMoveto(float px, float py) {
        if (this.vertexCount > 0) {
            this.parsePathCode(4);
        }
        this.parsePathCode(0);
        this.parsePathVertex(px, py);
    }

    private void parsePathLineto(float px, float py) {
        this.parsePathCode(0);
        this.parsePathVertex(px, py);
    }

    private void parsePathCurveto(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.parsePathCode(1);
        this.parsePathVertex(x1, y1);
        this.parsePathVertex(x2, y2);
        this.parsePathVertex(x3, y3);
    }

    private void parsePathQuadto(float cx, float cy, float x2, float y2) {
        this.parsePathCode(2);
        this.parsePathVertex(cx, cy);
        this.parsePathVertex(x2, y2);
    }

    private void parsePathArcto(float x1, float y1, float rx, float ry, float angle, boolean fa, boolean fs, float x2, float y2) {
        float cyr;
        float cxr;
        float y1r;
        float sinPhi;
        if (x1 == x2 && y1 == y2) {
            return;
        }
        if (rx == 0.0f || ry == 0.0f) {
            this.parsePathLineto(x2, y2);
            return;
        }
        rx = PApplet.abs(rx);
        ry = PApplet.abs(ry);
        float phi = PApplet.radians((angle % 360.0f + 360.0f) % 360.0f);
        float cosPhi = PApplet.cos(phi);
        float x1r = (cosPhi * (x1 - x2) + (sinPhi = PApplet.sin(phi)) * (y1 - y2)) / 2.0f;
        float A = x1r * x1r / (rx * rx) + (y1r = (-sinPhi * (x1 - x2) + cosPhi * (y1 - y2)) / 2.0f) * y1r / (ry * ry);
        if (A > 1.0f) {
            float sqrtA = PApplet.sqrt(A);
            rx *= sqrtA;
            cxr = 0.0f;
            ry *= sqrtA;
            cyr = 0.0f;
        } else {
            float k = (fa == fs ? -1.0f : 1.0f) * PApplet.sqrt(rx * rx * ry * ry / (rx * rx * y1r * y1r + ry * ry * x1r * x1r) - 1.0f);
            cxr = k * rx * y1r / ry;
            cyr = -k * ry * x1r / rx;
        }
        float cx = cosPhi * cxr - sinPhi * cyr + (x1 + x2) / 2.0f;
        float cy = sinPhi * cxr + cosPhi * cyr + (y1 + y2) / 2.0f;
        float sx = (x1r - cxr) / rx;
        float sy = (y1r - cyr) / ry;
        float tx = (-x1r - cxr) / rx;
        float ty = (-y1r - cyr) / ry;
        float phi1 = PApplet.atan2(sy, sx);
        float phiDelta = ((PApplet.atan2(ty, tx) - phi1) % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
        if (!fs) {
            phiDelta -= (float)Math.PI * 2;
        }
        int segmentCount = PApplet.ceil(PApplet.abs(phiDelta) / ((float)Math.PI * 2) * 4.0f);
        float inc = phiDelta / (float)segmentCount;
        float a = PApplet.sin(inc) * (PApplet.sqrt(4.0f + 3.0f * PApplet.sq(PApplet.tan(inc / 2.0f))) - 1.0f) / 3.0f;
        float sinPhi1 = PApplet.sin(phi1);
        float cosPhi1 = PApplet.cos(phi1);
        float p1x = x1;
        float p1y = y1;
        float relq1x = a * (-rx * cosPhi * sinPhi1 - ry * sinPhi * cosPhi1);
        float relq1y = a * (-rx * sinPhi * sinPhi1 + ry * cosPhi * cosPhi1);
        for (int i = 0; i < segmentCount; ++i) {
            float eta = phi1 + (float)(i + 1) * inc;
            float sinEta = PApplet.sin(eta);
            float cosEta = PApplet.cos(eta);
            float p2x = cx + rx * cosPhi * cosEta - ry * sinPhi * sinEta;
            float p2y = cy + rx * sinPhi * cosEta + ry * cosPhi * sinEta;
            float relq2x = a * (-rx * cosPhi * sinEta - ry * sinPhi * cosEta);
            float relq2y = a * (-rx * sinPhi * sinEta + ry * cosPhi * cosEta);
            if (i == segmentCount - 1) {
                p2x = x2;
                p2y = y2;
            }
            this.parsePathCode(1);
            this.parsePathVertex(p1x + relq1x, p1y + relq1y);
            this.parsePathVertex(p2x - relq2x, p2y - relq2y);
            this.parsePathVertex(p2x, p2y);
            p1x = p2x;
            relq1x = relq2x;
            p1y = p2y;
            relq1y = relq2y;
        }
    }

    protected static PMatrix2D parseTransform(String matrixStr) {
        matrixStr = matrixStr.trim();
        PMatrix2D outgoing = null;
        int start = 0;
        int stop = -1;
        while ((stop = matrixStr.indexOf(41, start)) != -1) {
            PMatrix2D m = PShapeSVG.parseSingleTransform(matrixStr.substring(start, stop + 1));
            if (outgoing == null) {
                outgoing = m;
            } else {
                outgoing.apply(m);
            }
            start = stop + 1;
        }
        return outgoing;
    }

    protected static PMatrix2D parseSingleTransform(String matrixStr) {
        String[] pieces = PApplet.match(matrixStr, "[,\\s]*(\\w+)\\((.*)\\)");
        if (pieces == null) {
            System.err.println("Could not parse transform " + matrixStr);
            return null;
        }
        float[] m = PApplet.parseFloat(PApplet.splitTokens(pieces[2], ", "));
        if (pieces[1].equals("matrix")) {
            return new PMatrix2D(m[0], m[2], m[4], m[1], m[3], m[5]);
        }
        if (pieces[1].equals("translate")) {
            float tx = m[0];
            float ty = m.length == 2 ? m[1] : m[0];
            return new PMatrix2D(1.0f, 0.0f, tx, 0.0f, 1.0f, ty);
        }
        if (pieces[1].equals("scale")) {
            float sx = m[0];
            float sy = m.length == 2 ? m[1] : m[0];
            return new PMatrix2D(sx, 0.0f, 0.0f, 0.0f, sy, 0.0f);
        }
        if (pieces[1].equals("rotate")) {
            float angle = m[0];
            if (m.length == 1) {
                float c = PApplet.cos(angle);
                float s = PApplet.sin(angle);
                return new PMatrix2D(c, -s, 0.0f, s, c, 0.0f);
            }
            if (m.length == 3) {
                PMatrix2D mat = new PMatrix2D(0.0f, 1.0f, m[1], 1.0f, 0.0f, m[2]);
                mat.rotate(m[0]);
                mat.translate(-m[1], -m[2]);
                return mat;
            }
        } else {
            if (pieces[1].equals("skewX")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, PApplet.tan(m[0]), 0.0f, 0.0f);
            }
            if (pieces[1].equals("skewY")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, 0.0f, PApplet.tan(m[0]), 0.0f);
            }
        }
        return null;
    }

    protected void parseColors(XML properties) {
        if (properties.hasAttribute("opacity")) {
            String opacityText = properties.getString("opacity");
            this.setOpacity(opacityText);
        }
        if (properties.hasAttribute("stroke")) {
            String strokeText = properties.getString("stroke");
            this.setColor(strokeText, false);
        }
        if (properties.hasAttribute("stroke-opacity")) {
            String strokeOpacityText = properties.getString("stroke-opacity");
            this.setStrokeOpacity(strokeOpacityText);
        }
        if (properties.hasAttribute("stroke-width")) {
            String lineweight = properties.getString("stroke-width");
            this.setStrokeWeight(lineweight);
        }
        if (properties.hasAttribute("stroke-linejoin")) {
            String linejoin = properties.getString("stroke-linejoin");
            this.setStrokeJoin(linejoin);
        }
        if (properties.hasAttribute("stroke-linecap")) {
            String linecap = properties.getString("stroke-linecap");
            this.setStrokeCap(linecap);
        }
        if (properties.hasAttribute("fill")) {
            String fillText = properties.getString("fill");
            this.setColor(fillText, true);
        }
        if (properties.hasAttribute("fill-opacity")) {
            String fillOpacityText = properties.getString("fill-opacity");
            this.setFillOpacity(fillOpacityText);
        }
        if (properties.hasAttribute("style")) {
            String styleText = properties.getString("style");
            String[] styleTokens = PApplet.splitTokens(styleText, ";");
            for (int i = 0; i < styleTokens.length; ++i) {
                String[] tokens = PApplet.splitTokens(styleTokens[i], ":");
                tokens[0] = PApplet.trim(tokens[0]);
                if (tokens[0].equals("fill")) {
                    this.setColor(tokens[1], true);
                    continue;
                }
                if (tokens[0].equals("fill-opacity")) {
                    this.setFillOpacity(tokens[1]);
                    continue;
                }
                if (tokens[0].equals("stroke")) {
                    this.setColor(tokens[1], false);
                    continue;
                }
                if (tokens[0].equals("stroke-width")) {
                    this.setStrokeWeight(tokens[1]);
                    continue;
                }
                if (tokens[0].equals("stroke-linecap")) {
                    this.setStrokeCap(tokens[1]);
                    continue;
                }
                if (tokens[0].equals("stroke-linejoin")) {
                    this.setStrokeJoin(tokens[1]);
                    continue;
                }
                if (tokens[0].equals("stroke-opacity")) {
                    this.setStrokeOpacity(tokens[1]);
                    continue;
                }
                if (!tokens[0].equals("opacity")) continue;
                this.setOpacity(tokens[1]);
            }
        }
    }

    void setOpacity(String opacityText) {
        this.opacity = PApplet.parseFloat(opacityText);
        this.strokeColor = (int)(this.opacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
        this.fillColor = (int)(this.opacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setStrokeWeight(String lineweight) {
        this.strokeWeight = PShapeSVG.parseUnitSize(lineweight, this.svgSizeXY);
    }

    void setStrokeOpacity(String opacityText) {
        this.strokeOpacity = PApplet.parseFloat(opacityText);
        this.strokeColor = (int)(this.strokeOpacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
    }

    void setStrokeJoin(String linejoin) {
        if (!linejoin.equals("inherit")) {
            if (linejoin.equals("miter")) {
                this.strokeJoin = 8;
            } else if (linejoin.equals("round")) {
                this.strokeJoin = 2;
            } else if (linejoin.equals("bevel")) {
                this.strokeJoin = 32;
            }
        }
    }

    void setStrokeCap(String linecap) {
        if (!linecap.equals("inherit")) {
            if (linecap.equals("butt")) {
                this.strokeCap = 1;
            } else if (linecap.equals("round")) {
                this.strokeCap = 2;
            } else if (linecap.equals("square")) {
                this.strokeCap = 4;
            }
        }
    }

    void setFillOpacity(String opacityText) {
        this.fillOpacity = PApplet.parseFloat(opacityText);
        this.fillColor = (int)(this.fillOpacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setColor(String colorText, boolean isFill) {
        colorText = colorText.trim();
        int opacityMask = this.fillColor & 0xFF000000;
        boolean visible = true;
        int color = 0;
        String name = "";
        Gradient gradient = null;
        if (colorText.equals("none")) {
            visible = false;
        } else if (colorText.startsWith("url(#")) {
            name = colorText.substring(5, colorText.length() - 1);
            PShape object = this.findChild(name);
            if (object instanceof Gradient) {
                gradient = (Gradient)object;
            } else {
                System.err.println("url " + name + " refers to unexpected data: " + object);
            }
        } else {
            color = opacityMask | PShapeSVG.parseSimpleColor(colorText);
        }
        if (isFill) {
            this.fill = visible;
            this.fillColor = color;
            this.fillName = name;
            this.fillGradient = gradient;
        } else {
            this.stroke = visible;
            this.strokeColor = color;
            this.strokeName = name;
            this.strokeGradient = gradient;
        }
    }

    protected static int parseSimpleColor(String colorText) {
        if (colorNames.hasKey(colorText = colorText.toLowerCase().trim())) {
            return colorNames.get(colorText);
        }
        if (colorText.startsWith("#")) {
            if (colorText.length() == 4) {
                colorText = colorText.replaceAll("^#(.)(.)(.)$", "#$1$1$2$2$3$3");
            }
            return Integer.parseInt(colorText.substring(1), 16) & 0xFFFFFF;
        }
        if (colorText.startsWith("rgb")) {
            return PShapeSVG.parseRGB(colorText);
        }
        System.err.println("Cannot parse \"" + colorText + "\".");
        return 0;
    }

    protected static int parseRGB(String what) {
        int leftParen = what.indexOf(40) + 1;
        int rightParen = what.indexOf(41);
        String sub = what.substring(leftParen, rightParen);
        String[] values = PApplet.splitTokens(sub, ", ");
        int rgbValue = 0;
        if (values.length == 3) {
            for (int i = 0; i < 3; ++i) {
                rgbValue <<= 8;
                if (values[i].endsWith("%")) {
                    rgbValue |= (int)PApplet.constrain(255.0f * PShapeSVG.parseFloatOrPercent(values[i]), 0.0f, 255.0f);
                    continue;
                }
                rgbValue |= PApplet.constrain(PApplet.parseInt(values[i]), 0, 255);
            }
        } else {
            System.err.println("Could not read color \"" + what + "\".");
        }
        return rgbValue;
    }

    protected static StringDict parseStyleAttributes(String style) {
        StringDict table = new StringDict();
        if (style != null) {
            String[] pieces = style.split(";");
            for (int i = 0; i < pieces.length; ++i) {
                String[] parts = pieces[i].split(":");
                table.set(parts[0], parts[1]);
            }
        }
        return table;
    }

    protected static float getFloatWithUnit(XML element, String attribute, float relativeTo) {
        String val = element.getString(attribute);
        return val == null ? 0.0f : PShapeSVG.parseUnitSize(val, relativeTo);
    }

    protected static float parseUnitSize(String text, float relativeTo) {
        int len = text.length() - 2;
        if (text.endsWith("pt")) {
            return PApplet.parseFloat(text.substring(0, len)) * 1.25f;
        }
        if (text.endsWith("pc")) {
            return PApplet.parseFloat(text.substring(0, len)) * 15.0f;
        }
        if (text.endsWith("mm")) {
            return PApplet.parseFloat(text.substring(0, len)) * 3.543307f;
        }
        if (text.endsWith("cm")) {
            return PApplet.parseFloat(text.substring(0, len)) * 35.43307f;
        }
        if (text.endsWith("in")) {
            return PApplet.parseFloat(text.substring(0, len)) * 90.0f;
        }
        if (text.endsWith("px")) {
            return PApplet.parseFloat(text.substring(0, len));
        }
        if (text.endsWith("%")) {
            return relativeTo * PShapeSVG.parseFloatOrPercent(text);
        }
        return PApplet.parseFloat(text);
    }

    protected static float parseFloatOrPercent(String text) {
        if ((text = text.trim()).endsWith("%")) {
            return Float.parseFloat(text.substring(0, text.length() - 1)) / 100.0f;
        }
        return Float.parseFloat(text);
    }

    private static PFont parseFont(XML properties) {
        String fontFamily = null;
        float size = 10.0f;
        int weight = 0;
        int italic = 0;
        if (properties.hasAttribute("style")) {
            String styleText = properties.getString("style");
            String[] styleTokens = PApplet.splitTokens(styleText, ";");
            for (int i = 0; i < styleTokens.length; ++i) {
                String[] tokens = PApplet.splitTokens(styleTokens[i], ":");
                tokens[0] = PApplet.trim(tokens[0]);
                if (tokens[0].equals("font-style")) {
                    if (!tokens[1].contains("italic")) continue;
                    italic = 2;
                    continue;
                }
                if (tokens[0].equals("font-variant")) continue;
                if (tokens[0].equals("font-weight")) {
                    if (!tokens[1].contains("bold")) continue;
                    weight = 1;
                    continue;
                }
                if (tokens[0].equals("font-stretch")) continue;
                if (tokens[0].equals("font-size")) {
                    size = Float.parseFloat(tokens[1].split("px")[0]);
                    continue;
                }
                if (tokens[0].equals("line-height")) continue;
                if (tokens[0].equals("font-family")) {
                    fontFamily = tokens[1];
                    continue;
                }
                if (!tokens[0].equals("text-align") && !tokens[0].equals("letter-spacing") && !tokens[0].equals("word-spacing") && !tokens[0].equals("writing-mode") && !tokens[0].equals("text-anchor")) continue;
            }
        }
        if (fontFamily == null) {
            return null;
        }
        return PShapeSVG.createFont(fontFamily, weight | italic, size, true);
    }

    protected static PFont createFont(String name, int weight, float size, boolean smooth) {
        return null;
    }

    @Override
    public PShape getChild(String name) {
        PShape found = super.getChild(name);
        if (found == null) {
            found = super.getChild(name.replace(' ', '_'));
        }
        if (found != null) {
            found.width = this.width;
            found.height = this.height;
        }
        return found;
    }

    public void print() {
        PApplet.println(this.element.toString());
    }

    public static class FontGlyph
    extends PShapeSVG {
        public String name;
        char unicode;
        int horizAdvX;

        public FontGlyph(PShapeSVG parent, XML properties, Font font) {
            super(parent, properties, true);
            super.parsePath();
            this.name = properties.getString("glyph-name");
            String u = properties.getString("unicode");
            this.unicode = '\u0000';
            if (u != null) {
                if (u.length() == 1) {
                    this.unicode = u.charAt(0);
                } else {
                    System.err.println("unicode for " + this.name + " is more than one char: " + u);
                }
            }
            this.horizAdvX = properties.hasAttribute("horiz-adv-x") ? properties.getInt("horiz-adv-x") : font.horizAdvX;
        }

        protected boolean isLegit() {
            return this.vertexCount != 0;
        }
    }

    static class FontFace
    extends PShapeSVG {
        int horizOriginX;
        int horizOriginY;
        int vertOriginX;
        int vertOriginY;
        int vertAdvY;
        String fontFamily;
        int fontWeight;
        String fontStretch;
        int unitsPerEm;
        int[] panose1;
        int ascent;
        int descent;
        int[] bbox;
        int underlineThickness;
        int underlinePosition;

        public FontFace(PShapeSVG parent, XML properties) {
            super(parent, properties, true);
            this.unitsPerEm = properties.getInt("units-per-em", 1000);
        }

        protected void drawShape() {
        }
    }

    public static class Font
    extends PShapeSVG {
        public FontFace face;
        public Map<String, FontGlyph> namedGlyphs;
        public Map<Character, FontGlyph> unicodeGlyphs;
        public int glyphCount;
        public FontGlyph[] glyphs;
        public FontGlyph missingGlyph;
        int horizAdvX;

        public Font(PShapeSVG parent, XML properties) {
            super(parent, properties, false);
            XML[] elements = properties.getChildren();
            this.horizAdvX = properties.getInt("horiz-adv-x", 0);
            this.namedGlyphs = new HashMap<String, FontGlyph>();
            this.unicodeGlyphs = new HashMap<Character, FontGlyph>();
            this.glyphCount = 0;
            this.glyphs = new FontGlyph[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                String name = elements[i].getName();
                XML elem = elements[i];
                if (name == null) continue;
                if (name.equals("glyph")) {
                    FontGlyph fg = new FontGlyph((PShapeSVG)this, elem, this);
                    if (fg.isLegit()) {
                        if (fg.name != null) {
                            this.namedGlyphs.put(fg.name, fg);
                        }
                        if (fg.unicode != '\u0000') {
                            this.unicodeGlyphs.put(Character.valueOf(fg.unicode), fg);
                        }
                    }
                    this.glyphs[this.glyphCount++] = fg;
                    continue;
                }
                if (name.equals("missing-glyph")) {
                    this.missingGlyph = new FontGlyph((PShapeSVG)this, elem, this);
                    continue;
                }
                if (name.equals("font-face")) {
                    this.face = new FontFace(this, elem);
                    continue;
                }
                System.err.println("Ignoring " + name + " inside <font>");
            }
        }

        protected void drawShape() {
        }

        public void drawString(PGraphics g, String str, float x, float y, float size) {
            g.pushMatrix();
            float s = size / (float)this.face.unitsPerEm;
            g.translate(x, y);
            g.scale(s, -s);
            char[] c = str.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                FontGlyph fg = this.unicodeGlyphs.get(Character.valueOf(c[i]));
                if (fg != null) {
                    fg.draw(g);
                    g.translate(fg.horizAdvX, 0.0f);
                    continue;
                }
                System.err.println("'" + c[i] + "' not available.");
            }
            g.popMatrix();
        }

        public void drawChar(PGraphics g, char c, float x, float y, float size) {
            g.pushMatrix();
            float s = size / (float)this.face.unitsPerEm;
            g.translate(x, y);
            g.scale(s, -s);
            FontGlyph fg = this.unicodeGlyphs.get(Character.valueOf(c));
            if (fg != null) {
                g.shape(fg);
            }
            g.popMatrix();
        }

        public float textWidth(String str, float size) {
            float w = 0.0f;
            char[] c = str.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                FontGlyph fg = this.unicodeGlyphs.get(Character.valueOf(c[i]));
                if (fg == null) continue;
                w += (float)fg.horizAdvX / (float)this.face.unitsPerEm;
            }
            return w * size;
        }
    }

    public static class LineOfText
    extends PShapeSVG {
        String textToDisplay;
        PFont font;

        public LineOfText(PShapeSVG parent, XML properties) {
            super(parent, properties, false);
            String text;
            float x = Float.parseFloat(properties.getString("x"));
            float y = Float.parseFloat(properties.getString("y"));
            float parentX = Float.parseFloat(parent.element.getString("x"));
            float parentY = Float.parseFloat(parent.element.getString("y"));
            if (this.matrix == null) {
                this.matrix = new PMatrix2D();
            }
            this.matrix.translate(x - parentX, (y - parentY) / 2.0f);
            this.parseColors(properties);
            this.font = PShapeSVG.parseFont(properties);
            if (this.childCount > 0) {
                // empty if block
            }
            this.textToDisplay = text = properties.getContent();
        }

        @Override
        public void drawImpl(PGraphics g) {
            if (this.font == null) {
                this.font = ((Text)this.parent).font;
                if (this.font == null) {
                    return;
                }
            }
            this.pre(g);
            g.textFont(this.font, this.font.size);
            g.text(this.textToDisplay, 0.0f, 0.0f);
            this.post(g);
        }
    }

    public static class Text
    extends PShapeSVG {
        protected PFont font;

        public Text(PShapeSVG parent, XML properties) {
            super(parent, properties, true);
            float x = Float.parseFloat(properties.getString("x"));
            float y = Float.parseFloat(properties.getString("y"));
            if (this.matrix == null) {
                this.matrix = new PMatrix2D();
            }
            this.matrix.translate(x, y);
            this.family = 0;
            this.font = PShapeSVG.parseFont(properties);
        }
    }

    public class RadialGradient
    extends Gradient {
        public float cx;
        public float cy;
        public float r;

        public RadialGradient(PShapeSVG parent, XML properties) {
            super(parent, properties);
            this.cx = RadialGradient.getFloatWithUnit(properties, "cx", this.svgWidth);
            this.cy = RadialGradient.getFloatWithUnit(properties, "cy", this.svgHeight);
            this.r = RadialGradient.getFloatWithUnit(properties, "r", this.svgSizeXY);
            String transformStr = properties.getString("gradientTransform");
            if (transformStr != null) {
                float[] t = RadialGradient.parseTransform(transformStr).get(null);
                this.transform = new Matrix();
                this.transform.setValues(new float[]{t[0], t[1], t[2], t[3], t[4], t[5], 0.0f, 0.0f, 1.0f});
                float[] t1 = new float[]{this.cx, this.cy};
                float[] t2 = new float[]{this.cx + this.r, this.cy};
                this.transform.mapPoints(t1);
                this.transform.mapPoints(t2);
                this.cx = t1[0];
                this.cy = t1[1];
                this.r = t2[0] - t1[0];
            }
        }
    }

    public class LinearGradient
    extends Gradient {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public LinearGradient(PShapeSVG parent, XML properties) {
            super(parent, properties);
            this.x1 = LinearGradient.getFloatWithUnit(properties, "x1", this.svgWidth);
            this.y1 = LinearGradient.getFloatWithUnit(properties, "y1", this.svgHeight);
            this.x2 = LinearGradient.getFloatWithUnit(properties, "x2", this.svgWidth);
            this.y2 = LinearGradient.getFloatWithUnit(properties, "y2", this.svgHeight);
            String transformStr = properties.getString("gradientTransform");
            if (transformStr != null) {
                float[] t = LinearGradient.parseTransform(transformStr).get(null);
                this.transform = new Matrix();
                this.transform.setValues(new float[]{t[0], t[1], t[2], t[3], t[4], t[5], 0.0f, 0.0f, 1.0f});
                float[] t1 = new float[]{this.x1, this.y1};
                float[] t2 = new float[]{this.x2, this.y2};
                this.transform.mapPoints(t1);
                this.transform.mapPoints(t2);
                this.x1 = t1[0];
                this.y1 = t1[1];
                this.x2 = t2[0];
                this.y2 = t2[1];
            }
        }
    }

    public static class Gradient
    extends PShapeSVG {
        Matrix transform;
        public float[] offset;
        public int[] color;
        public int count;

        public Gradient(PShapeSVG parent, XML properties) {
            super(parent, properties, true);
            XML[] elements = properties.getChildren();
            this.offset = new float[elements.length];
            this.color = new int[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                String opacityStr;
                XML elem = elements[i];
                String name = elem.getName();
                if (!name.equals("stop")) continue;
                String offsetAttr = elem.getString("offset");
                this.offset[this.count] = Gradient.parseFloatOrPercent(offsetAttr);
                String style = elem.getString("style");
                StringDict styles = Gradient.parseStyleAttributes(style);
                String colorStr = styles.get("stop-color");
                if (colorStr == null && (colorStr = elem.getString("stop-color")) == null) {
                    colorStr = "#000000";
                }
                if ((opacityStr = styles.get("stop-opacity")) == null && (opacityStr = elem.getString("stop-opacity")) == null) {
                    opacityStr = "1";
                }
                int tupacity = PApplet.constrain((int)(PApplet.parseFloat(opacityStr) * 255.0f), 0, 255);
                this.color[this.count] = tupacity << 24 | Gradient.parseSimpleColor(colorStr);
                ++this.count;
            }
            this.offset = PApplet.subset(this.offset, 0, this.count);
            this.color = PApplet.subset(this.color, 0, this.count);
        }
    }
}

