/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.graphics.Bitmap;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;

public class PImage
implements PConstants,
Cloneable {
    public int format;
    public int[] pixels;
    public int width;
    public int height;
    public int pixelDensity = 1;
    public int pixelWidth;
    public int pixelHeight;
    public PApplet parent;
    protected Bitmap bitmap;
    protected HashMap<PGraphics, Object> cacheMap;
    protected HashMap<PGraphics, Object> paramMap;
    protected boolean modified;
    protected int mx1;
    protected int my1;
    protected int mx2;
    protected int my2;
    public boolean loaded = false;
    private int fracU;
    private int ifU;
    private int fracV;
    private int ifV;
    private int u1;
    private int u2;
    private int v1;
    private int v2;
    private int sX;
    private int sY;
    private int iw;
    private int iw1;
    private int ih1;
    private int ul;
    private int ll;
    private int ur;
    private int lr;
    private int cUL;
    private int cLL;
    private int cUR;
    private int cLR;
    private int srcXOffset;
    private int srcYOffset;
    private int r;
    private int g;
    private int b;
    private int a;
    private int[] srcBuffer;
    static final int PRECISIONB = 15;
    static final int PRECISIONF = 32768;
    static final int PREC_MAXVAL = Short.MAX_VALUE;
    static final int PREC_ALPHA_SHIFT = 9;
    static final int PREC_RED_SHIFT = 1;
    private int blurRadius;
    private int blurKernelSize;
    private int[] blurKernel;
    private int[][] blurMult;
    public static final int ALPHA_MASK = -16777216;
    public static final int RED_MASK = 0xFF0000;
    public static final int GREEN_MASK = 65280;
    public static final int BLUE_MASK = 255;
    private static final int RB_MASK = 0xFF00FF;
    private static final int GN_MASK = 65280;
    static byte[] TIFF_HEADER = new byte[]{77, 77, 0, 42, 0, 0, 0, 8, 0, 9, 0, -2, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 3, 0, 0, 0, 122, 1, 6, 0, 3, 0, 0, 0, 1, 0, 2, 0, 0, 1, 17, 0, 4, 0, 0, 0, 1, 0, 0, 3, 0, 1, 21, 0, 3, 0, 0, 0, 1, 0, 3, 0, 0, 1, 22, 0, 3, 0, 0, 0, 1, 0, 0, 0, 0, 1, 23, 0, 4, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 8};
    static final String TIFF_ERROR = "Error: Processing can only read its own TIFF files.";
    protected String[] saveImageFormats;

    public PImage() {
        this.format = 2;
    }

    public PImage(int width, int height) {
        this.init(width, height, 1);
    }

    public PImage(int width, int height, int format) {
        this.init(width, height, format);
    }

    public void init(int width, int height, int format) {
        this.width = width;
        this.height = height;
        this.pixels = new int[width * height];
        this.format = format;
        this.pixelWidth = width * this.pixelDensity;
        this.pixelHeight = height * this.pixelDensity;
        this.pixels = new int[this.pixelWidth * this.pixelHeight];
    }

    protected void checkAlpha() {
        if (this.pixels == null) {
            return;
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            if ((this.pixels[i] & 0xFF000000) == -16777216) continue;
            this.format = 2;
            break;
        }
    }

    public PImage(Object nativeObject) {
        Bitmap bitmap;
        this.bitmap = bitmap = (Bitmap)nativeObject;
        this.width = bitmap.getWidth();
        this.height = bitmap.getHeight();
        this.pixels = null;
        this.format = bitmap.hasAlpha() ? 2 : 1;
        this.pixelDensity = 1;
        this.pixelWidth = this.width;
        this.pixelHeight = this.height;
    }

    public Object getNative() {
        return this.bitmap;
    }

    public void setNative(Object nativeObject) {
        Bitmap bitmap;
        this.bitmap = bitmap = (Bitmap)nativeObject;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setModified(boolean m) {
        this.modified = m;
    }

    public int getModifiedX1() {
        return this.mx1;
    }

    public int getModifiedX2() {
        return this.mx2;
    }

    public int getModifiedY1() {
        return this.my1;
    }

    public int getModifiedY2() {
        return this.my2;
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        if (this.bitmap != null) {
            if (this.modified) {
                if (!this.bitmap.isMutable()) {
                    this.bitmap = this.bitmap.copy(Bitmap.Config.ARGB_8888, true);
                }
                this.bitmap.setPixels(this.pixels, 0, this.width, this.mx1, this.my1, this.mx2 - this.mx1, this.my2 - this.my1);
                this.modified = false;
            } else {
                this.bitmap.getPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
            }
        }
        this.setLoaded();
    }

    public void updatePixels() {
        this.updatePixelsImpl(0, 0, this.width, this.height);
    }

    public void updatePixels(int x, int y, int w, int h) {
        this.updatePixelsImpl(x, y, w, h);
    }

    protected void updatePixelsImpl(int x, int y, int w, int h) {
        int x2 = x + w;
        int y2 = y + h;
        if (!this.modified) {
            this.mx1 = PApplet.max(0, x);
            this.mx2 = PApplet.min(this.width, x2);
            this.my1 = PApplet.max(0, y);
            this.my2 = PApplet.min(this.height, y2);
            this.modified = true;
        } else {
            if (x < this.mx1) {
                this.mx1 = PApplet.max(0, x);
            }
            if (x > this.mx2) {
                this.mx2 = PApplet.min(this.width, x);
            }
            if (y < this.my1) {
                this.my1 = PApplet.max(0, y);
            }
            if (y > this.my2) {
                this.my2 = PApplet.min(this.height, y);
            }
            if (x2 < this.mx1) {
                this.mx1 = PApplet.max(0, x2);
            }
            if (x2 > this.mx2) {
                this.mx2 = PApplet.min(this.width, x2);
            }
            if (y2 < this.my1) {
                this.my1 = PApplet.max(0, y2);
            }
            if (y2 > this.my2) {
                this.my2 = PApplet.min(this.height, y2);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return this.get();
    }

    public void resize(int w, int h) {
        if (this.bitmap == null) {
            return;
        }
        if (w <= 0 && h <= 0) {
            throw new IllegalArgumentException("width or height must be > 0 for resize");
        }
        if (w == 0) {
            float diff = (float)h / (float)this.height;
            w = (int)((float)this.width * diff);
        } else if (h == 0) {
            float diff = (float)w / (float)this.width;
            h = (int)((float)this.height * diff);
        }
        this.bitmap = Bitmap.createScaledBitmap((Bitmap)this.bitmap, (int)w, (int)h, (boolean)true);
        if (this.pixels != null) {
            this.pixels = new int[w * h];
            this.bitmap.getPixels(this.pixels, 0, w, 0, 0, w, h);
        }
        this.width = w;
        this.height = h;
        this.pixelWidth = w * this.pixelDensity;
        this.pixelHeight = h * this.pixelDensity;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded() {
        this.loaded = true;
    }

    public void setLoaded(boolean l) {
        this.loaded = l;
    }

    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        if (this.pixels == null) {
            return this.bitmap.getPixel(x, y);
        }
        switch (this.format) {
            case 1: {
                return this.pixels[y * this.width + x] | 0xFF000000;
            }
            case 2: {
                return this.pixels[y * this.width + x];
            }
            case 4: {
                return this.pixels[y * this.width + x] << 24 | 0xFFFFFF;
            }
        }
        return 0;
    }

    public PImage get(int x, int y, int w, int h) {
        int targetX = 0;
        int targetY = 0;
        int targetWidth = w;
        int targetHeight = h;
        boolean cropped = false;
        if (x < 0) {
            w += x;
            targetX = -x;
            cropped = true;
            x = 0;
        }
        if (y < 0) {
            h += y;
            targetY = -y;
            cropped = true;
            y = 0;
        }
        if (x + w > this.width) {
            w = this.width - x;
            cropped = true;
        }
        if (y + h > this.height) {
            h = this.height - y;
            cropped = true;
        }
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        int targetFormat = this.format;
        if (cropped && this.format == 1) {
            targetFormat = 2;
        }
        PImage target = new PImage(targetWidth, targetHeight, targetFormat);
        target.parent = this.parent;
        if (w > 0 && h > 0) {
            this.getImpl(x, y, w, h, target, targetX, targetY);
            Bitmap nat = Bitmap.createBitmap((int[])target.pixels, (int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            target.setNative(nat);
        }
        return target;
    }

    protected void getImpl(int sourceX, int sourceY, int sourceWidth, int sourceHeight, PImage target, int targetX, int targetY) {
        if (this.bitmap != null) {
            this.bitmap.getPixels(target.pixels, targetY * target.width + targetX, target.width, sourceX, sourceY, sourceWidth, sourceHeight);
        } else if (this.pixels != null) {
            int sourceIndex = sourceY * this.width + sourceX;
            int targetIndex = targetY * target.width + targetX;
            for (int row = 0; row < sourceHeight; ++row) {
                System.arraycopy(this.pixels, sourceIndex, target.pixels, targetIndex, sourceWidth);
                sourceIndex += this.width;
                targetIndex += target.width;
            }
        }
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public PImage copy() {
        return this.get(0, 0, this.pixelWidth, this.pixelHeight);
    }

    public void set(int x, int y, int c) {
        if (this.pixels == null) {
            this.bitmap.setPixel(x, y, c);
        } else {
            if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
                return;
            }
            this.pixels[y * this.width + x] = c;
            this.updatePixelsImpl(x, y, 1, 1);
        }
    }

    public void set(int x, int y, PImage img) {
        if (img.format == 4) {
            throw new IllegalArgumentException("set() not available for ALPHA images");
        }
        int sx = 0;
        int sy = 0;
        int sw = img.width;
        int sh = img.height;
        if (x < 0) {
            sx -= x;
            sw += x;
            x = 0;
        }
        if (y < 0) {
            sy -= y;
            sh += y;
            y = 0;
        }
        if (x + sw > this.width) {
            sw = this.width - x;
        }
        if (y + sh > this.height) {
            sh = this.height - y;
        }
        if (sw <= 0 || sh <= 0) {
            return;
        }
        this.setImpl(img, sx, sy, sw, sh, x, y);
    }

    protected void setImpl(PImage sourceImage, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int targetX, int targetY) {
        if (sourceImage.pixels == null) {
            sourceImage.loadPixels();
        }
        if (this.pixels == null) {
            if (!this.bitmap.isMutable()) {
                this.bitmap = this.bitmap.copy(Bitmap.Config.ARGB_8888, true);
            }
            int offset = sourceY * sourceImage.width + sourceX;
            this.bitmap.setPixels(sourceImage.pixels, offset, sourceImage.width, targetX, targetY, sourceWidth, sourceHeight);
        } else {
            int srcOffset = sourceY * sourceImage.width + sourceX;
            int dstOffset = targetY * this.width + targetX;
            for (int y = sourceY; y < sourceY + sourceHeight; ++y) {
                System.arraycopy(sourceImage.pixels, srcOffset, this.pixels, dstOffset, sourceWidth);
                srcOffset += sourceImage.width;
                dstOffset += this.width;
            }
            this.updatePixelsImpl(targetX, targetY, sourceWidth, sourceHeight);
        }
    }

    public void mask(int[] alpha) {
        this.loadPixels();
        if (alpha.length != this.pixels.length) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = (alpha[i] & 0xFF) << 24 | this.pixels[i] & 0xFFFFFF;
        }
        this.format = 2;
        this.updatePixels();
    }

    public void mask(PImage alpha) {
        if (alpha.pixels == null) {
            alpha.loadPixels();
            this.mask(alpha.pixels);
            alpha.pixels = null;
        } else {
            this.mask(alpha.pixels);
        }
    }

    public void filter(int kind) {
        this.loadPixels();
        switch (kind) {
            case 11: {
                this.filter(11, 1.0f);
                break;
            }
            case 12: {
                if (this.format == 4) {
                    for (int i = 0; i < this.pixels.length; ++i) {
                        int col = 255 - this.pixels[i];
                        this.pixels[i] = 0xFF000000 | col << 16 | col << 8 | col;
                    }
                    this.format = 1;
                    break;
                }
                for (int i = 0; i < this.pixels.length; ++i) {
                    int col = this.pixels[i];
                    int lum = 77 * (col >> 16 & 0xFF) + 151 * (col >> 8 & 0xFF) + 28 * (col & 0xFF) >> 8;
                    this.pixels[i] = col & 0xFF000000 | lum << 16 | lum << 8 | lum;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < this.pixels.length) {
                    int n = i++;
                    this.pixels[n] = this.pixels[n] ^ 0xFFFFFF;
                }
                break;
            }
            case 15: {
                throw new RuntimeException("Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)");
            }
            case 1: {
                int i = 0;
                while (i < this.pixels.length) {
                    int n = i++;
                    this.pixels[n] = this.pixels[n] | 0xFF000000;
                }
                this.format = 1;
                break;
            }
            case 16: {
                this.filter(16, 0.5f);
                break;
            }
            case 17: {
                this.dilate(true);
                break;
            }
            case 18: {
                this.dilate(false);
            }
        }
        this.updatePixels();
    }

    public void filter(int kind, float param) {
        this.loadPixels();
        switch (kind) {
            case 11: {
                if (this.format == 4) {
                    this.blurAlpha(param);
                    break;
                }
                if (this.format == 2) {
                    this.blurARGB(param);
                    break;
                }
                this.blurRGB(param);
                break;
            }
            case 12: {
                throw new RuntimeException("Use filter(GRAY) instead of filter(GRAY, param)");
            }
            case 13: {
                throw new RuntimeException("Use filter(INVERT) instead of filter(INVERT, param)");
            }
            case 14: {
                throw new RuntimeException("Use filter(OPAQUE) instead of filter(OPAQUE, param)");
            }
            case 15: {
                int levels = (int)param;
                if (levels < 2 || levels > 255) {
                    throw new RuntimeException("Levels must be between 2 and 255 for filter(POSTERIZE, levels)");
                }
                int levels1 = levels - 1;
                for (int i = 0; i < this.pixels.length; ++i) {
                    int rlevel = this.pixels[i] >> 16 & 0xFF;
                    int glevel = this.pixels[i] >> 8 & 0xFF;
                    int blevel = this.pixels[i] & 0xFF;
                    rlevel = (rlevel * levels >> 8) * 255 / levels1;
                    glevel = (glevel * levels >> 8) * 255 / levels1;
                    blevel = (blevel * levels >> 8) * 255 / levels1;
                    this.pixels[i] = 0xFF000000 & this.pixels[i] | rlevel << 16 | glevel << 8 | blevel;
                }
                break;
            }
            case 16: {
                int thresh = (int)(param * 255.0f);
                for (int i = 0; i < this.pixels.length; ++i) {
                    int max = Math.max((this.pixels[i] & 0xFF0000) >> 16, Math.max((this.pixels[i] & 0xFF00) >> 8, this.pixels[i] & 0xFF));
                    this.pixels[i] = this.pixels[i] & 0xFF000000 | (max < thresh ? 0 : 0xFFFFFF);
                }
                break;
            }
            case 17: {
                throw new RuntimeException("Use filter(ERODE) instead of filter(ERODE, param)");
            }
            case 18: {
                throw new RuntimeException("Use filter(DILATE) instead of filter(DILATE, param)");
            }
        }
        this.updatePixels();
    }

    protected void buildBlurKernel(float r) {
        int radius = (int)(r * 3.5f);
        int n = radius < 1 ? 1 : (radius = radius < 248 ? radius : 248);
        if (this.blurRadius != radius) {
            int[] bm;
            this.blurRadius = radius;
            this.blurKernelSize = 1 + this.blurRadius << 1;
            this.blurKernel = new int[this.blurKernelSize];
            this.blurMult = new int[this.blurKernelSize][256];
            int radiusi = radius - 1;
            for (int i = 1; i < radius; ++i) {
                int bki;
                this.blurKernel[radiusi] = bki = radiusi * radiusi;
                this.blurKernel[radius + i] = bki;
                bm = this.blurMult[radius + i];
                int[] bmi = this.blurMult[radiusi--];
                for (int j = 0; j < 256; ++j) {
                    bm[j] = bmi[j] = bki * j;
                }
            }
            int bk = this.blurKernel[radius] = radius * radius;
            bm = this.blurMult[radius];
            for (int j = 0; j < 256; ++j) {
                bm[j] = bk * j;
            }
        }
    }

    protected void blurAlpha(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int sum;
        int x;
        int y;
        int[] b2 = new int[this.pixels.length];
        int yi = 0;
        this.buildBlurKernel(r);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                sum = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.width) break;
                    bk0 = 0;
                }
                for (i = bk0; i < this.blurKernelSize && read < this.width; ++read, ++i) {
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                }
                ri = yi + x;
                b2[ri] = cb / sum;
            }
            yi += this.width;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.width;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                sum = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.height) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                for (i = bk0; i < this.blurKernelSize && ri < this.height; ++i) {
                    int[] bm = this.blurMult[i];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.width;
                }
                this.pixels[x + yi] = cb / sum;
            }
            yi += this.width;
            ymi += this.width;
            ++ym;
        }
    }

    protected void blurRGB(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int cg;
        int cr;
        int sum;
        int x;
        int y;
        int[] r2 = new int[this.pixels.length];
        int[] g2 = new int[this.pixels.length];
        int[] b2 = new int[this.pixels.length];
        int yi = 0;
        this.buildBlurKernel(r);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                sum = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.width) break;
                    bk0 = 0;
                }
                for (i = bk0; i < this.blurKernelSize && read < this.width; ++read, ++i) {
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    cr += bm[(c & 0xFF0000) >> 16];
                    cg += bm[(c & 0xFF00) >> 8];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                }
                ri = yi + x;
                r2[ri] = cr / sum;
                g2[ri] = cg / sum;
                b2[ri] = cb / sum;
            }
            yi += this.width;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.width;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                sum = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.height) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                for (i = bk0; i < this.blurKernelSize && ri < this.height; ++i) {
                    int[] bm = this.blurMult[i];
                    cr += bm[r2[read]];
                    cg += bm[g2[read]];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.width;
                }
                this.pixels[x + yi] = 0xFF000000 | cr / sum << 16 | cg / sum << 8 | cb / sum;
            }
            yi += this.width;
            ymi += this.width;
            ++ym;
        }
    }

    protected void blurARGB(float r) {
        int ri;
        int i;
        int bk0;
        int read;
        int cb;
        int cg;
        int cr;
        int ca;
        int sum;
        int x;
        int y;
        int wh = this.pixels.length;
        int[] r2 = new int[wh];
        int[] g2 = new int[wh];
        int[] b2 = new int[wh];
        int[] a2 = new int[wh];
        int yi = 0;
        this.buildBlurKernel(r);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                sum = 0;
                ca = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                read = x - this.blurRadius;
                if (read < 0) {
                    bk0 = -read;
                    read = 0;
                } else {
                    if (read >= this.width) break;
                    bk0 = 0;
                }
                for (i = bk0; i < this.blurKernelSize && read < this.width; ++read, ++i) {
                    int c = this.pixels[read + yi];
                    int[] bm = this.blurMult[i];
                    ca += bm[(c & 0xFF000000) >>> 24];
                    cr += bm[(c & 0xFF0000) >> 16];
                    cg += bm[(c & 0xFF00) >> 8];
                    cb += bm[c & 0xFF];
                    sum += this.blurKernel[i];
                }
                ri = yi + x;
                a2[ri] = ca / sum;
                r2[ri] = cr / sum;
                g2[ri] = cg / sum;
                b2[ri] = cb / sum;
            }
            yi += this.width;
        }
        yi = 0;
        int ym = -this.blurRadius;
        int ymi = ym * this.width;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                sum = 0;
                ca = 0;
                cr = 0;
                cg = 0;
                cb = 0;
                if (ym < 0) {
                    bk0 = ri = -ym;
                    read = x;
                } else {
                    if (ym >= this.height) break;
                    bk0 = 0;
                    ri = ym;
                    read = x + ymi;
                }
                for (i = bk0; i < this.blurKernelSize && ri < this.height; ++i) {
                    int[] bm = this.blurMult[i];
                    ca += bm[a2[read]];
                    cr += bm[r2[read]];
                    cg += bm[g2[read]];
                    cb += bm[b2[read]];
                    sum += this.blurKernel[i];
                    ++ri;
                    read += this.width;
                }
                this.pixels[x + yi] = ca / sum << 24 | cr / sum << 16 | cg / sum << 8 | cb / sum;
            }
            yi += this.width;
            ymi += this.width;
            ++ym;
        }
    }

    protected void dilate(boolean isInverted) {
        int currIdx = 0;
        int maxIdx = this.pixels.length;
        int[] out = new int[maxIdx];
        if (!isInverted) {
            while (currIdx < maxIdx) {
                int currRowIdx = currIdx;
                int maxRowIdx = currIdx + this.width;
                while (currIdx < maxRowIdx) {
                    int colOut;
                    int colOrig = colOut = this.pixels[currIdx];
                    int idxLeft = currIdx - 1;
                    int idxRight = currIdx + 1;
                    int idxUp = currIdx - this.width;
                    int idxDown = currIdx + this.width;
                    if (idxLeft < currRowIdx) {
                        idxLeft = currIdx;
                    }
                    if (idxRight >= maxRowIdx) {
                        idxRight = currIdx;
                    }
                    if (idxUp < 0) {
                        idxUp = 0;
                    }
                    if (idxDown >= maxIdx) {
                        idxDown = currIdx;
                    }
                    int colUp = this.pixels[idxUp];
                    int colLeft = this.pixels[idxLeft];
                    int colDown = this.pixels[idxDown];
                    int colRight = this.pixels[idxRight];
                    int currLum = 77 * (colOrig >> 16 & 0xFF) + 151 * (colOrig >> 8 & 0xFF) + 28 * (colOrig & 0xFF);
                    int lumLeft = 77 * (colLeft >> 16 & 0xFF) + 151 * (colLeft >> 8 & 0xFF) + 28 * (colLeft & 0xFF);
                    int lumRight = 77 * (colRight >> 16 & 0xFF) + 151 * (colRight >> 8 & 0xFF) + 28 * (colRight & 0xFF);
                    int lumUp = 77 * (colUp >> 16 & 0xFF) + 151 * (colUp >> 8 & 0xFF) + 28 * (colUp & 0xFF);
                    int lumDown = 77 * (colDown >> 16 & 0xFF) + 151 * (colDown >> 8 & 0xFF) + 28 * (colDown & 0xFF);
                    if (lumLeft > currLum) {
                        colOut = colLeft;
                        currLum = lumLeft;
                    }
                    if (lumRight > currLum) {
                        colOut = colRight;
                        currLum = lumRight;
                    }
                    if (lumUp > currLum) {
                        colOut = colUp;
                        currLum = lumUp;
                    }
                    if (lumDown > currLum) {
                        colOut = colDown;
                        currLum = lumDown;
                    }
                    out[currIdx++] = colOut;
                }
            }
        } else {
            while (currIdx < maxIdx) {
                int currRowIdx = currIdx;
                int maxRowIdx = currIdx + this.width;
                while (currIdx < maxRowIdx) {
                    int colOut;
                    int colOrig = colOut = this.pixels[currIdx];
                    int idxLeft = currIdx - 1;
                    int idxRight = currIdx + 1;
                    int idxUp = currIdx - this.width;
                    int idxDown = currIdx + this.width;
                    if (idxLeft < currRowIdx) {
                        idxLeft = currIdx;
                    }
                    if (idxRight >= maxRowIdx) {
                        idxRight = currIdx;
                    }
                    if (idxUp < 0) {
                        idxUp = 0;
                    }
                    if (idxDown >= maxIdx) {
                        idxDown = currIdx;
                    }
                    int colUp = this.pixels[idxUp];
                    int colLeft = this.pixels[idxLeft];
                    int colDown = this.pixels[idxDown];
                    int colRight = this.pixels[idxRight];
                    int currLum = 77 * (colOrig >> 16 & 0xFF) + 151 * (colOrig >> 8 & 0xFF) + 28 * (colOrig & 0xFF);
                    int lumLeft = 77 * (colLeft >> 16 & 0xFF) + 151 * (colLeft >> 8 & 0xFF) + 28 * (colLeft & 0xFF);
                    int lumRight = 77 * (colRight >> 16 & 0xFF) + 151 * (colRight >> 8 & 0xFF) + 28 * (colRight & 0xFF);
                    int lumUp = 77 * (colUp >> 16 & 0xFF) + 151 * (colUp >> 8 & 0xFF) + 28 * (colUp & 0xFF);
                    int lumDown = 77 * (colDown >> 16 & 0xFF) + 151 * (colDown >> 8 & 0xFF) + 28 * (colDown & 0xFF);
                    if (lumLeft < currLum) {
                        colOut = colLeft;
                        currLum = lumLeft;
                    }
                    if (lumRight < currLum) {
                        colOut = colRight;
                        currLum = lumRight;
                    }
                    if (lumUp < currLum) {
                        colOut = colUp;
                        currLum = lumUp;
                    }
                    if (lumDown < currLum) {
                        colOut = colDown;
                        currLum = lumDown;
                    }
                    out[currIdx++] = colOut;
                }
            }
        }
        System.arraycopy(out, 0, this.pixels, 0, maxIdx);
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.blend(this, sx, sy, sw, sh, dx, dy, dw, dh, 0);
    }

    public void copy(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.blend(src, sx, sy, sw, sh, dx, dy, dw, dh, 0);
    }

    public static int blendColor(int c1, int c2, int mode) {
        switch (mode) {
            case 0: {
                return c2;
            }
            case 1: {
                return PImage.blend_blend(c1, c2);
            }
            case 2: {
                return PImage.blend_add_pin(c1, c2);
            }
            case 4: {
                return PImage.blend_sub_pin(c1, c2);
            }
            case 8: {
                return PImage.blend_lightest(c1, c2);
            }
            case 16: {
                return PImage.blend_darkest(c1, c2);
            }
            case 32: {
                return PImage.blend_difference(c1, c2);
            }
            case 64: {
                return PImage.blend_exclusion(c1, c2);
            }
            case 128: {
                return PImage.blend_multiply(c1, c2);
            }
            case 256: {
                return PImage.blend_screen(c1, c2);
            }
            case 1024: {
                return PImage.blend_hard_light(c1, c2);
            }
            case 2048: {
                return PImage.blend_soft_light(c1, c2);
            }
            case 512: {
                return PImage.blend_overlay(c1, c2);
            }
            case 4096: {
                return PImage.blend_dodge(c1, c2);
            }
            case 8192: {
                return PImage.blend_burn(c1, c2);
            }
        }
        return 0;
    }

    public void blend(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        this.blend(this, sx, sy, sw, sh, dx, dy, dw, dh, mode);
    }

    public void blend(PImage src, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, int mode) {
        int sx2 = sx + sw;
        int sy2 = sy + sh;
        int dx2 = dx + dw;
        int dy2 = dy + dh;
        this.loadPixels();
        if (src == this) {
            if (this.intersect(sx, sy, sx2, sy2, dx, dy, dx2, dy2)) {
                this.blit_resize(this.get(sx, sy, sw, sh), 0, 0, sw, sh, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode);
            } else {
                this.blit_resize(src, sx, sy, sx2, sy2, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode);
            }
        } else {
            src.loadPixels();
            this.blit_resize(src, sx, sy, sx2, sy2, this.pixels, this.pixelWidth, this.pixelHeight, dx, dy, dx2, dy2, mode);
        }
        this.updatePixels();
    }

    private boolean intersect(int sx1, int sy1, int sx2, int sy2, int dx1, int dy1, int dx2, int dy2) {
        int sw = sx2 - sx1 + 1;
        int sh = sy2 - sy1 + 1;
        int dw = dx2 - dx1 + 1;
        int dh = dy2 - dy1 + 1;
        if (dx1 < sx1) {
            if ((dw += dx1 - sx1) > sw) {
                dw = sw;
            }
        } else {
            int w = sw + sx1 - dx1;
            if (dw > w) {
                dw = w;
            }
        }
        if (dy1 < sy1) {
            if ((dh += dy1 - sy1) > sh) {
                dh = sh;
            }
        } else {
            int h = sh + sy1 - dy1;
            if (dh > h) {
                dh = h;
            }
        }
        return dw > 0 && dh > 0;
    }

    private void blit_resize(PImage img, int srcX1, int srcY1, int srcX2, int srcY2, int[] destPixels, int screenW, int screenH, int destX1, int destY1, int destX2, int destY2, int mode) {
        block103: {
            int destOffset;
            int dy;
            int dx;
            int destH;
            int destW;
            block102: {
                if (srcX1 < 0) {
                    srcX1 = 0;
                }
                if (srcY1 < 0) {
                    srcY1 = 0;
                }
                if (srcX2 > img.pixelWidth) {
                    srcX2 = img.pixelWidth;
                }
                if (srcY2 > img.pixelHeight) {
                    srcY2 = img.pixelHeight;
                }
                int srcW = srcX2 - srcX1;
                int srcH = srcY2 - srcY1;
                destW = destX2 - destX1;
                destH = destY2 - destY1;
                boolean smooth = true;
                if (!smooth) {
                    ++srcW;
                    ++srcH;
                }
                if (destW <= 0 || destH <= 0 || srcW <= 0 || srcH <= 0 || destX1 >= screenW || destY1 >= screenH || srcX1 >= img.pixelWidth || srcY1 >= img.pixelHeight) {
                    return;
                }
                dx = (int)((float)srcW / (float)destW * 32768.0f);
                dy = (int)((float)srcH / (float)destH * 32768.0f);
                this.srcXOffset = destX1 < 0 ? -destX1 * dx : srcX1 * 32768;
                int n = this.srcYOffset = destY1 < 0 ? -destY1 * dy : srcY1 * 32768;
                if (destX1 < 0) {
                    destW += destX1;
                    destX1 = 0;
                }
                if (destY1 < 0) {
                    destH += destY1;
                    destY1 = 0;
                }
                destW = PImage.min(destW, screenW - destX1);
                destH = PImage.min(destH, screenH - destY1);
                destOffset = destY1 * screenW + destX1;
                this.srcBuffer = img.pixels;
                if (!smooth) break block102;
                this.iw = img.pixelWidth;
                this.iw1 = img.pixelWidth - 1;
                this.ih1 = img.pixelHeight - 1;
                switch (mode) {
                    case 1: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_blend(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 2: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_add_pin(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 4: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_sub_pin(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 8: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_lightest(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 16: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_darkest(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 0: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = this.filter_bilinear();
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 32: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_difference(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 64: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_exclusion(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 128: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_multiply(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 256: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_screen(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 512: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_overlay(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 1024: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_hard_light(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 2048: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_soft_light(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 4096: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_dodge(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break block103;
                    }
                    case 8192: {
                        for (int y = 0; y < destH; ++y) {
                            this.filter_new_scanline();
                            for (int x = 0; x < destW; ++x) {
                                destPixels[destOffset + x] = PImage.blend_burn(destPixels[destOffset + x], this.filter_bilinear());
                                this.sX += dx;
                            }
                            destOffset += screenW;
                            this.srcYOffset += dy;
                        }
                        break;
                    }
                }
                break block103;
            }
            switch (mode) {
                case 1: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_blend(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 2: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_add_pin(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 4: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_sub_pin(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 8: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_lightest(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 16: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_darkest(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 0: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = this.srcBuffer[this.sY + (this.sX >> 15)];
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 32: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_difference(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 64: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_exclusion(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 128: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_multiply(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 256: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_screen(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 512: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_overlay(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 1024: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_hard_light(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 2048: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_soft_light(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 4096: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_dodge(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
                case 8192: {
                    for (int y = 0; y < destH; ++y) {
                        this.sX = this.srcXOffset;
                        this.sY = (this.srcYOffset >> 15) * img.pixelWidth;
                        for (int x = 0; x < destW; ++x) {
                            destPixels[destOffset + x] = PImage.blend_burn(destPixels[destOffset + x], this.srcBuffer[this.sY + (this.sX >> 15)]);
                            this.sX += dx;
                        }
                        destOffset += screenW;
                        this.srcYOffset += dy;
                    }
                    break;
                }
            }
        }
    }

    private void filter_new_scanline() {
        this.sX = this.srcXOffset;
        this.fracV = this.srcYOffset & Short.MAX_VALUE;
        this.ifV = Short.MAX_VALUE - this.fracV + 1;
        this.v1 = (this.srcYOffset >> 15) * this.iw;
        this.v2 = PImage.min((this.srcYOffset >> 15) + 1, this.ih1) * this.iw;
    }

    private int filter_bilinear() {
        this.fracU = this.sX & Short.MAX_VALUE;
        this.ifU = Short.MAX_VALUE - this.fracU + 1;
        this.ul = this.ifU * this.ifV >> 15;
        this.ll = this.ifU - this.ul;
        this.ur = this.ifV - this.ul;
        this.lr = 32768 - this.ul - this.ll - this.ur;
        this.u1 = this.sX >> 15;
        this.u2 = PImage.min(this.u1 + 1, this.iw1);
        this.cUL = this.srcBuffer[this.v1 + this.u1];
        this.cUR = this.srcBuffer[this.v1 + this.u2];
        this.cLL = this.srcBuffer[this.v2 + this.u1];
        this.cLR = this.srcBuffer[this.v2 + this.u2];
        this.r = this.ul * ((this.cUL & 0xFF0000) >> 16) + this.ll * ((this.cLL & 0xFF0000) >> 16) + this.ur * ((this.cUR & 0xFF0000) >> 16) + this.lr * ((this.cLR & 0xFF0000) >> 16) << 1 & 0xFF0000;
        this.g = this.ul * (this.cUL & 0xFF00) + this.ll * (this.cLL & 0xFF00) + this.ur * (this.cUR & 0xFF00) + this.lr * (this.cLR & 0xFF00) >>> 15 & 0xFF00;
        this.b = this.ul * (this.cUL & 0xFF) + this.ll * (this.cLL & 0xFF) + this.ur * (this.cUR & 0xFF) + this.lr * (this.cLR & 0xFF) >>> 15;
        this.a = this.ul * ((this.cUL & 0xFF000000) >>> 24) + this.ll * ((this.cLL & 0xFF000000) >>> 24) + this.ur * ((this.cUR & 0xFF000000) >>> 24) + this.lr * ((this.cLR & 0xFF000000) >>> 24) << 9 & 0xFF000000;
        return this.a | this.r | this.g | this.b;
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    private static int max(int a, int b) {
        return a > b ? a : b;
    }

    private static int blend_blend(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + (src & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (src & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_add_pin(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int rb = (dst & 0xFF00FF) + ((src & 0xFF00FF) * s_a >>> 8 & 0xFF00FF);
        int gn = (dst & 0xFF00) + ((src & 0xFF00) * s_a >>> 8);
        return PImage.min((dst >>> 24) + a, 255) << 24 | PImage.min(rb & 0xFFFF0000, 0xFF0000) | PImage.min(gn & 0xFFFF00, 65280) | PImage.min(rb & 0xFFFF, 255);
    }

    private static int blend_sub_pin(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int rb = (src & 0xFF00FF) * s_a >>> 8;
        int gn = (src & 0xFF00) * s_a >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | PImage.max((dst & 0xFF0000) - (rb & 0xFF0000), 0) | PImage.max((dst & 0xFF00) - (gn & 0xFF00), 0) | PImage.max((dst & 0xFF) - (rb & 0xFF), 0);
    }

    private static int blend_lightest(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int rb = PImage.max(src & 0xFF0000, dst & 0xFF0000) | PImage.max(src & 0xFF, dst & 0xFF);
        int gn = PImage.max(src & 0xFF00, dst & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_darkest(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int rb = PImage.min(src & 0xFF0000, dst & 0xFF0000) | PImage.min(src & 0xFF, dst & 0xFF);
        int gn = PImage.min(src & 0xFF00, dst & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_difference(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (dst & 0xFF0000) - (src & 0xFF0000);
        int b = (dst & 0xFF) - (src & 0xFF);
        int g = (dst & 0xFF00) - (src & 0xFF00);
        int rb = (r < 0 ? -r : r) | (b < 0 ? -b : b);
        int gn = g < 0 ? -g : g;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_exclusion(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_rb = dst & 0xFF00FF;
        int d_gn = dst & 0xFF00;
        int s_gn = src & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb_sub = ((src & 0xFF0000) * (f_r + (f_r >= 127 ? 1 : 0)) | (src & 0xFF) * (f_b + (f_b >= 127 ? 1 : 0))) >>> 7 & 0x1FF01FF;
        int gn_sub = s_gn * (d_gn + (d_gn >= 32512 ? 256 : 0)) >>> 15 & 0x1FF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | d_rb * d_a + (d_rb + (src & 0xFF00FF) - rb_sub) * s_a >>> 8 & 0xFF00FF | d_gn * d_a + (d_gn + s_gn - gn_sub) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_multiply(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_gn = dst & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb = ((src & 0xFF0000) * (f_r + 1) | (src & 0xFF) * (f_b + 1)) >>> 8 & 0xFF00FF;
        int gn = (src & 0xFF00) * (d_gn + 256) >>> 16 & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | d_gn * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_screen(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_rb = dst & 0xFF00FF;
        int d_gn = dst & 0xFF00;
        int s_gn = src & 0xFF00;
        int f_r = (dst & 0xFF0000) >> 16;
        int f_b = dst & 0xFF;
        int rb_sub = ((src & 0xFF0000) * (f_r + 1) | (src & 0xFF) * (f_b + 1)) >>> 8 & 0xFF00FF;
        int gn_sub = s_gn * (d_gn + 256) >>> 16 & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | d_rb * d_a + (d_rb + (src & 0xFF00FF) - rb_sub) * s_a >>> 8 & 0xFF00FF | d_gn * d_a + (d_gn + s_gn - gn_sub) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_overlay(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r = src & 0xFF0000;
        int s_g = src & 0xFF00;
        int s_b = src & 0xFF;
        int r = d_r < 0x800000 ? d_r * ((s_r >>> 16) + 1) >>> 7 : 0xFF0000 - ((256 - (s_r >>> 16)) * (0xFF0000 - d_r) >>> 7);
        int g = d_g < 32768 ? d_g * (s_g + 256) >>> 15 : 65280 - ((65536 - s_g) * (65280 - d_g) >>> 15);
        int b = d_b < 128 ? d_b * (s_b + 1) >>> 7 : 65280 - ((256 - s_b) * (255 - d_b) << 1) >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + ((r | b) & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (g & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_hard_light(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r = src & 0xFF0000;
        int s_g = src & 0xFF00;
        int s_b = src & 0xFF;
        int r = s_r < 0x800000 ? s_r * ((d_r >>> 16) + 1) >>> 7 : 0xFF0000 - ((256 - (d_r >>> 16)) * (0xFF0000 - s_r) >>> 7);
        int g = s_g < 32768 ? s_g * (d_g + 256) >>> 15 : 65280 - ((65536 - d_g) * (65280 - s_g) >>> 15);
        int b = s_b < 128 ? s_b * (d_b + 1) >>> 7 : 65280 - ((256 - d_b) * (255 - s_b) << 1) >>> 8;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + ((r | b) & 0xFF00FF) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + (g & 0xFF00) * s_a >>> 8 & 0xFF00;
    }

    private static int blend_soft_light(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int d_r = dst & 0xFF0000;
        int d_g = dst & 0xFF00;
        int d_b = dst & 0xFF;
        int s_r1 = src & 0xFF;
        int s_g1 = src & 0xFF;
        int s_b1 = src & 0xFF;
        int d_r1 = (d_r >> 16) + ((float)s_r1 < 7.0f ? 1 : 0);
        int d_g1 = (d_g >> 8) + ((float)s_g1 < 7.0f ? 1 : 0);
        int d_b1 = d_b + ((float)s_b1 < 7.0f ? 1 : 0);
        int r = (s_r1 * d_r >> 7) + 255 * d_r1 * (d_r1 + 1) - (s_r1 * d_r1 * d_r1 << 1) & 0xFF0000;
        int g = (s_g1 * d_g << 1) + 255 * d_g1 * (d_g1 + 1) - (s_g1 * d_g1 * d_g1 << 1) >>> 8 & 0xFF00;
        int b = (s_b1 * d_b << 9) + 255 * d_b1 * (d_b1 + 1) - (s_b1 * d_b1 * d_b1 << 1) >>> 16;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + (r | b) * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + g * s_a >>> 8 & 0xFF00;
    }

    private static int blend_dodge(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (dst & 0xFF0000) / (256 - ((src & 0xFF0000) >> 16));
        int g = ((dst & 0xFF00) << 8) / (256 - ((src & 0xFF00) >> 8));
        int b = ((dst & 0xFF) << 8) / (256 - (src & 0xFF));
        int rb = (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) | (b > 255 ? 255 : b);
        int gn = g > 65280 ? 65280 : g & 0xFF00;
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    private static int blend_burn(int dst, int src) {
        int a;
        int s_a = a + ((a = src >>> 24) >= 127 ? 1 : 0);
        int d_a = 256 - s_a;
        int r = (0xFF0000 - (dst & 0xFF0000)) / (1 + (src & 0xFF));
        int g = (65280 - (dst & 0xFF00) << 8) / (1 + (src & 0xFF));
        int b = (255 - (dst & 0xFF) << 8) / (1 + (src & 0xFF));
        int rb = 0xFF00FF - (r > 65280 ? 0xFF0000 : r << 8 & 0xFF0000) - (b > 255 ? 255 : b);
        int gn = 65280 - (g > 65280 ? 65280 : g & 0xFF00);
        return PImage.min((dst >>> 24) + a, 255) << 24 | (dst & 0xFF00FF) * d_a + rb * s_a >>> 8 & 0xFF00FF | (dst & 0xFF00) * d_a + gn * s_a >>> 8 & 0xFF00;
    }

    protected static PImage loadTIFF(byte[] tiff) {
        if (tiff[42] != tiff[102] || tiff[43] != tiff[103]) {
            System.err.println(TIFF_ERROR);
            return null;
        }
        int count = (tiff[114] & 0xFF) << 24 | (tiff[115] & 0xFF) << 16 | (tiff[116] & 0xFF) << 8 | tiff[117] & 0xFF;
        int width = (tiff[30] & 0xFF) << 8 | tiff[31] & 0xFF;
        int height = (tiff[42] & 0xFF) << 8 | tiff[43] & 0xFF;
        if (count != width * height * 3) {
            System.err.println("Error: Processing can only read its own TIFF files. (" + width + ", " + height + ")");
            return null;
        }
        for (int i = 0; i < TIFF_HEADER.length; ++i) {
            if (i == 30 || i == 31 || i == 42 || i == 43 || i == 102 || i == 103 || i == 114 || i == 115 || i == 116 || i == 117 || tiff[i] == TIFF_HEADER[i]) continue;
            System.err.println("Error: Processing can only read its own TIFF files. (" + i + ")");
            return null;
        }
        PImage outgoing = new PImage(width, height, 1);
        int index = 768;
        count /= 3;
        for (int i = 0; i < count; ++i) {
            outgoing.pixels[i] = 0xFF000000 | (tiff[index++] & 0xFF) << 16 | (tiff[index++] & 0xFF) << 8 | tiff[index++] & 0xFF;
        }
        return outgoing;
    }

    protected boolean saveTIFF(OutputStream output) {
        try {
            byte[] tiff = new byte[768];
            System.arraycopy(TIFF_HEADER, 0, tiff, 0, TIFF_HEADER.length);
            tiff[30] = (byte)(this.width >> 8 & 0xFF);
            tiff[31] = (byte)(this.width & 0xFF);
            tiff[42] = tiff[102] = (byte)(this.height >> 8 & 0xFF);
            tiff[43] = tiff[103] = (byte)(this.height & 0xFF);
            int count = this.width * this.height * 3;
            tiff[114] = (byte)(count >> 24 & 0xFF);
            tiff[115] = (byte)(count >> 16 & 0xFF);
            tiff[116] = (byte)(count >> 8 & 0xFF);
            tiff[117] = (byte)(count & 0xFF);
            output.write(tiff);
            for (int i = 0; i < this.pixels.length; ++i) {
                output.write(this.pixels[i] >> 16 & 0xFF);
                output.write(this.pixels[i] >> 8 & 0xFF);
                output.write(this.pixels[i] & 0xFF);
            }
            output.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean saveTGA(OutputStream output) {
        byte[] header = new byte[18];
        if (this.format == 4) {
            header[2] = 11;
            header[16] = 8;
            header[17] = 40;
        } else if (this.format == 1) {
            header[2] = 10;
            header[16] = 24;
            header[17] = 32;
        } else if (this.format == 2) {
            header[2] = 10;
            header[16] = 32;
            header[17] = 40;
        } else {
            throw new RuntimeException("Image format not recognized inside save()");
        }
        header[12] = (byte)(this.width & 0xFF);
        header[13] = (byte)(this.width >> 8);
        header[14] = (byte)(this.height & 0xFF);
        header[15] = (byte)(this.height >> 8);
        try {
            int index;
            output.write(header);
            int maxLen = this.height * this.width;
            int[] currChunk = new int[128];
            if (this.format == 4) {
                int rle;
                for (index = 0; index < maxLen; index += rle) {
                    int col;
                    boolean isRLE = false;
                    rle = 1;
                    currChunk[0] = col = this.pixels[index] & 0xFF;
                    while (index + rle < maxLen) {
                        if (col != (this.pixels[index + rle] & 0xFF) || rle == 128) {
                            isRLE = rle > 1;
                            break;
                        }
                        ++rle;
                    }
                    if (isRLE) {
                        output.write(0x80 | rle - 1);
                        output.write(col);
                        continue;
                    }
                    rle = 1;
                    while (index + rle < maxLen) {
                        int cscan = this.pixels[index + rle] & 0xFF;
                        if ((col == cscan || rle >= 128) && rle >= 3) {
                            if (col != cscan) break;
                            rle -= 2;
                            break;
                        }
                        currChunk[rle] = col = cscan;
                        ++rle;
                    }
                    output.write(rle - 1);
                    for (int i = 0; i < rle; ++i) {
                        output.write(currChunk[i]);
                    }
                }
            } else {
                while (index < maxLen) {
                    int col;
                    boolean isRLE = false;
                    currChunk[0] = col = this.pixels[index];
                    int rle = 1;
                    while (index + rle < maxLen) {
                        if (col != this.pixels[index + rle] || rle == 128) {
                            isRLE = rle > 1;
                            break;
                        }
                        ++rle;
                    }
                    if (isRLE) {
                        output.write(0x80 | rle - 1);
                        output.write(col & 0xFF);
                        output.write(col >> 8 & 0xFF);
                        output.write(col >> 16 & 0xFF);
                        if (this.format == 2) {
                            output.write(col >>> 24 & 0xFF);
                        }
                    } else {
                        int i;
                        rle = 1;
                        while (index + rle < maxLen) {
                            if ((col == this.pixels[index + rle] || rle >= 128) && rle >= 3) {
                                if (col != this.pixels[index + rle]) break;
                                rle -= 2;
                                break;
                            }
                            currChunk[rle] = col = this.pixels[index + rle];
                            ++rle;
                        }
                        output.write(rle - 1);
                        if (this.format == 2) {
                            for (i = 0; i < rle; ++i) {
                                col = currChunk[i];
                                output.write(col & 0xFF);
                                output.write(col >> 8 & 0xFF);
                                output.write(col >> 16 & 0xFF);
                                output.write(col >>> 24 & 0xFF);
                            }
                        } else {
                            for (i = 0; i < rle; ++i) {
                                col = currChunk[i];
                                output.write(col & 0xFF);
                                output.write(col >> 8 & 0xFF);
                                output.write(col >> 16 & 0xFF);
                            }
                        }
                    }
                    index += rle;
                }
            }
            output.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean save(String path) {
        boolean success = false;
        this.loadPixels();
        try {
            BufferedOutputStream output = new BufferedOutputStream(this.parent.createOutput(path), 16384);
            String lower = path.toLowerCase();
            String extension = lower.substring(lower.lastIndexOf(46) + 1);
            if (extension.equals("jpg") || extension.equals("jpeg")) {
                Bitmap outgoing = Bitmap.createBitmap((int[])this.pixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                success = outgoing.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)output);
            } else if (extension.equals("png")) {
                Bitmap outgoing = Bitmap.createBitmap((int[])this.pixels, (int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                success = outgoing.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)output);
            } else if (extension.equals("tga")) {
                success = this.saveTGA(output);
            } else {
                if (!extension.equals("tif") && !extension.equals("tiff")) {
                    path = path + ".tif";
                }
                success = this.saveTIFF(output);
            }
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!success) {
            System.err.println("Could not write the image to " + path);
        }
        return success;
    }
}

