/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.annotation.TargetApi;
import android.app.Service;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.wearable.complications.ComplicationData;
import android.support.wearable.watchface.CanvasWatchFaceService;
import android.support.wearable.watchface.WatchFaceStyle;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowInsets;
import android.view.WindowManager;
import java.lang.reflect.Method;
import processing.a2d.PGraphicsAndroid2D;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.android.ServiceEngine;
import processing.core.PApplet;

@TargetApi(value=21)
public class PWatchFaceCanvas
extends CanvasWatchFaceService
implements AppComponent {
    private Point size;
    private DisplayMetrics metrics;
    private CanvasEngine engine;

    @Override
    public void initDimensions() {
        this.metrics = new DisplayMetrics();
        this.size = new Point();
        WindowManager wm = (WindowManager)this.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        CompatUtils.getDisplayParams(display, this.metrics, this.size);
    }

    @Override
    public int getDisplayWidth() {
        return this.size.x;
    }

    @Override
    public int getDisplayHeight() {
        return this.size.y;
    }

    @Override
    public float getDisplayDensity() {
        return this.metrics.density;
    }

    @Override
    public int getKind() {
        return 2;
    }

    public PApplet createSketch() {
        return new PApplet();
    }

    @Override
    public void setSketch(PApplet sketch) {
        this.engine.sketch = sketch;
    }

    @Override
    public PApplet getSketch() {
        return this.engine.sketch;
    }

    @Override
    public boolean isService() {
        return true;
    }

    @Override
    public ServiceEngine getEngine() {
        return this.engine;
    }

    @Override
    public void requestDraw() {
        if (this.engine != null) {
            this.engine.invalidateIfNecessary();
        }
    }

    @Override
    public boolean canDraw() {
        return false;
    }

    @Override
    public void dispose() {
    }

    public void requestPermissions() {
    }

    public CanvasWatchFaceService.Engine onCreateEngine() {
        this.engine = new CanvasEngine();
        return this.engine;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.engine != null) {
            this.engine.onDestroy();
        }
    }

    private class CanvasEngine
    extends CanvasWatchFaceService.Engine
    implements ServiceEngine {
        private PApplet sketch;
        private Method compUpdatedMethod;
        private Method tapCommandMethod;
        private boolean isRound;
        private Rect insets;
        private boolean lowBitAmbient;
        private boolean burnInProtection;

        private CanvasEngine() {
            super((CanvasWatchFaceService)PWatchFaceCanvas.this);
            this.isRound = false;
            this.insets = new Rect();
            this.lowBitAmbient = false;
            this.burnInProtection = false;
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            super.onCreate(surfaceHolder);
            this.setWatchFaceStyle(new WatchFaceStyle.Builder((Service)PWatchFaceCanvas.this).setAcceptsTapEvents(true).build());
            this.sketch = PWatchFaceCanvas.this.createSketch();
            PGraphicsAndroid2D.useBitmap = false;
            this.sketch.initSurface(PWatchFaceCanvas.this, null);
            this.initTapEvents();
            this.initComplications();
            PWatchFaceCanvas.this.requestPermissions();
        }

        private void initTapEvents() {
            try {
                this.tapCommandMethod = this.sketch.getClass().getMethod("onTapCommand", Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE);
            }
            catch (Exception e) {
                this.tapCommandMethod = null;
            }
        }

        private void initComplications() {
            try {
                this.compUpdatedMethod = this.sketch.getClass().getMethod("onComplicationDataUpdate", Integer.TYPE, ComplicationData.class);
            }
            catch (Exception e) {
                this.compUpdatedMethod = null;
            }
        }

        private void invalidateIfNecessary() {
            if (this.isVisible() && !this.isInAmbientMode()) {
                this.invalidate();
            }
        }

        public void onAmbientModeChanged(boolean inAmbientMode) {
            super.onAmbientModeChanged(inAmbientMode);
            this.invalidateIfNecessary();
        }

        public void onPropertiesChanged(Bundle properties) {
            super.onPropertiesChanged(properties);
            this.lowBitAmbient = properties.getBoolean("low_bit_ambient", false);
            this.burnInProtection = properties.getBoolean("burn_in_protection", false);
        }

        public void onApplyWindowInsets(WindowInsets insets) {
            super.onApplyWindowInsets(insets);
            this.isRound = insets.isRound();
            this.insets.set(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        }

        public void onVisibilityChanged(boolean visible) {
            super.onVisibilityChanged(visible);
            if (this.sketch != null) {
                if (visible) {
                    this.sketch.onResume();
                } else {
                    this.sketch.onPause();
                }
            }
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            super.onSurfaceChanged(holder, format, width, height);
            if (this.sketch != null) {
                this.sketch.surfaceChanged();
                this.sketch.setSize(width, height);
            }
        }

        public void onPeekCardPositionUpdate(Rect rect) {
        }

        public void onTimeTick() {
            this.invalidate();
        }

        public void onDraw(Canvas canvas, Rect bounds) {
            super.onDraw(canvas, bounds);
            if (this.sketch != null) {
                PGraphicsAndroid2D g2 = (PGraphicsAndroid2D)this.sketch.g;
                g2.canvas = canvas;
                this.sketch.handleDraw();
            }
        }

        public void onTouchEvent(MotionEvent event) {
            super.onTouchEvent(event);
            if (this.sketch != null) {
                this.sketch.surfaceTouchEvent(event);
            }
        }

        public void onTapCommand(int tapType, int x, int y, long eventTime) {
            if (this.tapCommandMethod != null) {
                try {
                    this.tapCommandMethod.invoke((Object)tapType, x, y, eventTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invalidate();
            }
        }

        public void onComplicationDataUpdate(int complicationId, ComplicationData complicationData) {
            if (this.compUpdatedMethod != null) {
                try {
                    this.compUpdatedMethod.invoke((Object)complicationId, complicationData);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.invalidate();
            }
        }

        public void onDestroy() {
            super.onDestroy();
            if (this.sketch != null) {
                this.sketch.onDestroy();
            }
        }

        @Override
        public float getXOffset() {
            return 0.0f;
        }

        @Override
        public float getYOffset() {
            return 0.0f;
        }

        @Override
        public float getXOffsetStep() {
            return 0.0f;
        }

        @Override
        public float getYOffsetStep() {
            return 0.0f;
        }

        @Override
        public int getXPixelOffset() {
            return 0;
        }

        @Override
        public int getYPixelOffset() {
            return 0;
        }

        @Override
        public boolean isRound() {
            return this.isRound;
        }

        @Override
        public Rect getInsets() {
            return this.insets;
        }

        @Override
        public boolean useLowBitAmbient() {
            return this.lowBitAmbient;
        }

        @Override
        public boolean requireBurnInProtection() {
            return this.burnInProtection;
        }

        @Override
        public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            if (this.sketch != null) {
                this.sketch.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }
}

