/*
 * Decompiled with CFR 0.152.
 */
package processing.android;

import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.DisplayMetrics;
import android.view.ContextMenu;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import processing.android.AppComponent;
import processing.android.CompatUtils;
import processing.android.ServiceEngine;
import processing.core.PApplet;

public class PFragment
extends Fragment
implements AppComponent {
    private DisplayMetrics metrics;
    private Point size;
    private PApplet sketch;
    @LayoutRes
    private int layout = -1;

    public PFragment() {
    }

    public PFragment(PApplet sketch) {
        this.setSketch(sketch);
    }

    @Override
    public void initDimensions() {
        this.metrics = new DisplayMetrics();
        this.size = new Point();
        WindowManager wm = this.getActivity().getWindowManager();
        Display display = wm.getDefaultDisplay();
        CompatUtils.getDisplayParams(display, this.metrics, this.size);
    }

    @Override
    public int getDisplayWidth() {
        return this.size.x;
    }

    @Override
    public int getDisplayHeight() {
        return this.size.y;
    }

    @Override
    public float getDisplayDensity() {
        return this.metrics.density;
    }

    @Override
    public int getKind() {
        return 0;
    }

    @Override
    public void setSketch(PApplet sketch) {
        this.sketch = sketch;
        if (this.layout != -1) {
            sketch.parentLayout = this.layout;
        }
    }

    @Override
    public PApplet getSketch() {
        return this.sketch;
    }

    public void setLayout(@LayoutRes int layout, @IdRes int id, FragmentActivity activity) {
        this.layout = layout;
        if (this.sketch != null) {
            this.sketch.parentLayout = layout;
        }
        FragmentManager manager = activity.getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.add(id, (Fragment)this);
        transaction.commit();
    }

    public void setView(View view, FragmentActivity activity) {
        FragmentManager manager = activity.getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        transaction.add(view.getId(), (Fragment)this);
        transaction.commit();
    }

    @Override
    public boolean isService() {
        return false;
    }

    @Override
    public ServiceEngine getEngine() {
        return null;
    }

    @Override
    public void dispose() {
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (this.sketch != null) {
            this.sketch.initSurface(inflater, container, savedInstanceState, this, null);
            this.sketch.onCreate(savedInstanceState);
            return this.sketch.getSurface().getRootView();
        }
        return null;
    }

    public void onStart() {
        super.onStart();
        if (this.sketch != null) {
            this.sketch.onStart();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.sketch != null) {
            this.sketch.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.sketch != null) {
            this.sketch.onPause();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.sketch != null) {
            this.sketch.onStop();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.sketch != null) {
            this.sketch.onDestroy();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.sketch != null) {
            this.sketch.onActivityResult(requestCode, resultCode, data);
        }
    }

    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        if (this.sketch != null) {
            this.sketch.onCreateOptionsMenu(menu, inflater);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (this.sketch != null) {
            return this.sketch.onOptionsItemSelected(item);
        }
        return super.onOptionsItemSelected(item);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (this.sketch != null) {
            this.sketch.onCreateContextMenu(menu, v, menuInfo);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        if (this.sketch != null) {
            return this.sketch.onContextItemSelected(item);
        }
        return super.onContextItemSelected(item);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public void setOrientation(int which) {
        if (which == 1) {
            this.getActivity().setRequestedOrientation(1);
        } else if (which == 2) {
            this.getActivity().setRequestedOrientation(0);
        }
    }

    @Override
    public void requestDraw() {
    }

    @Override
    public boolean canDraw() {
        return this.sketch != null && this.sketch.isLooping();
    }
}

