/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.util.SignalCorrelator;

public class AutoCorrelator
implements SignalCorrelator {
    private static final float SUB_OCTAVE_REJECTION_FACTOR = 5.0E-4f;
    private static final int STATE_SEEKING_NEGATIVE = 0;
    private static final int STATE_SEEKING_POSITIVE = 1;
    private static final int STATE_SEEKING_MAXIMUM = 2;
    private static final int[] tauAdvanceByState = new int[]{4, 2, 1};
    private int state;
    private float[] buffer;
    private float[] diffs;
    private float[] diffs1;
    private float[] diffs2;
    private int cursor = -1;
    private int tau;
    private float sumProducts;
    private float sumSquares;
    private float localMaximum;
    private int localPosition;
    private float bestMaximum;
    private int bestPosition;
    private int peakCounter;
    private float pitchCorrectionFactor = 0.99988f;
    private double period;
    private double confidence;
    private int minPeriod = 2;
    private boolean bufferValid;
    private double previousSample = 0.0;
    private int maxWindowSize;
    private float noiseThreshold = 0.001f;

    public AutoCorrelator(int n) {
        this.buffer = new float[n];
        this.maxWindowSize = this.buffer.length / 2;
        this.diffs1 = new float[2 + n / 2];
        this.diffs2 = new float[this.diffs1.length];
        this.diffs = this.diffs1;
        this.period = this.minPeriod;
        this.reset();
    }

    private void rawDeltaScan(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; i += n4) {
            float f = this.buffer[n - i];
            float f2 = this.buffer[n2 - i];
            this.sumProducts += f * f2;
            this.sumSquares += f * f + f2 * f2;
        }
    }

    private void splitDeltaScan(int n, int n2, int n3, int n4) {
        int n5 = n2;
        this.rawDeltaScan(n, n2, n5, n4);
        this.rawDeltaScan(n - n5, this.buffer.length - 1, n3 - n5, n4);
    }

    private void checkDeltaScan(int n, int n2, int n3, int n4) {
        if (n3 > n2) {
            int n5 = n2;
            this.checkDeltaScan(n2, n, n5, n4);
            this.checkDeltaScan(this.buffer.length - 1, n - n5, n3 - n5, n4);
        } else if (n3 > n) {
            this.splitDeltaScan(n2, n, n3, n4);
        } else {
            this.rawDeltaScan(n, n2, n3, n4);
        }
    }

    private float topScan(int n, int n2, int n3, int n4) {
        int n5 = n - n2;
        if (n5 < 0) {
            n5 += this.buffer.length;
        }
        this.sumProducts = 0.0f;
        this.sumSquares = 0.0f;
        this.checkDeltaScan(n, n5, n3, n4);
        if (this.sumSquares < 1.0E-8f) {
            return 1.0E-8f;
        }
        float f = (float)Math.pow(this.pitchCorrectionFactor, n2);
        float f2 = (float)(2.0 * (double)this.sumProducts / (double)this.sumSquares) * f;
        return f2;
    }

    private void reset() {
        int n;
        this.switchDiffs();
        for (n = 0; n < this.minPeriod; ++n) {
            this.diffs[n] = 1.0f;
        }
        while (n < this.diffs.length) {
            this.diffs[n] = 0.0f;
            ++n;
        }
        this.tau = this.minPeriod;
        this.state = 0;
        this.peakCounter = 0;
        this.bestMaximum = -1.0f;
        this.bestPosition = -1;
    }

    private void nextPeakAnalysis(int n) {
        float f = this.diffs[n] * (1.0f - (float)n * 5.0E-4f);
        switch (this.state) {
            case 0: {
                if (!(f < -0.01f)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!(f > 0.2f)) break;
                this.state = 2;
                this.localMaximum = f;
                this.localPosition = n;
                break;
            }
            case 2: {
                if (f > this.localMaximum) {
                    this.localMaximum = f;
                    this.localPosition = n;
                    break;
                }
                if (!(f < -0.1f)) break;
                ++this.peakCounter;
                if (this.localMaximum > this.bestMaximum) {
                    this.bestMaximum = this.localMaximum;
                    this.bestPosition = this.localPosition;
                }
                this.state = 1;
            }
        }
    }

    private double findPreciseMaximum(int n) {
        if (n < 3) {
            return 3.0;
        }
        if (n == this.diffs.length - 1) {
            return n;
        }
        double d = this.diffs[n - 1];
        double d2 = this.diffs[n];
        double d3 = this.diffs[n + 1];
        return AutoCorrelator.interpolatePeak(d, d2, d3) + (double)n;
    }

    protected static double interpolatePeak(double d, double d2, double d3) {
        return 0.5 * (d - d3) / (d - 2.0 * d2 + d3);
    }

    private boolean incrementalAnalysis() {
        boolean bl = false;
        if (this.bufferValid) {
            int n = (int)((double)this.tau * this.confidence + (double)this.maxWindowSize * (1.0 - this.confidence));
            int n2 = 1;
            this.diffs[this.tau] = this.topScan(this.cursor, this.tau, n, n2);
            if (this.tau == this.minPeriod && this.sumProducts < this.noiseThreshold) {
                boolean bl2 = this.confidence > 0.0;
                this.confidence = 0.0;
                return bl2;
            }
            this.nextPeakAnalysis(this.tau);
            ++this.tau;
            for (int i = tauAdvanceByState[this.state] - 1; i > 0 && this.tau < this.diffs.length; --i) {
                this.diffs[this.tau] = this.diffs[this.tau - 1];
                ++this.tau;
            }
            if (this.peakCounter >= 4 || this.tau >= this.maxWindowSize) {
                if ((double)this.bestMaximum > 0.0) {
                    this.period = this.findPreciseMaximum(this.bestPosition);
                    this.confidence = (double)this.bestMaximum < 0.0 ? 0.0 : (double)this.bestMaximum;
                } else {
                    this.confidence = 0.0;
                }
                bl = true;
                this.reset();
            }
        }
        return bl;
    }

    @Override
    public float[] getDiffs() {
        return this.diffs == this.diffs1 ? this.diffs2 : this.diffs1;
    }

    private void switchDiffs() {
        this.diffs = this.diffs == this.diffs1 ? this.diffs2 : this.diffs1;
    }

    @Override
    public boolean addSample(double d) {
        double d2 = (d + this.previousSample) * 0.5;
        this.previousSample = d;
        ++this.cursor;
        if (this.cursor == this.buffer.length) {
            this.cursor = 0;
            this.bufferValid = true;
        }
        this.buffer[this.cursor] = (float)d2;
        return this.incrementalAnalysis();
    }

    @Override
    public double getPeriod() {
        return this.period;
    }

    @Override
    public double getConfidence() {
        return this.confidence;
    }

    public float getPitchCorrectionFactor() {
        return this.pitchCorrectionFactor;
    }

    public void setPitchCorrectionFactor(float f) {
        this.pitchCorrectionFactor = f;
    }
}

