### Getting Started
Visual Studio Code is a lightweight but powerful source code editor which runs on your desktop and is available for Windows, macOS and Linux. It comes with built-in support for JavaScript, TypeScript and Node.js and has a rich ecosystem of extensions for other languages and runtimes (such as C++, C#, Java, Python, PHP, Go, .NET). Begin your journey with VS Code with these introductory videos

### Visual Studio Code in Action
In-Product Source Control
Speed up your release cycle with SCM support inside your editor, including rich Git integration.
    
### Top Extensions
Enable additional languages, themes, debuggers, commands, and more. VS Code's growing community shares their secret sauce to improve your workflow.

Python
Python
66.5M
ms-python
IntelliSense (Pylance), Linting, Debugging (multi-threaded, remote), Jupyter Notebooks, code formatting, refactoring, unit tests, and more.
Jupyter
Jupyter
47.4M
ms-toolsai
Jupyter notebook support, interactive programming and computing that supports Intellisense, debugging and more.
Pylance
Pylance
39.7M
ms-python
A performant, feature-rich language server for Python in VS Code
C/C++
C/C++
37.0M
ms-vscode
C/C++ IntelliSense, debugging, and code browsing.
Jupyter Keymap
Jupyter Keymap
29.8M
ms-toolsai
Jupyter keymaps for notebooks
Jupyter Notebook Renderers
Jupyter Notebook Renderers
28.1M
ms-toolsai
Renderers for Jupyter Notebooks (with plotly, vega, gif, png, svg, jpeg and other such outputs)
Live Server
Live Server
26.4M
ritwickdey
Launch a development local Server with live reload feature for static & dynamic pages
Prettier - Code formatter
Prettier - Code formatter
25.1M
esbenp
Code formatter using prettier
See more in the Marketplace
<br>
<img src="https://code.visualstudio.com/assets/docs/editor/intellisense/intellisense_packagejson.gif">
<br>
<img src="https://code.visualstudio.com/assets/docs/editor/intellisense/intellisense_icons.png">
<br>
<img src="https://code.visualstudio.com/assets/docs/editor/debugging/debugging_hero.png">

### First Steps
To get the most out of Visual Studio Code, start by reviewing a few introductory topics:

Intro Videos - Begin your journey with VS Code through these introductory videos.

Setup - Install VS Code for your platform and configure the tool set for your development needs.

User Interface - Introduction to the basic UI, commands, and features of the VS Code editor.

Settings - Customize VS Code for how you like to work.

Languages - Learn about VS Code's support for your favorite programming languages.

Node.js - This tutorial gets you quickly running and debugging a Node.js web app.

Tips and Tricks - Jump right in with Tips and Tricks to become a VS Code power user.

Azure - VS Code is great for deploying your web applications to the cloud.

Extension API - Learn how to write a VS Code extension.

Why VS Code? - Read about the design philosophy and architecture of VS Code.

### Keyboard Shortcuts
Increase your productivity with VS Code's keyboard shortcuts.

Keyboard Shortcut Reference Sheet - Learn the commonly used keyboard shortcuts.

Keymap Extensions - Change VS Code's keyboard shortcuts to match another editor.

Customize Keyboard Shortcuts - Modify the default keyboard shortcuts.

### Downloads
Download VS Code 
- Quickly find the appropriate install for your platform (Windows, macOS and Linux
