# Vim

Vim is a highly configurable text editor built to enable efficient text editing. It is an improved version of the vi editor distributed with most UNIX systems. Vim is distributed free open source software.

## Installation

Vim is pre-installed on most Linux distributions. To install Vim on Windows, download the latest version from the [official website](https://www.vim.org/download.php).

## Usage

Vim is a modal text editor. It has three modes:

1. **Normal Mode**: In this mode, you can navigate the text and perform operations on it. To enter this mode, press the `Esc` key.

2. **Insert Mode**: In this mode, you can insert text. To enter this mode, press the `i` key.

3. **Visual Mode**: In this mode, you can select text. To enter this mode, press the `v` key.

To exit Vim, press the `Esc` key and then type `:q!` and press `Enter`.

### Normal Mode

In Normal Mode, you can navigate the text and perform operations on it. To enter this mode, press the `Esc` key. The following are some of the most commonly used commands in Normal Mode:

| Command | Description |
| ------- | ----------- |
| `h` | Move the cursor left |
| `j` | Move the cursor down |
| `k` | Move the cursor up |
| `l` | Move the cursor right |
| `w` | Move the cursor to the beginning of the next word |
| `b` | Move the cursor to the beginning of the previous word |
| `e` | Move the cursor to the end of the current word |
| `0` | Move the cursor to the beginning of the current line |
| `$` | Move the cursor to the end of the current line |
| `gg` | Move the cursor to the beginning of the file |
| `G` | Move the cursor to the end of the file |
| `x` | Delete the character under the cursor |
| `dd` | Delete the current line |
| `u` | Undo the last operation |
| `Ctrl + r` | Redo the last operation |

### Insert Mode

In Insert Mode, you can insert text. To enter this mode, press the `i` key. The following are some of the most commonly used commands in Insert Mode:

| Command | Description |
| ------- | ----------- |
| `Esc` | Enter Normal Mode |

![vim image](https://github.com/kannanjayachandran/Documentation-for-ide-s/blob/main/images/Vim/one.png)
