# How To Program Games : Tile Classics in JS for HTML5 Canvas
## This is a repository for the Udemy course, How To Program Games : Tile Classics in JS for HTML5 Canvas, instructed by Chris DeLeon.

### What am I going to get from this course?

* Create, display, and play with a 2D tile world that supports optimized collision (a central concept for generations of games in a variety of genres!)
* Program games in JavaScript for HTML5 Canvas without using any external libraries or plug-ins
* Create, load, display, and rotate image graphics in games
* Break game code into multiple files to better manage large projects
* Define a class and use it to create multiple instances of gameplay objects in unique positions (note: only using the very basic first concept of object-oriented programming, it doesn't dive deep into that rabbit hole)
* Handle mouse input for a one-player game, or keyboard controls for both one and two-player games
* Implement basic item pick-ups (keys) and trigger their usage upon collision (open doors)
* Develop and adapt gameplay for basic platformer movement, digital board/strategy games, simple matrix formations for retro arcade-style enemies, and worlds larger than the screen viewed by scrolling camera
* Apply simple trigonometry calls to move game objects at arbitrary angles
* Implement basic loading screen functionality in HTML5

### Target audience?

* Anyone who wants to learn practical skills to program their own games at home
* People who may aleady be familiar with programming concepts but are new to applying that knowledge to making real-time computer games
* Creators who have only ever tried drag-and-drop tools but are interested in learning more about how to make games by programming for an deeper level of control over the details
* Developers interested in getting practice with a more traditional "code only" approach to core gameplay programming before moving on to major engines and tools (which are not covered in this course) like Unity or Unreal
* People looking for a technical game design foundation based in indie-style games or classic gameplay as a starting point
* New developers who completed the free course "Code Your First Game: Arcade Classic in JavaScript on Canvas" and are looking to furthr build upon their game development skills in JavaScript on HTML5 Canvas
* Please note that advanced topics like object-oriented programming are only very briefly touched upon - software engineering patterns are generally outside the scope of this course
