﻿namespace AngleSharp.Html
{
    using System;

    /// <summary>
    /// The collection of (known / used) input type names.
    /// </summary>
    public static class InputTypeNames
    {
        /// <summary>
        /// The input will be hidden.
        /// </summary>
        public static readonly String Hidden = "hidden";

        /// <summary>
        /// A standard (1-line) text input.
        /// </summary>
        public static readonly String Text = "text";

        /// <summary>
        /// A search input.
        /// </summary>
        public static readonly String Search = "search";

        /// <summary>
        /// A telephone number input.
        /// </summary>
        public static readonly String Tel = "tel";

        /// <summary>
        /// An URL input field.
        /// </summary>
        public static readonly String Url = "url";

        /// <summary>
        /// An email input field.
        /// </summary>
        public static readonly String Email = "email";

        /// <summary>
        /// A password input field.
        /// </summary>
        public static readonly String Password = "password";

        /// <summary>
        /// A datetime input field.
        /// </summary>
        public static readonly String Datetime = "datetime";

        /// <summary>
        /// A datetime-local input field.
        /// </summary>
        public static readonly String DatetimeLocal = "datetime-local";

        /// <summary>
        /// A date input field.
        /// </summary>
        public static readonly String Date = "date";

        /// <summary>
        /// A month picker input field.
        /// </summary>
        public static readonly String Month = "month";

        /// <summary>
        /// A week picker input field.
        /// </summary>
        public static readonly String Week = "week";

        /// <summary>
        /// A time picker input field.
        /// </summary>
        public static readonly String Time = "time";

        /// <summary>
        /// A number input field.
        /// </summary>
        public static readonly String Number = "number";

        /// <summary>
        /// A range picker.
        /// </summary>
        public static readonly String Range = "range";

        /// <summary>
        /// A color picker input field.
        /// </summary>
        public static readonly String Color = "color";

        /// <summary>
        /// A checkbox.
        /// </summary>
        public static readonly String Checkbox = "checkbox";

        /// <summary>
        /// A radio box.
        /// </summary>
        public static readonly String Radio = "radio";

        /// <summary>
        /// A file upload box.
        /// </summary>
        public static readonly String File = "file";

        /// <summary>
        /// A submit button.
        /// </summary>
        public static readonly String Submit = "submit";

        /// <summary>
        /// An image input box.
        /// </summary>
        public static readonly String Image = "image";

        /// <summary>
        /// A reset form button.
        /// </summary>
        public static readonly String Reset = "reset";

        /// <summary>
        /// A simple button.
        /// </summary>
        public static readonly String Button = "button";

        /// <summary>
        /// A select-multiple select box.
        /// </summary>
        public static readonly String SelectMultiple = "select-multiple";

        /// <summary>
        /// A select-one select box.
        /// </summary>
        public static readonly String SelectOne = "select-one";
    }
}
