﻿namespace AngleSharp.Html.Dom
{
    /// <summary>
    /// The list of possible table frame directives.
    /// </summary>
    public enum TableFrames : System.Byte
    {
        /// <summary>
        /// No sides. This is the default value.
        /// </summary>
        Void,
        /// <summary>
        /// All four sides.
        /// </summary>
        Box,
        /// <summary>
        /// The top side only.
        /// </summary>
        Above,
        /// <summary>
        /// The bottom side only.
        /// </summary>
        Below,
        /// <summary>
        /// The top and bottom sides only.
        /// </summary>
        HSides,
        /// <summary>
        /// The right and left sides only.
        /// </summary>
        VSides,
        /// <summary>
        /// The left-hand side only.
        /// </summary>
        LHS,
        /// <summary>
        /// The right-hand side only.
        /// </summary>
        RHS,
        /// <summary>
        /// All four sides.
        /// </summary>
        Border
    }
}
