namespace AngleSharp.Html.Dom
{
    using AngleSharp.Dom;
    using System;

    /// <summary>
    /// Represents the HTML label element.
    /// </summary>
    sealed class HtmlLabelElement : HtmlElement, IHtmlLabelElement
    {
        #region ctor

        public HtmlLabelElement(Document owner, String? prefix = null)
            : base(owner, TagNames.Label, prefix)
        {
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the control that the label is assigned for if any.
        /// </summary>
        public IHtmlElement? Control
        {
            get
            {
                var controlId = HtmlFor;

                if (controlId is { Length: > 0 })
                {
                    var control = Owner.GetElementById(controlId) as IHtmlElement;

                    if (control is ILabelabelElement)
                    {
                        return control;
                    }
                }
                
                return null;
            }
        }

        /// <summary>
        /// Gets or sets the ID of the labeled control. Reflects the for attribute.
        /// </summary>
        public String? HtmlFor
        {
            get => this.GetOwnAttribute(AttributeNames.For);
            set => this.SetOwnAttribute(AttributeNames.For, value);
        }

        /// <summary>
        /// Gets the form element that the label is assigned for if any.
        /// </summary>
        public IHtmlFormElement? Form => GetAssignedForm();

        #endregion
    }
}
