﻿namespace AngleSharp.Html.Dom
{
    /// <summary>
    /// The list of possible horizontal alignments.
    /// </summary>
    enum Alignment : System.Byte
    {
        /// <summary>
        /// The bottom of the object should be vertically aligned with
        /// the current baseline. This is the default value.
        /// </summary>
        Bottom,
        /// <summary>
        /// The center of the object should be vertically aligned with
        /// the current baseline.
        /// </summary>
        Middle,
        /// <summary>
        /// The top of the object should be vertically aligned with the
        /// top of the current text line.
        /// </summary>
        Top,
        /// <summary>
        /// Float to the current left margin.
        /// </summary>
        Left,
        /// <summary>
        /// Float to the current right margin.
        /// </summary>
        Right
    }
}
