﻿namespace AngleSharp.Dom
{
    using System;

    /// <summary>
    /// Contains a list of common namespaces.
    /// </summary>
    public static class NamespaceNames
    {
        /// <summary>
        /// Gets the namespace for HTML elements.
        /// </summary>
        public static readonly String HtmlUri = "http://www.w3.org/1999/xhtml";

        /// <summary>
        /// Gets the namespace for XMLNS elements.
        /// </summary>
        public static readonly String XmlNsUri = "http://www.w3.org/2000/xmlns/";

        /// <summary>
        /// Gets the namespace for XMLNS elements.
        /// </summary>
        public static readonly String XLinkUri = "http://www.w3.org/1999/xlink";

        /// <summary>
        /// Gets the namespace for XML elements.
        /// </summary>
        public static readonly String XmlUri = "http://www.w3.org/XML/1998/namespace";

        /// <summary>
        /// Gets the namespace for SVG elements.
        /// </summary>
        public static readonly String SvgUri = "http://www.w3.org/2000/svg";

        /// <summary>
        /// Gets the namespace for MathML elements.
        /// </summary>
        public static readonly String MathMlUri = "http://www.w3.org/1998/Math/MathML";

        /// <summary>
        /// Gets the prefix for XMLNS elements.
        /// </summary>
        public static readonly String XmlNsPrefix = "xmlns";

        /// <summary>
        /// Gets the prefix for XMLNS elements.
        /// </summary>
        public static readonly String XLinkPrefix = "xlink";

        /// <summary>
        /// Gets the prefix for XML elements.
        /// </summary>
        public static readonly String XmlPrefix = "xml";
    }
}
