﻿namespace AngleSharp.Dom
{
    using System;

    /// <summary>
    /// The collection of (known / used) event names.
    /// </summary>
    public static class EventNames
    {
        /// <summary>
        /// The invalid event.
        /// </summary>
        public static readonly String Invalid = "invalid";

        /// <summary>
        /// The load event.
        /// </summary>
        public static readonly String Load = "load";

        /// <summary>
        /// The DOMContentLoaded event.
        /// </summary>
        public static readonly String DomContentLoaded = "DOMContentLoaded";

        /// <summary>
        /// The error event.
        /// </summary>
        public static readonly String Error = "error";

        /// <summary>
        /// The beforescriptexecute event.
        /// </summary>
        public static readonly String BeforeScriptExecute = "beforescriptexecute";

        /// <summary>
        /// The afterscriptexecute event.
        /// </summary>
        public static readonly String AfterScriptExecute = "afterscriptexecute";

        /// <summary>
        /// The readystatechanged event.
        /// </summary>
        public static readonly String ReadyStateChanged = "readystatechanged";

        /// <summary>
        /// The abort event.
        /// </summary>
        public static readonly String Abort = "abort";

        /// <summary>
        /// The blur event.
        /// </summary>
        public static readonly String Blur = "blur";

        /// <summary>
        /// The cancel event.
        /// </summary>
        public static readonly String Cancel = "cancel";

        /// <summary>
        /// The click event.
        /// </summary>
        public static readonly String Click = "click";

        /// <summary>
        /// The change event.
        /// </summary>
        public static readonly String Change = "change";

        /// <summary>
        /// The canplaythrough event.
        /// </summary>
        public static readonly String CanPlayThrough = "canplaythrough";

        /// <summary>
        /// The canplay event.
        /// </summary>
        public static readonly String CanPlay = "canplay";

        /// <summary>
        /// The cuechange event.
        /// </summary>
        public static readonly String CueChange = "cuechange";

        /// <summary>
        /// The dblclick event.
        /// </summary>
        public static readonly String DblClick = "dblclick";

        /// <summary>
        /// The drag event.
        /// </summary>
        public static readonly String Drag = "drag";

        /// <summary>
        /// The dragend event.
        /// </summary>
        public static readonly String DragEnd = "dragend";

        /// <summary>
        /// The dragenter event.
        /// </summary>
        public static readonly String DragEnter = "dragenter";

        /// <summary>
        /// The dragexit event.
        /// </summary>
        public static readonly String DragExit = "dragexit";

        /// <summary>
        /// The dragleave event.
        /// </summary>
        public static readonly String DragLeave = "dragleave";

        /// <summary>
        /// The dragover event.
        /// </summary>
        public static readonly String DragOver = "dragover";

        /// <summary>
        /// The dragstart event.
        /// </summary>
        public static readonly String DragStart = "dragstart";

        /// <summary>
        /// The drop event.
        /// </summary>
        public static readonly String Drop = "drop";

        /// <summary>
        /// The durationchange event.
        /// </summary>
        public static readonly String DurationChange = "durationchange";

        /// <summary>
        /// The emptied event.
        /// </summary>
        public static readonly String Emptied = "emptied";

        /// <summary>
        /// The focus event.
        /// </summary>
        public static readonly String Focus = "focus";

        /// <summary>
        /// The fullscreenchange event.
        /// </summary>
        public static readonly String FullscreenChange = "fullscreenchange";

        /// <summary>
        /// The fullscreenerror event.
        /// </summary>
        public static readonly String FullscreenError = "fullscreenerror";

        /// <summary>
        /// The hashchange event.
        /// </summary>
        public static readonly String HashChange = "hashchange";

        /// <summary>
        /// The input event.
        /// </summary>
        public static readonly String Input = "input";

        /// <summary>
        /// The message event.
        /// </summary>
        public static readonly String Message = "message";

        /// <summary>
        /// The keydown event.
        /// </summary>
        public static readonly String Keydown = "keydown";

        /// <summary>
        /// The keypress event.
        /// </summary>
        public static readonly String Keypress = "keypress";

        /// <summary>
        /// The keyup event.
        /// </summary>
        public static readonly String Keyup = "keyup";

        /// <summary>
        /// The ended event.
        /// </summary>
        public static readonly String Ended = "ended";

        /// <summary>
        /// The loadeddata event.
        /// </summary>
        public static readonly String LoadedData = "loadeddata";

        /// <summary>
        /// The loadedmetadata event.
        /// </summary>
        public static readonly String LoadedMetaData = "loadedmetadata";

        /// <summary>
        /// The loadend event.
        /// </summary>
        public static readonly String LoadEnd = "loadend";

        /// <summary>
        /// The loadstart event.
        /// </summary>
        public static readonly String LoadStart = "loadstart";

        /// <summary>
        /// The wheel event.
        /// </summary>
        public static readonly String Wheel = "wheel";

        /// <summary>
        /// The mouseup event.
        /// </summary>
        public static readonly String Mouseup = "mouseup";

        /// <summary>
        /// The mouseover event.
        /// </summary>
        public static readonly String Mouseover = "mouseover";

        /// <summary>
        /// The mouseout event.
        /// </summary>
        public static readonly String Mouseout = "mouseout";

        /// <summary>
        /// The mousemove event.
        /// </summary>
        public static readonly String Mousemove = "mousemove";

        /// <summary>
        /// The mouseleave event.
        /// </summary>
        public static readonly String Mouseleave = "mouseleave";

        /// <summary>
        /// The mouseenter event.
        /// </summary>
        public static readonly String Mouseenter = "mouseenter";

        /// <summary>
        /// The mousedown event.
        /// </summary>
        public static readonly String Mousedown = "mousedown";

        /// <summary>
        /// The pause event.
        /// </summary>
        public static readonly String Pause = "pause";

        /// <summary>
        /// The play event.
        /// </summary>
        public static readonly String Play = "play";

        /// <summary>
        /// The playing event.
        /// </summary>
        public static readonly String Playing = "playing";

        /// <summary>
        /// The progress event.
        /// </summary>
        public static readonly String Progress = "progress";

        /// <summary>
        /// The ratechange event.
        /// </summary>
        public static readonly String RateChange = "ratechange";

        /// <summary>
        /// The waiting event.
        /// </summary>
        public static readonly String Waiting = "waiting";

        /// <summary>
        /// The volumechange event.
        /// </summary>
        public static readonly String VolumeChange = "volumechange";

        /// <summary>
        /// The toggle event.
        /// </summary>
        public static readonly String Toggle = "toggle";

        /// <summary>
        /// The timeupdate event.
        /// </summary>
        public static readonly String TimeUpdate = "timeupdate";

        /// <summary>
        /// The suspend event.
        /// </summary>
        public static readonly String Suspend = "suspend";

        /// <summary>
        /// The submit event.
        /// </summary>
        public static readonly String Submit = "submit";

        /// <summary>
        /// The stalled event.
        /// </summary>
        public static readonly String Stalled = "stalled";

        /// <summary>
        /// The show event.
        /// </summary>
        public static readonly String Show = "show";

        /// <summary>
        /// The select event.
        /// </summary>
        public static readonly String Select = "select";

        /// <summary>
        /// The seeking event.
        /// </summary>
        public static readonly String Seeking = "seeking";

        /// <summary>
        /// The seeked event.
        /// </summary>
        public static readonly String Seeked = "seeked";

        /// <summary>
        /// The scroll event.
        /// </summary>
        public static readonly String Scroll = "scroll";

        /// <summary>
        /// The resize event.
        /// </summary>
        public static readonly String Resize = "resize";

        /// <summary>
        /// The reset event.
        /// </summary>
        public static readonly String Reset = "reset";

        /// <summary>
        /// The afterprint event.
        /// </summary>
        public static readonly String AfterPrint = "afterprint";

        /// <summary>
        /// The print event.
        /// </summary>
        public static readonly String Print = "print";

        /// <summary>
        /// The beforeprint event.
        /// </summary>
        public static readonly String BeforePrint = "beforeprint";

        /// <summary>
        /// The beforeunload event.
        /// </summary>
        public static readonly String BeforeUnload = "beforeunload";

        /// <summary>
        /// The unloading event.
        /// </summary>
        public static readonly String Unloading = "unloading";

        /// <summary>
        /// The offline event.
        /// </summary>
        public static readonly String Offline = "offline";

        /// <summary>
        /// The online event.
        /// </summary>
        public static readonly String Online = "online";

        /// <summary>
        /// The pagehide event.
        /// </summary>
        public static readonly String PageHide = "pagehide";

        /// <summary>
        /// The pageshow event.
        /// </summary>
        public static readonly String PageShow = "pageshow";

        /// <summary>
        /// The popstate event.
        /// </summary>
        public static readonly String PopState = "popstate";

        /// <summary>
        /// The unload event.
        /// </summary>
        public static readonly String Unload = "unload";

        /// <summary>
        /// The confirmUnload event.
        /// </summary>
        public static readonly String ConfirmUnload = "confirmUnload";

        /// <summary>
        /// The storage event.
        /// </summary>
        public static readonly String Storage = "storage";

        /// <summary>
        /// The parsing event.
        /// </summary>
        public static readonly String Parsing = "parsing";

        /// <summary>
        /// The parsed event.
        /// </summary>
        public static readonly String Parsed = "parsed";

        /// <summary>
        /// The requesting event.
        /// </summary>
        public static readonly String Requesting = "requesting";

        /// <summary>
        /// The requested event.
        /// </summary>
        public static readonly String Requested = "requested";
    }
}
