namespace AngleSharp.Dom
{
    using System;

    /// <summary>
    /// The collection of (known / used) attribute names.
    /// </summary>
    public static class AttributeNames
    {
        /// <summary>
        /// The name attribute.
        /// </summary>
        public static readonly String Name = "name";

        /// <summary>
        /// The http-equiv attribute.
        /// </summary>
        public static readonly String HttpEquiv = "http-equiv";

        /// <summary>
        /// The scheme attribute.
        /// </summary>
        public static readonly String Scheme = "scheme";

        /// <summary>
        /// The content attribute.
        /// </summary>
        public static readonly String Content = "content";

        /// <summary>
        /// The class attribute.
        /// </summary>
        public static readonly String Class = "class";

        /// <summary>
        /// The style attribute.
        /// </summary>
        public static readonly String Style = "style";

        /// <summary>
        /// The label attribute.
        /// </summary>
        public static readonly String Label = "label";

        /// <summary>
        /// The action attribute.
        /// </summary>
        public static readonly String Action = "action";

        /// <summary>
        /// The prompt attribute.
        /// </summary>
        public static readonly String Prompt = "prompt";

        /// <summary>
        /// The href attribute.
        /// </summary>
        public static readonly String Href = "href";

        /// <summary>
        /// The hreflang attribute.
        /// </summary>
        public static readonly String HrefLang = "hreflang";

        /// <summary>
        /// The lang attribute.
        /// </summary>
        public static readonly String Lang = "lang";

        /// <summary>
        /// The disabled attribute.
        /// </summary>
        public static readonly String Disabled = "disabled";

        /// <summary>
        /// The selected attribute.
        /// </summary>
        public static readonly String Selected = "selected";

        /// <summary>
        /// The value attribute.
        /// </summary>
        public static readonly String Value = "value";

        /// <summary>
        /// The title attribute.
        /// </summary>
        public static readonly String Title = "title";

        /// <summary>
        /// The type attribute.
        /// </summary>
        public static readonly String Type = "type";

        /// <summary>
        /// The rel attribute.
        /// </summary>
        public static readonly String Rel = "rel";

        /// <summary>
        /// The rev attribute.
        /// </summary>
        public static readonly String Rev = "rev";

        /// <summary>
        /// The accesskey attribute.
        /// </summary>
        public static readonly String AccessKey = "accesskey";

        /// <summary>
        /// The download attribute.
        /// </summary>
        public static readonly String Download = "download";

        /// <summary>
        /// The media attribute.
        /// </summary>
        public static readonly String Media = "media";

        /// <summary>
        /// The target attribute.
        /// </summary>
        public static readonly String Target = "target";

        /// <summary>
        /// The charset attribute.
        /// </summary>
        public static readonly String Charset = "charset";

        /// <summary>
        /// The alt attribute.
        /// </summary>
        public static readonly String Alt = "alt";

        /// <summary>
        /// The coords attribute.
        /// </summary>
        public static readonly String Coords = "coords";

        /// <summary>
        /// The shape attribute.
        /// </summary>
        public static readonly String Shape = "shape";

        /// <summary>
        /// The formaction attribute.
        /// </summary>
        public static readonly String FormAction = "formaction";

        /// <summary>
        /// The formmethod attribute.
        /// </summary>
        public static readonly String FormMethod = "formmethod";

        /// <summary>
        /// The formtarget attribute.
        /// </summary>
        public static readonly String FormTarget = "formtarget";

        /// <summary>
        /// The formenctype attribute.
        /// </summary>
        public static readonly String FormEncType = "formenctype";

        /// <summary>
        /// The formnovalidate attribute.
        /// </summary>
        public static readonly String FormNoValidate = "formnovalidate";

        /// <summary>
        /// The dirname attribute.
        /// </summary>
        public static readonly String DirName = "dirname";

        /// <summary>
        /// The dir attribute.
        /// </summary>
        public static readonly String Dir = "dir";

        /// <summary>
        /// The nonce attribute.
        /// </summary>
        public static readonly String Nonce = "nonce";

        /// <summary>
        /// The noresize attribute.
        /// </summary>
        public static readonly String NoResize = "noresize";

        /// <summary>
        /// The src attribute.
        /// </summary>
        public static readonly String Src = "src";

        /// <summary>
        /// The srcset attribute.
        /// </summary>
        public static readonly String SrcSet = "srcset";

        /// <summary>
        /// The srclang attribute.
        /// </summary>
        public static readonly String SrcLang = "srclang";

        /// <summary>
        /// The srcdoc attribute.
        /// </summary>
        public static readonly String SrcDoc = "srcdoc";

        /// <summary>
        /// The scrolling attribute.
        /// </summary>
        public static readonly String Scrolling = "scrolling";

        /// <summary>
        /// The longdesc attribute.
        /// </summary>
        public static readonly String LongDesc = "longdesc";

        /// <summary>
        /// The frameborder attribute.
        /// </summary>
        public static readonly String FrameBorder = "frameborder";

        /// <summary>
        /// The width attribute.
        /// </summary>
        public static readonly String Width = "width";

        /// <summary>
        /// The height attribute.
        /// </summary>
        public static readonly String Height = "height";

        /// <summary>
        /// The marginwidth attribute.
        /// </summary>
        public static readonly String MarginWidth = "marginwidth";

        /// <summary>
        /// The marginheight attribute.
        /// </summary>
        public static readonly String MarginHeight = "marginheight";

        /// <summary>
        /// The cols attribute.
        /// </summary>
        public static readonly String Cols = "cols";

        /// <summary>
        /// The rows attribute.
        /// </summary>
        public static readonly String Rows = "rows";

        /// <summary>
        /// The align attribute.
        /// </summary>
        public static readonly String Align = "align";

        /// <summary>
        /// The encoding attribute.
        /// </summary>
        public static readonly String Encoding = "encoding";

        /// <summary>
        /// The standalone attribute.
        /// </summary>
        public static readonly String Standalone = "standalone";

        /// <summary>
        /// The version attribute.
        /// </summary>
        public static readonly String Version = "version";

        /// <summary>
        /// The dropzone attribute.
        /// </summary>
        public static readonly String DropZone = "dropzone";

        /// <summary>
        /// The draggable attribute.
        /// </summary>
        public static readonly String Draggable = "draggable";

        /// <summary>
        /// The spellcheck attribute.
        /// </summary>
        public static readonly String Spellcheck = "spellcheck";

        /// <summary>
        /// The tabindex attribute.
        /// </summary>
        public static readonly String TabIndex = "tabindex";

        /// <summary>
        /// The contenteditable attribute.
        /// </summary>
        public static readonly String ContentEditable = "contenteditable";

        /// <summary>
        /// The translate attribute.
        /// </summary>
        public static readonly String Translate = "translate";

        /// <summary>
        /// The contextmenu attribute.
        /// </summary>
        public static readonly String ContextMenu = "contextmenu";

        /// <summary>
        /// The hidden attribute.
        /// </summary>
        public static readonly String Hidden = "hidden";

        /// <summary>
        /// The id attribute.
        /// </summary>
        public static readonly String Id = "id";

        /// <summary>
        /// The sizes attribute.
        /// </summary>
        public static readonly String Sizes = "sizes";

        /// <summary>
        /// The scoped attribute.
        /// </summary>
        public static readonly String Scoped = "scoped";

        /// <summary>
        /// The reversed attribute.
        /// </summary>
        public static readonly String Reversed = "reversed";

        /// <summary>
        /// The start attribute.
        /// </summary>
        public static readonly String Start = "start";

        /// <summary>
        /// The ping attribute.
        /// </summary>
        public static readonly String Ping = "ping";

        /// <summary>
        /// The ismap attribute.
        /// </summary>
        public static readonly String IsMap = "ismap";

        /// <summary>
        /// The usemap attribute.
        /// </summary>
        public static readonly String UseMap = "usemap";

        /// <summary>
        /// The crossorigin attribute.
        /// </summary>
        public static readonly String CrossOrigin = "crossorigin";

        /// <summary>
        /// The sandbox attribute.
        /// </summary>
        public static readonly String Sandbox = "sandbox";

        /// <summary>
        /// The allowfullscreen attribute.
        /// </summary>
        public static readonly String AllowFullscreen = "allowfullscreen";

        /// <summary>
        /// The allowpaymentrequest attribute.
        /// </summary>
        public static readonly String AllowPaymentRequest = "allowpaymentrequest";

        /// <summary>
        /// The data attribute.
        /// </summary>
        public static readonly String Data = "data";

        /// <summary>
        /// The typemustmatch attribute.
        /// </summary>
        public static readonly String TypeMustMatch = "typemustmatch";

        /// <summary>
        /// The autofocus attribute.
        /// </summary>
        public static readonly String AutoFocus = "autofocus";

        /// <summary>
        /// The accept-charset attribute.
        /// </summary>
        public static readonly String AcceptCharset = "accept-charset";

        /// <summary>
        /// The enctype attribute.
        /// </summary>
        public static readonly String Enctype = "enctype";

        /// <summary>
        /// The autocomplete attribute.
        /// </summary>
        public static readonly String AutoComplete = "autocomplete";

        /// <summary>
        /// The method attribute.
        /// </summary>
        public static readonly String Method = "method";

        /// <summary>
        /// The novalidate attribute.
        /// </summary>
        public static readonly String NoValidate = "novalidate";

        /// <summary>
        /// The for attribute.
        /// </summary>
        public static readonly String For = "for";

        /// <summary>
        /// The seamless attribute.
        /// </summary>
        public static readonly String Seamless = "seamless";

        /// <summary>
        /// The valign attribute.
        /// </summary>
        public static readonly String Valign = "valign";

        /// <summary>
        /// The span attribute.
        /// </summary>
        public static readonly String Span = "span";

        /// <summary>
        /// The bgcolor attribute.
        /// </summary>
        public static readonly String BgColor = "bgcolor";

        /// <summary>
        /// The colspan attribute.
        /// </summary>
        public static readonly String ColSpan = "colspan";

        /// <summary>
        /// The referrerpolicy attribute.
        /// </summary>
        public static readonly String ReferrerPolicy = "referrerpolicy";

        /// <summary>
        /// The rowspan attribute.
        /// </summary>
        public static readonly String RowSpan = "rowspan";

        /// <summary>
        /// The nowrap attribute.
        /// </summary>
        public static readonly String NoWrap = "nowrap";

        /// <summary>
        /// The abbr attribute.
        /// </summary>
        public static readonly String Abbr = "abbr";

        /// <summary>
        /// The scope attribute.
        /// </summary>
        public static readonly String Scope = "scope";

        /// <summary>
        /// The headers attribute.
        /// </summary>
        public static readonly String Headers = "headers";

        /// <summary>
        /// The axis attribute.
        /// </summary>
        public static readonly String Axis = "axis";

        /// <summary>
        /// The border attribute.
        /// </summary>
        public static readonly String Border = "border";

        /// <summary>
        /// The cellpadding attribute.
        /// </summary>
        public static readonly String CellPadding = "cellpadding";

        /// <summary>
        /// The rules attribute.
        /// </summary>
        public static readonly String Rules = "rules";

        /// <summary>
        /// The summary attribute.
        /// </summary>
        public static readonly String Summary = "summary";

        /// <summary>
        /// The cellspacing attribute.
        /// </summary>
        public static readonly String CellSpacing = "cellspacing";

        /// <summary>
        /// The frame attribute.
        /// </summary>
        public static readonly String Frame = "frame";

        /// <summary>
        /// The form attribute.
        /// </summary>
        public static readonly String Form = "form";

        /// <summary>
        /// The required attribute.
        /// </summary>
        public static readonly String Required = "required";

        /// <summary>
        /// The multiple attribute.
        /// </summary>
        public static readonly String Multiple = "multiple";

        /// <summary>
        /// The min attribute.
        /// </summary>
        public static readonly String Min = "min";

        /// <summary>
        /// The max attribute.
        /// </summary>
        public static readonly String Max = "max";

        /// <summary>
        /// The open attribute.
        /// </summary>
        public static readonly String Open = "open";

        /// <summary>
        /// The challenge attribute.
        /// </summary>
        public static readonly String Challenge = "challenge";

        /// <summary>
        /// The keytype attribute.
        /// </summary>
        public static readonly String Keytype = "keytype";

        /// <summary>
        /// The size attribute.
        /// </summary>
        public static readonly String Size = "size";

        /// <summary>
        /// The wrap attribute.
        /// </summary>
        public static readonly String Wrap = "wrap";

        /// <summary>
        /// The maxlength attribute.
        /// </summary>
        public static readonly String MaxLength = "maxlength";

        /// <summary>
        /// The minlength attribute.
        /// </summary>
        public static readonly String MinLength = "minlength";

        /// <summary>
        /// The placeholder attribute.
        /// </summary>
        public static readonly String Placeholder = "placeholder";

        /// <summary>
        /// The readonly attribute.
        /// </summary>
        public static readonly String Readonly = "readonly";

        /// <summary>
        /// The accept attribute.
        /// </summary>
        public static readonly String Accept = "accept";

        /// <summary>
        /// The pattern attribute.
        /// </summary>
        public static readonly String Pattern = "pattern";

        /// <summary>
        /// The step attribute.
        /// </summary>
        public static readonly String Step = "step";

        /// <summary>
        /// The list attribute.
        /// </summary>
        public static readonly String List = "list";

        /// <summary>
        /// The checked attribute.
        /// </summary>
        public static readonly String Checked = "checked";

        /// <summary>
        /// The kind attribute.
        /// </summary>
        public static readonly String Kind = "kind";

        /// <summary>
        /// The default attribute.
        /// </summary>
        public static readonly String Default = "default";

        /// <summary>
        /// The autoplay attribute.
        /// </summary>
        public static readonly String Autoplay = "autoplay";

        /// <summary>
        /// The preload attribute.
        /// </summary>
        public static readonly String Preload = "preload";

        /// <summary>
        /// The loop attribute.
        /// </summary>
        public static readonly String Loop = "loop";

        /// <summary>
        /// The controls attribute.
        /// </summary>
        public static readonly String Controls = "controls";

        /// <summary>
        /// The muted attribute.
        /// </summary>
        public static readonly String Muted = "muted";

        /// <summary>
        /// The mediagroup attribute.
        /// </summary>
        public static readonly String MediaGroup = "mediagroup";

        /// <summary>
        /// The poster attribute.
        /// </summary>
        public static readonly String Poster = "poster";

        /// <summary>
        /// The color attribute.
        /// </summary>
        public static readonly String Color = "color";

        /// <summary>
        /// The face attribute.
        /// </summary>
        public static readonly String Face = "face";

        /// <summary>
        /// The command attribute.
        /// </summary>
        public static readonly String Command = "command";

        /// <summary>
        /// The icon attribute.
        /// </summary>
        public static readonly String Icon = "icon";

        /// <summary>
        /// The radiogroup attribute.
        /// </summary>
        public static readonly String Radiogroup = "radiogroup";

        /// <summary>
        /// The cite attribute.
        /// </summary>
        public static readonly String Cite = "cite";

        /// <summary>
        /// The async attribute.
        /// </summary>
        public static readonly String Async = "async";

        /// <summary>
        /// The defer attribute.
        /// </summary>
        public static readonly String Defer = "defer";

        /// <summary>
        /// The language attribute.
        /// </summary>
        public static readonly String Language = "language";

        /// <summary>
        /// The event attribute.
        /// </summary>
        public static readonly String Event = "event";

        /// <summary>
        /// The alink attribute.
        /// </summary>
        public static readonly String Alink = "alink";

        /// <summary>
        /// The background attribute.
        /// </summary>
        public static readonly String Background = "background";

        /// <summary>
        /// The link attribute.
        /// </summary>
        public static readonly String Link = "link";

        /// <summary>
        /// The text attribute.
        /// </summary>
        public static readonly String Text = "text";

        /// <summary>
        /// THe vlink attribute.
        /// </summary>
        public static readonly String Vlink = "vlink";

        /// <summary>
        /// The show attribute.
        /// </summary>
        public static readonly String Show = "show";

        /// <summary>
        /// The role attribute.
        /// </summary>
        public static readonly String Role = "role";

        /// <summary>
        /// The actuate attribute.
        /// </summary>
        public static readonly String Actuate = "actuate";

        /// <summary>
        /// The arcrole attribute.
        /// </summary>
        public static readonly String Arcrole = "arcrole";

        /// <summary>
        /// The space attribute.
        /// </summary>
        public static readonly String Space = "space";

        /// <summary>
        /// The window attribute.
        /// </summary>
        public static readonly String Window = "window";

        /// <summary>
        /// The manifest attribute.
        /// </summary>
        public static readonly String Manifest = "manifest";

        /// <summary>
        /// The datetime attribute.
        /// </summary>
        public static readonly String Datetime = "datetime";

        /// <summary>
        /// The low attribute.
        /// </summary>
        public static readonly String Low = "low";

        /// <summary>
        /// The high attribute.
        /// </summary>
        public static readonly String High = "high";

        /// <summary>
        /// The optimum attribute.
        /// </summary>
        public static readonly String Optimum = "optimum";

        /// <summary>
        /// The slot attribute.
        /// </summary>
        public static readonly String Slot = "slot";

        /// <summary>
        /// The body attribute.
        /// </summary>
        public static readonly String Body = "body";

        /// <summary>
        /// The integrity attribute.
        /// </summary>
        public static readonly String Integrity = "integrity";

        /// <summary>
        /// The clear attribute.
        /// </summary>
        public static readonly String Clear = "clear";

        /// <summary>
        /// The codetype attribute.
        /// </summary>
        public static readonly String Codetype = "codetype";

        /// <summary>
        /// The compact attribute.
        /// </summary>
        public static readonly String Compact = "compact";

        /// <summary>
        /// The declare attribute.
        /// </summary>
        public static readonly String Declare = "declare";

        /// <summary>
        /// The direction attribute.
        /// </summary>
        public static readonly String Direction = "direction";

        /// <summary>
        /// The nohref attribute.
        /// </summary>
        public static readonly String NoHref = "nohref";

        /// <summary>
        /// The noshade attribute.
        /// </summary>
        public static readonly String NoShade = "noshade";

        /// <summary>
        /// The valuetype attribute.
        /// </summary>
        public static readonly String ValueType = "valuetype";
    }
}
