﻿namespace AngleSharp.Css
{
    using System;

    /// <summary>
    /// The collection of (known / used) selector pseudo element names.
    /// </summary>
    public static class PseudoElementNames
    {
        /// <summary>
        /// The before pseudo element.
        /// </summary>
        public static readonly String Before = "before";

        /// <summary>
        /// The after pseudo element.
        /// </summary>
        public static readonly String After = "after";

        /// <summary>
        /// The slotted pseudo element.
        /// </summary>
        public static readonly String Slotted = "slotted";

        /// <summary>
        /// The selection pseudo element.
        /// </summary>
        public static readonly String Selection = "selection";

        /// <summary>
        /// The first-line pseudo element.
        /// </summary>
        public static readonly String FirstLine = "first-line";

        /// <summary>
        /// The first-letter pseudo element.
        /// </summary>
        public static readonly String FirstLetter = "first-letter";

        /// <summary>
        /// The footnote-call pseudo element.
        /// </summary>
        public static readonly String FootnoteCall = "footnote-call";

        /// <summary>
        /// The footnote-marker pseudo element.
        /// </summary>
        public static readonly String FootnoteMarker = "footnote-marker";

        /// <summary>
        /// The content pseudo element.
        /// </summary>
        public static readonly String Content = "content";

        /// <summary>
        /// The separating double-colon.
        /// </summary>
        public static readonly String Separator = "::";
    }
}
