namespace AngleSharp.Css
{
    using System;

    /// <summary>
    /// The collection of (known / used) selector pseudo class names.
    /// </summary>
    public static class PseudoClassNames
    {
        /// <summary>
        /// The root pseudo class.
        /// </summary>
        public static readonly String Root = "root";

        /// <summary>
        /// The scope pseudo class.
        /// </summary>
        public static readonly String Scope = "scope";

        /// <summary>
        /// The only-of-type pseudo class.
        /// </summary>
        public static readonly String OnlyType = "only-of-type";

        /// <summary>
        /// The first-of-type pseudo class.
        /// </summary>
        public static readonly String FirstOfType = "first-of-type";

        /// <summary>
        /// The last-of-type pseudo class.
        /// </summary>
        public static readonly String LastOfType = "last-of-type";

        /// <summary>
        /// The only-child pseudo class.
        /// </summary>
        public static readonly String OnlyChild = "only-child";

        /// <summary>
        /// The first-child pseudo class.
        /// </summary>
        public static readonly String FirstChild = "first-child";

        /// <summary>
        /// The last-child pseudo class.
        /// </summary>
        public static readonly String LastChild = "last-child";

        /// <summary>
        /// The empty pseudo class.
        /// </summary>
        public static readonly String Empty = "empty";

        /// <summary>
        /// The any-link pseudo class.
        /// </summary>
        public static readonly String AnyLink = "any-link";

        /// <summary>
        /// The link pseudo class.
        /// </summary>
        public static readonly String Link = "link";

        /// <summary>
        /// The visited pseudo class.
        /// </summary>
        public static readonly String Visited = "visited";

        /// <summary>
        /// The active pseudo class.
        /// </summary>
        public static readonly String Active = "active";

        /// <summary>
        /// The hover pseudo class.
        /// </summary>
        public static readonly String Hover = "hover";

        /// <summary>
        /// The focus pseudo class.
        /// </summary>
        public static readonly String Focus = "focus";

        /// <summary>
        /// The target pseudo class.
        /// </summary>
        public static readonly String Target = "target";

        /// <summary>
        /// The enabled pseudo class.
        /// </summary>
        public static readonly String Enabled = "enabled";

        /// <summary>
        /// The disabled pseudo class.
        /// </summary>
        public static readonly String Disabled = "disabled";

        /// <summary>
        /// The checked pseudo class.
        /// </summary>
        public static readonly String Checked = "checked";

        /// <summary>
        /// The unchecked pseudo class.
        /// </summary>
        public static readonly String Unchecked = "unchecked";

        /// <summary>
        /// The indeterminate pseudo class.
        /// </summary>
        public static readonly String Indeterminate = "indeterminate";

        /// <summary>
        /// The placeholder-shown pseudo class.
        /// </summary>
        public static readonly String PlaceholderShown = "placeholder-shown";

        /// <summary>
        /// The default pseudo class.
        /// </summary>
        public static readonly String Default = "default";

        /// <summary>
        /// The valid pseudo class.
        /// </summary>
        public static readonly String Valid = "valid";

        /// <summary>
        /// The invalid pseudo class.
        /// </summary>
        public static readonly String Invalid = "invalid";

        /// <summary>
        /// The required pseudo class.
        /// </summary>
        public static readonly String Required = "required";

        /// <summary>
        /// The in-range pseudo class.
        /// </summary>
        public static readonly String InRange = "in-range";

        /// <summary>
        /// The out-of-range pseudo class.
        /// </summary>
        public static readonly String OutOfRange = "out-of-range";

        /// <summary>
        /// The optional pseudo class.
        /// </summary>
        public static readonly String Optional = "optional";

        /// <summary>
        /// The read-only pseudo class.
        /// </summary>
        public static readonly String ReadOnly = "read-only";

        /// <summary>
        /// The read-write pseudo class.
        /// </summary>
        public static readonly String ReadWrite = "read-write";

        /// <summary>
        /// The shadow pseudo class.
        /// </summary>
        public static readonly String Shadow = "shadow";

        /// <summary>
        /// The dir pseudo function.
        /// </summary>
        public static readonly String Dir = "dir";

        /// <summary>
        /// The has pseudo function.
        /// </summary>
        public static readonly String Has = "has";

        /// <summary>
        /// The matches pseudo function.
        /// </summary>
        public static readonly String Is = "is";

        /// <summary>
        /// The matches pseudo function.
        /// </summary>
        public static readonly String Matches = "matches";

        /// <summary>
        /// The nth-child pseudo function.
        /// </summary>
        public static readonly String NthChild = "nth-child";

        /// <summary>
        /// The nth-last-child pseudo function.
        /// </summary>
        public static readonly String NthLastChild = "nth-last-child";

        /// <summary>
        /// The nth-of-type pseudo function.
        /// </summary>
        public static readonly String NthOfType = "nth-of-type";

        /// <summary>
        /// The nth-last-of-type pseudo function.
        /// </summary>
        public static readonly String NthLastOfType = "nth-last-of-type";

        /// <summary>
        /// The nth-column pseudo function.
        /// </summary>
        public static readonly String NthColumn = "nth-column";

        /// <summary>
        /// The nth-last-column pseudo function.
        /// </summary>
        public static readonly String NthLastColumn = "nth-last-column";

        /// <summary>
        /// The not pseudo function.
        /// </summary>
        public static readonly String Not = "not";

        /// <summary>
        /// The lang pseudo function.
        /// </summary>
        public static readonly String Lang = "lang";

        /// <summary>
        /// The contains pseudo function.
        /// </summary>
        public static readonly String Contains = "contains";

        /// <summary>
        /// The contains pseudo function.
        /// </summary>
        public static readonly String Where = "where";

        /// <summary>
        /// The host-context pseudo function.
        /// </summary>
        public static readonly String HostContext = "host-context";

        /// <summary>
        /// The focus-visible pseudo class.
        /// </summary>
        public static readonly String FocusVisible = "focus-visible";

        /// <summary>
        /// The focus-within pseudo class.
        /// </summary>
        public static readonly String FocusWithin = "focus-within";

        /// <summary>
        /// The separating colon.
        /// </summary>
        public static readonly String Separator = ":";
    }
}
