namespace AngleSharp.Core.Tests.Html
{
    using AngleSharp.Html.Dom;
    using NUnit.Framework;

    /// <summary>
    /// Tests generated according to the W3C-Test.org page:
    /// http://www.w3c-test.org/html/semantics/forms/constraints/form-validation-validity-tooShort.html
    /// </summary>
    [TestFixture]
    public class ValidityTooShortTests
    {
        [Test]
        public void TestTooshortInputText1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "AAAAA";
            element.IsDirty = true;
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputText9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "text";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual("text", element.Type);
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "AAAAA";
            element.IsDirty = true;
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputSearch9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "search";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual("search", element.Type);
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "AAAAA";
            element.IsDirty = true;
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputTel9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "tel";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual("tel", element.Type);
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "AAAAA";
            element.IsDirty = true;
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputUrl9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "url";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual("url", element.Type);
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "AAAAA";
            element.IsDirty = true;
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputEmail9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "email";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual("email", element.Type);
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "AAAAA";
            element.IsDirty = true;
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortInputPassword9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("input") as HtmlInputElement;
            Assert.IsNotNull(element);
            element.Type = "password";
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual("password", element.Type);
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea1()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "");
            element.Value = "abc";
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea2()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "";
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea3()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea4()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea5()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea6()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcde";
            element.IsDirty = true;
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea7()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "\r\n\r\n\r\n";
            element.IsDirty = true;
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea8()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abcd";
            element.IsDirty = true;
            Assert.AreEqual(false, element.Validity.IsTooShort);
        }

        [Test]
        public void TestTooshortTextarea9()
        {
            var document = ("").ToHtmlDocument();
            var element = document.CreateElement("textarea") as HtmlTextAreaElement;
            Assert.IsNotNull(element);
            element.RemoveAttribute("required");
            element.RemoveAttribute("pattern");
            element.RemoveAttribute("step");
            element.RemoveAttribute("max");
            element.RemoveAttribute("min");
            element.RemoveAttribute("maxlength");
            element.RemoveAttribute("value");
            element.RemoveAttribute("multiple");
            element.RemoveAttribute("checked");
            element.RemoveAttribute("selected");
            element.SetAttribute("minLength", "4");
            element.Value = "abc";
            element.IsDirty = true;
            Assert.AreEqual(true, element.Validity.IsTooShort);
        }
    }
}