# AngleSharp Documentation

We have more detailed information regarding the following subjects:

- [Getting Started](general/01-Basics.md)
- [Current Features](general/02-Features.md)
- [Upcoming Features](general/03-Upcoming.md)
- [Performance Comparisons](general/04-Performance.md)
- [API Documentation](tutorials/01-API.md)
- [Parser Options](tutorials/02-Options.md)
- [More Examples](tutorials/03-Examples.md)
- [Form Submission by Example](tutorials/04-Forms.md)
- [Migration Information](tutorials/05-Migration.md)
- [Frequently Asked Questions](tutorials/06-Questions.md)

## Why AngleSharp?

If you need some arguments for using AngleSharp (over similar libraries) then here we go:

- AngleSharp is totally standard-driven
- AngleSharp can also parse related content like CSS, SVG or MathML
- AngleSharp stands all HTML5-lib tests (i.e. it is a valid HTML5 parser)
- AngleSharp handles malformed HTML exactly as every modern browser
- AngleSharp contains brand new elements like support for the `<template>` tag
- AngleSharp performs at least as good as other libraries, mostly better
- AngleSharp provides very useful extension methods for DOM manipulation
- AngleSharp gives you a decoupled API that is easy to use
- AngleSharp is free of dependencies to other libraries
- AngleSharp can be used in cross-platform solutions
- AngleSharp can validate and submit forms
- AngleSharp is very easy to extend and customize

There are tons of other arguments. With the provided configuration abilities, and the given extensibility, AngleSharp can be used in various scenarios.
