/**
 * @Author: Bi Ying
 * @Date:   2022-05-24 13:48:55
 * @Last Modified by:   Bi Ying
 * @Last Modified time: 2024-08-12 12:44:42
 */
export default {
  lang: '中文',
  meta: {
    'title': '向量脉络',
    'description': '基于 AI 的知识库 + 工作流管理系统',
  },
  router: {
    base: '向量脉络',
    basic: {
      children: {
        'index': '首页',
      }
    },
    workspace: {
      children: {
        'workflow_space': '我的工作流空间',
        'data_space': '我的数据空间',
        'workflow_main': '工作流主页',
        'workflow_use': '工作流使用',
        'workflow_template': '工作流模板',
        'database_detail': '数据库详情',
        'database_object_create': '创建对象',
        'database_object_detail': '数据库对象详情',
      }
    },
    account: {
      children: {
        'info': '我的账号信息',
        'settings': '我的账号设置',
      }
    },
    settings: '设置',
  },
  status: {
    'IN': '无效',
    'PR': '处理中',
    'VA': '有效',
    'DE': '已删除',
    'EX': '已过期',
    'INVALID': '无效',
    'EXPIRED': '已过期',
    'DELETING': '删除中',
    'DELETED': '已删除',
    'VALID': '有效',
    'ERROR': '错误',
    'CREATING': '创建中',
    'NOT_STARTED': '未开始',
    'QUEUED': '排队中',
    'RUNNING': '运行中',
    'FINISHED': '已完成',
    'FAILED': '失败',
  },
  common: {
    'vector_vein': '向量脉络',
    'time_length': '{hours}小时{minutes}分钟',
    'refresh': '刷新',
    'index': '首页',
    'update_log': '更新日志',
    'my': '我的',
    'official': '官方',
    'community': '社区',
    'all': '全部',
    'all_tags': '全部标签',
    'add': '添加',
    'edit': '编辑',
    'create': '创建',
    'delete': '删除',
    'status': '状态',
    'tags': '标签',
    'action': '操作',
    'output': '输出',
    'support_inquiries': '问题咨询：',
    'notice': '注意',
    'ok': '好的',
    'save': '保存',
    'pay_channel': '支付方式',
    'credits': '积分',
    'total_price': '总价格',
    'total_credits': '总积分',
    'bonus_credits': '奖励积分',
    'available_credits': '可用积分',
    'pay': '付款',
    'warning': '警告',
    'copy_success': '复制成功',
    'alipay': '支付宝',
    'wechatpay': '微信支付',
    'create_time': '创建时间',
    'update_time': '更新时间',
    'update_time_format': '更新时间: {time}',
    'back': '返回',
    'previous_step': '上一步',
    'next_step': '下一步',
    'title': '标题',
    'description': '描述',
    'content': '内容',
    'save_success': '保存成功',
    'card_view': '卡片视图',
    'table_view': '表格视图',
    'finish': '完成',
    'success': '成功',
    'failed': '失败',
    'cancel': '取消',
    'more_settings': '更多设置',
    'yes': '是',
    'no': '否',
    'duplicate': '复制',
    'vectorvein_user': '向量脉络用户',
    'preview': '预览',
    'close_preview': '关闭预览',
    'reset': '重置',
    'select': '选择',
    'remove': '移除',
    'workflow': '工作流',
    'workflow_template': '工作流模板',
    'chat': '聊天',
    'confirm_leave': '您还未保存，确认离开？',
    'publiced': '已公开',
    'not_publiced': '未公开',
    'shared': '已分享',
    'not_shared': '未分享',
    'share_status_update_success': '分享状态更新成功',
    'share_status_update_failed': '分享状态更新失败',
    'copy_link': '复制链接',
    'load_more': '加载更多',
    'start': '开始',
    'manage': '管理',
    'statistics': '统计数据',
    'enter': '进入',
    'enter_too_fast': '操作过快，请稍后再试',
    'help_document': '帮助文档',
    'finish': '完成',
    'insufficient_quota': '剩余额度不足',
    'skip': '跳过',
    'or': '或',
    'card_view': '卡片视图',
    'table_view': '表格视图',
    'membership': '会员',
    'more_settings': '更多设置',
    'sync': '同步',
    'async': '异步',
    'too_many_requests': '请求过快，请稍后再试',
    'language': '语言',
    'model': '模型',
    'me': '我',
    'TIP': '提示',
    'NOTE': '注意',
    'IMPORTANT': '重要',
    'WARNING': '警告',
    'CAUTION': '小心'
  },
  email: {
    verify: {
      'email_verify_success': '邮箱验证成功！',
      'email_verify_success_subtitle': '您的邮箱验证成功，快来试用一下吧！',
      'check_control_panel': '查看控制台',
      'email_verify_failed': '邮箱验证失败！',
      'email_verify_failed_subtitle': '验证链接有误，请重新检查并刷新',
      'email_verify_expired_subtitle': '链接已超时，请重新发送',
      'resend_email': '重新发送邮件',
      'email_already_verified': '邮箱已验证！',
      'email_already_verified_subtitle': '该链接已验证，请直接登陆',
      'please_verify_your_email': '请验证您的邮箱',
      'please_verify_your_email_subtitle': '为保证您的账号安全，我们需要确认您的邮箱地址：',
      'sending_failed': '发送失败',
      'too_frequently_resend': '您的邮件发送过于频繁，请稍后再试',
      'sending_successfull': '发送成功',
      'please_relogin_after_verify': '验证成功后请重新登录网站',
    }
  },
  userAuth: {
    common: {
      'please_enter': '请输入',
      'username': '用户名',
      'email': 'Email电子邮箱',
      'mobile': '手机',
      'verification_code': '验证码',
      'send_verification_code': '发送验证码',
      'password': '密码',
      'login': '登录',
      'logout': '登出',
      'or': '或',
      'register': '注册新账号',
      'sign_up': '注册新账号',
      'error': '服务器错误',
    },
    login: {
      'please_enter_username': '请输入手机号或用户名',
      'please_enter_email': '请输入邮箱',
      'please_enter_password': '请输入密码',
      'remember_account': '记住账号',
      'forget_password': '忘记密码',
      'account_not_exists_title': '密码错误或账号不存在',
      'account_not_exists_content': '请检查账号密码是否正确或注册新账号',
      'mobileLogin': '手机号登录',
      'wechatLogin': '微信登录',
      'email_login': '邮箱登录',
    },
    register: {
      'region_search_or_select': '请搜索或选择您的区域',
      'please_select_your_region': '请选择您的区域',
      'human_verification_error': '人机验证失败！',
      'connection_error': '连接错误！',
      'email_already_exists': '该邮箱已注册，请直接登录',
      'username_already_exists': '该用户名已被使用',
      'register_success': '注册成功，请验证邮件',
    },
    registerResult: {
      'check_email': '查看邮箱',
      'back_to_login': '返回登录',
      'verification_email_sent': '激活邮件已发送到你的邮箱中，邮件有效期为24小时。请及时登录邮箱，点击邮件中的链接激活帐户。',
      'your_email_account_register_success': '你的账户：{email} 注册成功',
    },
    forgetPassword: {
      'verify_email': '验证邮箱',
      'enter_new_password': '输入新密码',
      'verify': '验证',
      'verification_code_send_success': '验证码已发送',
      'human_verification_error': '人机验证失败！',
      'connection_error': '连接错误！',
      'email_not_exists': '该邮箱未注册',
      'reset_password': '重置密码',
      'reset_success': '重置密码成功',
    }
  },
  userAccount: {
    accountInfo: {
      'my_account': '我的账号',
      'my_credits': '我的积分',
    },
    accountSettings: {
      'account_email': '账号邮箱',
      'account_settings': '账号设置',
    }
  },
  workspace: {
    chatSpace: {
      'fetch_conversations_failed': '获取会话列表失败',
      'fetch_conversation_failed': '获取会话失败',
      'textarea_tip': 'Ctrl + Enter 发送',
      'send_message': '发送消息',
      'send': '发送',
      'send_message_failed': '发送消息失败',
      'new_chat': '新的聊天',
      'how_can_i_help_you_today': '有什么可以帮您的吗？',
      'share_chat': '分享聊天',
      'delete_chat': '删除聊天',
      'delete_chat_confirm_title': '确认删除？',
      'delete_chat_confirm_content': '将会删除 {title}',
      'delete_chat_failed': '删除聊天失败',
      'delete_chat_success': '删除聊天成功',
      'today': '今天',
      'yesterday': '昨天',
      'last30Days': '最近30天',
      'earlier': '更早',
      'settings': '设置',
      'workflows': '工作流',
      'selected_workflows': '已选择工作流',
      'update_workflows_success': '更新工作流选择成功',
      'update_workflows_failed': '更新工作流选择失败',
      'update_settings_success': '更新设置成功',
      'update_settings_failed': '更新设置失败',
      'agent_settings': 'Agent 设置',
      'system_prompt': '系统提示词',
      'system_prompt_description': '您可以使用系统提示词来描述助手的个性，定义模型应该和不应该回答什么，并定义模型响应的格式。',
      'auto_run_workflow': '自动运行工作流',
      'auto_run_workflow_description': '当 AI 判断需要运行工作流来完成任务时，自动运行工作流并返回结果。',
      'use_workflow': '调用工作流',
      'run_workflow': '运行工作流',
      'workflow_running': '工作流运行中',
      'open_workflow_record_page': '打开工作流运行记录页面',
      'cant_open_template_record': '无法打开工作流模板运行记录页面',
      'global_settings': '全局设置',
      'ai_agent': 'AI Agent',
      'generating_params': '正在生成工作流调用参数',
      'share_chat_description': '创建链接后发送的消息不会被分享。任何拥有链接的人都可以查看分享的聊天。聊天中涉及的工作流运行记录会被设置为已分享的状态。',
      'hide_nickname': '隐藏昵称',
      'show_nickname': '显示昵称',
      'message_changed_after_last_share': '聊天消息在上次分享后有新增，关闭并重新打开分享将更新。',
      'upload_attachments': '上传附件',
      'input_too_large': '输入内容过长，请缩短后再试。',
      'model_select': 'AI 模型选择',
      'model_select_success': 'AI 模型选择已更新',
      'share_to_community': '分享到社区',
      'not_share_to_community': '未分享到社区',
      'share_to_community_brief': '分享到社区后，其他用户可以在分享列表中看到该聊天记录。否则仅可通过分享链接访问。',
      'workflow_title_clickable': '单击标题可展开工作流运行记录详情',
      'model': '模型',
      'model_unit_price': '单价(输入/输出)',
      'unit_1000_tokens': '单位: 1000 Tokens',
      'prompt_unit_credits': '输入: {credits} 积分 / 1000 Tokens',
      'completion_unit_credits': '输出: {credits} 积分 / 1000 Tokens',
      'local_model': '本地模型',
      'recording': '录音',
      'stop_recording': '停止录音',
      'recording_start': '录音开始',
      'recording_failed': '录音失败',
      'transcribe_failed': '语音识别失败',
      'agent_audio_reply': 'Agent 语音回复',
      'agent_audio_reply_description': 'Agent 生成回复后用语音播放',
      'agent_audio_voice': 'Agent 声音',
      'native_multimodal': '原生多模态',
      'native_multimodal_description': '如果模型支持，则优先使用模型的多模态输入，此时上传的图片会被直接传递给模型。',
      'drop_to_upload': '放到此处上传附件',
      'no_selected_workflows': '未选择工作流',
    },
    agentSpace: {
      'my_agents': '我的 AI Agent',
      'public_agents': '公开 AI Agent',
      'shared_chats': 'Agent 对话分享',
      'input_search_text': '搜索',
      'create_agent': '创建 Agent',
      'no_agents_1': '您还没有创建任何 AI Agent',
      'no_agents_2': '可以查看官方 AI Agent 或者创建一个新的 AI Agent',
      'agent_name': 'Agent 名称',
      'agent_name_placeholder': '请输入 Agent 名称',
      'agent_name_required': 'Agent 名称不能为空',
      'agent_description': 'Agent 介绍',
      'agent_description_placeholder': '请输入该 Agent 的功能介绍。',
      'delete_agent_confirm_title': '确认删除？',
      'delete_agent_confirm_content': '将会删除 {name}，且聊天记录会被同步删除。',
      'create_agent_success': '创建 Agent 成功',
      'delete_agent_success': '删除 Agent 成功',
      'duplicate_as_mine': '复制到我的 Agent',
      'duplicate_agent_success': '复制 Agent 成功',
      'add_templates': '同步添加工作流模板',
      'add_templates_to_your_workflows': '是否同步将该 Agent 中的工作流模板添加为您的个人工作流。添加后可回看工作流运行记录，方便查看。若不添加则该 Agent 不会关联任何工作流，需要您手动处理。',
      'modify_agent': '修改 Agent',
      'system_prompt': '系统提示词',
      'system_prompt_tip': '系统提示是用于引导 AI 行为的特殊消息，可以允许开发人员在一定范围内规定人工智能的风格和任务，使其更加可定制和适应各种用例。',
      'opening_dialog': '开场白',
      'opening_question_suggestions': '建议问题',
      'opening_question_suggestions_tip': '给出几个可选的开场问题，让用户可以快速开始对话。',
      'workflow_selection': '工作流选择',
      'selected_workflows': '已选择工作流',
      'remove_workflow': '移除工作流',
      'chat_with_agent': '与 Agent 聊天',
      'toggle_agent_shared_true': '分享 Agent',
      'toggle_agent_shared_true_content': '分享后其他用户可以通过链接使用该 Agent。',
      'toggle_agent_shared_false': '取消分享 Agent',
      'toggle_agent_shared_false_content': '取消分享后其他用户将无法通过链接使用该 Agent。',
      'toggle_agent_is_public_true': '公开 Agent',
      'toggle_agent_is_public_true_content': '公开后其他用户可以在社区公开页面发现该 Agent。',
      'toggle_agent_is_public_false': '取消公开 Agent',
      'toggle_agent_is_public_false_content': '取消公开后其他用户将无法在社区公开页面发现该 Agent。',
      'workflow_become_template_warning': '您的个人工作流将会自动转换为工作流模板以方便其他用户使用。',
      'database_access_control_warning': '如果您的 Agent 使用的工作流中涉及到知识库搜索，请注意确认数据库的权限。如果数据库为私有权限，则转换为工作流模板后用户需要自行创建数据库。如果您希望用户直接使用您已创建号的数据库，注意将数据库权限改为公开可读。',
      'workflows_converted_to_templates': '工作流已转换为模板',
      'copy_agent_share_link': '复制分享链接',
      'model_select': 'AI 模型选择',
      'model_select_tip': '您可以根据需要选择不同的 AI 模型作为默认模型。聊天对话时可手动更改模型。',
      'cant_open_template_record': '无法打开工作流模板运行记录页面',
      'not_shared_agent': '未分享的 Agent',
    },
    workflowSpace: {
      'workflow_index': '工作流首页',
      'user_fast_access_workflows': '快速访问工作流',
      'add_new_workflow': '新建工作流',
      'new_workflow': '新工作流',
      'share_workflow': '分享',
      'clone_workflow': '克隆',
      'clone_success': '克隆成功',
      'clone_failed': '克隆失败',
      'add_to_fast_access': '添加到快速访问',
      'add_to_fast_access_confirm': '确认添加该工作流到快速访问？',
      'delete_from_fast_access': '从快速访问删除',
      'delete_from_fast_access_confirm': '确认从快速访问删除该工作流？',
      'add_to_fast_access_success': '添加到快速访问成功',
      'add_to_fast_access_failed': '添加到快速访问失败',
      'delete_from_fast_access_success': '从快速访问删除成功',
      'delete_from_fast_access_failed': '从快速访问删除失败',
      'update_time': '更新时间: {time}',
      'inputs': '输入',
      'outputs': '输出',
      'triggers': '触发器',
      'run': '运行',
      'edit': '编辑',
      'delete': '删除',
      'delete_confirm': '确认删除该工作流？',
      'delete_success': '删除成功',
      'delete_failed': '删除失败',
      'save_success': '保存成功',
      'save_failed': '保存失败',
      'workflow_cant_invoke_itself': '工作流不能调用自身',
      'get_workflow_failed': '获取工作流失败',
      'get_workflow_record_failed': '获取工作流运行记录失败',
      'submit_workflow_success': '已提交工作流运行请求',
      'submit_workflow_failed': '提交工作流运行请求失败',
      'run_workflow_success': '运行工作流成功',
      'run_workflow_failed': '运行工作流失败',
      'update_schedule_success': '更新定时设置成功',
      'update_schedule_failed': '更新定时设置失败',
      'delete_schedule_trigger_confirm': '确认删除该定时设置？',
      'delete_schedule_success': '删除定时设置成功',
      'delete_schedule_failed': '删除定时设置失败',
      'brief': '简介',
      'field_is_empty': '{field} 不能为空',
      'record_status': '工作流运行记录状态: {status}',
      'record_error_task': '出错任务: {task}',
      'maximize_output': '最大化输出区域',
      'normalize_output': '恢复输出区域尺寸',
      'related_workflows': '相关工作流',
      'diagnosis_workflow_record': '诊断工作流运行记录',
      'diagnosis_workflow_record_tip': '你现在可以针对具体某一条工作流记录进行诊断，查看各个节点的运行情况、运行时间等信息。',
      'more_actions': '更多操作',
      'api_key_is_empty': '模型 {model} 的 API Key 未设置！',
      'version_tip': '工作流版本',
      'run_workflow_version_inconsistent': '工作流版本不一致',
      'run_workflow_version_inconsistent_tip1': '当前工作流版本与运行记录版本不一致，请选择以下任意一种方式继续运行',
      'run_workflow_version_inconsistent_tip2': '如果选择运行记录当时的版本，则会以运行记录对应的工作流结构来运行，而非当前最新的工作流结构。如果采用当前最新版本的工作流结构，由于字段可能有差异，不一定可以自动填充并运行成功。',
      'run_record_version': '运行记录版本',
      'run_latest_version': '运行最新版本',
      'record_version': '工作流运行记录对应工作流版本',
    },
    workflowEditor: {
      'exit_not_saved_confirm': '工作流尚未保存，确认退出？',
      'save_and_exit': '保存并退出',
      'exit_without_save': '不保存退出',
      'test_run': '测试',
      'workflow_info': '基本信息',
      'workflow_canvas': '工作流画布',
      'workflow_ui_design': '界面设计',
      'tags': '标签',
      'brief_info': '简介信息',
      'brief_images': '简介图片',
      'edit_code': '编辑代码',
      'workflow_check_warning': '工作流检查警告',
      'workflow_has_no_inputs': '工作流没有输入（请勾选需要显示在使用界面的字段）',
      'workflow_has_no_outputs': '工作流没有输出（请从输出里面拖拽一个节点到画布上并连接）',
      'workflow_has_no_triggers': '工作流没有触发器（请从触发器里面拖拽一个节点到画布上并连接）',
      'workflow_has_cycles': '工作流连线存在环路，请确保各个节点的连接不会形成一个环',
      'workflow_has_isolated_nodes': '工作流中存在孤立节点，请确保除了触发器节点以外各个节点都与其他节点连接',
      'edge_delete_message': '按下键盘的退格键（Backspace）或者双击连线即可删除',
      'edge_already_connected_message': '该端口已有连线',
      'diagnosing_record': '正在诊断记录 {record}',
      'cannot_save_when_diagnosing': '诊断记录时无法保存',
      'layout_graph': '自动布局',
      'resume_node_but_edge_already_connected_message': '连线另一端有其他连线，请先删除其他连线或忽略对应连线的节点。',
    },
    workflowSpaceMain: {
      'my_workflows': '我的工作流',
      'workflow_title': '工作流',
      'tags': '标签',
      'tags_filter': '标签筛选',
      'update_time': '更新时间',
      'create_workflow': '创建工作流',
      'official_workflow_template': '官方工作流模板',
      'community_workflow_template': '社区分享工作流模板',
      'input_search_text': '输入待搜索的标题、简介等信息',
      'reset_search': '重置搜索',
      'no_workflows_1': '你还没有添加或创建工作流',
      'no_workflows_2': '到这里添加一个工作流看看吧',
    },
    workflowTemplate: {
      'template': '模板',
      'add_to_my_workflows': '添加到我的工作流',
      'add_success': '添加成功',
      'add_failed': '添加失败',
      'author': '作者: {author}',
      'used_count': '{count} 人已使用',
      'workflow_template_tags': '工作流模板标签',
      'edit_template': '编辑模板',
      'update_success': '更新成功',
      'update_failed': '更新失败',
      'test_run_template': '测试运行模板',
      'test_run_template_hint1': '建议您添加到自己的工作流后再运行，方便保存记录以及进行自定义修改。',
    },
    dataSpace: {
      'create': '新建',
      'create_success': '创建成功',
      'create_failed': '创建失败',
      'database_name': '数据库名称',
      'status_invalid': '无效',
      'status_expired': '已过期',
      'status_deleted': '已删除',
      'status_valid': '有效',
      'status_error': '错误',
      'status_creating': '创建中',
      'status_deleting': '删除中',
      'delete': '删除',
      'delete_confirm': '确认删除该数据库？删除后不可恢复！',
      'delete_success': '删除成功',
      'delete_failed': '删除失败',
      'vector_database': '向量数据库',
      'vector_database_description': '向量数据库是一种基于向量检索的数据库，可以用于存储和检索文本、图片、音频、视频等数据。',
      'relational_database': '关系型数据库',
      'relational_database_description': '关系型数据库是一种基于关系模型的数据库，可以用于存储和检索结构化数据。',
      'embedding_provider': '嵌入模型提供商',
      'embedding_provider_azure_tip': '如果设置中的 OpenAI 类型是 Azure，则以设置中的 Azure Embedding 部署名为准。',
      'embedding_provider_text_embeddings_inference_tip': 'text-embeddings-inference 需要自行部署，具体查看',
      'embedding_models': '嵌入模型',
      'embedding_size': '嵌入维度',
    },
    databaseDetail: {
      'add_object': '添加数据',
      'object_title': '数据名称',
      'object_source_url': '来源链接',
      'object_type': '数据类型',
      'add_method': '添加方式',
      'add_method_url': '从链接抓取',
      'add_method_files': '上传文件',
      'add_method_text': '输入文本',
      'crawl_data_from_url': '从链接爬取数据',
      'use_oversea_crawler': '使用海外爬虫节点',
      'object_content': '数据内容',
      'content_empty': '内容为空！',
      'create_success': '添加成功',
      'create_failed': '添加失败',
      'delete_success': '删除成功',
      'delete_failed': '删除失败',
      'check_detail_data': '查看详细数据',
      'source_url': '来源链接',
      'data_type': '数据类型',
      'data_type_TEXT': '文本',
      'data_type_IMAGE': '图片',
      'data_type_AUDIO': '音频',
      'data_type_VIDEO': '视频',
      'data_type_OTHER': '其他',
      'delete_confirm': '确认删除该数据？',
      'delete': '删除',
      'modify_database_info': '修改数据库信息',
      'table': '表格',
      'table_name': '表格名称',
      'table_status': '表格状态',
      'table_current_rows': '当前数据量',
      'run_sql': '运行 SQL',
      'please_enter_sql': '请输入符合 SQLite 语法的 SQL 语句',
      'failed_to_load_database': '加载数据库失败，可能数据库过大或文件已损坏',
      'sql_success': 'SQL 运行成功',
      'affected_rows': '影响行数 {rows}',
      'max_show_rows': '页面上最多显示 1000 条数据',
      'force_refresh_database': '强制刷新数据库',
      'result_n': '执行结果 {n}',
      'affected_rows': '影响行数 {rows}',
    },
    databaseObjectCreate: {
      'add_object': '添加数据',
      'add_method': '添加方式',
      'add_method_url': '从链接抓取',
      'add_method_files': '上传文件',
      'add_method_text': '输入文本',
      'split_method': '分割方式',
      'split_method_general': '通用分割',
      'split_method_delimeter': '分隔符分割',
      'split_method_markdown': 'Markdown 分割',
      'split_method_table': '表格分割',
      'chunk_length': '分段长度',
      'remove_url_and_email': '移除链接和邮箱',
      'use_oversea_crawler': '使用海外爬虫节点',
      'object_source_url': '来源链接',
      'object_files': '文件',
      'object_title': '数据名称',
      'object_content': '数据内容',
      'process_rules': '处理规则',
      'delimiter': '分隔符',
      'finish': '完成',
      'content_empty': '内容为空！',
      'create_success': '添加成功',
      'create_failed': '添加失败',
      question: {
        'chunk_length': {
          '1': '分段长度表示将文本按照多长进行分段，比如 1000 表示每 1000 个字符分成一段。',
          '2': '向量数据库在进行搜索时会找到最相关的段落返回回来。',
          '3': '注意这里的分段长度不是严格遵守的，而是大致接近。',
        },
      },
    },
    databaseObjectDetail: {
      'source_url': '来源链接',
      'segments': '分段内容',
      'full_document': '完整文档',
      'params_info': '参数信息',
      'segment_index': '分段索引',
      'segment_text': '文本',
      'segment_keywords': '关键词',
      'segment_tokens': 'Token 数',
      'segment_word_counts': '字符数',
      'paragraph_counts': '段落数',
      'word_counts': '字符数',
      'modify_object_info': '修改信息',
      'object_title': '文档名称',
    },
    databaseTableCreate: {
      'add_table': '添加表格',
      'add_method': '添加方式',
      'add_method_table_file': '上传文件',
      'add_method_manual': '手动创建',
      'add_method_sql': 'SQL 语句创建',
      'table_name': '表格名称',
      'sql_statement': 'SQL 语句',
      'sql_statement_too_long': 'SQL 语句过长，请使用文件上传方式上传 SQL 文件。',
      'table_schema': '表格结构',
      'get_table_schema': '读取表格结构',
      'column_name': '列名',
      'column_type': '列类型',
      'max_length': '最大长度',
      'type_INTEGER': '整数',
      'type_REAL': '小数',
      'type_TEXT': '长文本',
      'type_VARCHAR': '短文本',
      'type_BOOLEAN': '布尔值',
      'type_DATETIME': '日期时间',
      'add_column': '添加一列',
      'sql_statement_empty': 'SQL 语句不能为空',
      'table_name_empty': '表格名称不能为空',
      'table_schema_empty': '表格结构不能为空',
      'uploaded_files': '已上传文件',
      'table_name_already_exists': '表格名称已存在',
      'not_enough_quota': '表格数量超出额度',
      'upload_file_alert_title': '注意数据文件格式',
      'upload_file_alert_description': '为了更准确地处理数据，请您确保表格第一行是表头，第二行开始每一行都是一条数据，且表格内无合并单元格。',
      'no_space_in_column_name': '列名中不能包含空格',
    },
    databaseTableRecord: {
      'sheet': '表格',
      'load_data': '加载数据',
      'delete_records_confirm': '确认删除选中的记录？',
      'add_record': '添加记录',
      'current_rows_max_rows': '当前数据量 / 最大数据量',
      'force_refresh_table': '强制刷新表格',
    },
  },
  components: {
    layout: {
      basicHeader: {
        'agent': 'Agent',
        'workflow_space': '工作流',
        'data_space': '数据集',
        'opensource_code': '开源代码',
        'setting': '设置',
        'pin_window': '窗口始终置顶',
        'unpin_window': '取消窗口置顶',
        'theme_dark': '深色主题',
      },
      helpDropdown: {
        'help': '帮助',
        'about': '关于',
        'documentation': '文档',
        'software_update': '软件更新',
        'check_update': '检查更新',
        'update_available': '有新版本可用',
        'new_version': '新版本 {version} {releaseDatetime}',
        'about_vectorvein': '关于向量脉络',
        'about_vectorvein_description': '### 利用 AI 的力量构建您的自动化工作流程\n#### 无需编程，只需拖拽即可创建强大的工作流，自动化所有任务。\n\n向量脉络（VectorVein）开源版由 Maker毕 开发，可用于个人使用，不可用于商业使用。',
        'view_logs': '查看日志',
      },
    },
    markdownEditor: {
      'raw_text': '无格式文本',
      'markdown_text': 'Markdown 文本',
    },
    workspace: {
      workflowEditor: {
        'add_node': '添加节点',
        'add_tag': '添加标签',
        'brief_editor': '描述编辑器',
        'brief_images': '图片',
      },
      myWorkflows: {
        'input_search_text': '输入待搜索的标题、简介等信息',
        'reset_search': '重置搜索',
        'no_workflows_1': '你还没有添加或创建工作流',
        'no_workflows_2': '到这里添加一个工作流看看吧',
      },
      relatedWorkflowsModal: {
        'title': '被间接调用的相关工作流',
      },
      uiDesign: {
        'typography-paragraph': {
          'title': '文字内容',
          'placeholder': '支持 Markdown 语法，在使用界面中会被直接渲染',
          'tip': '可用于在使用界面中放置提示性信息',
        }
      },
      uploaderFieldUse: {
        'upload': '选择文件',
        'upload_success': '已选择 {file}',
        'upload_failed': '选择 {file} 失败',
        'uploader_text': '点击或拖拽文件到此区域上传',
        'uploader_hint': '目前支持的文件类型：{fileTypes}',
      },
      mindmapRenderer: {
        'download_svg': '下载 SVG 文件',
        'download_xmind': '下载 XMind 文件',
      },
      echartsRenderer: {
        'download_image': '下载图片',
      },
      newWorkflowModal: {
        'create_new_workflow': '创建新工作流',
        'empty_workflow': '新建空工作流',
      },
      tagInput: {
        'select_tags': '选择标签',
      },
      workflowRunRecordsDrawer: {
        'workflows_run_records': '运行记录',
        'my_workflows_run_records': '我的工作流运行记录',
        'start_time': '开始时间',
        'end_time': '结束时间',
        'run_time': '运行时长',
        'used_credits': '消耗积分',
        'status': '状态',
        'status_not_started': '未开始',
        'status_queued': '排队中',
        'status_running': '运行中',
        'status_finished': '已完成',
        'status_failed': '运行失败',
        'status_stopping': '停止中',
        'status_stopped': '已停止',
        'check_record': '查看记录',
        'check_record_and_error_task': '查看记录及错误任务',
        'workflow_title': '工作流标题',
        'version': '版本',
      },
      vueFlowStyleSettings: {
        'title': '风格设置',
        'edge_type': '连线类型',
        'edge_type_bezier': '贝塞尔曲线',
        'edge_type_step': '直角台阶',
        'edge_type_smoothstep': '圆角台阶',
        'edge_type_straight': '直线',
        'edge_animated': '连线动画',
      },
      agentInvokeDataEdit: {
        'agent_invoke': 'Agent 调用',
        'tool_name': '工具名称',
        'tool_name_tip': '可理解为该工作流的函数名，只能是数字、字母、下划线、短横线，不超过64字。',
        'tool_name_required': '工具名称不能为空',
        'tool_name_placeholder': '请输入工具名称，只能是数字、字母、下划线、短横线。',
        'tool_name_error': '工具名称只能是数字、字母、下划线、短横线，不超过64字',
        'tool_description': '工具描述',
        'tool_description_tip': '用于让 AI 识别该工具的作用。应该尽可能清晰、简洁地描述该工具的作用，特别是输入及输出。',
        'tool_description_placeholder': '请输入工具描述，用于让 AI 识别该工具的作用。',
        'parameters': '参数',
        'parameter_name': '参数名称',
        'parameter_description': '参数描述',
        'parameter_required': '参数必填',
      },
      avatarUpload: {
        'uploader_text': '上传头像',
      },
      tagManage: {
        'title': '标签管理',
        'color': '颜色',
        'delete_tag_confirm': '确认删除该标签？',
      },
    },
    codeEditorModal: {
      'title': '代码编辑器',
      'please_enter_code': '请输入代码，函数名固定为 main，输入参数与设定名称请一致。',
      'copy_code': '复制代码',
      'copy_success': '复制成功',
    },
    templateEditorModal: {
      'title': '模板编辑器',
      'variable_fields': '变量字段',
      'template': '模板',
      'drag_to_insert': '单击或拖拽插入',
      'format_fields': '格式化字段',
      'format_fields_tip': '快速用 XML 标签将变量字段格式化填入模板',
    },
    nodes: {
      common: {
        'input': '输入',
        'output': '输出',
      },
      baseNode: {
        'document_link': '文档链接',
        'clone_node': '克隆节点',
        'ignore_node': '忽略节点',
        'ignore_node_tip': '忽略节点后，该节点会保留在画布上，但不会对工作流运行产生任何影响。',
        'remove_ignore': '移除忽略，恢复节点',
        'delete_node': '删除节点',
        'run_time': '运行时间 {time}s',
        'no_run_record': '无运行记录',
        'view_node_help_document': '快速查看节点帮助文档',
      },
      baseField: {
        'show_in_use_interface': '是否在使用界面显示',
        'show': '显示',
        'hide': '隐藏',
        'show_field_info': '查看字段信息',
        'field_info': '字段信息',
        'data_type': '数据类型',
        'field_value': '字段值',
      },
      listField: {
        'add_item': '添加项',
      },
      assistedNodes: {
        'title': '辅助节点',
        CommentNode: {
          'title': '注释节点',
          'description': '用于添加注释，不会对工作流运行产生任何影响。',
          'comment': '注释',
        },
      },
      fileProcessing: {
        'title': '文件处理',
        FileLoader: {
          'title': '读取文件',
          'description': '读取文件内容。',
          'files': '文件',
          'remove_image': '移除图片',
          'remove_url_and_email': '移除链接和邮箱',
          'output': '输出',
        },
        FileUpload: {
          'title': '选择文件',
          'description': '选择本地文件并获取文件路径。',
          'files': '文件',
          'output': '文件路径',
        },
      },
      textProcessing: {
        title: '文本处理',
        TemplateCompose: {
          'title': '文本合成',
          'description': '将多个变量合成为一段文字。',
          'template': '模板',
          'output': '输出',
          'add_field': '添加变量',
          'add_field_type': '输入类型',
          'field_type_input': '单行输入框',
          'field_type_textarea': '多行输入框',
          'field_type_select': '列表选择输入',
          'add_field_display_name': '显示名称',
          'add_field_list_options': '列表选项',
          'click_to_add_to_template': '点击可将变量添加到模板',
          'open_template_editor': '打开模板编辑器',
          'edit_field': '编辑变量',
          'name_reserved': 'template/output 是保留关键字，不能作为变量名。',
        },
        MarkdownToHtml: {
          'title': 'MD 转 HTML',
          'description': '将 Markdown 格式的文本转换为 HTML 格式。',
          'markdown': 'Markdown',
          'html': 'HTML',
        },
        TextSplitters: {
          'title': '文本分割',
          'description': '将文本按照指定的方法分割成多个文本。',
          'text': '文本',
          'split_method': '分割方法',
          'split_method_general': '通用分割',
          'split_method_delimiter': '分隔符分割',
          'split_method_markdown': 'Markdown 分割',
          'delimiter': '分隔符',
          'chunk_length': '分割长度',
          'chunk_overlap': '分割重叠',
          'output': '输出',
        },
        ListRender: {
          'title': '列表渲染',
          'description': '将列表渲染成文本。',
          'list': '列表',
          'add_item': '添加项',
          'separator': '合并项分隔符',
          'output_type': '输出端口格式',
          'output_type_text': '文本',
          'output_type_list': '列表',
          'output': '输出',
        },
        TextInOut: {
          'title': '简易输入',
          'description': '将输入的文本原样输出。用于多个地方需要同样的文本时。',
          'text': '文本',
          'input_type': '输入类型',
          'input_type_text': '文本',
          'input_type_number': '数字',
          'edit_name': '编辑显示名',
          'output': '输出',
        },
        TextTruncation: {
          'title': '文本截断',
          'description': '将文本截取为指定长度。',
          'text': '文本',
          'truncate_method': '截取方法',
          'truncate_method_general': '通用截取',
          'truncate_method_markdown': 'Markdown 截取',
          'truncate_length': '截取长度',
          'floating_range': '浮动范围',
          'output': '输出',
        },
      },
      llms: {
        title: 'AI模型',
        common: {
          'use_function_call': '使用函数调用',
          'functions': '函数',
          'function_call_mode': '函数调用方式',
          'add_function': '添加函数',
          'function_name': '函数名称',
          'function_description': '函数描述',
          'function_parameters': '函数参数',
          'function_required_parameters': '必填参数',
          'add_parameter': '添加参数',
          'parameter_name': '参数名称',
          'parameter_description': '参数描述',
          'parameter_type': '参数类型',
          'response_format': '响应格式',
          'array_configuration_mode': '数组配置方式',
          'array_configuration_mode_simple': '简单配置',
          'array_configuration_mode_manual': '手动编写',
          'array_items_type': '数组项类型',
          'array_items_manual_schema': '数组项 JSON 格式',
          'array_items_manual_schema_error': '数组项 JSON 格式错误',
          'object_items_manual_schema': '对象 JSON 格式',
          'object_items_manual_schema_error': '对象 JSON 格式错误',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
          'function_call_output': '函数调用完整输出',
          'function_call_arguments': '函数调用参数值',
        },
        OpenAI: {
          'title': 'OpenAI',
          'description': 'OpenAI 的 GPT 模型是一种强大的自然语言处理AI，能理解和生成人类语言。',
          'use_function_call': '使用函数调用',
          'functions': '函数',
          'function_call_mode': '函数调用方式',
          'add_function': '添加函数',
          'function_name': '函数名称',
          'function_description': '函数描述',
          'function_parameters': '函数参数',
          'function_required_parameters': '必填参数',
          'add_parameter': '添加参数',
          'parameter_name': '参数名称',
          'parameter_description': '参数描述',
          'parameter_type': '参数类型',
          'response_format': '响应格式',
          'response_format_text': '文本',
          'response_format_json_object': 'JSON 对象',
          'array_configuration_mode': '数组配置方式',
          'array_configuration_mode_simple': '简单配置',
          'array_configuration_mode_manual': '手动编写',
          'array_items_type': '数组项类型',
          'array_items_manual_schema': '数组项 JSON 格式',
          'array_items_manual_schema_error': '数组项 JSON 格式错误',
          'object_items_manual_schema': '对象 JSON 格式',
          'object_items_manual_schema_error': '对象 JSON 格式错误',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
          'function_call_output': '函数调用完整输出',
          'function_call_arguments': '函数调用参数值',
        },
        ChatGLM: {
          'title': 'ChatGLM',
          'description': 'ChatGLM 系列模型，通过注入代码预训练，有监督微调等技术对齐人类意图，具备问答、多轮对话、代码生成等能力。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        MiniMax: {
          'title': 'MiniMax',
          'description': '基于 MiniMax 端到端自研多模态大语言模型。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        BaiduWenxin: {
          'title': '百度文心',
          'description': '百度全新一代知识增强大语言模型，文心大模型家族的新成员，能够与人对话互动，回答问题，协助创作。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        AliyunQwen: {
          'title': '通义千问',
          'description': '通义千问（Qianwen）是阿里巴巴达摩院推出的超大规模预训练模型。该模型基于Transformer Decoder-only结构，由大规模全球互联网数据训练而成。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Baichuan: {
          'title': '百川大模型',
          'description': 'Baichuan2-53B大模型，融合了意图理解、信息检索以及强化学习技术，在知识问答、文本创作领域表现突出。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Claude: {
          'title': 'Claude',
          'description': 'Claude是Antropic开发的大型语言模型,被训练来给出有益且无害的回复。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Gemini: {
          'title': 'Gemini',
          'description': 'Gemini 是 Google 最新的大型语言模型系列。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Moonshot: {
          'title': 'Moonshot',
          'description': 'Moonshot 是 “月之暗面” 公司的千亿参数级大模型。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        LingYiWanWu: {
          'title': 'Yi',
          'description': '零一万物大模型',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Stepfun: {
          'title': 'Stepfun',
          'description': '阶跃星辰大模型',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Deepseek: {
          'title': 'Deepseek',
          'description': 'Deepseek',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        Groq: {
          'title': 'Groq',
          'description': 'Groq 是一家提供快速 AI 推理的 AI 基础设施公司。',
          'prompt': '输入内容（Prompt）',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
        LocalLlm: {
          'title': '本地大语言模型',
          'description': '用户自行定义的大语言模型接口',
          'prompt': '输入内容（Prompt）',
          'model_family': '模型系列',
          'llm_model': '模型',
          'temperature': 'AI 偏好（温度）',
          'creative': '创意',
          'balanced': '平衡',
          'precise': '精准',
          'output': '输出',
        },
      },
      imageGeneration: {
        title: '图像生成',
        StableDiffusion: {
          'title': 'Stable Diffusion',
          'description': 'Stable Diffusion 是2022年发布的深度学习文本到图像生成模型。',
          'provider': '提供方',
          'provider_self-host': '自行部署',
          'provider_stable-diffusion-official': 'Stable Diffusion 官方',
          'prompt': '提示词',
          'negative_prompt': '负面提示词',
          'model': '模型',
          'cfg_scale': '提示遵循强度',
          'sampler': '采样器',
          'width': '宽度',
          'height': '高度',
          'size': '尺寸',
          'aspect_ratio': '宽高比',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅路径',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
        DallE: {
          'title': 'DALL·E',
          'description': 'OpenAI 最强大的图像生成模型。可根据用户最近的提示词生成具有复杂细节的高质量图像。',
          'prompt': '提示词',
          'model': '模型',
          'size': '尺寸',
          'quality': '品质',
          'style': '风格',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
      },
      mediaEditing: {
        title: '多媒体编辑',
        ImageEditing: {
          'title': '图片编辑',
          'description': '用于对图片进行基本的编辑如裁剪、缩放、旋转等。',
          'input_image': '输入图像',
          'crop': '裁剪',
          'group_crop': '裁剪设置',
          'crop_method': '裁剪方法',
          'crop_method_proportional': '按比例裁剪',
          'crop_method_fixed': '固定尺寸裁剪',
          'crop_width_ratio': '裁剪宽度比例',
          'crop_height_ratio': '裁剪高度比例',
          'crop_position': '裁剪位置',
          'crop_position_center': '居中',
          'crop_position_top_left': '左上',
          'crop_position_top': '顶部',
          'crop_position_top_right': '右上',
          'crop_position_right': '右侧',
          'crop_position_bottom_right': '右下',
          'crop_position_bottom': '底部',
          'crop_position_bottom_left': '左下',
          'crop_position_left': '左侧',
          'crop_position_absolute': '绝对位置',
          'crop_x': '裁剪起点横坐标',
          'crop_y': '裁剪起点纵坐标',
          'crop_width': '裁剪宽度',
          'crop_width_tip': '裁剪宽度如果为 0 则按宽度为原图宽度',
          'crop_height': '裁剪高度',
          'crop_height_tip': '裁剪高度如果为 0 则按高度为原图高度',
          'scale': '缩放',
          'group_scale': '缩放设置',
          'scale_method': '缩放方法',
          'scale_method_proportional_scale': '等比例缩放',
          'scale_method_fixed_width_height': '固定宽高缩放',
          'scale_ratio': '缩放比例',
          'scale_width': '缩放宽度',
          'scale_width_tip': '设置为 0 时，高度按比例缩放',
          'scale_height': '缩放高度',
          'scale_height_tip': '设置为 0 时，宽度按比例缩放',
          'compress': '压缩',
          'compress_tip': '压缩值为 100 时表示不压缩，压缩值越小压缩比例越大',
          'rotate': '旋转',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
        ImageBackgroundRemoval: {
          'title': '图片背景去除',
          'description': '用于去除图片背景。',
          'input_image': '输入图像',
          'remove_background_method': '移除背景方法',
          'remove_background_method_fast': '快速',
          'remove_background_method_accurate': '精确',
          'remove_background_method_portrait': '人像',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
        ImageWatermark: {
          'title': '图片水印',
          'description': '用于给图片添加水印。',
          'input_image': '输入图像',
          'opacity': '透明度',
          'image_or_text': '图片或文字',
          'image_or_text_image': '图片',
          'image_or_text_text': '文字',
          'watermark_image': '水印图片',
          'watermark_image_width_ratio': '水印图片宽度占比',
          'watermark_image_width_ratio_tip': '当设置为 0 时，按照水印图片高度占比自动计算',
          'watermark_image_height_ratio': '水印图片高度占比',
          'watermark_image_height_ratio_tip': '当设置为 0 时，按照水印图片宽度占比自动计算',
          'watermark_text': '水印文字',
          'watermark_text_font': '水印文字字体',
          'watermark_text_font_source_han_sans_sc': '思源黑体-简体中文',
          'watermark_text_font_source_han_sans_tc': '思源黑体-繁体中文',
          'watermark_text_font_source_han_sans_jp': '思源黑体-日文',
          'watermark_text_font_source_han_sans_kr': '思源黑体-韩文',
          'watermark_text_font_you_she_biao_ti_hei': '优设标题黑',
          'watermark_text_font_zi_hun_bian_tao_ti': '字魂扁桃体',
          'watermark_text_font_ckt_king_kong': '创客贴金刚体',
          'watermark_text_font_douyin_sans': '抖音美好体',
          'watermark_text_font_alimama_dong_fang_da_kai': '阿里妈妈东方大楷',
          'watermark_text_font_inter': 'Inter',
          'watermark_text_font_custom': '自定义字体',
          'watermark_text_font_size': '水印文字字号',
          'watermark_text_font_color': '水印文字颜色',
          'position': '水印位置',
          'position_center': '居中',
          'position_top_left': '左上',
          'position_top': '顶部',
          'position_top_right': '右上',
          'position_right': '右侧',
          'position_bottom_right': '右下',
          'position_bottom': '底部',
          'position_bottom_left': '左下',
          'position_left': '左侧',
          'vertical_gap': '垂直边缘间距',
          'horizontal_gap': '水平边缘间距',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
      },
      outputs: {
        title: '输出',
        Text: {
          'title': '文本呈现',
          'description': '用于在用户使用界面呈现文本。',
          'text': '文本内容',
          'output_title': '文本标题',
          'output_title_tip': '用于在使用界面区分模块',
          'render_markdown': '渲染 Markdown',
          'output': '输出',
        },
        Email: {
          'title': '邮件',
          'description': '用于发送邮件。',
          'to_email': '收件人',
          'subject': '主题',
          'content_html': '内容（HTML）',
          'attachments': '附件',
        },
        Document: {
          'title': '文档',
          'description': '用于生成文档文件。',
          'file_name': '文件名',
          'content': '内容',
          'export_type': '文档类型',
          'output_type': '输出端口格式',
          'output_type_only_path': '仅生成文件路径',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'show_local_file': '显示本地文件',
          'output': '输出',
        },
        Audio: {
          'title': '音频',
          'description': '用于生成音频文件。',
          'content': '文字内容',
          'show_player': '显示播放器',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅下载链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'show_local_file': '显示本地文件',
          'output': '输出',
        },
        Mindmap: {
          'title': '思维导图',
          'description': '用于生成思维导图。',
          'content': 'Markdown 内容',
          'show_mind_map': '显示思维导图',
          'output_type': '输出端口格式',
          'output': '输出',
        },
        Mermaid: {
          'title': 'Mermaid',
          'description': '用于生成 Mermaid 图表。',
          'content': 'Mermaid 内容',
          'show_mermaid': '显示 Mermaid',
          'output_type': '输出端口格式',
          'output': '输出',
        },
        Echarts: {
          'title': '图表',
          'description': '用于生成 Echarts 图表。',
          'option': 'Echarts 配置项',
          'show_echarts': '显示图表',
          'output_type': '输出端口格式',
          'output': '输出',
        },
        Table: {
          'title': '表格',
          'description': '用于展示表格。',
          'content': '文件链接/表格内容',
          'bordered': '显示边框',
          'show_table': '显示表格',
          'content_type': '输入类型',
          'content_type_file': '文件',
          'content_type_csv': 'CSV',
          'content_type_json': 'JSON',
          'output': '输出',
        },
        PictureRender: {
          'title': '图片渲染',
          'description': '用于将一定内容渲染为图片，例如将 Markdown 内容渲染为长图。',
          'render_type': '渲染类型',
          'content': '内容',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅下载链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
        WorkflowInvokeOutput: {
          'title': '工作流调用输出',
          'description': '用于被工作流调用节点调用时显示的输出，不显示在使用界面。',
          'value': '数据',
          'display_name': '显示名称',
        },
        Audio: {
          'title': '音频',
          'description': '用于生成音频文件，可实现文字转语音、播放音频文件等功能。',
          'audio_type': '音频类型',
          'audio_type_text_to_speech': '文字转语音',
          'audio_type_play_audio': '播放音频',
          'content': '文字内容',
          'tts_provider': '语音合成提供商',
          'tts_model': '语音合成模型',
          'tts_voice': '语音合成声音',
          'file_link': '音频文件链接',
          'direct_play': '直接播放',
          'show_player': '显示播放器',
          'output_type': '输出端口格式',
          'output_type_only_link': '仅下载链接文字',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': '输出',
        },
        Html: {
          'title': 'HTML',
          'description': '显示 HTML 渲染后的页面结果。',
          'html_code': 'HTML 代码',
          'output': '输出',
        },
      },
      webCrawlers: {
        title: '网络爬虫',
        TextCrawler: {
          'title': '文本爬虫',
          'description': '用于爬取网页中的文本。',
          'url': '网址',
          'output_type': '输出端口格式',
          'text': '文本',
          'json': 'JSON',
          'use_oversea_crawler': '使用海外爬虫（速度较慢）',
          'output_text': '网页正文文本',
          'output_title': '网页标题',
        },
        BilibiliCrawler: {
          'title': 'Bilibili爬虫',
          'description': '用于爬取 Bilibili 视频信息。',
          'url_or_bvid': '视频网址或 BVID',
          'download_video': '下载视频',
          'output_type': '输出端口格式',
          'output_type_str': '文本',
          'output_type_list': '列表',
          'str': '文本',
          'list': '列表',
          'output_subtitle': '字幕',
          'output_title': '标题',
          'output_video': '视频',
        },
        YoutubeCrawler: {
          'title': 'Youtube爬虫',
          'description': '用于爬取 Youtube 视频信息。',
          'url_or_video_id': '视频网址或视频 ID',
          'get_comments': '抓取评论',
          'comments_type': '评论输出格式',
          'comments_type_text_only': '仅文本',
          'comments_type_detailed': '详细信息',
          'output_type': '输出端口格式',
          'str': '文本',
          'list': '列表',
          'output_subtitle': '字幕',
          'output_title': '标题',
          'output_comments': '评论',
        },
      },
      triggers: {
        title: '触发器',
        ButtonTrigger: {
          'title': '按钮触发器',
          'description': '用于触发工作流运行，作为特殊节点，可以不需要与其它节点连接。',
          'button_text': '按钮文字',
          'run': '运行',
          'output': '输出',
        },
        ScheduleTrigger: {
          'title': '定时触发器',
          'description': '用于定时触发工作流运行。',
          'schedule': '定时',
          'schedule_settings': '定时设置',
          'save_schedule_settings': '保存定时设置',
          'output': '输出',
        },
      },
      vectorDb: {
        title: '向量数据库',
        AddData: {
          'title': '添加数据',
          'description': '用于向向量数据库中添加数据。',
          'text': '文本',
          'content_title': '标题',
          'source_url': '来源网址',
          'data_type': '数据类型',
          'database': '数据库',
          'split_method': '分割方法',
          'split_method_general': '通用分割',
          'split_method_delimiter': '分隔符分割',
          'split_method_markdown': 'Markdown 分割',
          'split_method_table': '表格分割',
          'chunk_length': '分割长度',
          'chunk_overlap': '分割重叠',
          'delimiter': '分隔符',
          'remove_url_and_email': '移除链接和邮箱',
          'wait_for_processing': '等待处理完成',
          'output': '输出',
          'object_id': '数据对象ID',
        },
        DeleteData: {
          'title': '删除数据',
          'description': '用于向向量数据库中删除数据。',
          'object_id': '数据对象 ID',
          'database': '数据库',
          'delete_success': '删除成功',
        },
        Search: {
          'title': '搜索数据',
          'description': '用于搜索向量数据库中的数据。',
          'search_text': '搜索文本',
          'data_type': '数据类型',
          'database': '数据库',
          'count': '搜索结果数量',
          'output_type': '输出端口格式',
          'text': '文本',
          'list': '列表',
          'output': '输出',
        },
      },
      relationalDb: {
        title: '关系数据库',
        SmartQuery: {
          'title': '智能查询',
          'description': '使用自然语言查询数据库。',
          'query': '查询内容',
          'model': '大语言模型',
          'database': '数据库',
          'tables': '表格',
          'load_tables': '加载表格',
          'select_all_if_empty': '如果为空则选择该数据库下所有表格，建议只选择需要的表格以获得更准确的结果。',
          'select_database': '请选择数据库',
          'use_sample_data': '附加示例数据',
          'use_sample_data_tip': '勾选后会提供一条表格数据作为提示词内容，方便 AI 参考数据格式，虽然增加了提示词的长度，但是可以获得更准确的结果。',
          'include_column_names': '包含列名',
          'include_column_names_tip': '开启后输出结果会包含列名',
          'max_count': '最大返回数量',
          'output_type': '输出端口格式',
          'output_type_list': '列表',
          'output_type_markdown': 'Markdown 表格',
          'output_type_csv': 'CSV 格式文本',
          'output': '输出',
          'output_query_sql': 'SQL 查询语句',
        },
        GetTableInfo: {
          'title': '获取表信息',
          'description': '用于获取数据库表格的信息。',
          'database': '数据库',
          'tables': '表格',
          'load_tables': '加载表格',
          'select_all_if_empty': '如果为空则选择该数据库下所有表格，建议只选择需要的表格以获得更准确的结果。',
          'select_database': '请选择数据库',
          'output_sql': 'SQL 输出',
          'output_sql_tip': '以 CREATE TABLE 语句输出表结构',
          'output_json': 'JSON 输出',
          'output_markdown': 'Markdown 输出',
        },
        RunSql: {
          'title': '运行 SQL',
          'description': '用于在用户自己的数据库内运行 SQL 语句。',
          'database': '数据库',
          'sql': 'SQL 语句',
          'read_only': '只读操作',
          'read_only_tip': '开启后不会对数据库表格产生修改操作',
          'include_column_names': '包含列名',
          'include_column_names_tip': '开启后输出结果会包含列名',
          'max_count': '最大返回数量',
          'output_type': '输出端口格式',
          'output_type_list': '列表',
          'output_type_markdown': 'Markdown 表格',
          'output_type_csv': 'CSV 格式文本',
          'output': '输出',
        },
      },
      tools: {
        title: '工具',
        ProgrammingFunction: {
          'title': '编程函数',
          'description': '用于执行编程函数。',
          'language': '编程语言',
          'code': '代码',
          'open_editor': '打开代码编辑器',
          'add_parameter': '添加输入参数',
          'add_parameter_type': '参数类型',
          'parameter_name_reserved': 'language/code/output/use_oversea_node/list_input/error_msg 是保留关键字，不能作为参数名。',
          'parameter_type_str': '字符串',
          'parameter_type_int': '整数',
          'parameter_type_float': '浮点数',
          'parameter_type_bool': '布尔值',
          'parameter_type_list': '列表',
          'parameter_type_dict': '字典',
          'add_parameter_name': '参数名称',
          'use_oversea_node': '使用海外节点',
          'list_input': '列表形式输入',
          'output': '返回值',
          "console_msg": "控制台消息",
          'error_msg': '报错消息',
          'files': '生成文件',
        },
        ImageSearch: {
          'title': '图片搜索',
          'description': '用于搜索图片。',
          'search_text': '搜索词',
          'search_engine': '搜索引擎',
          'search_engine_bing': 'Bing',
          'search_engine_pexels': 'Pexels',
          'count': '搜索结果数量',
          'output_type': '输出端口格式',
          'output_type_text': '文本',
          'output_type_markdown': 'Markdown',
          'output': '输出',
        },
        WorkflowInvoke: {
          'title': '工作流调用',
          'description': '用于调用工作流并获取结果。',
          'select_workflow': '选择工作流',
          'selected_workflow': '已选择工作流',
          'workflow_id': '工作流 ID',
          'fail_all': '该节点失败则工作流整体失败',
          'list_input': '列表形式输入',
          'workflow_fields': '工作流字段',
        },
        Screenshot: {
          'title': '屏幕截图',
          'description': '用于截取屏幕内容。',
          'monitor_number': '显示器编号',
          'output_type': '输出端口格式',
          'output_type_base64': 'Base64',
          'output_type_file_path': '文件路径',
          'output': '输出',
        },
        TextSearch: {
          'title': '文本搜索',
          'description': '用于搜索文本。',
          'search_text': '搜索词',
          'search_engine': '搜索引擎',
          'search_engine_bing': 'Bing',
          'search_engine_duckduckgo': 'Duckduckgo',
          'count': '搜索结果数量',
          'combine_result_in_text': '将搜索结果合并为单个文本',
          'max_snippet_length': '摘要最大长度',
          'output_type': '输出端口格式',
          'output_type_text': '文本',
          'output_type_markdown': 'Markdown',
          'output_page_title': '网页标题',
          'output_page_url': '网页网址',
          'output_page_snippet': '网页摘要',
        },
      },
      controlFlows: {
        title: '控制流',
        Empty: {
          'title': '空节点',
          'description': '用于需要确保工作流顺序执行的情况。',
          'input': '输入',
          'output': '输出（不改变被连接节点的值）',
        },
        Conditional: {
          'title': '条件判断',
          'description': '用于根据条件判断执行不同的操作。',
          'field_type': '数据类型',
          'field_type_string': '字符串',
          'field_type_number': '数字',
          'left_field': '左侧数据',
          'right_field': '右侧数据',
          'operator': '条件判断运算符',
          'operator_equal': '等于',
          'operator_not_equal': '不等于',
          'operator_greater_than': '大于',
          'operator_less_than': '小于',
          'operator_greater_than_or_equal': '大于等于',
          'operator_less_than_or_equal': '小于等于',
          'operator_include': '左边包含右边',
          'operator_not_include': '左边不包含右边',
          'operator_is_empty': '为空',
          'operator_is_not_empty': '不为空',
          'operator_starts_with': '左边以右边开头',
          'operator_ends_with': '左边以右边结尾',
          'true_output': '满足条件时的输出',
          'false_output': '不满足条件时的输出',
          'output': '输出',
        },
        RandomChoice: {
          'title': '随机选择',
          'description': '用于从列表中随机选择一个元素。',
          'input': '输入',
          'output': '输出',
        },
        JsonProcess: {
          'title': 'JSON 处理',
          'description': '用于处理 JSON 或 Python 的字典数据。',
          'input': '输入',
          'process_mode': '处理模式',
          'process_mode_get_value': '根据 Key 获取值',
          'process_mode_get_multiple_values': '根据多个 Key 获取多个值',
          'process_mode_list_values': '列表形式列出所有值',
          'process_mode_list_keys': '列表形式列出所有 Key',
          'key': 'Key',
          'keys': 'Keys',
          'add_key': '添加 Key',
          'edit_key': '编辑 Key',
          'default_value': '默认值（当 Key 不存在时）',
          'output': '输出',
        },
        WorkflowLoop: {
          'title': '工作流循环',
          'description': '用于循环执行工作流。',
          'select_workflow': '选择工作流',
          'selected_workflow': '已选择工作流',
          'workflow_id': '工作流 ID',
          'fail_all': '该节点失败则工作流整体失败',
          'list_input': '列表形式输入',
          'workflow_fields': '工作流字段',
          'workflow_fields_initial_values': '初始值',
          'workflow_fields_assignment_in_loop': '循环内赋值',
          'constant': '固定值',
          'input_field': '输入字段',
          'output_field': '输出字段上次循环结果',
          'output_field_cumulative': '输出字段累加结果',
          'output_field_cumulative_tip': '将之前每次循环的输出结果累加，用换行符分隔',
          'loop_count': '循环次数',
          'max_loop_count': '最大循环次数',
          'source': '赋值来源',
          'value': '值',
          'source_input_field': '来源输入字段',
          'source_output_field': '来源输出字段',
          'loop_end_condition': '循环结束条件',
          'loop_end_condition_loop_count': '循环次数',
          'loop_end_condition_output_field_condition': '输出字段条件',
          'loop_end_condition_extra_workflow_judgement': '额外工作流判断',
          'loop_end_condition_ai_model_judgement': 'AI 模型判断',
          'output_field_condition_field': '条件字段',
          'output_field_condition_operator': '条件判断运算符',
          'output_field_condition_operator_equal': '等于',
          'output_field_condition_operator_not_equal': '不等于',
          'output_field_condition_operator_greater_than': '大于',
          'output_field_condition_operator_less_than': '小于',
          'output_field_condition_operator_greater_than_or_equal': '大于等于',
          'output_field_condition_operator_less_than_or_equal': '小于等于',
          'output_field_condition_operator_include': '左边包含右边',
          'output_field_condition_operator_not_include': '左边不包含右边',
          'output_field_condition_operator_is_empty': '为空',
          'output_field_condition_operator_is_not_empty': '不为空',
          'output_field_condition_operator_starts_with': '左边以右边开头',
          'output_field_condition_operator_ends_with': '左边以右边结尾',
          'output_field_condition_true_output': '满足条件时的输出',
          'output_field_condition_false_output': '不满足条件时的输出',
          'output_field_condition_value': '条件值',
          'judgement_model': '模型',
          'judgement_prompt': '模型判断提示词',
          'judgement_end_output': '模型判断结束输出',
          'judgement_end_output_tip': '当模型输出此值时，循环结束',
        },
      },
      mediaProcessing: {
        title: '多模态处理',
        GptVision: {
          'title': 'GPT-Vision',
          'description': '带视觉的 GPT，允许模型接收图像并回答有关它们的问题。',
          'text_prompt': '文本提示词',
          'images_or_urls': '图片或链接',
          'images_or_urls_images': '图片',
          'images_or_urls_urls': '链接',
          'images': '图片',
          'urls': '链接',
          'model': '模型',
          'detail_type': '图像理解细节',
          'detail_type_auto': '自动选择',
          'detail_type_low': '低分辨率图像理解',
          'detail_type_high': '高分辨率图像理解',
          'output': '输出',
        },
        GlmVision: {
          'title': 'GLM-Vision',
          'description': '实现了视觉语言特征的深度融合，支持视觉问答、图像字幕、视觉定位、复杂目标检测等各类图像理解任务。',
          'text_prompt': '文本提示词',
          'images': '图片',
          'urls': '链接',
          'model': '模型',
          'images_or_urls': '图片或链接',
          'images_or_urls_images': '图片',
          'images_or_urls_urls': '链接',
          'output': '输出',
        },
        ClaudeVision: {
          'title': 'Claude-Vision',
          'description': 'Claude 3 系列模型具有新的视觉功能，允许 Claude 理解和分析图像。',
          'text_prompt': '文本提示词',
          'llm_model': '模型',
          'images': '图片',
          'urls': '链接',
          'images_or_urls': '图片或链接',
          'images_or_urls_images': '图片',
          'images_or_urls_urls': '链接',
          'output': '输出',
        },
        GeminiVision: {
          'title': 'Gemini-Vision',
          'description': '带视觉的 Gemini，允许模型接收图像并回答有关它们的问题。',
          'text_prompt': '文本提示词',
          'llm_model': '模型',
          'images': '图片',
          'urls': '链接',
          'images_or_urls': '图片或链接',
          'images_or_urls_images': '图片',
          'images_or_urls_urls': '链接',
          'output': '输出',
        },
        LocalVision: {
          'title': '本地多模态',
          'description': '本地的多模态模型。',
          'text_prompt': '文本提示词',
          'model_family': '模型系列',
          'llm_model': '模型',
          'images': '图片',
          'urls': '链接',
          'images_or_urls': '图片或链接',
          'images_or_urls_images': '图片',
          'images_or_urls_urls': '链接',
          'output': '输出',
        },
        SpeechRecognition: {
          'title': '语音识别',
          'description': '用于将语音转换为文本。',
          'engine': '语音识别引擎',
          'files_or_urls': '文件或链接',
          'files_or_urls_files': '文件',
          'files_or_urls_urls': '链接',
          'files': '文件',
          'urls': '链接',
          'output_type': '输出端口格式',
          'output_type_text': '文本',
          'output_type_list': '列表',
          'output_type_srt': 'SRT 字幕',
          'output': '输出',
        },
      },
    },
    copyButton: {
      'click_to_copy': '点击复制',
      'copy_success': '复制成功',
    },
    inputSearch: {
      input_search_text: '搜索',
    },
    help: {
      documentModal: {
        'load_error': '加载失败',
      },
      logModal: {
        'load_error': '加载失败',
        'auto_refresh': '自动刷新',
        'stop_refresh': '停止刷新',
      },
    },
  },
  layouts: {
    workspaceLayout: {
      tour: {
        'workflow_button_title': '切换工作流界面',
        'workflow_button_description': '点击此按钮可以切换到工作流界面。您的工作流以及官方模板等均可在此找到。',
        'database_button_title': '切换知识库/数据库界面',
        'database_button_description': '点击此按钮可以切换到数据界面。您可以在此创建您的个人知识库并上传您的数据以在工作流中使用。',
      },
      initial_setup: '初始设置',
      domain_tip: '中国用户建议使用 vectorvein.com',
      setting_tip1: '如需使用 AI 相关功能请务必在右上角设置中配置大语言模型的相关信息。',
      setting_tip2: '不同的 工作流/Agent 可能会使用不同的大语言模型，若您只使用某些特定的模型，建议在运行工作流或使用 Agent 之前检查并配置为您使用的模型。',
    },
  },
  settings: {
    'endpoints': 'API 端点',
    'llms': '远程大语言模型',
    'other': '其他',
    'open': '打开设置',
    'close': '关闭设置',
    'save': '保存设置',
    'save_success': '保存成功',
    'my_setting': '我的设置',
    'openai_api_type': 'OpenAI API 类型',
    'openai': 'OpenAI',
    'azure': 'Azure',
    'openai_api_key': 'OpenAI API Key',
    'openai_api_base': 'OpenAI API Base',
    'deployment_id': '部署 ID',
    'chatglm6b_api_base': 'ChatGLM-6B API Base',
    'moonshot_api_base': 'Moonshot API Base',
    'moonshot_api_key': 'Moonshot API Key',
    'zhipuai': '智谱 AI',
    'anthropic_api_base': 'Anthropic API Base',
    'anthropic_api_key': 'Anthropic API Key',
    'qwen': '通义千问',
    'lingyiwanwu': '零一万物',
    'baichuan': '百川智能',
    'local_llms': '本地大语言模型',
    'custom_llms': '自定义大语言模型',
    'model_family_api_base': '模型系列 API Base',
    'model_family_api_key': '模型系列 API Key',
    'model_family': '模型系列名称',
    'models': '模型列表',
    'model_label': '模型标签',
    'model_id': '模型 ID',
    'model_id_tip': '模型 ID 是模型实际部署时的 ID，一般情况与模型 Key 一致，但是在 Azure OpenAI、Anthropic on Vertex 等情况下，模型 ID 与模型 Key 不一致，需要单独设置。',
    'model_key': '模型 Key',
    'model_key_tip': '模型 Key 是模型系列的唯一标识，通常应与官方标识一致。',
    'model_rpm': '每分钟请求数',
    'model_concurrent': '并发数',
    'model_max_tokens': '上下文长度',
    'model_function_calling': '接口支持函数调用',
    'model_native_multimodal': '原生多模态支持',
    'model_response_format_available': '接口支持响应格式',
    'add_model_family': '添加模型系列',
    'add_model': '添加模型',
    'edit_model': '编辑模型',
    'save_model_family': '保存模型系列',
    'output_folder': '输出文件夹',
    'select_folder': '选择文件夹',
    'email_settings': '邮件设置',
    'email_user': '邮箱账号',
    'email_password': '邮箱密码',
    'email_smtp_host': '发信服务器',
    'email_smtp_port': '发信端口号',
    'email_smtp_ssl': 'SMTP SSL',
    'pexels_api_key': 'Pexels API Key',
    'stable_diffusion_base_url': 'Stable Diffusion URL',
    'use_system_proxy': '使用系统代理',
    'website_domain': '官网域名',
    'log_path': '日志路径',
    'data_path': '数据路径',
    'agent_settings': 'Agent 设置',
    'agent_auto_title': '自动生成对话标题',
    'agent_auto_title_model': '标题生成模型',
    'agent_screenshot_monitor_device': '截屏的显示器编号',
    'agent_screenshot_monitor_device_question_popover': '快捷键启动 Agent 聊天时调用。',
    'microphone_device': '麦克风设备',
    'shortcut_settings': '快捷键设置',
    'error_start_shortcut_setting': '监听快捷键设置失败',
    'new_chat_with_agent': '与 Agent 开启新的聊天',
    'new_chat_with_agent_with_screenshot': '与 Agent 开启新的聊天（附带屏幕截图）',
    'continue_chat_with_agent': '与 Agent 继续聊天',
    'continue_chat_with_agent_with_screenshot': '与 Agent 继续聊天（附带屏幕截图）',
    'recording_using_shorcut_tip': '使用快捷键唤起 Agent 进行麦克风对话时，会自动检测实时说话音量。在判断音量为无人说话的一小段时间后会自动停止录音。',
    'toggle_recording': '快捷键第一次按下开始录音，再次按下停止录音。',
    'waiting_for_combo_key': '等待组合键',
    'shortcut_not_set': '未设置快捷键',
    'shortcut_conflict': '快捷键冲突，请检查并修改（相同或包含）: {key1} 与 {key2}',
    'embedding_models': '嵌入模型',
    'tts': '语音合成',
    'web_search': '网络搜索',
    'stability_key': 'Stability Key',
    'asr': '语音识别',
    'provider_for_asr': '语音识别提供商',
    'asr_openai_setting_same_as_llm': '与大语言模型选项卡中设置相同',
    'voices': '声音',
    'voice_label': '声音标签',
    'voice_id': '声音 ID',
    'add_endpoint': '添加端点',
    'endpoint_id': '端点 ID',
    'api_base': 'API Base',
    'api_key': 'API Key',
    'region': '区域',
    'endpoint_name': '端点名称',
    'save_endpoint': '保存端点',
    'is_azure': 'Azure',
    'is_vertex': 'Vertex',
    'credentials': '凭证',
    'credentials_placeholder': '请输入特殊凭证，例如 Google 凭证',
    'concurrent_requests': '并发请求数',
    'select_endpoint': '选择端点',
    'api_base_empty': 'API Base 不能为空',
    'max_output_tokens': '最大输出 Token 数',
    'delete_model_family': '删除模型系列',
    'delete_model_family_confirm': '确定删除 {modelFamily} 模型系列？',
    'edit_model_family_name': '编辑模型系列名称',
    'model_family_name_repeat': '模型系列名称与已有名称重复',
    'list_models': '列出模型',
    'settings_changed': '设置已更改，请注意保存',
    'model_owned_by': '模型所属',
    'available_models': '可用模型',
    'add_to_custom_models': '添加到自定义模型',
    'endpoint_id_empty': '端点 ID 不能为空',
    'select_all': '全选',
    'clear': '清除',
    'list_models_failed': '获取模型列表失败',
    'agent_tool_call_data_generate_model': 'Agent 工具调用数据生成模型',
    'skip_ssl_verification': '跳过 SSL 验证',
  },
  voiceOptions: {
    "minimax_male-qn-qingse": "青涩青年音色",
    "minimax_male-qn-jingying": "精英青年音色",
    "minimax_male-qn-badao": "霸道青年音色",
    "minimax_male-qn-daxuesheng": "青年大学生音色",
    "minimax_female-shaonv": "少女音色",
    "minimax_female-yujie": "御姐音色",
    "minimax_female-chengshu": "成熟女性音色",
    "minimax_female-tianmei": "甜美女性音色",
    "minimax_presenter_male": "男性主持人",
    "minimax_presenter_female": "女性主持人",
    "minimax_audiobook_male_1": "男性有声书1",
    "minimax_audiobook_male_2": "男性有声书2",
    "minimax_audiobook_female_1": "女性有声书1",
    "minimax_audiobook_female_2": "女性有声书2",
    "minimax_male-qn-qingse-jingpin": "青涩青年音色-beta",
    "minimax_male-qn-jingying-jingpin": "精英青年音色-beta",
    "minimax_male-qn-badao-jingpin": "霸道青年音色-beta",
    "minimax_male-qn-daxuesheng-jingpin": "青年大学生音色-beta",
    "minimax_female-shaonv-jingpin": "少女音色-beta",
    "minimax_female-yujie-jingpin": "御姐音色-beta",
    "minimax_female-chengshu-jingpin": "成熟女性音色-beta",
    "minimax_female-tianmei-jingpin": "甜美女性音色-beta",
  },
}
