/**
 * @Author: Bi Ying
 * @Date:   2022-05-24 13:48:55
 * @Last Modified by:   Bi Ying
 * @Last Modified time: 2024-08-12 12:45:04
 */
export default {
  lang: 'English',
  meta: {
    'title': 'VectorVein',
    'description': 'A brand new knowledge base + workflow management system',
  },
  router: {
    base: 'VectorVein',
    basic: {
      children: {
        'index': 'Index',
      }
    },
    workspace: {
      children: {
        'workflow_space': 'My workflow space',
        'data_space': 'My data space',
        'workflow_main': 'Workflow main',
        'workflow_use': 'Workflow use',
        'workflow_template': 'Workflow template',
        'database_detail': 'Database detail',
        'database_object_create': 'Database object create',
        'database_object_detail': 'Database object detail',
      }
    },
    account: {
      children: {
        'info': 'My Account Info',
        'settings': 'My Account Settings',
      }
    },
    settings: 'Settings',
  },
  status: {
    'IN': 'Invalid',
    'PR': 'Processing',
    'VA': 'Valid',
    'DE': 'Deleted',
    'EX': 'Expired',
    'INVALID': 'Invalid',
    'EXPIRED': 'Expired',
    'DELETING': 'Deleting',
    'DELETED': 'Deleted',
    'VALID': 'Valid',
    'ERROR': 'Error',
    'CREATING': 'Creating',
    'NOT_STARTED': 'Not started',
    'QUEUED': 'Queued',
    'RUNNING': 'Running',
    'FINISHED': 'Finished',
    'FAILED': 'Failed',
  },
  common: {
    'vector_vein': 'VectorVein',
    'time_length': '{hours} Hours {minutes} Minutes',
    'refresh': 'Refresh',
    'index': 'Index',
    'update_log': 'Update log',
    'my': 'My',
    'official': 'Official',
    'community': 'Community',
    'all': 'All',
    'all_tags': 'All tags',
    'add': 'Add',
    'edit': 'Edit',
    'create': 'Create',
    'delete': 'Delete',
    'status': 'Status',
    'tags': 'Tags',
    'action': 'Action',
    'output': 'Output',
    'support_inquiries': 'Support inquiries: ',
    'notice': 'Notice',
    'ok': 'OK',
    'save': 'Save',
    'pay_channel': 'Payment method',
    'credits': 'Credits',
    'total_price': 'Total price',
    'total_credits': 'Total credits',
    'bonus_credits': 'Bonus credits',
    'available_credits': 'Available credits',
    'pay': 'Pay',
    'warning': 'Warning',
    'copy_success': 'Copy success',
    'alipay': 'Alipay',
    'wechatpay': 'Wechatpay',
    'create_time': 'Create time',
    'update_time': 'Update time',
    'update_time_format': 'Update time: {time}',
    'back': 'Back',
    'previous_step': 'Previous step',
    'next_step': 'Next step',
    'title': 'Title',
    'description': 'Description',
    'content': 'Content',
    'save_success': 'Save success',
    'card_view': 'Card view',
    'table_view': 'Table view',
    'finish': 'Finish',
    'success': 'Success',
    'failed': 'Failed',
    'cancel': 'Cancel',
    'more_settings': 'More settings',
    'yes': 'Yes',
    'no': 'No',
    'duplicate': 'Duplicate',
    'vectorvein_user': 'VectorVein user',
    'preview': 'Preview',
    'close_preview': 'Close preview',
    'reset': 'Reset',
    'select': 'Select',
    'remove': 'Remove',
    'workflow': 'Workflow',
    'workflow_template': 'Workflow template',
    'chat': 'Chat',
    'confirm_leave': 'You have not saved yet, confirm to leave?',
    'publiced': 'Publiced',
    'not_publiced': 'Private',
    'shared': 'Shared',
    'not_shared': 'Not shared',
    'share_status_update_success': 'Share status update success',
    'share_status_update_failed': 'Share status update failed',
    'copy_link': 'Copy link',
    'load_more': 'Load more',
    'start': 'Start',
    'manage': 'Manage',
    'statistics': 'Statistics',
    'enter': 'Enter',
    'enter_too_fast': 'Too fast, please try again later',
    'help_document': 'Help document',
    'finish': 'Finish',
    'insufficient_quota': 'Insufficient quota',
    'skip': 'Skip',
    'or': 'Or',
    'card_view': 'Card view',
    'table_view': 'Table view',
    'membership': 'Membership',
    'more_settings': 'More settings',
    'sync': 'Sync',
    'async': 'Async',
    'too_many_requests': 'Too fast, please try again later',
    'language': 'Language',
    'model': 'Model',
    'me': 'Me',
    'TIP': 'Tip',
    'NOTE': 'Note',
    'IMPORTANT': 'Important',
    'WARNING': 'Warning',
    'CAUTION': 'Caution'
  },
  email: {
    verify: {
      'email_verify_success': 'Email verify success!',
      'email_verify_success_subtitle': 'Your email has been verified successfully, check the courses now!',
      'check_control_panel': 'Check control panel',
      'email_verify_failed': 'Email verify failed!',
      'email_verify_failed_subtitle': 'There is an error in the verification link, please recheck and refresh.',
      'email_verify_expired_subtitle': 'This link has expired. Please resend the verification email.',
      'resend_email': 'Resend email',
      'email_already_verified': 'Email already verified!',
      'email_already_verified_subtitle': 'This link is verified, please login directly',
      'please_verify_your_email': 'Please verify your email',
      'please_verify_your_email_subtitle': 'To keep your account safe, we need to verify your email address: ',
      'sending_failed': 'Sending failed',
      'too_frequently_resend': 'Your emails are being sent too often, please try again later',
      'sending_successfull': 'Sending successfull',
      'please_relogin_after_verify': 'Please re-login after successful verification',
    }
  },
  userAuth: {
    common: {
      'please_enter': 'Please enter ',
      'username': 'Username',
      'email': 'Email',
      'mobile': 'Mobile',
      'verification_code': 'Verification code',
      'send_verification_code': 'Send verification code',
      'password': 'Password',
      'login': 'Login',
      'logout': 'Logout',
      'or': 'or',
      'register': 'Register',
      'sign_up': 'Sign up',
      'error': 'Server error',
    },
    login: {
      'please_enter_username': 'Please enter username',
      'please_enter_email': 'Please enter email',
      'please_enter_password': 'Please enter password',
      'remember_account': 'Remember me',
      'forget_password': 'Forget password',
      'account_not_exists_title': 'Password incorrect or account not exists',
      'account_not_exists_content': 'Please check if your account password is correct or register a new account.',
      'mobileLogin': 'Mobile login',
      'wechatLogin': 'Wechat login',
      'email_login': 'Email login',
    },
    register: {
      'region_search_or_select': 'Region (search or select)',
      'please_select_your_region': 'Please select your region',
      'human_verification_error': 'Human verification error!',
      'connection_error': 'Connection error!',
      'email_already_exists': 'Email already registered! Please login directly.',
      'username_already_exists': 'Username already used!',
      'register_success': 'Register success! Please verify your email.',
    },
    registerResult: {
      'check_email': 'Check email',
      'back_to_login': 'Back to login',
      'verification_email_sent': 'The activation email has been sent to your email address, and the email is valid for 24 hours. Please log in to your mailbox in time and click the link in the email to activate your account.',
      'your_email_account_register_success': 'Your account {email} registered successfully!',
    },
    forgetPassword: {
      'verify_email': 'Verify email',
      'enter_new_password': 'Enter new password',
      'verify': 'Verify',
      'verification_code_send_success': 'Verification code sent',
      'human_verification_error': 'Human verification error!',
      'connection_error': 'Connection error!',
      'email_not_exists': 'Email not exists!',
      'reset_password': 'Reset password',
      'reset_success': 'Reset success! Please login.',
    }
  },
  userAccount: {
    accountInfo: {
      'my_account': 'My account',
      'my_credits': 'My credits',
    },
    accountSettings: {
      'account_email': 'Account email',
      'account_settings': 'Account settings',
    }
  },
  workspace: {
    chatSpace: {
      'fetch_conversations_failed': 'Fetch conversations failed',
      'fetch_conversation_failed': 'Fetch conversation failed',
      'textarea_tip': 'Ctrl + Enter send',
      'send_message': 'Send message',
      'send': 'Send',
      'send_message_failed': 'Send message failed',
      'new_chat': 'New chat',
      'how_can_i_help_you_today': 'How can I help you today?',
      'share_chat': 'Share chat',
      'delete_chat': 'Delete chat',
      'delete_chat_confirm_title': 'Confirm to delete?',
      'delete_chat_confirm_content': 'This will delete {title}',
      'delete_chat_failed': 'Delete chat failed',
      'delete_chat_success': 'Delete chat success',
      'today': 'Today',
      'yesterday': 'Yesterday',
      'last30Days': 'Previous 30 days',
      'earlier': 'Earlier',
      'settings': 'Settings',
      'workflows': 'Workflows',
      'selected_workflows': 'Selected workflows',
      'update_workflows_success': 'Update workflows success',
      'update_workflows_failed': 'Update workflows failed',
      'update_settings_success': 'Update settings success',
      'update_settings_failed': 'Update settings failed',
      'agent_settings': 'Agent settings',
      'system_prompt': 'System prompt',
      'system_prompt_description': 'You can use system prompts to describe the personality of your assistant, define what the model should and should not respond to, and define the format of the model\'s response.',
      'auto_run_workflow': 'Auto run workflow',
      'auto_run_workflow_description': 'When the AI determines that it needs to run a workflow to complete the task, it will automatically run the workflow and return the result.',
      'use_workflow': 'Use workflow',
      'run_workflow': 'Run workflow',
      'workflow_running': 'Workflow running',
      'open_workflow_record_page': 'Open workflow record page',
      'cant_open_template_record': 'Can\'t open workflow template record page',
      'global_settings': 'Global settings',
      'ai_agent': 'AI Agent',
      'generating_params': 'Generating workflow invoke parameters',
      'share_chat_description': 'Messages sent after creating the link will not be shared. Anyone with the link can view the shared chat. The workflow run records involved in the chat will be set to the shared state.',
      'hide_nickname': 'Hide nickname',
      'show_nickname': 'Show nickname',
      'message_changed_after_last_share': 'The chat message has been added since the last share, closing and reopening the share will update.',
      'upload_attachments': 'Upload attachments',
      'input_too_large': 'The input content is too long, please shorten it and try again.',
      'model_select': 'AI model select',
      'model_select_success': 'AI model select updated',
      'share_to_community': 'Public',
      'not_share_to_community': 'Not public',
      'share_to_community_brief': 'After sharing publicly to the community, other users can see the chat record in the share list. Otherwise, it can only be accessed through the share link.',
      'workflow_title_clickable': 'Click the title to expand the workflow run record details',
      'model': 'Model',
      'model_unit_price': 'Unit price(Input/Output)',
      'unit_1000_tokens': 'Unit: 1000 Tokens',
      'prompt_unit_credits': 'Input: {credits} credits / 1000 Tokens',
      'completion_unit_credits': 'Output: {credits} credits / 1000 Tokens',
      'local_model': 'Local Model',
      'recording': 'Recording',
      'stop_recording': 'Stop recording',
      'recording_start': 'Recording start',
      'recording_failed': 'Recording failed',
      'transcribe_failed': 'Transcribe failed',
      'agent_audio_reply': 'Agent audio reply',
      'agent_audio_reply_description': 'Play the agent\'s reply with audio after the agent generates the reply',
      'agent_audio_voice': 'Agent voice',
      'native_multimodal': 'Native multimodal',
      'native_multimodal_description': 'If the model supports multimodal, uploaded images will be passed directly to the model.',
      'drop_to_upload': 'Drop to upload attachments',
      'no_selected_workflows': 'No selected workflows',
    },
    agentSpace: {
      'my_agents': 'My AI agent',
      'public_agents': 'Public AI agent',
      'shared_chats': 'Agent chat share',
      'input_search_text': 'Search',
      'create_agent': 'Create agent',
      'no_agents_1': 'You haven\'t created any AI agent yet',
      'no_agents_2': 'You can view official AI agent or create a new AI agent',
      'agent_name': 'Agent name',
      'agent_name_placeholder': 'Please enter the name of the AI agent',
      'agent_name_required': 'Agent name required',
      'agent_description': 'Agent description',
      'agent_description_placeholder': 'Please enter the function introduction of the agent.',
      'delete_agent_confirm_title': 'Confirm to delete?',
      'delete_agent_confirm_content': '{name} will be deleted, and the chat record will be deleted.',
      'create_agent_success': 'Create agent success',
      'delete_agent_success': 'Delete agent success',
      'duplicate_as_mine': 'Duplicate as mine',
      'duplicate_agent_success': 'Duplicate agent success',
      'add_templates': 'Add templates',
      'add_templates_to_your_workflows': 'Do you want to add the workflow templates in this Agent as your personal workflows? After adding, you can review the workflow run records. If not added, this Agent will not be associated with any workflows and will require manual handling by you.',
      'modify_agent': 'Modify agent',
      'system_prompt': 'System prompt',
      'system_prompt_tip': 'System prompts are special messages used to guide AI behavior, which allow developers to define the style and tasks of artificial intelligence within a certain range, making it more customizable and adaptable to various use cases.',
      'opening_dialog': 'Opening dialog',
      'opening_question_suggestions': 'Opening question suggestions',
      'opening_question_suggestions_tip': 'Give a few optional opening questions so that users can start the conversation quickly.',
      'workflow_selection': 'Workflow selection',
      'selected_workflows': 'Selected workflows',
      'remove_workflow': 'Remove workflow',
      'chat_with_agent': 'Chat with agent',
      'toggle_agent_shared_true': 'Share agent',
      'toggle_agent_shared_true_content': 'After sharing, other users can use the agent through the link.',
      'toggle_agent_shared_false': 'Cancel share agent',
      'toggle_agent_shared_false_content': 'After canceling the sharing, other users will not be able to use the agent through the link.',
      'toggle_agent_is_public_true': 'Make agent public',
      'toggle_agent_is_public_true_content': 'After making it public, other users can find the agent on the community public page.',
      'toggle_agent_is_public_false': 'Cancel public agent',
      'toggle_agent_is_public_false_content': 'After canceling the public, other users will not be able to find the agent on the community public page.',
      'workflow_become_template_warning': 'Your personal workflow will be automatically converted to a workflow template for other users to use.',
      'database_access_control_warning': 'If the workflow used by your Agent involves knowledge base search, please pay attention to confirm the permission of the database. If the database is private, after converting to a workflow template, the user needs to create the database by himself. If you want users to use the database you have created directly, pay attention to change the database permission to public read.',
      'workflows_converted_to_templates': 'Workflows converted to templates',
      'copy_agent_share_link': 'Copy agent share link',
      'model_select': 'AI model select',
      'model_select_tip': 'You can choose different AI models as the default model according to your needs. You can manually change the model during the chat.',
      'cant_open_template_record': 'Can\'t open workflow template record page',
      'not_shared_agent': 'Not shared Agent',
    },
    workflowSpace: {
      'workflow_index': 'Workflow index',
      'user_fast_access_workflows': 'Fast access workflows',
      'add_new_workflow': 'Add new workflow',
      'new_workflow': 'New workflow',
      'share_workflow': 'Share',
      'clone_workflow': 'Clone',
      'clone_success': 'Clone success',
      'clone_failed': 'Clone failed',
      'add_to_fast_access': 'Add to fast access',
      'add_to_fast_access_confirm': 'Confirm to add the workflow to fast access?',
      'delete_from_fast_access': 'Delete from fast access',
      'delete_from_fast_access_confirm': 'Confirm to delete the workflow from fast access?',
      'add_to_fast_access_success': 'Add to fast access success',
      'add_to_fast_access_failed': 'Add to fast access failed',
      'delete_from_fast_access_success': 'Delete from fast access success',
      'delete_from_fast_access_failed': 'Delete from fast access failed',
      'update_time': 'Update time: {time}',
      'inputs': 'Inputs',
      'outputs': 'Outputs',
      'triggers': 'Triggers',
      'run': 'Run',
      'edit': 'Edit',
      'delete': 'Delete',
      'delete_confirm': 'Confirm to delete the workflow?',
      'delete_success': 'Delete success',
      'delete_failed': 'Delete failed',
      'save_success': 'Save success',
      'save_failed': 'Save failed',
      'workflow_cant_invoke_itself': 'Workflow can\'t invoke itself',
      'get_workflow_failed': 'Get workflow failed',
      'get_workflow_record_failed': 'Get workflow record failed',
      'submit_workflow_success': 'Submit workflow request success',
      'submit_workflow_failed': 'Submit workflow request failed',
      'run_workflow_success': 'Run workflow success',
      'run_workflow_failed': 'Run workflow failed',
      'update_schedule_success': 'Update schedule success',
      'update_schedule_failed': 'Update schedule failed',
      'delete_schedule_trigger_confirm': 'Confirm to delete the schedule trigger?',
      'delete_schedule_success': 'Delete schedule success',
      'delete_schedule_failed': 'Delete schedule failed',
      'brief': 'Brief',
      'field_is_empty': '{field} is empty',
      'record_status': 'Workflow run record status: {status}',
      'record_error_task': 'Error task: {task}',
      'maximize_output': 'Maximize output area',
      'normalize_output': 'Restore output area size',
      'related_workflows': 'Related workflows',
      'diagnosis_workflow_record': 'Diagnosis workflow run record',
      'diagnosis_workflow_record_tip': 'You can now diagnose a specific workflow run record to view the running status, running time of each node.',
      'more_actions': 'More',
      'api_key_is_empty': 'The API Key of model {model} is not set!',
      'version_tip': 'Workflow version',
      'run_workflow_version_inconsistent': 'Workflow version inconsistent',
      'run_workflow_version_inconsistent_tip1': 'The current workflow version is inconsistent with the run record version, please select one of the following options to continue running',
      'run_workflow_version_inconsistent_tip2': 'If you choose to run the version from the run record, it will use the workflow structure corresponding to that record, rather than the current latest workflow structure. If you use the current latest version of the workflow structure, due to possible differences in fields, it may not be able to automatically fill and run successfully.',
      'run_record_version': 'Run record version',
      'run_latest_version': 'Run latest version',
      'record_version': 'Workflow run record corresponding to workflow version',
    },
    workflowEditor: {
      'exit_not_saved_confirm': 'Workflow not saved, confirm exit?',
      'save_and_exit': 'Save and exit',
      'exit_without_save': 'Exit without save',
      'test_run': 'Test',
      'workflow_info': 'Basic info',
      'workflow_canvas': 'Workflow canvas',
      'workflow_ui_design': 'UI design',
      'tags': 'Tags',
      'brief_info': 'Brief info',
      'brief_images': 'Brief images',
      'edit_code': 'Edit code',
      'workflow_check_warning': 'Workflow check warning',
      'workflow_has_no_inputs': 'Workflow has no inputs (please check the fields you want to display in the use interface)',
      'workflow_has_no_outputs': 'Workflow has no outputs (please drag a node from the output to the canvas and connect it)',
      'workflow_has_no_triggers': 'Workflow has no triggers (please drag a node from the triggers to the canvas and connect it)',
      'workflow_has_cycles': 'The workflow connection has a cycle, please make sure that the connection of each node will not form a cycle',
      'workflow_has_isolated_nodes': 'There are isolated nodes in the workflow, please make sure that all nodes except the trigger node are connected to other nodes',
      'edge_delete_message': 'Press the backspace key on the keyboard or double-click the line to delete',
      'edge_already_connected_message': 'The handle has already connected an edge',
      'diagnosing_record': 'Diagnosing {record}',
      'cannot_save_when_diagnosing': 'Cannot save when diagnosing record',
      'layout_graph': 'Auto layout',
      'resume_node_but_edge_already_connected_message': 'The other end of the line has other lines, please delete other lines or ignore the nodes corresponding to the lines.',
    },
    workflowSpaceMain: {
      'my_workflows': 'My workflows',
      'workflow_title': 'Workflow',
      'tags': 'Tags',
      'tags_filter': 'Tags filter',
      'update_time': 'Update time',
      'create_workflow': 'Create workflow',
      'official_workflow_template': 'Official template',
      'community_workflow_template': 'Community template',
      'input_search_text': 'Enter the title, brief, etc. to be searched',
      'reset_search': 'Reset',
      'no_workflows_1': 'You have not added or created a workflow yet',
      'no_workflows_2': 'Add a workflow here',
    },
    workflowTemplate: {
      'template': 'Template',
      'add_to_my_workflows': 'Add to my workflows',
      'add_success': 'Add success',
      'add_failed': 'Add failed',
      'author': 'Author: {author}',
      'used_count': '{count} people have used',
      'workflow_template_tags': 'Workflow template tags',
      'edit_template': 'Edit template',
      'update_success': 'Update success',
      'update_failed': 'Update failed',
      'test_run_template': 'Test run template',
      'test_run_template_hint1': 'It is recommended that you add it to your own workflow before running, so that you can save the record and make custom modifications.',
    },
    dataSpace: {
      'create': 'Create',
      'create_success': 'Create success',
      'create_failed': 'Create failed',
      'database_name': 'Database name',
      'status_invalid': 'Invalid',
      'status_expired': 'Expired',
      'status_deleted': 'Deleted',
      'status_valid': 'Valid',
      'status_error': 'Error',
      'status_creating': 'Creating',
      'status_deleting': 'Deleting',
      'delete': 'Delete',
      'delete_confirm': 'Confirm to delete the database? It cannot be restored after deletion!',
      'delete_success': 'Delete success',
      'delete_failed': 'Delete failed',
      'vector_database': 'Vector database',
      'vector_database_description': 'Vector database is a database based on vector retrieval, which can be used to store and retrieve text, images, audio, video and other data.',
      'relational_database': 'Relational database',
      'relational_database_description': 'Relational database is a database based on the relational model, which can be used to store and retrieve structured data.',
      'embedding_provider': 'Embedding provider',
      'embedding_provider_azure_tip': 'If the OpenAI type in the settings is Azure, the deployment name of Azure Embedding in the settings is used.',
      'embedding_provider_text_embeddings_inference_tip': 'text-embeddings-inference needs to be deployed by yourself, see details',
      'embedding_models': 'Embedding models',
      'embedding_size': 'Embedding size',
    },
    databaseDetail: {
      'add_object': 'Add object',
      'object_title': 'Object title',
      'object_source_url': 'Object source url',
      'object_type': 'Object type',
      'add_method': 'Add method',
      'add_method_url': 'Add from url',
      'add_method_files': 'Upload files',
      'add_method_text': 'Input text',
      'crawl_data_from_url': 'Crawl data from url',
      'use_oversea_crawler': 'Use oversea crawler',
      'object_content': 'Object content',
      'content_empty': 'Content empty!',
      'create_success': 'Add success',
      'create_failed': 'Add failed',
      'delete_success': 'Delete success',
      'delete_failed': 'Delete failed',
      'check_detail_data': 'Check detail data',
      'source_url': 'Source link',
      'data_type': 'Data type',
      'data_type_TEXT': 'Text',
      'data_type_IMAGE': 'Image',
      'data_type_AUDIO': 'Audio',
      'data_type_VIDEO': 'Video',
      'data_type_OTHER': 'Other',
      'delete_confirm': 'Confirm to delete this data?',
      'delete': 'Delete',
      'modify_database_info': 'Modify database info',
      'table': 'Table',
      'table_name': 'Table name',
      'table_status': 'Table status',
      'table_current_rows': 'Current rows',
      'run_sql': 'Run SQL',
      'please_enter_sql': 'Please enter SQL statement conforming to SQLite syntax',
      'failed_to_load_database': 'Failed to load the database, the database may be too large or the file is damaged',
      'sql_success': 'SQL success',
      'affected_rows': 'Affected rows {rows}',
      'max_show_rows': 'Up to 1000 rows of data can be displayed on the page',
      'force_refresh_database': 'Force refresh database',
      'result_n': 'Result {n}',
      'affected_rows': 'Affected rows {rows}',
    },
    databaseObjectCreate: {
      'add_object': 'Add object',
      'add_method': 'Add method',
      'add_method_url': 'Add from url',
      'add_method_files': 'Upload files',
      'add_method_text': 'Input text',
      'split_method': 'Split method',
      'split_method_general': 'General split',
      'split_method_delimeter': 'Delimeter split',
      'split_method_markdown': 'Markdown split',
      'split_method_table': 'Table split',
      'chunk_length': 'Chunk length',
      'remove_url_and_email': 'Remove url and email',
      'use_oversea_crawler': 'Use oversea crawler',
      'object_source_url': 'Object source url',
      'object_files': 'Object files',
      'object_title': 'Object title',
      'object_content': 'Object content',
      'process_rules': 'Process rules',
      'delimiter': 'Delimiter',
      'finish': 'Finish',
      'content_empty': 'Content empty!',
      'create_success': 'Add success',
      'create_failed': 'Add failed',
      question: {
        'chunk_length': {
          '1': 'The chunk length means that the text is divided into segments according to how long it is, for example, 1000 means that every 1000 characters are divided into one segment.',
          '2': 'The vector database will find the most relevant paragraph and return it when searching.',
          '3': 'Note that the paragraph length here is not strictly followed, but is roughly close.',
        },
      },
    },
    databaseObjectDetail: {
      'source_url': 'Source link',
      'segments': 'Segments',
      'full_document': 'Full document',
      'params_info': 'Params info',
      'segment_index': 'Index',
      'segment_text': 'Text',
      'segment_keywords': 'Keywords',
      'segment_tokens': 'Tokens',
      'segment_word_counts': 'Counts',
      'paragraph_counts': 'Paragraph counts',
      'word_counts': 'Word counts',
      'modify_object_info': 'Modify information',
      'object_title': 'Object title',
    },
    databaseTableCreate: {
      'add_table': 'Add table',
      'add_method': 'Add method',
      'add_method_table_file': 'Upload file',
      'add_method_manual': 'Manual input',
      'add_method_sql': 'SQL import',
      'table_name': 'Table name',
      'sql_statement': 'SQL statement',
      'sql_statement_too_long': 'SQL statement is too long, please use the file upload method to upload the SQL file.',
      'table_schema': 'Table schema',
      'get_table_schema': 'Get table schema',
      'column_name': 'Column name',
      'column_type': 'Column type',
      'max_length': 'Max length',
      'type_INTEGER': 'Integer',
      'type_REAL': 'Real',
      'type_TEXT': 'Text',
      'type_VARCHAR': 'Varchar',
      'type_BOOLEAN': 'Boolean',
      'type_DATETIME': 'Datetime',
      'add_column': 'Add column',
      'sql_statement_empty': 'SQL statement cannot be empty',
      'table_name_empty': 'Table name cannot be empty',
      'table_schema_empty': 'Table schema cannot be empty',
      'uploaded_files': 'Uploaded files',
      'table_name_already_exists': 'Table name already exists',
      'not_enough_quota': 'Not enough tables\' quota',
      'upload_file_alert_title': 'Please upload data files within 100M',
      'upload_file_alert_description': 'To process data more accurately, please ensure that the first row of the table is the header, and each row from the second row is a piece of data, and there are no merged cells in the table.',
      'no_space_in_column_name': 'Column names cannot contain spaces',
    },
    databaseTableRecord: {
      'sheet': 'Sheet',
      'load_data': 'Load data',
      'delete_records_confirm': 'Confirm to delete the selected records?',
      'add_record': 'Add record',
      'current_rows_max_rows': 'Current rows / Max rows',
      'force_refresh_table': 'Force refresh table',
    },
  },
  components: {
    layout: {
      basicHeader: {
        'agent': 'Agent',
        'workflow_space': 'Workflow',
        'data_space': 'Data',
        'opensource_code': 'Open source code',
        'setting': 'Setting',
        'pin_window': 'Pin window',
        'unpin_window': 'Unpin window',
        'theme_dark': 'Dark theme',
      },
      helpDropdown: {
        'help': 'Help',
        'about': 'About',
        'documentation': 'Documentation',
        'software_update': 'Software update',
        'check_update': 'Check update',
        'update_available': 'Update available',
        'new_version': 'New version {version} {releaseDatetime}',
        'about_vectorvein': 'About VectorVein',
        'about_vectorvein_description': '### Build Your Automated Workflow with the Power of AI\n#### Create powerful workflows with drag-and-drop functionality, no programming required.\n\nThe open-source version of VectorVein, developed by MakerBi, is available for personal use only and cannot be used for commercial purposes.',
        'view_logs': 'View logs',
      },
    },
    markdownEditor: {
      'raw_text': 'Raw text',
      'markdown_text': 'Markdown text',
    },
    workspace: {
      workflowEditor: {
        'add_node': 'Add node',
        'add_tag': 'Add tag',
        'brief_editor': 'Brief editor',
        'brief_images': 'Brief images',
      },
      myWorkflows: {
        'input_search_text': 'Enter the title, brief, etc. to be searched',
        'reset_search': 'Reset',
        'no_workflows_1': 'You have not added or created a workflow yet',
        'no_workflows_2': 'Add a workflow here',
      },
      relatedWorkflowsModal: {
        'title': 'Related workflows that are indirectly called',
      },
      uiDesign: {
        'typography-paragraph': {
          'title': 'Text Content',
          'placeholder': 'Supports Markdown syntax, which will be rendered directly in the interface',
          'tip': 'Can be used to place tips in the interface',
        }
      },
      uploaderFieldUse: {
        'upload': 'Select file',
        'upload_success': '{file} selected',
        'upload_failed': '{file} upload failed',
        'uploader_text': 'Click or drag file to this area to upload',
        'uploader_hint': 'Currently supported file types: {fileTypes}',
      },
      mindmapRenderer: {
        'download_svg': 'Download svg file',
        'download_xmind': 'Download xmind file',
      },
      echartsRenderer: {
        'download_image': 'Download image',
      },
      newWorkflowModal: {
        'create_new_workflow': 'Create new workflow',
        'empty_workflow': 'Create empty workflow',
      },
      tagInput: {
        'select_tags': 'Select tags',
      },
      workflowRunRecordsDrawer: {
        'workflows_run_records': 'Workflows records',
        'my_workflows_run_records': 'My workflows run records',
        'start_time': 'Start',
        'end_time': 'End',
        'run_time': 'Run time',
        'used_credits': 'Used credits',
        'status': 'Status',
        'status_not_started': 'Not started',
        'status_queued': 'Queued',
        'status_running': 'Running',
        'status_finished': 'Finished',
        'status_failed': 'Failed',
        'status_stopping': 'Stopping',
        'status_stopped': 'Stopped',
        'check_record': 'Check record',
        'check_record_and_error_task': 'Check record and error task',
        'workflow_title': 'Workflow title',
        'version': 'Version',
      },
      vueFlowStyleSettings: {
        'title': 'Style Settings',
        'edge_type': 'Edge type',
        'edge_type_bezier': 'Bezier',
        'edge_type_step': 'Step',
        'edge_type_smoothstep': 'Smoothstep',
        'edge_type_straight': 'Straight',
        'edge_animated': 'Edge animated',
      },
      agentInvokeDataEdit: {
        'agent_invoke': 'Agent invoke',
        'tool_name': 'Tool name',
        'tool_name_required': 'Tool name required',
        'tool_name_tip': 'Can be understood as the function name of the workflow, which can only be numbers, letters, underscores, and hyphens, no more than 64 characters.',
        'tool_name_placeholder': 'Please enter the tool name, which can only be numbers, letters, underscores, and hyphens.',
        'tool_name_error': 'Tool name can only be numbers, letters, underscores, and hyphens, no more than 64 characters',
        'tool_description': 'Tool description',
        'tool_description_tip': 'Used to let AI recognize the function of the tool. The function of the tool should be described as clearly and concisely as possible, especially the input and output.',
        'tool_description_placeholder': 'Please enter a tool description to let the AI recognize the function of the tool.',
        'parameters': 'Parameters',
        'parameter_name': 'Parameter name',
        'parameter_description': 'Parameter description',
        'parameter_required': 'Parameter required',
      },
      avatarUpload: {
        'uploader_text': 'Upload avatar',
      },
      tagManage: {
        'title': 'Tag management',
        'color': 'Color',
        'delete_tag_confirm': 'Confirm to delete the tag?',
      },
    },
    codeEditorModal: {
      'title': 'Code editor',
      'please_enter_code': 'Please enter the code, the function name is fixed to main, and the input parameters should be consistent with the set name.',
      'copy_code': 'Copy code',
      'copy_success': 'Copy success',
    },
    templateEditorModal: {
      'title': 'Template editor',
      'variable_fields': 'Variables',
      'template': 'Template',
      'drag_to_insert': 'Click or drag to insert',
      'format_fields': 'Format fields',
      'format_fields_tip': 'Quickly use XML tags to format and fill in the template with variable fields',
    },
    nodes: {
      common: {
        'input': 'Input',
        'output': 'Output',
      },
      baseNode: {
        'document_link': 'Document link',
        'clone_node': 'Clone node',
        'ignore_node': 'Ignore node',
        'ignore_node_tip': 'After ignoring the node, the node will remain on the canvas, but will not affect the workflow run.',
        'remove_ignore': 'Remove ignore, restore node',
        'delete_node': 'Delete node',
        'run_time': 'Run time {time}s',
        'no_run_record': 'No run record',
        'view_node_help_document': 'Quickly view node help documents',
      },
      baseField: {
        'show_in_use_interface': 'Whether to display in the use interface',
        'show': 'Show',
        'hide': 'Hide',
        'show_field_info': 'Show field info',
        'field_info': 'Field info',
        'data_type': 'Data type',
        'field_value': 'Field value',
      },
      listField: {
        'add_item': 'Add item',
      },
      assistedNodes: {
        'title': 'Assisted nodes',
        CommentNode: {
          'title': 'Comment node',
          'description': 'Used to add comments, will not have any effect on the workflow run.',
          'comment': 'Comment',
        },
      },
      fileProcessing: {
        'title': 'File processing',
        FileLoader: {
          'title': 'Read File',
          'description': 'Read the contents of the file.',
          'files': 'File',
          'remove_image': 'Remove image',
          'remove_url_and_email': 'Remove url and email',
          'output': 'Output',
        },
        FileUpload: {
          'title': 'Select File',
          'description': 'Select a local file and get the file path.',
          'files': 'File',
          'output': 'File path',
        },
      },
      textProcessing: {
        title: 'Text processing',
        TemplateCompose: {
          'title': 'Template compose',
          'description': 'Compose the text according to the template.',
          'template': 'Template',
          'output': 'Output',
          'add_field': 'Add field',
          'add_field_type': 'Add field type',
          'field_type_input': 'Single line input box',
          'field_type_textarea': 'Multi-line input box',
          'field_type_select': 'List selection input',
          'add_field_display_name': 'Display name',
          'add_field_list_options': 'List options',
          'click_to_add_to_template': 'Click to add variables to the template',
          'open_template_editor': 'Open template editor',
          'edit_field': 'Edit field',
          'name_reserved': 'template/output is a reserved keyword and cannot be used as a variable name.',
        },
        MarkdownToHtml: {
          'title': 'Markdown to HTML',
          'description': 'Convert Markdown to HTML.',
          'markdown': 'Markdown',
          'html': 'HTML',
        },
        TextSplitters: {
          'title': 'Text splitters',
          'description': 'Split the text into multiple texts according to the specified method.',
          'text': 'Text',
          'split_method': 'Split method',
          'split_method_general': 'General',
          'split_method_delimiter': 'Delimiter',
          'split_method_markdown': 'Markdown',
          'delimiter': 'Delimiter',
          'chunk_length': 'Chunk length',
          'chunk_overlap': 'Chunk overlap',
          'output': 'Output',
        },
        ListRender: {
          'title': 'List render',
          'description': 'Render the list into text.',
          'list': 'List',
          'add_item': 'Add item',
          'separator': 'Merge item separator',
          'output_type': 'Output port format',
          'output_type_text': 'Text',
          'output_type_list': 'List',
          'output': 'Output',
        },
        TextInOut: {
          'title': 'Simple Input',
          'description': 'Output the input text as it is. Used when the same text is needed in multiple places.',
          'text': 'Text',
          'input_type': 'Input type',
          'input_type_text': 'Text',
          'input_type_number': 'Number',
          'edit_name': 'Edit display name',
          'output': 'Output',
        },
        TextTruncation: {
          'title': 'Text truncation',
          'description': 'Truncate the text to the specified length.',
          'text': 'Text',
          'truncate_method': 'Truncate method',
          'truncate_method_general': 'General truncation',
          'truncate_method_markdown': 'Markdown truncation',
          'truncate_length': 'Truncate length',
          'floating_range': 'Floating range',
          'output': 'Output',
        },
      },
      llms: {
        title: 'Language models',
        common: {
          'use_function_call': 'Use function call',
          'functions': 'Functions',
          'function_call_mode': 'Function call mode',
          'add_function': 'Add function',
          'function_name': 'Function name',
          'function_description': 'Function description',
          'function_parameters': 'Function parameters',
          'function_required_parameters': 'Required parameters',
          'add_parameter': 'Add parameter',
          'parameter_name': 'Name',
          'parameter_description': 'Description',
          'parameter_type': 'Type',
          'response_format': 'Response format',
          'array_configuration_mode': 'Array configuration mode',
          'array_configuration_mode_simple': 'Simple configuration',
          'array_configuration_mode_manual': 'Manual configuration',
          'array_items_type': 'Array items type',
          'array_items_manual_schema': 'Items JSON Schema',
          'array_items_manual_schema_error': 'Items JSON Schema error',
          'object_items_manual_schema': 'Object JSON Schema',
          'object_items_manual_schema_error': 'Object JSON Schema error',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
          'function_call_output': 'Function call output',
          'function_call_arguments': 'Function call arguments',
        },
        OpenAI: {
          'title': 'OpenAI',
          'description': 'OpenAI\'s GPT model is a powerful natural language processing AI that understands and generates human language.',
          'use_function_call': 'Use function call',
          'functions': 'Functions',
          'function_call_mode': 'Function call mode',
          'add_function': 'Add function',
          'function_name': 'Function name',
          'function_description': 'Function description',
          'function_parameters': 'Function parameters',
          'function_required_parameters': 'Required parameters',
          'add_parameter': 'Add parameter',
          'parameter_name': 'Name',
          'parameter_description': 'Description',
          'parameter_type': 'Type',
          'response_format': 'Response format',
          'response_format_text': 'Text',
          'response_format_json_object': 'JSON Object',
          'array_configuration_mode': 'Array configuration mode',
          'array_configuration_mode_simple': 'Simple configuration',
          'array_configuration_mode_manual': 'Manual configuration',
          'array_items_type': 'Array items type',
          'array_items_manual_schema': 'Items JSON Schema',
          'array_items_manual_schema_error': 'Items JSON Schema error',
          'object_items_manual_schema': 'Object JSON Schema',
          'object_items_manual_schema_error': 'Object JSON Schema error',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
          'function_call_output': 'Function call output',
          'function_call_arguments': 'Function call arguments',
        },
        ChatGLM: {
          'title': 'ChatGLM',
          'description': 'ChatGLM series models, through the injection of code pre-training, supervised fine-tuning and other technologies to align human intentions, with question and answer, multi-round dialogue, code generation and other capabilities.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        MiniMax: {
          'title': 'MiniMax',
          'description': 'MiniMax is an end-to-end multimodal large language model developed by MiniMax.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        BaiduWenxin: {
          'title': 'Baidu Wenxin',
          'description': 'Baidu\'s new generation of knowledge-enhanced large language model, a new member of the Wenxin large model family, can interact with people, answer questions, assist in creation, and efficiently and conveniently help people obtain information, knowledge and inspiration.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        AliyunQwen: {
          'title': 'Qwen',
          'description': 'Qwen is a large-scale pre-training model launched by Alibaba DAMO Academy. The model is based on the Transformer Decoder-only structure and is trained on large-scale global Internet data.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Baichuan: {
          'title': 'Baichuan',
          'description': 'Baichuan2-53B large model, which integrates intent understanding, information retrieval and reinforcement learning technology, and combines supervised fine-tuning with human intent alignment, has outstanding performance in knowledge Q&A and text creation.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Claude: {
          'title': 'Claude',
          'description': 'Claude is a large language model developed by Antropic, trained to give helpful and harmless responses.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Gemini: {
          'title': 'Gemini',
          'description': 'Gemini is Google\'s latest family of large language models.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Moonshot: {
          'title': 'Moonshot',
          'description': 'Moonshot is a 100 billion parameter-level large model of "MoonShot AI" company.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        LingYiWanWu: {
          'title': 'Yi Model',
          'description': 'Yi Model',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Stepfun: {
          'title': 'Stepfun',
          'description': 'Stepfun model',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Deepseek: {
          'title': 'Deepseek',
          'description': 'Deepseek',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        Groq: {
          'title': 'Groq',
          'description': 'Groq is the AI infrastructure company that delivers fast AI inference.',
          'prompt': 'Prompt',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
        LocalLlm: {
          'title': 'Local LLM',
          'description': 'User-defined large language model interface',
          'prompt': 'Prompt',
          'model_family': 'Model family',
          'llm_model': 'Model',
          'temperature': 'AI preference (temperature)',
          'creative': 'Creative',
          'balanced': 'Balanced',
          'precise': 'Precise',
          'output': 'Output',
        },
      },
      imageGeneration: {
        title: 'Image generation',
        StableDiffusion: {
          'title': 'Stable Diffusion',
          'description': 'Stable Diffusion is a deep learning text-to-image generation model released in 2022.',
          'provider': 'Provider',
          'provider_self-host': 'Self-host',
          'provider_stable-diffusion-official': 'Stable Diffusion Official',
          'prompt': 'Prompt',
          'negative_prompt': 'Negative prompt',
          'model': 'Model',
          'cfg_scale': 'CFG Scale',
          'sampler': 'Sampler',
          'width': 'Width',
          'height': 'Height',
          'size': 'Size',
          'aspect_ratio': 'Aspect ratio',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
        DallE: {
          'title': 'DALL·E',
          'description': 'OpenAI\'s most powerful image generation model. It can generate high-quality images with complex details based on the user\'s recent prompt words.',
          'prompt': 'Prompt',
          'model': 'Model',
          'size': 'Size',
          'quality': 'Quality',
          'style': 'Style',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
      },
      mediaEditing: {
        title: 'Media Editing',
        ImageEditing: {
          'title': 'Image Editing',
          'description': 'Used for basic image editing such as cropping, scaling, rotating, etc.',
          'input_image': 'Input Image',
          'crop': 'Crop',
          'group_crop': 'Crop Settings',
          'crop_method': 'Crop Method',
          'crop_method_proportional': 'Proportional Cropping',
          'crop_method_fixed': 'Fixed Cropping',
          'crop_width_ratio': 'Crop Width Ratio',
          'crop_height_ratio': 'Crop Height Ratio',
          'crop_position': 'Crop Position',
          'crop_position_center': 'Center',
          'crop_position_top_left': 'Top Left',
          'crop_position_top': 'Top',
          'crop_position_top_right': 'Top Right',
          'crop_position_right': 'Right',
          'crop_position_bottom_right': 'Bottom Right',
          'crop_position_bottom': 'Bottom',
          'crop_position_bottom_left': 'Bottom Left',
          'crop_position_left': 'Left',
          'crop_position_absolute': 'Absolute Position',
          'crop_x': 'X-Coordinate of Crop Origin',
          'crop_y': 'Y-Coordinate of Crop Origin',
          'crop_width': 'Crop Width',
          'crop_width_tip': 'If the crop width is 0, the width is the original image width',
          'crop_height': 'Crop Height',
          'crop_height_tip': 'If the crop height is 0, the height is the original image height',
          'scale': 'Scale',
          'group_scale': 'Scale Settings',
          'scale_method': 'Scaling Method',
          'scale_method_proportional_scale': 'Proportional Scaling',
          'scale_method_fixed_width_height': 'Fixed Width and Height Scaling',
          'scale_ratio': 'Scaling Ratio',
          'scale_width': 'Scaled Width',
          'scale_width_tip': 'When set to 0, the height scales proportionally.',
          'scale_height': 'Scaled Height',
          'scale_height_tip': 'When set to 0, the width scales proportionally.',
          'compress': 'Compress',
          'compress_tip': 'A compression value of 100 indicates no compression, and the smaller the compression value, the greater the compression ratio.',
          'rotate': 'Rotate',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
        ImageBackgroundRemoval: {
          'title': 'Image BG Removal',
          'description': 'Remove the background of the image to achieve the effect of isolating the main object.',
          'input_image': 'Input Image',
          'remove_background_method': 'Remove background method',
          'remove_background_method_fast': 'Fast',
          'remove_background_method_accurate': 'Accurate',
          'remove_background_method_portrait': 'Portrait',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
        ImageWatermark: {
          'title': 'Image Watermark',
          'description': 'Used for adding watermarks to images.',
          'input_image': 'Input Image',
          'opacity': 'Opacity',
          'image_or_text': 'Image or Text',
          'image_or_text_image': 'Image',
          'image_or_text_text': 'Text',
          'watermark_image': 'Watermark Image',
          'watermark_image_width_ratio': 'Watermark Image Width Ratio',
          'watermark_image_width_ratio_tip': 'When set to 0, it is automatically calculated according to the watermark image height ratio',
          'watermark_image_height_ratio': 'Watermark Image Height Ratio',
          'watermark_image_height_ratio_tip': 'When set to 0, it is automatically calculated according to the watermark image width ratio',
          'watermark_text': 'Watermark Text',
          'watermark_text_font': 'Watermark Text Font',
          'watermark_text_font_source_han_sans_sc': 'Source Han Sans - Simplified Chinese',
          'watermark_text_font_source_han_sans_tc': 'Source Han Sans - Traditional Chinese',
          'watermark_text_font_source_han_sans_jp': 'Source Han Sans - Japanese',
          'watermark_text_font_source_han_sans_kr': 'Source Han Sans - Korean',
          'watermark_text_font_you_she_biao_ti_hei': 'You She Title Black',
          'watermark_text_font_zi_hun_bian_tao_ti': 'Zi Hun Bian Tao Ti',
          'watermark_text_font_ckt_king_kong': 'Chuangketie King Kong',
          'watermark_text_font_douyin_sans': 'Douyin Sans',
          'watermark_text_font_alimama_dong_fang_da_kai': 'Alimama Oriental Great Kai',
          'watermark_text_font_inter': 'Inter',
          'watermark_text_font_custom': 'Custom Font',
          'watermark_text_font_size': 'Watermark Text Font Size',
          'watermark_text_font_color': 'Watermark Text Font Color',
          'position': 'Watermark Position',
          'position_center': 'Center',
          'position_top_left': 'Top Left',
          'position_top': 'Top',
          'position_top_right': 'Top Right',
          'position_right': 'Right',
          'position_bottom_right': 'Bottom Right',
          'position_bottom': 'Bottom',
          'position_bottom_left': 'Bottom Left',
          'position_left': 'Left',
          'vertical_gap': 'Vertical Edge Spacing',
          'horizontal_gap': 'Horizontal Edge Spacing',
          'output_type': 'Output Port Format',
          'output_type_only_link': 'Only Link Text',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
      },
      outputs: {
        title: 'Outputs',
        Text: {
          'title': 'Text',
          'description': 'Used to present text in the user interface.',
          'text': 'Text content',
          'output_title': 'Text title',
          'output_title_tip': 'Used to distinguish modules in the use interface',
          'render_markdown': 'Render Markdown',
          'output': 'Output',
        },
        Email: {
          'title': 'Email',
          'description': 'Used to send emails.',
          'to_email': 'To email',
          'subject': 'Subject',
          'content_html': 'Content HTML',
          'attachments': 'Attachments',
        },
        Document: {
          'title': 'Document',
          'description': 'Used to generate documents.',
          'file_name': 'File name',
          'content': 'Content',
          'export_type': 'Export type',
          'output_type': 'Output port format',
          'output_type_only_path': 'Only path',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'show_local_file': 'Show local file',
          'output': 'Output',
        },
        Audio: {
          'title': 'Audio',
          'description': 'Used to generate audio files.',
          'content': 'Content',
          'show_player': 'Show player',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'show_local_file': 'Show local file',
          'output': 'Output',
        },
        Mindmap: {
          'title': 'Mindmap',
          'description': 'Used to generate mind maps.',
          'content': 'Markdown content',
          'show_mind_map': 'Show mind map',
          'output_type': 'Output port format',
          'output': 'Output',
        },
        Mermaid: {
          'title': 'Mermaid',
          'description': 'Used to generate Mermaid diagrams.',
          'content': 'Mermaid content',
          'show_mermaid': 'Show Mermaid diagram',
          'output_type': 'Output port format',
          'output': 'Output',
        },
        Echarts: {
          'title': 'Charts',
          'description': 'Used to generate Echarts charts.',
          'option': 'Echarts option',
          'show_echarts': 'Show Echarts',
          'output_type': 'Output port format',
          'output': 'Output',
        },
        Table: {
          'title': 'Table',
          'description': 'Used to display tables.',
          'content': 'File link / Table content',
          'bordered': 'Show border',
          'show_table': 'Show table',
          'content_type': 'Content type',
          'content_type_file': 'File',
          'content_type_csv': 'CSV',
          'content_type_json': 'JSON',
          'output': 'Output',
        },
        PictureRender: {
          'title': 'Picture Render',
          'description': 'Used to render certain content as an image, such as rendering PDF into images.',
          'render_type': 'Render type',
          'content': 'Content',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
        WorkflowInvokeOutput: {
          'title': 'Workflow invoke output',
          'description': 'Used to display the output when called by the workflow invoke node, not displayed in the use interface.',
          'value': 'Value',
          'display_name': 'Display name',
        },
        Audio: {
          'title': 'Audio',
          'description': 'Used to generate audio files, which can realize functions such as text-to-speech and playing audio files.',
          'audio_type': 'Audio type',
          'audio_type_text_to_speech': 'Text to speech',
          'audio_type_play_audio': 'Play audio',
          'content': 'Content',
          'tts_provider': 'TTS provider',
          'tts_model': 'TTS model',
          'tts_voice': 'TTS voice',
          'file_link': 'File link',
          'direct_play': 'Direct play',
          'show_player': 'Show player',
          'output_type': 'Output port format',
          'output_type_only_link': 'Only link',
          'output_type_markdown': 'Markdown',
          'output_type_html': 'HTML',
          'output': 'Output',
        },
        Html: {
          'title': 'HTML',
          'description': 'Display the page result after HTML rendering.',
          'html_code': 'HTML code',
          'output': 'Output',
        },
      },
      webCrawlers: {
        title: 'Web crawlers',
        TextCrawler: {
          'title': 'Text crawler',
          'description': 'Used to crawl text from web pages.',
          'url': 'URL',
          'output_type': 'Output port format',
          'text': 'Text',
          'json': 'JSON',
          'use_oversea_crawler': 'Use crawler outside China',
          'output_text': 'Web page text',
          'output_title': 'Web page title',
        },
        BilibiliCrawler: {
          'title': 'Bilibili crawler',
          'description': 'Used to crawl videos from Bilibili.',
          'url_or_bvid': 'URL or BVID',
          'download_video': 'Download video',
          'output_type': 'Output port format',
          'output_type_str': 'String',
          'output_type_list': 'List',
          'str': 'String',
          'list': 'List',
          'output_subtitle': 'Subtitle',
          'output_title': 'Title',
          'output_video': 'Video',
        },
        YoutubeCrawler: {
          'title': 'Youtube ',
          'description': 'Used to crawl videos from youtube.',
          'url_or_video_id': 'URL or video ID',
          'get_comments': 'Get comments',
          'comments_type': 'Comments output format',
          'comments_type_text_only': 'Text only',
          'comments_type_detailed': 'Detailed',
          'output_type': 'Output port format',
          'str': 'String',
          'list': 'List',
          'output_subtitle': 'Subtitle',
          'output_title': 'Title',
          'output_comments': 'Comments',
        },
      },
      triggers: {
        title: 'Triggers',
        ButtonTrigger: {
          'title': 'Button trigger',
          'description': 'Used to trigger workflow runs. As a special node, it can be used without connecting to other nodes.',
          'button_text': 'Button text',
          'run': 'Run',
          'output': 'Output',
        },
        ScheduleTrigger: {
          'title': 'Scheduled Trigger',
          'description': 'Used to trigger workflow runs at specified times.',
          'schedule': 'Schedule',
          'schedule_settings': 'Schedule settings',
          'save_schedule_settings': 'Save schedule settings',
          'output': 'Output',
        },
      },
      vectorDb: {
        title: 'Vector database',
        AddData: {
          'title': 'Add data',
          'description': 'Used to add data to the vector database.',
          'text': 'Text',
          'content_title': 'Title',
          'source_url': 'Source URL',
          'data_type': 'Data type',
          'database': 'Database',
          'split_method': 'Split method',
          'split_method_general': 'General',
          'split_method_delimiter': 'Delimiter split',
          'split_method_markdown': 'Markdown split',
          'split_method_table': 'Table split',
          'chunk_length': 'Chunk length',
          'chunk_overlap': 'Chunk overlap',
          'delimiter': 'Delimiter',
          'remove_url_and_email': 'Remove URL and email',
          'wait_for_processing': 'Wait for processing to complete',
          'output': 'Output',
          'object_id': 'Object ID',
        },
        DeleteData: {
          'title': 'Delete data',
          'description': 'Used to delete data from the vector database.',
          'object_id': 'Object ID',
          'database': 'Database',
          'delete_success': 'Delete success',
        },
        Search: {
          'title': 'Search data',
          'description': 'Used to search for data in the vector database. The search results are sorted by similarity.',
          'search_text': 'Search text',
          'data_type': 'Data type',
          'database': 'Database',
          'count': 'Search results count',
          'output_type': 'Output port format',
          'text': 'Text',
          'list': 'List',
          'output': 'Output',
        },
      },
      relationalDb: {
        title: 'Relational Database',
        SmartQuery: {
          'title': 'Smart Query',
          'description': 'Use natural language to query the database.',
          'query': 'Query Content',
          'model': 'LLM Model',
          'database': 'Database',
          'tables': 'Tables',
          'load_tables': 'Load Tables',
          'select_all_if_empty': 'If empty, select all tables in the database. It is recommended to only select the necessary tables for more accurate results.',
          'select_database': 'Please Select Database',
          'use_sample_data': 'Use Sample Data',
          'use_sample_data_tip': 'Check this option to provide a table data as a prompt content, which is convenient for AI to refer to the data format. Although it increases the length of the prompt, it can obtain more accurate results.',
          'include_column_names': 'Include Column Names',
          'include_column_names_tip': 'When enabled, the output will include column names',
          'max_count': 'Maximum Return Quantity',
          'output_type': 'Output port format',
          'output_type_list': 'List',
          'output_type_markdown': 'Markdown Table',
          'output_type_csv': 'CSV Format Text',
          'output': 'Output',
          'output_query_sql': 'SQL query statement',
        },
        GetTableInfo: {
          'title': 'Get Table Information',
          'description': 'Used to obtain information about database tables.',
          'database': 'Database',
          'tables': 'Tables',
          'load_tables': 'Load Tables',
          'select_all_if_empty': 'If empty, select all tables in the database. It is recommended to only select the necessary tables for more accurate results.',
          'select_database': 'Please Select Database',
          'output_sql': 'SQL Output',
          'output_sql_tip': 'Output the table structure in CREATE TABLE statement',
          'output_json': 'JSON Output',
          'output_markdown': 'Markdown Output',
        },
        RunSql: {
          'title': 'Run SQL',
          'description': 'Used to run SQL statements within the user\'s own database.',
          'database': 'Database',
          'sql': 'SQL Statement',
          'read_only': 'Read-Only Operation',
          'read_only_tip': 'When enabled, no modifications will be made to the database tables',
          'include_column_names': 'Include Column Names',
          'include_column_names_tip': 'When enabled, the output will include column names',
          'max_count': 'Maximum Return Quantity',
          'output_type': 'Output port format',
          'output_type_list': 'List',
          'output_type_markdown': 'Markdown Table',
          'output_type_csv': 'CSV Format Text',
          'output': 'Output',
        },
      },
      tools: {
        title: 'Tools',
        ProgrammingFunction: {
          'title': 'Programming function',
          'description': 'Used to run code.',
          'language': 'Language',
          'code': 'Code',
          'open_editor': 'Open code editor',
          'add_parameter': 'Add parameter',
          'add_parameter_type': 'Parameter type',
          'parameter_name_reserved': 'language/code/output/use_oversea_node/list_input/error_msg are reserved keywords and cannot be used as parameter names.',
          'parameter_type_str': 'String',
          'parameter_type_int': 'Integer',
          'parameter_type_float': 'Float',
          'parameter_type_bool': 'Boolean',
          'parameter_type_list': 'List',
          'parameter_type_dict': 'Dict',
          'add_parameter_name': 'Parameter name',
          'use_oversea_node': 'Use node outside China',
          'list_input': 'List input',
          'output': 'Return value',
          "console_msg": "Console message",
          'error_msg': 'Error message',
          'files': 'Generated files',
        },
        ImageSearch: {
          'title': 'Image search',
          'description': 'Used to search for images on the Internet.',
          'search_text': 'Search text',
          'search_engine': 'Search engine',
          'search_engine_bing': 'Bing',
          'search_engine_pexels': 'Pexels',
          'count': 'Search results count',
          'output_type': 'Output port format',
          'output_type_text': 'Text',
          'output_type_markdown': 'Markdown',
          'output': 'Output',
        },
        WorkflowInvoke: {
          'title': 'Workflow invoke',
          'description': 'Used to invoke the workflow and get the result.',
          'select_workflow': 'Select workflow',
          'selected_workflow': 'Selected workflow',
          'workflow_id': 'Workflow ID',
          'fail_all': 'If this node fails, the entire workflow fails',
          'list_input': 'List input',
          'workflow_fields': 'Workflow fields',
        },
        Screenshot: {
          'title': 'Screenshot',
          'description': 'Used to capture screen content.',
          'monitor_number': 'Monitor number',
          'output_type': 'Output port format',
          'output_type_base64': 'Base64',
          'output_type_file_path': 'File path',
          'output': 'Output',
        },
        TextSearch: {
          'title': 'Text Search',
          'description': 'Used to search for text on the Internet.',
          'search_text': 'Search text',
          'search_engine': 'Search engine',
          'search_engine_bing': 'Bing',
          'search_engine_duckduckgo': 'Duckduckgo',
          'count': 'Search results count',
          'combine_result_in_text': 'Combine search results into a single text',
          'max_snippet_length': 'Maximum snippet length',
          'output_type': 'Output port format',
          'output_type_text': 'Text',
          'output_type_markdown': 'Markdown',
          'output_page_title': 'Page title',
          'output_page_url': 'Page URL',
          'output_page_snippet': 'Page snippet',
        },
      },
      controlFlows: {
        title: 'Control flows',
        Empty: {
          'title': 'Empty node',
          'description': 'Used in cases where it is necessary to ensure that the workflow is executed in order.',
          'input': 'Input',
          'output': 'Output (does not change the value of the connected node)',
        },
        Conditional: {
          'title': 'Conditional',
          'description': 'Used to execute different modules according to different conditions.',
          'field_type': 'Data type',
          'field_type_string': 'String',
          'field_type_number': 'Number',
          'left_field': 'Left data',
          'right_field': 'Right data',
          'operator': 'Condition judgment operator',
          'operator_equal': 'Equal',
          'operator_not_equal': 'Not equal',
          'operator_greater_than': 'Greater than',
          'operator_less_than': 'Less than',
          'operator_greater_than_or_equal': 'Greater than or equal',
          'operator_less_than_or_equal': 'Less than or equal',
          'operator_include': 'Left include right',
          'operator_not_include': 'Left not include right',
          'operator_is_empty': 'Is empty',
          'operator_is_not_empty': 'Is not empty',
          'operator_starts_with': 'Left starts with right',
          'operator_ends_with': 'Left ends with right',
          'true_output': 'Output when the condition is met',
          'false_output': 'Output when the condition is not met',
          'output': 'Output',
        },
        RandomChoice: {
          'title': 'Random choice',
          'description': 'Used to randomly select an element from a list.',
          'input': 'Input',
          'output': 'Output',
        },
        JsonProcess: {
          'title': 'JSON process',
          'description': 'Used to process JSON or Python dictionary data.',
          'input': 'Input',
          'process_mode': 'Process mode',
          'process_mode_get_value': 'Get value by Key',
          'process_mode_get_multiple_values': 'Get multiple values by Keys',
          'process_mode_list_values': 'List all values',
          'process_mode_list_keys': 'List all keys',
          'key': 'Key',
          'keys': 'Keys',
          'add_key': 'Add key',
          'edit_key': 'Edit key',
          'default_value': 'Default value (when Key does not exist)',
          'output': 'Output',
        },
        WorkflowLoop: {
          'title': 'Workflow Loop',
          'description': 'Used to loop execution of workflows.',
          'select_workflow': 'Select workflow',
          'selected_workflow': 'Selected workflow',
          'workflow_id': 'Workflow ID',
          'fail_all': 'If this node fails, the entire workflow fails',
          'list_input': 'List input',
          'workflow_fields': 'Workflow fields',
          'workflow_fields_initial_values': 'Initial values',
          'workflow_fields_assignment_in_loop': 'Assignment in loop',
          'constant': 'Constant',
          'input_field': 'Input field',
          'output_field': 'Output field last loop',
          'output_field_cumulative': 'Output field cumulative',
          'output_field_cumulative_tip': 'Accumulate the output results of previous loops, separated by line breaks',
          'loop_count': 'Loop count',
          'max_loop_count': 'Max loop count',
          'source': 'Source',
          'value': 'Value',
          'source_input_field': 'Source input field',
          'source_output_field': 'Source output field',
          'loop_end_condition': 'Loop end condition',
          'loop_end_condition_loop_count': 'Loop count',
          'loop_end_condition_output_field_condition': 'Output field condition',
          'loop_end_condition_extra_workflow_judgement': 'Extra workflow judgement',
          'loop_end_condition_ai_model_judgement': 'AI model judgement',
          'output_field_condition_field': 'Condition field',
          'output_field_condition_operator': 'Condition judgment operator',
          'output_field_condition_operator_equal': 'Equal',
          'output_field_condition_operator_not_equal': 'Not equal',
          'output_field_condition_operator_greater_than': 'Greater than',
          'output_field_condition_operator_less_than': 'Less than',
          'output_field_condition_operator_greater_than_or_equal': 'Greater than or equal',
          'output_field_condition_operator_less_than_or_equal': 'Less than or equal',
          'output_field_condition_operator_include': 'Left include right',
          'output_field_condition_operator_not_include': 'Left not include right',
          'output_field_condition_operator_is_empty': 'Is empty',
          'output_field_condition_operator_is_not_empty': 'Is not empty',
          'output_field_condition_operator_starts_with': 'Left starts with right',
          'output_field_condition_operator_ends_with': 'Left ends with right',
          'output_field_condition_true_output': 'Output when the condition is met',
          'output_field_condition_false_output': 'Output when the condition is not met',
          'output_field_condition_value': 'Condition value',
          'judgement_model': 'Judgement model',
          'judgement_prompt': 'Judgement prompt',
          'judgement_end_output': 'Judgement end output',
          'judgement_end_output_tip': 'The loop ends when the model outputs this value',
        },
      },
      mediaProcessing: {
        title: 'Multimodal',
        GptVision: {
          'title': 'GPT-Vision',
          'description': 'GPT with vision, allowing the model to receive images and answer questions about them.',
          'text_prompt': 'Text prompt',
          'images_or_urls': 'Images or URLs',
          'images_or_urls_images': 'Images',
          'images_or_urls_urls': 'URLs',
          'images': 'Images',
          'urls': 'URLs',
          'model': 'Model',
          'detail_type': 'Detail type',
          'detail_type_auto': 'Auto',
          'detail_type_low': 'Low',
          'detail_type_high': 'High',
          'output': 'Output',
        },
        GlmVision: {
          'title': 'GLM-Vision',
          'description': 'Realized the deep fusion of visual language features, supporting various image understanding tasks such as visual question answering, image subtitles, visual positioning, and complex object detection.',
          'text_prompt': 'Text prompt',
          'images': 'Images',
          'urls': 'URLs',
          'model': 'Model',
          'images_or_urls': 'Images or URLs',
          'images_or_urls_images': 'Images',
          'images_or_urls_urls': 'URLs',
          'output': 'Output',
        },
        ClaudeVision: {
          'title': 'Claude-Vision',
          'description': 'Claude 3 series models have new visual capabilities, allowing Claude to understand and analyze images.',
          'text_prompt': 'Text prompt',
          'llm_model': 'Model',
          'images': 'Images',
          'urls': 'URLs',
          'images_or_urls': 'Images or URLs',
          'images_or_urls_images': 'Images',
          'images_or_urls_urls': 'URLs',
          'output': 'Output',
        },
        GeminiVision: {
          'title': 'Gemini-Vision',
          'description': 'Gemini with vision, allowing the model to receive images and answer questions about them.',
          'text_prompt': 'Text prompt',
          'llm_model': 'Model',
          'images': 'Images',
          'urls': 'URLs',
          'images_or_urls': 'Images or URLs',
          'images_or_urls_images': 'Images',
          'images_or_urls_urls': 'URLs',
          'output': 'Output',
        },
        LocalVision: {
          'title': 'Local multimodal',
          'description': 'Local multimodal model.',
          'text_prompt': 'Text prompt',
          'model_family': 'Model family',
          'llm_model': 'Model',
          'images': 'Images',
          'urls': 'URLs',
          'images_or_urls': 'Images or URLs',
          'images_or_urls_images': 'Images',
          'images_or_urls_urls': 'URLs',
          'output': 'Output',
        },
        SpeechRecognition: {
          'title': 'Speech Recognition',
          'description': 'Used to convert speech to text.',
          'engine': 'ASR Engine',
          'files_or_urls': 'File or URL',
          'files_or_urls_files': 'Files',
          'files_or_urls_urls': 'URLs',
          'files': 'Files',
          'urls': 'URLs',
          'output_type': 'Output port format',
          'output_type_text': 'Text',
          'output_type_list': 'List',
          'output_type_srt': 'SRT Subtitle',
          'output': 'Output',
        },
      },
    },
    copyButton: {
      'click_to_copy': 'Click to copy',
      'copy_success': 'Copy success',
    },
    inputSearch: {
      input_search_text: 'Search',
    },
    help: {
      documentModal: {
        'load_error': 'Load failed',
      },
      logModal: {
        'load_error': 'Load failed',
        'auto_refresh': 'Auto refresh',
        'stop_refresh': 'Stop refresh',
      },
    },
  },
  layouts: {
    workspaceLayout: {
      tour: {
        'workflow_button_title': 'Switch to workflow interface',
        'workflow_button_description': 'Click this button to switch to the workflow interface. Your workflows and official templates can be found here.',
        'database_button_title': 'Switch to database interface',
        'database_button_description': 'Click this button to switch to the database interface. You can create your personal knowledge base here and upload your data for use in workflows.',
      },
      initial_setup: 'Initial setup',
      domain_tip: 'It is recommended that users outside of China use vectorvein.ai.',
      setting_tip1: 'If you need to use AI-related functions, be sure to configure the relevant information of the large language model in the settings in the upper right corner.',
      setting_tip2: 'Different workflows/Agents may use different large language models. If you only use certain specific models, it is recommended to check and configure the model you use before running the workflow or using the Agent.',
    },
  },
  settings: {
    'endpoints': 'API Endpoints',
    'llms': 'Remote LLMs',
    'other': 'Other',
    'open': 'Open setting',
    'close': 'Close setting',
    'save': 'Save setting',
    'save_success': 'Save success',
    'my_setting': 'My setting',
    'openai_api_type': 'OpenAI API type',
    'openai': 'OpenAI',
    'azure': 'Azure',
    'openai_api_key': 'OpenAI API Key',
    'openai_api_base': 'OpenAI API Base',
    'deployment_id': 'Deployment ID',
    'chatglm6b_api_base': 'ChatGLM-6B API Base',
    'moonshot_api_base': 'Moonshot API Base',
    'moonshot_api_key': 'Moonshot API Key',
    'zhipuai': 'ZhiPu AI',
    'anthropic_api_base': 'Anthropic API Base',
    'anthropic_api_key': 'Anthropic API Key',
    'qwen': 'Qwen',
    'lingyiwanwu': 'Yi',
    'baichuan': 'Baichuan',
    'local_llms': 'Local LLMs',
    'custom_llms': 'Custom LLMs',
    'model_family_api_base': 'Model family API Base',
    'model_family_api_key': 'Model family API Key',
    'model_family': 'Model family name',
    'models': 'Models',
    'model_label': 'Model label',
    'model_id': 'Model ID',
    'model_id_tip': 'Model ID is the ID of the model when it is actually deployed. Generally, it is consistent with the model Key, but in cases such as Azure OpenAI and Anthropic on Vertex, the model ID and model Key are inconsistent and need to be set separately.',
    'model_key': 'Model Key',
    'model_key_tip': 'Model Key is the unique identifier of the model family, usually consistent with the official identifier.',
    'model_rpm': 'RPM',
    'model_concurrent': 'Concurrency',
    'model_max_tokens': 'Context length',
    'model_function_calling': 'Function calling',
    'model_native_multimodal': 'Native multimodal',
    'model_response_format_available': 'Response format',
    'add_model_family': 'Add model family',
    'add_model': 'Add model',
    'edit_model': 'Edit model',
    'save_model_family': 'Save model family',
    'output_folder': 'Output folder',
    'select_folder': 'Select folder',
    'email_settings': 'Email settings',
    'email_user': 'Email user',
    'email_password': 'Email password',
    'email_smtp_host': 'SMTP host',
    'email_smtp_port': 'SMTP port',
    'email_smtp_ssl': 'SMTP SSL',
    'pexels_api_key': 'Pexels API Key',
    'stable_diffusion_base_url': 'Stable Diffusion URL',
    'use_system_proxy': 'Use system proxy',
    'website_domain': 'Website domain',
    'log_path': 'Log folder',
    'data_path': 'Data folder',
    'agent_settings': 'Agent settings',
    'agent_auto_title': 'Auto title',
    'agent_auto_title_model': 'Title generation model',
    'agent_screenshot_monitor_device': 'Monitor number for screenshot',
    'agent_screenshot_monitor_device_question_popover': 'Called from hotkeys.',
    'microphone_device': 'Microphone device',
    'shortcut_settings': 'Shortcut settings',
    'error_start_shortcut_setting': 'Failed to set up shortcut key listening',
    'new_chat_with_agent': 'Start a new chat with Agent',
    'new_chat_with_agent_with_screenshot': 'Start a new chat with Agent (with screenshot)',
    'continue_chat_with_agent': 'Continue chatting with Agent',
    'continue_chat_with_agent_with_screenshot': 'Continue chatting with Agent (with screenshot)',
    'recording_using_shorcut_tip': 'When using a shortcut key to activate the Agent for microphone conversation, it will automatically detect the real-time speaking volume. If it determines that there has been no speech for a short period, it will automatically stop recording.',
    'toggle_recording': 'Press the shortcut key to start recording for the first time, and press it again to stop recording.',
    'waiting_for_combo_key': 'Waiting for combo key',
    'shortcut_not_set': 'Shortcut not set',
    'shortcut_conflict': 'Shortcut conflict, please check and modify (same or included): {key1} and {key2}',
    'embedding_models': 'Embedding models',
    'tts': 'Text-To-Speech',
    'web_search': 'Web search',
    'stability_key': 'Stability Key',
    'asr': 'Speech Recognition',
    'provider_for_asr': 'Speech Recognition Provider',
    'asr_openai_setting_same_as_llm': 'Same as the settings in the Language Models tab',
    'voices': 'Voices',
    'voice_label': 'Voice label',
    'voice_id': 'Voice ID',
    'add_endpoint': 'Add endpoint',
    'endpoint_id': 'Endpoint ID',
    'api_base': 'API Base',
    'api_key': 'API Key',
    'region': 'Region',
    'endpoint_name': 'Endpoint name',
    'save_endpoint': 'Save endpoint',
    'is_azure': 'Azure',
    'is_vertex': 'Vertex',
    'credentials': 'Credentials',
    'credentials_placeholder': 'Enter special credentials, such as Google credentials',
    'concurrent_requests': 'Concurrent requests',
    'select_endpoint': 'Select endpoint',
    'api_base_empty': 'API Base cannot be empty',
    'max_output_tokens': 'Max output tokens',
    'delete_model_family': 'Delete model family',
    'delete_model_family_confirm': 'Are you sure you want to delete {modelFamily} model family?',
    'edit_model_family_name': 'Edit model family name',
    'model_family_name_repeat': 'Model family name already exists',
    'list_models': 'List models',
    'settings_changed': 'Settings have changed, please save them.',
    'model_owned_by': 'Model owned by',
    'available_models': 'Available models',
    'add_to_custom_models': 'Add to custom models',
    'endpoint_id_empty': 'Endpoint ID cannot be empty',
    'select_all': 'Select all',
    'clear': 'Clear',
    'list_models_failed': 'Failed to get model list',
    'agent_tool_call_data_generate_model': 'Agent tool call data generation model',
    'skip_ssl_verification': 'Skip SSL verification',
  },
  voiceOptions: {
    "minimax_male-qn-qingse": "Youthful Male Voice",
    "minimax_male-qn-jingying": "Elite Young Male Voice",
    "minimax_male-qn-badao": "Dominant Young Male Voice",
    "minimax_male-qn-daxuesheng": "College Student Male Voice",
    "minimax_female-shaonv": "Young Female Voice",
    "minimax_female-yujie": "Mature Female Voice",
    "minimax_female-chengshu": "Mature Woman Voice",
    "minimax_female-tianmei": "Sweet Female Voice",
    "minimax_presenter_male": "Male Presenter",
    "minimax_presenter_female": "Female Presenter",
    "minimax_audiobook_male_1": "Male Audiobook Voice 1",
    "minimax_audiobook_male_2": "Male Audiobook Voice 2",
    "minimax_audiobook_female_1": "Female Audiobook Voice 1",
    "minimax_audiobook_female_2": "Female Audiobook Voice 2",
    "minimax_male-qn-qingse-jingpin": "Youthful Male Voice - Beta",
    "minimax_male-qn-jingying-jingpin": "Elite Young Male Voice - Beta",
    "minimax_male-qn-badao-jingpin": "Dominant Young Male Voice - Beta",
    "minimax_male-qn-daxuesheng-jingpin": "College Student Male Voice - Beta",
    "minimax_female-shaonv-jingpin": "Young Female Voice - Beta",
    "minimax_female-yujie-jingpin": "Mature Female Voice - Beta",
    "minimax_female-chengshu-jingpin": "Mature Woman Voice - Beta",
    "minimax_female-tianmei-jingpin": "Sweet Female Voice - Beta",
  },
}
