# 数据库内核杂谈（一）：一个小时实现一个基本功能的数据库

> 数据库内核博大精深，很多子系统的设计初看不知所云，但是细读就会发现其已经做到了极致。但是市面上很少有类似的资源或是教程把数据库内容的精髓讲解出来。

### 开篇词

#### 为啥想写这样一个系列？

最主要原因肯定是出于兴趣吧，自从接触了数据库内核开发，觉得里面真的是博大精深，很多子系统的设计初看不知所云，细读就发现已经做到了极致。然后特别希望有大牛能够深入浅出地把这些精髓讲解出来。但可惜，一直没有发现类似的资源或者课程（笔者虽然工作多年，但自觉还是比较注重积累，每天都关注科技新闻，技术博客甚至领域内的新的学术文章）。近期也看到有越来越多的付费培训，从算法到系统设计，到大数据，应有尽有，但唯独没有发现非常好的关于数据库内核设计的资源。自己当然没有实力可以去开那样一门课程，但我希望可以通过写blog来完善自己的知识储备。也希望读者能有所收获。不过想归想，自己从来没下定决心去做这样一件事，因为总是觉得自己积累还不够，还要准备云云。

#### 什么契机让你真正去行动了？

这契机真的是一个非常偶然的故事。上个周末的一天晚上，小葡萄（我最爱且仅爱的老婆大人）正在给我洗脸。感觉闲着也是闲着，加之正好下午刚讨论过SQL，我就半开玩笑地说，“老婆，你不是对数据库感兴趣吗？我给你讲讲数据库是怎么实现的，数据库是怎么去执行一个SQL语句的”。小葡萄：“你说呀，你能说得出来吗？”；“嘿，小看我，你听着哦。。。”然后我就吧啦吧啦地讲了大半个小时，用尽量通俗易懂的语言给老婆描述了数据库最初是怎么起源的；怎么去实现最基本的存储；有了存储，怎么去实现基本的数据读取；有了读取怎么去实现基本的数据操作，等等。听完，小葡萄真的是突然有种对我肃然起敬地感觉（极有可能是我自己的一厢情愿）。也正是小葡萄的支持，我决定，要真正去做这件想了很久却从未开始的事情。就像她说的，与其过多地去get ready but do nothing，还不如去实践一个不怎么ready的事！

#### 啥背景呀，就感写数据库内核

说真的，我自己也信心不足呢。说说背景（偶尔咱也知乎体一下）：咳咳，谢邀。本人上海交通大学软件学院本科毕业，University of California， Davis计算机博士毕业。现在在脸书做一个老年程序员。自己并不是算一个数据库的科班出身，博士学的也不是数据库专业。一个很偶然的机会，我得到了一份数据库公司Greenplum（Pivotal）的实习的机会，又阴长阳错地毕业后正式加入了Query Processing组。在Pivotal的两年，非常有幸地参与了Orca Query Optimizer（已在Apache开源）的开发。在这期间也混了几篇VLDB，SIGMOD的paper。正是这份工作让我开始对内核有所了解。再后来原Pivotal的director离开，开了个数据库虚拟化的初创公司就把我一起拉去了。这个初创公司做的也非常有趣，database virtualization：旨在不用改变application code的前提下（包括不用换JDBC，或者ODBC driver），就让application code可以直接运行在另一个数据库上（举个例子，Teradata BTEQ script可以直接通过我们的中间件，运行在Pivotal Greenplumn Database上），当时我们用的最多的简介就是VMWare in terms of databases。这份工作让我更细致地了解了不同数据库原生接口的不同以及如何rewrite不同的SQL dialect来使它们之间互相兼容，我觉得也算变相的query optimization吧。总的来说，自己对各个部件都有所了解，但知识点比较分散，不够系统，也希望在写blog的过程中去学习和完善知识储备。

#### 这个系列会分为哪几个模块？有没有大纲

真心觉得自己还不够格去系统地讲解数据库的各个模块。所以我才把这个系列的名称定为杂谈。咱们就暂不列什么提纲了，但我会把最核心的部件包括存储，SQL语言，数据优化器和执行器都cover了。然后我们也就能够自由发挥，分享一些我对NoSQL以及NewSQL的理解。在这个过程中，我也会去查最新的资料，在写的同时也能更好地去巩固和订正知识。

#### 阅读这个系列会有啥收获？

我希望能够深入浅出地去讲解数据库是一个什么样的系统，以及为什么它最后会演化成这样一个系统，为什么我们都用SQL来操作数据，而不是AQL或BQL。希望读者阅读后，对数据库的理解不再单单只是知道简单的table，row等的基本概念或者单单会写些join，select的SQL语句。而是能从源头真正做到知其所以然。希望能从对数据库系统的认知来进一步提高对general系统设计的认知。

虽然没有大纲，但是这篇的题目想好了：一个小时实现一个基本数据库。

#### 一个小时实现一个基本数据库



