# Resources

## Wikis
- [OS Dev Wiki](https://wiki.osdev.org/Expanded_Main_Page)
- [Lowlevel.eu](http://www.lowlevel.eu/wiki/Hauptseite)
  
## Specifications
- [UEFI Specification](https://uefi.org/sites/default/files/resources/UEFI%20Spec%202.8B%20May%202020.pdf)
- [SATA Specification](https://www.intel.com.au/content/dam/www/public/us/en/documents/technical-specifications/serial-ata-ahci-spec-rev1-3-1.pdf#zoom=100)
- [ACPI Specification](https://uefi.org/sites/default/files/resources/ACPI_6_3_final_Jan30.pdf)
- [Gnu-EFI](https://github.com/geneC/gnu-efi/tree/master/gnu-efi-3.0)
- [OVMF](https://github.com/tianocore/tianocore.github.io/wiki/OVMF)

## Tutorials
- [Little OS book](https://littleosbook.github.io/)
- [JamesM's kernel development tutorials](http://jamesmolloy.co.uk/tutorial_html/)
- [Operating Systems From 0 to 1](https://tuhdo.github.io/os01/)
- [Writing a Simple Operating System from Scratch](https://www.cs.bham.ac.uk/~exr/lectures/opsys/10_11/lectures/os-dev.pdf)

## Books
- [Modern Operating Systems](https://www.amazon.de/-/en/Andrew-S-Tanenbaum/dp/1292061421/ref=sr_1_1?dchild=1&keywords=Modern+Operating+systems&qid=1619088089&sr=8-1)
- [C++: Das umfassende Handbuch zu Modern C++](https://www.amazon.de/-/en/Torsten-T-Will/dp/3836275937/ref=sr_1_2?dchild=1&keywords=c%2B%2B+buch&qid=1619087992&sr=8-2)
- [Clean Code](https://www.amazon.de/-/en/Robert-Martin/dp/0132350882/ref=sr_1_1?dchild=1&keywords=clean+code&qid=1619088059&sr=8-1)

## Inspirations
- [SerenityOS](https://github.com/SerenityOS/serenity)
- [Linux](https://github.com/torvalds/linux)
- [SkiftOS](https://github.com/skiftOS/skift)
- [ReactOS](https://github.com/reactos/reactos)

## Other
- [Zap light 16 PSF Font](https://www.zap.org.au/projects/console-fonts-zap/)
- [PS/2 Mouse Interface](https://users.utcluj.ro/~baruch/sie/labor/PS2/PS-2_Mouse_Interface.htm)
- [How PCI express devices talk](http://xillybus.com/tutorials/pci-express-tlp-pcie-primer-tutorial-guide-1)
- [The PIT: A System Clock](http://www.osdever.net/bkerndev/Docs/pit.htm)