It has been a year since we made our first commit, and we are proud to look back on the significant progress we've achieved with AgnosUI. As we near the release of our 1.0 version, we want to provide you with a clearer vision of what’s ahead and share the exciting developments coming to our library.

## Tech Enablers

We are actively working on delivering our demo examples using Server-Side Rendering (SSR). This move aims to boost both performance and user experience (UX), ensuring smoother interactions and faster load times.

Our React demos are currently built using Vite, but we believe a more realistic setup is needed to better reflect real-world usage. To this end, we plan to migrate our React demo site to Tanstack Start, which will offer a more robust environment aligned with the production.

We’re committed to keeping AgnosUI up-to-date with the latest technology. As soon as React 19 and Angular 19 are officially released, we will ensure our library is fully compatible with these new versions, further improving performance and functionality.

In parallel, we are enhancing the performance of Tansu, our reactive state library. You can follow our ongoing progress [here](https://github.com/AmadeusITGroup/tansu/pull/139). We are also collaborating closely with TC39 to integrate similar signal features into future JavaScript implementations.

Key contributions to the signal proposal include: [issue 227](https://github.com/tc39/proposal-signals/issues/227), [issue 226](https://github.com/tc39/proposal-signals/issues/226), [PR 197](https://github.com/tc39/proposal-signals/pull/197)

## New Components on the Horizon

We have exciting plans to expand AgnosUI by adding a range of new components. Here’s a preview of what’s to come:

- Carousel (already in progress for version 0.6)
- Dropdown
- Select
- Tree (already in progress for version 0.6)
- Stepper
- SideNav
- Tabs
- ScrollSpy
- Tooltip
- Popover

## Documentation Enhancements

Additionally, we are assessing the right abstraction for date/time components and improving the functionality of current components. For example, we will add services to better manage Modal and Toast components, and explore the new native Popover API for improved performance.

We are committed to making AgnosUI as accessible and **user-friendly** as possible. Over the coming months, we will continue improving our **documentation**, with a focus on clarity, examples, and emphasizing the accessibility and usability of our components.

Expect to see a series of **blog** articles that highlight the unique value of our widget libraries, showing why AgnosUI is the best choice for your development needs.

To encourage **collaboration**, we will release a comprehensive guide for new **contributors**. This will make it easier for anyone to get involved in the development of AgnosUI.

We will provide detailed documentation on our **Navigation Manager Service**, which will help developers optimize user interactions and improve the overall experience.

Expect a thorough explanation of our **Intersection Service**, designed to efficiently manage elements within the viewport, enhancing performance.

We will clarify the **extension capabilities** of AgnosUI, providing insights into how you can extend the library and configure it to meet your specific needs.

To ensure transparency, we will also document our **release management process**, helping you stay informed about how we manage and release updates across multiple libraries.

## Conclusion

We are thrilled to share these updates with you and continue the journey toward AgnosUI’s first major release. Reflecting on the progress made this year, we can’t wait to showcase the full potential of AgnosUI. We hope you share our excitement, and we look forward to bringing you more updates soon. Stay tuned for further news about AgnosUI - Where components shine!
