import type {SampleInfo} from '$lib/layout/sample';

import focustrack from '@agnos-ui/samples/bootstrap/focustrack/focustrack';
import floatingUI from '@agnos-ui/samples/bootstrap/floatingUI/floatingUI';
import resizeObserver from '@agnos-ui/samples/bootstrap/resizeObserver/resizeObserver';
import slotsUsage from '@agnos-ui/samples/bootstrap/slots/usage';
import slotsContext from '@agnos-ui/samples/bootstrap/slots/context';
import alertsIcon from '@agnos-ui/samples/bootstrap/alert/icon';
import slotsHeadless from '@agnos-ui/samples/bootstrap/slots/headless';
import directivesUsage from '@agnos-ui/samples/bootstrap/directives/usage';
import configurationBasic from '@agnos-ui/samples/bootstrap/configuration/basic';
import configurationDown from '@agnos-ui/samples/bootstrap/configuration/down';
import transitionCollapse from '@agnos-ui/samples/bootstrap/transition/collapseDemo';
import transitionFlip from '@agnos-ui/samples/bootstrap/transition/flipDemo';
import transitionTransition from '@agnos-ui/samples/bootstrap/transition/transition';
import matchMedia from '@agnos-ui/samples/bootstrap/matchMedia/matchMedia';
import navManager from '@agnos-ui/samples/bootstrap/navManager/navManager';
import navManagerWithSelector from '@agnos-ui/samples/bootstrap/navManager/navManagerWithSelector';

const samples: Map<string, SampleInfo> = new Map();
samples.set('focustrack/focustrack', focustrack);
samples.set('floatingUI/floatingUI', floatingUI);
samples.set('resizeObserver/resizeObserver', resizeObserver);
samples.set('slots/usage', slotsUsage);
samples.set('slots/context', slotsContext);
samples.set('alert/icon', alertsIcon);
samples.set('slots/headless', slotsHeadless);
samples.set('directives/usage', directivesUsage);
samples.set('configuration/basic', configurationBasic);
samples.set('configuration/down', configurationDown);
samples.set('transition/collapse', transitionCollapse);
samples.set('transition/flip', transitionFlip);
samples.set('transition/transition', transitionTransition);
samples.set('matchMedia/matchMedia', matchMedia);
samples.set('navManager/navManager', navManager);
samples.set('navManager/navManagerWithSelector', navManagerWithSelector);
export default samples;
