## v0.2.0 (2024-03-05)

### Overview

Version 0.2.0 is out ! :fire:  
It comes out with a new component and a new service, while enhancing the documentation website.

- components are now tagged as **In Progress**, **Beta** or **Stable** 🏷️
  - **In Progress** components are still under active development and probably do not have all the features you expect from the component
  - **Beta** components have all the basic functionalities implemented, but more polishing features are being implemented / considered
- the **slider** component now supports slots for strong customization ⚙️
- the **pagination** component now supports a `slotStructure` for full customization ⚙️
- a new [toast](https://www.agnosui.dev/latest/docs/angular/components/toast/examples) component is available
- a new [resize observer](https://www.agnosui.dev/latest/docs/angular/services/resize-observer) service is available 🦦
- the documentation website now supports dark mode 🌕
- the documentation website now documents how to use [transitions](https://www.agnosui.dev/latest/docs/angular/services/transition)

### Breaking changes

- the slot `slotContent` of the progressbar has been renamed to `slotStructure` to be consistent with all components.

### Features

- accessibility tests in all pages + inline setup of dark theme ([6affbb1](https://github.com/AmadeusITGroup/AgnosUI/commit/6affbb1ab4af65ab657ecf144ab71ec31c14710c))
- **accordion:** add support for custom header tag ([57fc1aa](https://github.com/AmadeusITGroup/AgnosUI/commit/57fc1aacfe3419682d1e0efaffb7ea989660e776))
- **accordion:** default value for destroy on hide changed to match ngb ([66074dd](https://github.com/AmadeusITGroup/AgnosUI/commit/66074dd9b9684d3afdc3855e959ea705d7a3d784))
- **accordion:** demo examples ([b71fa6d](https://github.com/AmadeusITGroup/AgnosUI/commit/b71fa6d549e91db27e77291c352331f09962d33a))
- **accordion:** initial version ([#42](https://github.com/AmadeusITGroup/AgnosUI/issues/42)) ([b8e2316](https://github.com/AmadeusITGroup/AgnosUI/commit/b8e2316ba478fb9b2c6c610d27fdf6fb5e369ee3))
- **Accordion:** use clear naming closes [#160](https://github.com/AmadeusITGroup/AgnosUI/issues/160) ([82ba1c6](https://github.com/AmadeusITGroup/AgnosUI/commit/82ba1c6aa6ae1c1e6e800192bf7d9fafe8f82ec7))
- **Accordion:** use common id generator closes [#508](https://github.com/AmadeusITGroup/AgnosUI/issues/508) ([4d6ff33](https://github.com/AmadeusITGroup/AgnosUI/commit/4d6ff337572b06f7c44040dfc99a3c7027682895))
- add dark mode and dasyUI pagination closes [#521](https://github.com/AmadeusITGroup/AgnosUI/issues/521) ([726b0b6](https://github.com/AmadeusITGroup/AgnosUI/commit/726b0b61831003edd6b4e142aea3ee81baf9b7e3))
- add link to Twitter AgnosUI account ([#24](https://github.com/AmadeusITGroup/AgnosUI/issues/24)) ([720d42c](https://github.com/AmadeusITGroup/AgnosUI/commit/720d42c3704068f271d33c31a804c24e705f4405))
- add modal sample using already defined component ([a5e8e6b](https://github.com/AmadeusITGroup/AgnosUI/commit/a5e8e6b06249bdfbf31db09e8515bf8dce719a75))
- add modal sample using already defined component ([000c2e5](https://github.com/AmadeusITGroup/AgnosUI/commit/000c2e5ad0d924ed58f53d9dfc3ad7032c2ab0ff))
- add previous and next link to each doc page ([71cddee](https://github.com/AmadeusITGroup/AgnosUI/commit/71cddee092e95ca50bb48321466f05628db738df))
- add renovate scheduled action ([#57](https://github.com/AmadeusITGroup/AgnosUI/issues/57)) ([d90257f](https://github.com/AmadeusITGroup/AgnosUI/commit/d90257f324b7dd9d98dd22a85dfa53643eb69833))
- add slots to slider ([#507](https://github.com/AmadeusITGroup/AgnosUI/issues/507)) ([12c9ad6](https://github.com/AmadeusITGroup/AgnosUI/commit/12c9ad6fa1c2760f659901174faffb688b942f1f))
- Add typeArray and allow passing equal function to bindableDerived ([#175](https://github.com/AmadeusITGroup/AgnosUI/issues/175)) ([77f3dcf](https://github.com/AmadeusITGroup/AgnosUI/commit/77f3dcfdd8aa33c6fb272801e63171a12c7d4e9c))
- addition of progressbar widget ([#109](https://github.com/AmadeusITGroup/AgnosUI/issues/109)) ([f6600cb](https://github.com/AmadeusITGroup/AgnosUI/commit/f6600cbce96409fc2ca0b2359ff6a83ea3597f21))
- adjust spacing doc ([7e2791e](https://github.com/AmadeusITGroup/AgnosUI/commit/7e2791ea62683a11a8b3d55f95e27b0f95fd2294))
- allow passing onX={x} in addition to on:X={x} in svelte components ([#225](https://github.com/AmadeusITGroup/AgnosUI/issues/225)) ([8a35c33](https://github.com/AmadeusITGroup/AgnosUI/commit/8a35c33dfa707d91df655df7e5dd99c3df53166a)), closes [#196](https://github.com/AmadeusITGroup/AgnosUI/issues/196)
- allow passing props stores to widget factories ([62d56ac](https://github.com/AmadeusITGroup/AgnosUI/commit/62d56ac79e8983bbc06aaef0aa8d067999afd0da))
- allow to trigger renovate manually ([aa967de](https://github.com/AmadeusITGroup/AgnosUI/commit/aa967de4df776cfe0babc4164cfe83c7a4e9a8d6))
- angular esbuild ([9b4ff86](https://github.com/AmadeusITGroup/AgnosUI/commit/9b4ff86aa45d8f263c10370030202c072d200606))
- **blog:** Add Intl support for publish date ([8f70950](https://github.com/AmadeusITGroup/AgnosUI/commit/8f70950115d494e8fc39981634df63d46157eb1f))
- boost local dev for windows users ([b5a74d7](https://github.com/AmadeusITGroup/AgnosUI/commit/b5a74d7076ca7310293b709148c4ba6b6846e651))
- **branding:** new branding ([5dd208e](https://github.com/AmadeusITGroup/AgnosUI/commit/5dd208e9402b8f53a333a1a729ccba74d6e5e518))
- build demo on esnext ([60e5ec3](https://github.com/AmadeusITGroup/AgnosUI/commit/60e5ec363d9b84c1aacf0822ce308b7b0a4a1ebb))
- customization of widgets config types ([#170](https://github.com/AmadeusITGroup/AgnosUI/issues/170)) ([88ee262](https://github.com/AmadeusITGroup/AgnosUI/commit/88ee26260d936c5a5c1050b6dd856ca86e5e46b3))
- dark mode samples ([1710af4](https://github.com/AmadeusITGroup/AgnosUI/commit/1710af4acdd6e032725de26d051ddb3596a65449))
- default tsconfig with alias, allowing to go to declaration in VSCode ([#367](https://github.com/AmadeusITGroup/AgnosUI/issues/367)) ([7f18eb7](https://github.com/AmadeusITGroup/AgnosUI/commit/7f18eb77bd15e10821bafcb12c535734e24b38fc))
- **demo:** add a sitemap.xml static ([565f296](https://github.com/AmadeusITGroup/AgnosUI/commit/565f29689a41d71c5a26b5d106a2c9eea3044b97))
- **Demo:** Add alert for beta/progress components closes [#531](https://github.com/AmadeusITGroup/AgnosUI/issues/531) ([055f765](https://github.com/AmadeusITGroup/AgnosUI/commit/055f76508f0654ad1dc9ca280c75dd0e2dc2f960))
- **demo:** add the dark mode ([6dfef7e](https://github.com/AmadeusITGroup/AgnosUI/commit/6dfef7e93b25af86572b8ccbe96a485b067a10db))
- **Demo:** function values select ([#140](https://github.com/AmadeusITGroup/AgnosUI/issues/140)) ([6ce8cf4](https://github.com/AmadeusITGroup/AgnosUI/commit/6ce8cf4e5cfde8e067540194e0d633e90efe2fde))
- doc on slots ([8c000c6](https://github.com/AmadeusITGroup/AgnosUI/commit/8c000c6b81a12bf868ee157097e940430b3d7dc9))
- **doc:** Add installation guides ([#139](https://github.com/AmadeusITGroup/AgnosUI/issues/139)) ([a1f0fb8](https://github.com/AmadeusITGroup/AgnosUI/commit/a1f0fb89a953d5f6c3742008a3bba631c8fda066))
- **doc:** put nodejs website link as external ([82d049f](https://github.com/AmadeusITGroup/AgnosUI/commit/82d049f198c32db96a80afcdd2d8b96efa452028))
- **doc:** transitions documentation ([a409422](https://github.com/AmadeusITGroup/AgnosUI/commit/a4094225109751c1fb19893362d6d58322d2e01a))
- dynamic sitemap ([53d3955](https://github.com/AmadeusITGroup/AgnosUI/commit/53d39553c20b9af20e23efffdd9b92f38fc4fcf7))
- e2e coverage ([#22](https://github.com/AmadeusITGroup/AgnosUI/issues/22)) ([5fd9bed](https://github.com/AmadeusITGroup/AgnosUI/commit/5fd9bededc0e078841b7b371a1beec54a03f2fb3))
- extendWidgetProps utility ([#163](https://github.com/AmadeusITGroup/AgnosUI/issues/163)) ([6362437](https://github.com/AmadeusITGroup/AgnosUI/commit/6362437675619a47309b72bd99529c970c7f3d87))
- floating UI ([#237](https://github.com/AmadeusITGroup/AgnosUI/issues/237)) ([60bbb4a](https://github.com/AmadeusITGroup/AgnosUI/commit/60bbb4a2a41958f6929fe6d162283ff75f8d2bf7))
- **floatingui:** set floating-ui as a peer dependency ([#313](https://github.com/AmadeusITGroup/AgnosUI/issues/313)) ([5d4649a](https://github.com/AmadeusITGroup/AgnosUI/commit/5d4649aea23df74d4120bd9502ed6ce76ed2e032))
- **headless:** add headless demo + pagination ([887f3d8](https://github.com/AmadeusITGroup/AgnosUI/commit/887f3d8cd32b35bdb40f9096389c8d23986d9dc6))
- improved doc, resizable observer on root element and slight display improvements ([#82](https://github.com/AmadeusITGroup/AgnosUI/issues/82)) ([4c71c4a](https://github.com/AmadeusITGroup/AgnosUI/commit/4c71c4a905c5b52564f59233d05367a0ba91b855))
- improved look of header when viewing a page with no tabs ([7886804](https://github.com/AmadeusITGroup/AgnosUI/commit/7886804e74395bdeabd2b3bb88611198459ce683))
- improving navManager ([#183](https://github.com/AmadeusITGroup/AgnosUI/issues/183)) ([4e9153c](https://github.com/AmadeusITGroup/AgnosUI/commit/4e9153ca170b2eb89aa9fcd9e2cee93aa7ab3648))
- isFocusable utility ([#205](https://github.com/AmadeusITGroup/AgnosUI/issues/205)) ([0e45d9d](https://github.com/AmadeusITGroup/AgnosUI/commit/0e45d9de36abf162578bb92f15d53c8005699e5d))
- lazy-loaded routes ([fbb421f](https://github.com/AmadeusITGroup/AgnosUI/commit/fbb421f63aecd777002f8534254bfc276a9fdf6a))
- **lint:** enforce jsdoc of widgets + exported functions in core closes [#30](https://github.com/AmadeusITGroup/AgnosUI/issues/30) ([#52](https://github.com/AmadeusITGroup/AgnosUI/issues/52)) ([f922011](https://github.com/AmadeusITGroup/AgnosUI/commit/f922011fe2dcd2a378673a6b7b5a641260dc1953))
- main mobile menu ([fa1bcb6](https://github.com/AmadeusITGroup/AgnosUI/commit/fa1bcb6da05b9abb1c5c267a2199d7372cb3f7d4))
- making auUse synchronous ([8478008](https://github.com/AmadeusITGroup/AgnosUI/commit/84780082cd1bf1cfddda072f1176c267ded9df67))
- markdown doc ([#365](https://github.com/AmadeusITGroup/AgnosUI/issues/365)) ([88f02c7](https://github.com/AmadeusITGroup/AgnosUI/commit/88f02c7d3315bba914cb90ddb860c94cdf151d52))
- **menu:** Add collapsible sections to side menu ([8d1a68d](https://github.com/AmadeusITGroup/AgnosUI/commit/8d1a68d9a30787186aa1db14d78d7e6ba11cdf60))
- **mermaid:** Integrate mermaid in markdown renderer ([#413](https://github.com/AmadeusITGroup/AgnosUI/issues/413)) ([259f1df](https://github.com/AmadeusITGroup/AgnosUI/commit/259f1dfd6f1f377a60aa6cfc158523945c727540))
- move the framework selection into the side menu instead of component page header ([71821e1](https://github.com/AmadeusITGroup/AgnosUI/commit/71821e151c0025161f407637beb76e8bfbb416f8))
- navigation manager ([#177](https://github.com/AmadeusITGroup/AgnosUI/issues/177)) ([f36bcde](https://github.com/AmadeusITGroup/AgnosUI/commit/f36bcded8ba1c31937ab112679a1b9b5e99992b3))
- **navManager:** add focusFirstLeft/focusFirstRight and fix navManager e2e test on Mac ([873ad1d](https://github.com/AmadeusITGroup/AgnosUI/commit/873ad1d6f4cd3a2015a92d6cf60aec3739a71fdd))
- pagination hrefs ([#434](https://github.com/AmadeusITGroup/AgnosUI/issues/434)) ([484b45f](https://github.com/AmadeusITGroup/AgnosUI/commit/484b45fa220a12e495c16197eb79e1ffca27c34d))
- **pagination:** add slot structure closes [#157](https://github.com/AmadeusITGroup/AgnosUI/issues/157) ([6d5284d](https://github.com/AmadeusITGroup/AgnosUI/commit/6d5284d8fb2833853daed6e44baddea0d9f25fed))
- **pagination:** Demo add first pagination Ex ([#40](https://github.com/AmadeusITGroup/AgnosUI/issues/40)) ([54c829b](https://github.com/AmadeusITGroup/AgnosUI/commit/54c829bd181a151d2a089f9badc22b1e52b6d88a))
- pointer cursor on select items ([4e28a76](https://github.com/AmadeusITGroup/AgnosUI/commit/4e28a7685979bfcba0d28bd8f330e1cfb7ec9ef9))
- progressbar slot content renamed to slot structure ([0f451a9](https://github.com/AmadeusITGroup/AgnosUI/commit/0f451a9f5e3685c36895c5516259bbee4256a5a1))
- proposal select types ([#344](https://github.com/AmadeusITGroup/AgnosUI/issues/344)) ([2a92391](https://github.com/AmadeusITGroup/AgnosUI/commit/2a92391c534dde7356367de324b8f246e1811f51))
- release the website into the wild ([fe80de2](https://github.com/AmadeusITGroup/AgnosUI/commit/fe80de2eef6bd90abc4b40870daf379b4362975d))
- remove eslint disable from svelte samples ([f3642d4](https://github.com/AmadeusITGroup/AgnosUI/commit/f3642d44d74d5b223d12152d1d01ed206a61293c))
- removing dispatch-style events in Svelte ([#272](https://github.com/AmadeusITGroup/AgnosUI/issues/272)) ([3b6947a](https://github.com/AmadeusITGroup/AgnosUI/commit/3b6947a5ec24af524529378d12026bfd0fe6759e))
- resizable iframe + link headers ([#77](https://github.com/AmadeusITGroup/AgnosUI/issues/77)) ([ce2ab44](https://github.com/AmadeusITGroup/AgnosUI/commit/ce2ab443dc21c91bfdf119112f619c83e2df7e07))
- resize observer store in core package ([4523243](https://github.com/AmadeusITGroup/AgnosUI/commit/4523243414817418e7abb47e93bf2ba217daa058))
- run core outside of Angular zone ([#188](https://github.com/AmadeusITGroup/AgnosUI/issues/188)) ([24d49aa](https://github.com/AmadeusITGroup/AgnosUI/commit/24d49aa5d03a2e69994f5cad2dff19ae7276189a))
- **select:** positioning ([#312](https://github.com/AmadeusITGroup/AgnosUI/issues/312)) ([8a8d8a6](https://github.com/AmadeusITGroup/AgnosUI/commit/8a8d8a64ec05af47c9b98da24430ec52df4dad4e))
- set tansu as peer dependency ([d72ee37](https://github.com/AmadeusITGroup/AgnosUI/commit/d72ee371a3e056f3de8be99215732a094c6bcb69))
- set up self-hosted renovate ([ff83ff7](https://github.com/AmadeusITGroup/AgnosUI/commit/ff83ff7208da195446dc11e38c583f0a6e9f4fc9))
- setup wireit ([#353](https://github.com/AmadeusITGroup/AgnosUI/issues/353)) ([1b764c3](https://github.com/AmadeusITGroup/AgnosUI/commit/1b764c3b2b6c323cadbab1116bbcf9c463eed318))
- simplify stackblitz repos ([a09bf05](https://github.com/AmadeusITGroup/AgnosUI/commit/a09bf05a4078fa4e05d62a6b8c477aa4560faee6))
- **slider:** Add decimal values support for slider ([e32c608](https://github.com/AmadeusITGroup/AgnosUI/commit/e32c60830473eb55a263b1b71e166bb2eb1f2dc3))
- **slider:** Add props for showing min, max and value labels ([c935a7d](https://github.com/AmadeusITGroup/AgnosUI/commit/c935a7d62decccd1bfaa3f98c44b94aaaedad78e))
- **slider:** Add RTL support ([890047b](https://github.com/AmadeusITGroup/AgnosUI/commit/890047bccf410fe7bfe299718af29c6ad02c793f))
- **slider:** Add slider component ([#182](https://github.com/AmadeusITGroup/AgnosUI/issues/182)) ([07d66a9](https://github.com/AmadeusITGroup/AgnosUI/commit/07d66a98e08172215c89bf9c0fd5f78469174428))
- **slider:** add style mixin + css modification ([#234](https://github.com/AmadeusITGroup/AgnosUI/issues/234)) ([585e2d5](https://github.com/AmadeusITGroup/AgnosUI/commit/585e2d528eddd161a7b96ab547f8e6fa9470cfc8))
- **slider:** Add touch events to slider ([422cff6](https://github.com/AmadeusITGroup/AgnosUI/commit/422cff626f0b2942374d6b149272d76af6761081))
- **slider:** Handle aria-valuetext customizability ([3245b7c](https://github.com/AmadeusITGroup/AgnosUI/commit/3245b7cc3287b90734c855d015b1283304d00e36))
- slight README.md change ([8021ed8](https://github.com/AmadeusITGroup/AgnosUI/commit/8021ed8f78a319bc7f7431efaad651be2cbc794f))
- speed up stackblitz install by a LOT ([9a058f9](https://github.com/AmadeusITGroup/AgnosUI/commit/9a058f947ead96f204a20bc5d120abd5e0b2e86b))
- status of a component, used to tag components and display badges ([#472](https://github.com/AmadeusITGroup/AgnosUI/issues/472)) ([3bc214f](https://github.com/AmadeusITGroup/AgnosUI/commit/3bc214f53c1dc7feb5dedf5d70682da2890853ea))
- **style-bootstrap:** slider style refactor + style-bootstrap package ([#218](https://github.com/AmadeusITGroup/AgnosUI/issues/218)) ([21b11f3](https://github.com/AmadeusITGroup/AgnosUI/commit/21b11f3ff8cdfcd4677a2f66d573608eee086ad0))
- **style:** add prefix + customization + sizing ([#412](https://github.com/AmadeusITGroup/AgnosUI/issues/412)) ([00431f2](https://github.com/AmadeusITGroup/AgnosUI/commit/00431f2a4f7d0e5dd093d805db52d3473230c2fa))
- support and enforce number and boolean transform functions in angular ([b7f4e21](https://github.com/AmadeusITGroup/AgnosUI/commit/b7f4e21c06ad7fb72bfddbc07e77141bb10f0fa2))
- **toast:** Add toast component ([b8b87d1](https://github.com/AmadeusITGroup/AgnosUI/commit/b8b87d1d9f0cd43e33bdaf0ba11a50531d8561f8))
- update angular logo + dialog display on mobile ([fb89d26](https://github.com/AmadeusITGroup/AgnosUI/commit/fb89d26c488077b9dec0e29c9921440a6baa8c1c))
- use agnos-ui/svelte imports in the demo ([cb16dd2](https://github.com/AmadeusITGroup/AgnosUI/commit/cb16dd20cb99a11ae12c00e94348191265549ac4))
- use shiki as highlighter ([11ebc57](https://github.com/AmadeusITGroup/AgnosUI/commit/11ebc57da2491b726b3280747e689f5b26a2c0e0))
- use vite-plugin-svgr for react svgs ([e4f75c6](https://github.com/AmadeusITGroup/AgnosUI/commit/e4f75c6683a6ef8b2357f9eb4420f27216d2081d))
- useDirectives ([#311](https://github.com/AmadeusITGroup/AgnosUI/issues/311)) ([4e25c1a](https://github.com/AmadeusITGroup/AgnosUI/commit/4e25c1a9a47d234c938aaed51bc7c479bf66b024))
- view transitions on demo website ([17f9a97](https://github.com/AmadeusITGroup/AgnosUI/commit/17f9a97311813777164905b2fd7b80ee3f427cee))
- VSCode modern themes ([f5d3eaf](https://github.com/AmadeusITGroup/AgnosUI/commit/f5d3eafee2b5adfa78ec6ff73b94324a1201b314))
- website meta tags ([aa91609](https://github.com/AmadeusITGroup/AgnosUI/commit/aa916094c437bcc161e9c3dfea38a215b06f0583))

### Bug Fixes

- **Accordion:** clean unused code ([#164](https://github.com/AmadeusITGroup/AgnosUI/issues/164)) ([b30e71b](https://github.com/AmadeusITGroup/AgnosUI/commit/b30e71b71c8cea612d27b106e2b979aa8d5091d8))
- adapt the type of widget factories for slots in headless packages ([#165](https://github.com/AmadeusITGroup/AgnosUI/issues/165)) ([70ab1d0](https://github.com/AmadeusITGroup/AgnosUI/commit/70ab1d03866ca0d46581bf6c96d4fcdc2610cf05))
- add missing aria-disabled on the whole slider when disabled ([5379579](https://github.com/AmadeusITGroup/AgnosUI/commit/5379579bff4e7d9aa3844e8ac5c58f21baf93076))
- add path to renovate config + set renovate platform ([771065b](https://github.com/AmadeusITGroup/AgnosUI/commit/771065b7512339e481e552d1337b2553f77c64e9))
- adding back the service worker ([f4dadf4](https://github.com/AmadeusITGroup/AgnosUI/commit/f4dadf48b502a7dc3a4f6a9e178e66d93fd51753))
- **alert:** Add alert-dismissible class ([16d8c1f](https://github.com/AmadeusITGroup/AgnosUI/commit/16d8c1fc28a454a434f2fec616b741386beaebe6))
- angular budget error when building with coverage instrumentation ([#250](https://github.com/AmadeusITGroup/AgnosUI/issues/250)) ([a081136](https://github.com/AmadeusITGroup/AgnosUI/commit/a08113600f1dc92cc16de68d514f73ff8fa5a22c))
- angular config types ([d6b76ee](https://github.com/AmadeusITGroup/AgnosUI/commit/d6b76ee629fb0e0b5f176a14964645bec5b04e93))
- angular logo ([8c7f46a](https://github.com/AmadeusITGroup/AgnosUI/commit/8c7f46a02d53fc3a0b3b296a3df887efee8d932a))
- angular types ([4300462](https://github.com/AmadeusITGroup/AgnosUI/commit/4300462eb4ffb4f27c5bae81f6f655901f7a7899))
- **angular:** workaround for a bug in Angular when updating to v16.2.4 ([b0d09e0](https://github.com/AmadeusITGroup/AgnosUI/commit/b0d09e0b5fed133d2fe4518aea3a17b90046cfae))
- api and playground on local ([60065ae](https://github.com/AmadeusITGroup/AgnosUI/commit/60065ae0d8e1ee4741ab3fb4cbc7c07ef053d65b))
- api default config for slider ([787b1e0](https://github.com/AmadeusITGroup/AgnosUI/commit/787b1e0c18cd69ae75d149d7dc82f8687e8143ed))
- bootstrap links in stackblitz ([d0ab8b7](https://github.com/AmadeusITGroup/AgnosUI/commit/d0ab8b798ba71209c60ede0993e69f3398534f84))
- **build:** code coverage ([d8b100b](https://github.com/AmadeusITGroup/AgnosUI/commit/d8b100b76fa7c3174b45efe9ea90e697a01c6338))
- **build:** computation of doc folder based on the version number ([#110](https://github.com/AmadeusITGroup/AgnosUI/issues/110)) ([946dd24](https://github.com/AmadeusITGroup/AgnosUI/commit/946dd241c8d05a712c08c343770d944b5670736a))
- check version number does not start with v ([#189](https://github.com/AmadeusITGroup/AgnosUI/issues/189)) ([d806214](https://github.com/AmadeusITGroup/AgnosUI/commit/d806214b622e3c9be916ff6ec22ec62eb3dccba2))
- codecov token ([f6937e8](https://github.com/AmadeusITGroup/AgnosUI/commit/f6937e8d445c0211c3d3d6332153be32c78956cc))
- color contrast in demo website ([#37](https://github.com/AmadeusITGroup/AgnosUI/issues/37)) ([e419c85](https://github.com/AmadeusITGroup/AgnosUI/commit/e419c85db643bf17f5ce8e7e0c93389b7beea845))
- correct title / description for installation guide ([95b224e](https://github.com/AmadeusITGroup/AgnosUI/commit/95b224e0fadca94540fac148d5e9895309c1e8b4))
- **coverage:** better code coverage ([#51](https://github.com/AmadeusITGroup/AgnosUI/issues/51)) ([ac5ecf4](https://github.com/AmadeusITGroup/AgnosUI/commit/ac5ecf439e0c5502b3d455f396408a2f0f82e0ff))
- custom slider handle mouse click ([4234f12](https://github.com/AmadeusITGroup/AgnosUI/commit/4234f123e740b3b32f8b464f69bfebc23b2e836d))
- **demo:** add tabs nowrap ([a06c135](https://github.com/AmadeusITGroup/AgnosUI/commit/a06c13590777f87e5e57deb5ac0a71ab7f09b62d))
- **demo:** blur is sometimes bad on mobile ([35a0b70](https://github.com/AmadeusITGroup/AgnosUI/commit/35a0b7039f24803ad6079dcad6f08ffe2e02dca2))
- **demo:** fix small layout issues ([f015604](https://github.com/AmadeusITGroup/AgnosUI/commit/f0156040fd48891b4834bf47cb2dc4a0f7db9e61))
- **demo:** keep component active in the menu even when not on "Examples" tab ([8274c70](https://github.com/AmadeusITGroup/AgnosUI/commit/8274c707b306d3fbc2eeca9e5df17a1469d89623))
- **demo:** react custom demo was not consistent with angular and svelte ([8bc8c0a](https://github.com/AmadeusITGroup/AgnosUI/commit/8bc8c0a593f97c5ce5010b986b5329af9bd6339a))
- **demo:** version number displayed in the demo site ([909f58a](https://github.com/AmadeusITGroup/AgnosUI/commit/909f58ae8b036771496cc2b172c815821729c731))
- deployment to gh-pages, list of versions now published in versions.json ([bac770c](https://github.com/AmadeusITGroup/AgnosUI/commit/bac770cdfd6f53c92a60c81883871875fac59b96))
- **deps:** fixing issue with dependencies ([f373f4d](https://github.com/AmadeusITGroup/AgnosUI/commit/f373f4db998bcc0a07312c17ac2700fed51b06ea))
- **deps:** update all non-major dependencies ([67e8ef6](https://github.com/AmadeusITGroup/AgnosUI/commit/67e8ef6381d5cdc9c4cec32de668a352e6c16ade))
- **deps:** update all non-major dependencies ([1ac9519](https://github.com/AmadeusITGroup/AgnosUI/commit/1ac9519d1eead139ba3e200870540b802eda0159))
- **deps:** update all non-major dependencies ([95271bb](https://github.com/AmadeusITGroup/AgnosUI/commit/95271bbbafabd00339dba91d0fa832ac703b906c))
- **deps:** update all non-major dependencies ([d7ab68d](https://github.com/AmadeusITGroup/AgnosUI/commit/d7ab68dfbe447a9e90fa55ab4506476c510c37e6))
- **deps:** update all non-major dependencies ([9d72d8c](https://github.com/AmadeusITGroup/AgnosUI/commit/9d72d8c30da3715637868e08243fe0a3a642594d))
- **deps:** update all non-major dependencies ([e2096a7](https://github.com/AmadeusITGroup/AgnosUI/commit/e2096a78a87ae8864d03cb92ac4cb1cb26c784d2))
- **deps:** update all non-major dependencies ([7645f10](https://github.com/AmadeusITGroup/AgnosUI/commit/7645f10dab8330e40763c6c11134d8b343924878))
- **deps:** update all non-major dependencies ([ae9cd0f](https://github.com/AmadeusITGroup/AgnosUI/commit/ae9cd0f5cdc30ce9ca13487a24cbe75d8e1b16db))
- **deps:** update all non-major dependencies ([#113](https://github.com/AmadeusITGroup/AgnosUI/issues/113)) ([f049d4b](https://github.com/AmadeusITGroup/AgnosUI/commit/f049d4bf44f2045c94c6ed1d2e56b276369d5796))
- **deps:** update all non-major dependencies ([#169](https://github.com/AmadeusITGroup/AgnosUI/issues/169)) ([02c60e8](https://github.com/AmadeusITGroup/AgnosUI/commit/02c60e8d65583fef00208a4f21b9582e5671724f))
- **deps:** update all non-major dependencies ([#215](https://github.com/AmadeusITGroup/AgnosUI/issues/215)) ([65aafc5](https://github.com/AmadeusITGroup/AgnosUI/commit/65aafc5bcef9aa41409fd5e548f1cfe83be60d67))
- **deps:** update dependency @amadeus-it-group/tansu to v1 ([701d3c5](https://github.com/AmadeusITGroup/AgnosUI/commit/701d3c50be534012643ca33844edd5d95fd46074))
- display of readonly rating on android ([#81](https://github.com/AmadeusITGroup/AgnosUI/issues/81)) ([44be31d](https://github.com/AmadeusITGroup/AgnosUI/commit/44be31d7fc24c57cd92d9c7086cd2e917a9e96ee))
- **doc:** createPagination option is for pagination ([#126](https://github.com/AmadeusITGroup/AgnosUI/issues/126)) ([e3886cb](https://github.com/AmadeusITGroup/AgnosUI/commit/e3886cb6f9a43038b65edf09ba923d1e2a30ca6f))
- **e2e:** use expect.poll to wait for the state to match expectations ([#166](https://github.com/AmadeusITGroup/AgnosUI/issues/166)) ([6321bfa](https://github.com/AmadeusITGroup/AgnosUI/commit/6321bfadc5a800753323eca338d8abdde1de9ed6))
- eslint not working in vscode for some files in Angular ([f6018a7](https://github.com/AmadeusITGroup/AgnosUI/commit/f6018a7c47bed80ac6f274bbbb3f72da3e2e81f7))
- eslint plugin error reporting with bindings ([#247](https://github.com/AmadeusITGroup/AgnosUI/issues/247)) ([3fd0f2e](https://github.com/AmadeusITGroup/AgnosUI/commit/3fd0f2e253d39b84f47cfae290ad434d82285b55))
- eslint-plugin issue with types comparison ([baa93b6](https://github.com/AmadeusITGroup/AgnosUI/commit/baa93b69276481602bf24b12a4b692c16fc8099f))
- explicitly set repositories for renovate ([44d3ece](https://github.com/AmadeusITGroup/AgnosUI/commit/44d3ece2f528419c4985bf69a4f26b3508f0e042))
- file format + errors reported by svelte-check after minor upgrade ([ac1508c](https://github.com/AmadeusITGroup/AgnosUI/commit/ac1508c987de48c2f2a9ae1c359e132bd5795d64))
- fixing e2e tests ([#287](https://github.com/AmadeusITGroup/AgnosUI/issues/287)) ([ec0d9b5](https://github.com/AmadeusITGroup/AgnosUI/commit/ec0d9b57d46eca5ea74bb6a0843ef6bad3ef01d5))
- fixing typo preventing correct type-checking for the Alert in svelte ([6f912ae](https://github.com/AmadeusITGroup/AgnosUI/commit/6f912aee7623e956da64929e04989ce4024d869f))
- generation of exports on windows ([#319](https://github.com/AmadeusITGroup/AgnosUI/issues/319)) ([00d8e12](https://github.com/AmadeusITGroup/AgnosUI/commit/00d8e12461592d3403213b70436366e0ce171dbe))
- generic alert flicker ([#53](https://github.com/AmadeusITGroup/AgnosUI/issues/53)) ([c058661](https://github.com/AmadeusITGroup/AgnosUI/commit/c0586612febefb07f22165f544fe2b47a2a532e4))
- height of scrollable content container ([3f429fb](https://github.com/AmadeusITGroup/AgnosUI/commit/3f429fbc8375f5e03064b968fef56ffaf4cdadee))
- improve slider e2e test reliability ([#331](https://github.com/AmadeusITGroup/AgnosUI/issues/331)) ([f1e24f2](https://github.com/AmadeusITGroup/AgnosUI/commit/f1e24f214a6bd03fd193a3767e846af835c57ff3))
- incorrect usage of <slot> in accordion sample ([#271](https://github.com/AmadeusITGroup/AgnosUI/issues/271)) ([9c14c0a](https://github.com/AmadeusITGroup/AgnosUI/commit/9c14c0a20de16f7f0eeb742fb5732be005c8765c))
- incorrect usage of <slot> in accordion samples ([#273](https://github.com/AmadeusITGroup/AgnosUI/issues/273)) ([430f3bb](https://github.com/AmadeusITGroup/AgnosUI/commit/430f3bb9b5c6a778b5022d92b55eb302b47be39d))
- indicate to svelte-aware tooling that headless and lib are svelte libraries ([a511084](https://github.com/AmadeusITGroup/AgnosUI/commit/a51108441b6b822a254b4b511df00eb823380808))
- initial 500 error when navigating from home page ([43fa1c2](https://github.com/AmadeusITGroup/AgnosUI/commit/43fa1c290c42213bf5b02a6b95c95f48339ce08b))
- landing page on mobile [#35](https://github.com/AmadeusITGroup/AgnosUI/issues/35) ([#36](https://github.com/AmadeusITGroup/AgnosUI/issues/36)) ([509b90e](https://github.com/AmadeusITGroup/AgnosUI/commit/509b90ecd29ea2ff55415c0818c81400ca264604))
- links script on windows ([627ae87](https://github.com/AmadeusITGroup/AgnosUI/commit/627ae8720156b82bbb9f2b1aaa76e4e21302711d))
- local after building core ([7d265fd](https://github.com/AmadeusITGroup/AgnosUI/commit/7d265fd5a4fd2eb11d6f35ffb2bd140a71d83bab))
- markdown rendering on follow-up navigation ([d422d5f](https://github.com/AmadeusITGroup/AgnosUI/commit/d422d5f9f884385061a6398875dc85c36ac6ed46))
- md breakpoint display ([#406](https://github.com/AmadeusITGroup/AgnosUI/issues/406)) ([2396994](https://github.com/AmadeusITGroup/AgnosUI/commit/2396994c7c8c046995c30f1396b863a3c34522fb))
- **menu:** Cross animation doesn't work on navigation ([405c1bf](https://github.com/AmadeusITGroup/AgnosUI/commit/405c1bf49b50fecae1fb8074cab7e337c0254f84))
- modal props validation ([#275](https://github.com/AmadeusITGroup/AgnosUI/issues/275)) ([eba66fb](https://github.com/AmadeusITGroup/AgnosUI/commit/eba66fb86603a88c5e7f9275c445bcf2bee722c5))
- **modal:** Fade transition is not smooth ([9a0866f](https://github.com/AmadeusITGroup/AgnosUI/commit/9a0866f9b39e6faab5d8dbf1fb4ea04630171d62))
- package and README not present in @agnos-ui/svelte ([219414d](https://github.com/AmadeusITGroup/AgnosUI/commit/219414d26eef730c14c2d267bc2c46cff9bef4f7))
- plaintext codes in documentation ([daf5d33](https://github.com/AmadeusITGroup/AgnosUI/commit/daf5d33af496dcfb7b746972a29f86469e872258))
- portal directive should not move element when not needed ([#270](https://github.com/AmadeusITGroup/AgnosUI/issues/270)) ([a684409](https://github.com/AmadeusITGroup/AgnosUI/commit/a684409032576512ef9762b8902ef75483d4325e))
- prettier json format ([051cc83](https://github.com/AmadeusITGroup/AgnosUI/commit/051cc837d98bc40a4b8f7241fdd591d0ad5fffbd))
- react types for toast ([a54a014](https://github.com/AmadeusITGroup/AgnosUI/commit/a54a014a769dab1ca37fbe37fbc593133bef2259))
- removing loading="lazy" on demo samples iframe (as Firefox bugs with it) ([f116a16](https://github.com/AmadeusITGroup/AgnosUI/commit/f116a16fa0cfe3066d795253201c9d6f2141efab))
- removing useless re-exports ([42373fe](https://github.com/AmadeusITGroup/AgnosUI/commit/42373fef59d086784e53c4469f75974de177dd5c))
- renovate github action version ([5f3c352](https://github.com/AmadeusITGroup/AgnosUI/commit/5f3c35265d1de5844836ac19e22bcdccb91d95e8))
- replacing context.getSourceCode() by context.sourceCode in eslint-plugin ([92f8ea8](https://github.com/AmadeusITGroup/AgnosUI/commit/92f8ea88c669c83e7981300614b355ef6198fb2f))
- **responsiveness:** Main content takes 50% space, menu are shrinked accordingly. ([dce178c](https://github.com/AmadeusITGroup/AgnosUI/commit/dce178cf8def9ae8e048f3ca0b782aecec86d7d4))
- scroll back to top on navigation ([9ca108f](https://github.com/AmadeusITGroup/AgnosUI/commit/9ca108f6f20c7f5f2fb5892ff1303cebb5e7701e))
- service worker cache collision on same domain ([#159](https://github.com/AmadeusITGroup/AgnosUI/issues/159)) ([38bceff](https://github.com/AmadeusITGroup/AgnosUI/commit/38bceff9020e41d99de62287a231b79a53982c69))
- **service-worker:** fetch resource if cache does not hold it ([25c56e4](https://github.com/AmadeusITGroup/AgnosUI/commit/25c56e4310a8f3f07b4352a878230b12d8ec7001))
- setVersion + warning on stdinout listeners ([b506936](https://github.com/AmadeusITGroup/AgnosUI/commit/b506936e3027cb43ac4dd74b63a89a3505b7c67e))
- slider e2e test stability ([#318](https://github.com/AmadeusITGroup/AgnosUI/issues/318)) ([c7071d4](https://github.com/AmadeusITGroup/AgnosUI/commit/c7071d4386f77a8aee3f8210f57a909c7f3c6830))
- slider e2e test stability and readability improvement ([#310](https://github.com/AmadeusITGroup/AgnosUI/issues/310)) ([142ae61](https://github.com/AmadeusITGroup/AgnosUI/commit/142ae61503adc6d883e7e115ce212e5ee9ac0df6))
- **slider:** Allow slider click through progress ([142113c](https://github.com/AmadeusITGroup/AgnosUI/commit/142113c864ecbebaa083cca59f973eb439dcd638))
- **slider:** Bind min, max and stepSize to clean value ([053dd77](https://github.com/AmadeusITGroup/AgnosUI/commit/053dd77b9fa6ec8fad8c96931ec5ff1ab98c153f))
- **slider:** Remove margin block and align labels for vertical ([c9ba24b](https://github.com/AmadeusITGroup/AgnosUI/commit/c9ba24bb372e3a5233ceb0d3e1b315339cd919ff))
- **slider:** Request bounding rect for click and touch ([86eeea7](https://github.com/AmadeusITGroup/AgnosUI/commit/86eeea73840599d6fc657ab4b36c1bdf354dce6b))
- **slider:** style bootstrap font-weight + margin ([#429](https://github.com/AmadeusITGroup/AgnosUI/issues/429)) ([9187e92](https://github.com/AmadeusITGroup/AgnosUI/commit/9187e92b4d84fd95640191f1469ba6e87ee5e538))
- stackblitz with css ([e23893f](https://github.com/AmadeusITGroup/AgnosUI/commit/e23893fceb1c3b809dc7b316589418223cc7ae22))
- **svelte:** partly fixes SSR with svelte ([d4d2c19](https://github.com/AmadeusITGroup/AgnosUI/commit/d4d2c1991401c11a0880c2b70ff0e260b3650ea6))
- theme icon on first render ([6707b71](https://github.com/AmadeusITGroup/AgnosUI/commit/6707b71ddc7067911210a0964c056b3a07cd8821))
- toAngularSignal test with Angular 17.1.0 ([95d367d](https://github.com/AmadeusITGroup/AgnosUI/commit/95d367d42170ba54e876ddbfa0f432064b990388))
- transition demos should use useMemo instead of useWidget ([fdb67e2](https://github.com/AmadeusITGroup/AgnosUI/commit/fdb67e2f26769d7f57d3b20d8b57c026bfb1815d))
- types for react ([e6d32d8](https://github.com/AmadeusITGroup/AgnosUI/commit/e6d32d8905ae6ebf0bef8b21bcdfe71b4c2b83df))
- typo in github renovate file pattern ([dabdfdc](https://github.com/AmadeusITGroup/AgnosUI/commit/dabdfdc9be454ede9438158082a7dec846843331))
- unit test ([12b7548](https://github.com/AmadeusITGroup/AgnosUI/commit/12b754830716f5e867793cd6b890a2589937da47))
- use capture for focustrack utility ([17c329e](https://github.com/AmadeusITGroup/AgnosUI/commit/17c329e34859bf1a865c63fa617f98e33506cfd8))
- use minimatch pattern ([cb4c3b5](https://github.com/AmadeusITGroup/AgnosUI/commit/cb4c3b5864e907c08761d3f50eac111c07455f7e))
- use twitter-x bootstrap icon for twitter link ([#179](https://github.com/AmadeusITGroup/AgnosUI/issues/179)) ([d73d7e3](https://github.com/AmadeusITGroup/AgnosUI/commit/d73d7e379f0fa1d7e2a31a08011ff4fbc31438e3))
- woopsie on relative navigation ([ffe820b](https://github.com/AmadeusITGroup/AgnosUI/commit/ffe820b290ec7cea0dbfdc0b2d7c732fe496576d))
- workaround for Svelte SSR generation ([043869b](https://github.com/AmadeusITGroup/AgnosUI/commit/043869b70164101c1de148c2b75e4ad38a9ff238))

## v0.1.1 (2024-02-02)

### Overview

First official release of AgnosUI :fire:

Introduction of the following widgets

- [accordion](https://www.agnosui.dev/latest/docs/svelte/components/accordion/examples)
- [alert](https://www.agnosui.dev/latest/docs/svelte/components/alert/examples)
- [modal](https://www.agnosui.dev/latest/docs/svelte/components/modal/examples)
- [pagination](https://www.agnosui.dev/latest/docs/svelte/components/pagination/examples)
- [progressbar](https://www.agnosui.dev/latest/docs/svelte/components/progressbar/examples)
- [rating](https://www.agnosui.dev/latest/docs/svelte/components/rating/examples)
- [select](https://www.agnosui.dev/latest/docs/svelte/components/select/examples)
- [slider](https://www.agnosui.dev/latest/docs/svelte/components/slider/examples)

Introduction of the following services

- [focus track](https://www.agnosui.dev/latest/docs/svelte/services/focustrack)
- [floating UI](https://www.agnosui.dev/latest/docs/svelte/services/floating-ui)

### Features

- **accordion:** add support for custom header tag ([57fc1aa](https://github.com/AmadeusITGroup/AgnosUI/commit/57fc1aacfe3419682d1e0efaffb7ea989660e776))
- **accordion:** default value for destroy on hide changed to match ngb ([66074dd](https://github.com/AmadeusITGroup/AgnosUI/commit/66074dd9b9684d3afdc3855e959ea705d7a3d784))
- **accordion:** demo examples ([b71fa6d](https://github.com/AmadeusITGroup/AgnosUI/commit/b71fa6d549e91db27e77291c352331f09962d33a))
- **accordion:** initial version ([#42](https://github.com/AmadeusITGroup/AgnosUI/issues/42)) ([b8e2316](https://github.com/AmadeusITGroup/AgnosUI/commit/b8e2316ba478fb9b2c6c610d27fdf6fb5e369ee3))
- add link to Twitter AgnosUI account ([#24](https://github.com/AmadeusITGroup/AgnosUI/issues/24)) ([720d42c](https://github.com/AmadeusITGroup/AgnosUI/commit/720d42c3704068f271d33c31a804c24e705f4405))
- add modal sample using already defined component ([a5e8e6b](https://github.com/AmadeusITGroup/AgnosUI/commit/a5e8e6b06249bdfbf31db09e8515bf8dce719a75))
- add modal sample using already defined component ([000c2e5](https://github.com/AmadeusITGroup/AgnosUI/commit/000c2e5ad0d924ed58f53d9dfc3ad7032c2ab0ff))
- add previous and next link to each doc page ([71cddee](https://github.com/AmadeusITGroup/AgnosUI/commit/71cddee092e95ca50bb48321466f05628db738df))
- add renovate scheduled action ([#57](https://github.com/AmadeusITGroup/AgnosUI/issues/57)) ([d90257f](https://github.com/AmadeusITGroup/AgnosUI/commit/d90257f324b7dd9d98dd22a85dfa53643eb69833))
- Add typeArray and allow passing equal function to bindableDerived ([#175](https://github.com/AmadeusITGroup/AgnosUI/issues/175)) ([77f3dcf](https://github.com/AmadeusITGroup/AgnosUI/commit/77f3dcfdd8aa33c6fb272801e63171a12c7d4e9c))
- addition of progressbar widget ([#109](https://github.com/AmadeusITGroup/AgnosUI/issues/109)) ([f6600cb](https://github.com/AmadeusITGroup/AgnosUI/commit/f6600cbce96409fc2ca0b2359ff6a83ea3597f21))
- adjust spacing doc ([7e2791e](https://github.com/AmadeusITGroup/AgnosUI/commit/7e2791ea62683a11a8b3d55f95e27b0f95fd2294))
- allow passing onX={x} in addition to on:X={x} in svelte components ([#225](https://github.com/AmadeusITGroup/AgnosUI/issues/225)) ([8a35c33](https://github.com/AmadeusITGroup/AgnosUI/commit/8a35c33dfa707d91df655df7e5dd99c3df53166a)), closes [#196](https://github.com/AmadeusITGroup/AgnosUI/issues/196)
- allow passing props stores to widget factories ([62d56ac](https://github.com/AmadeusITGroup/AgnosUI/commit/62d56ac79e8983bbc06aaef0aa8d067999afd0da))
- allow to trigger renovate manually ([aa967de](https://github.com/AmadeusITGroup/AgnosUI/commit/aa967de4df776cfe0babc4164cfe83c7a4e9a8d6))
- angular esbuild ([9b4ff86](https://github.com/AmadeusITGroup/AgnosUI/commit/9b4ff86aa45d8f263c10370030202c072d200606))
- boost local dev for windows users ([b5a74d7](https://github.com/AmadeusITGroup/AgnosUI/commit/b5a74d7076ca7310293b709148c4ba6b6846e651))
- **branding:** new branding ([5dd208e](https://github.com/AmadeusITGroup/AgnosUI/commit/5dd208e9402b8f53a333a1a729ccba74d6e5e518))
- customization of widgets config types ([#170](https://github.com/AmadeusITGroup/AgnosUI/issues/170)) ([88ee262](https://github.com/AmadeusITGroup/AgnosUI/commit/88ee26260d936c5a5c1050b6dd856ca86e5e46b3))
- default tsconfig with alias, allowing to go to declaration in VSCode ([#367](https://github.com/AmadeusITGroup/AgnosUI/issues/367)) ([7f18eb7](https://github.com/AmadeusITGroup/AgnosUI/commit/7f18eb77bd15e10821bafcb12c535734e24b38fc))
- **Demo:** function values select ([#140](https://github.com/AmadeusITGroup/AgnosUI/issues/140)) ([6ce8cf4](https://github.com/AmadeusITGroup/AgnosUI/commit/6ce8cf4e5cfde8e067540194e0d633e90efe2fde))
- doc on slots ([8c000c6](https://github.com/AmadeusITGroup/AgnosUI/commit/8c000c6b81a12bf868ee157097e940430b3d7dc9))
- **doc:** Add installation guides ([#139](https://github.com/AmadeusITGroup/AgnosUI/issues/139)) ([a1f0fb8](https://github.com/AmadeusITGroup/AgnosUI/commit/a1f0fb89a953d5f6c3742008a3bba631c8fda066))
- **doc:** put nodejs website link as external ([82d049f](https://github.com/AmadeusITGroup/AgnosUI/commit/82d049f198c32db96a80afcdd2d8b96efa452028))
- e2e coverage ([#22](https://github.com/AmadeusITGroup/AgnosUI/issues/22)) ([5fd9bed](https://github.com/AmadeusITGroup/AgnosUI/commit/5fd9bededc0e078841b7b371a1beec54a03f2fb3))
- extendWidgetProps utility ([#163](https://github.com/AmadeusITGroup/AgnosUI/issues/163)) ([6362437](https://github.com/AmadeusITGroup/AgnosUI/commit/6362437675619a47309b72bd99529c970c7f3d87))
- floating UI ([#237](https://github.com/AmadeusITGroup/AgnosUI/issues/237)) ([60bbb4a](https://github.com/AmadeusITGroup/AgnosUI/commit/60bbb4a2a41958f6929fe6d162283ff75f8d2bf7))
- **floatingui:** set floating-ui as a peer dependency ([#313](https://github.com/AmadeusITGroup/AgnosUI/issues/313)) ([5d4649a](https://github.com/AmadeusITGroup/AgnosUI/commit/5d4649aea23df74d4120bd9502ed6ce76ed2e032))
- **headless:** add headless demo + pagination ([887f3d8](https://github.com/AmadeusITGroup/AgnosUI/commit/887f3d8cd32b35bdb40f9096389c8d23986d9dc6))
- improved doc, resizable observer on root element and slight display improvements ([#82](https://github.com/AmadeusITGroup/AgnosUI/issues/82)) ([4c71c4a](https://github.com/AmadeusITGroup/AgnosUI/commit/4c71c4a905c5b52564f59233d05367a0ba91b855))
- improved look of header when viewing a page with no tabs ([7886804](https://github.com/AmadeusITGroup/AgnosUI/commit/7886804e74395bdeabd2b3bb88611198459ce683))
- improving navManager ([#183](https://github.com/AmadeusITGroup/AgnosUI/issues/183)) ([4e9153c](https://github.com/AmadeusITGroup/AgnosUI/commit/4e9153ca170b2eb89aa9fcd9e2cee93aa7ab3648))
- isFocusable utility ([#205](https://github.com/AmadeusITGroup/AgnosUI/issues/205)) ([0e45d9d](https://github.com/AmadeusITGroup/AgnosUI/commit/0e45d9de36abf162578bb92f15d53c8005699e5d))
- lazy-loaded routes ([fbb421f](https://github.com/AmadeusITGroup/AgnosUI/commit/fbb421f63aecd777002f8534254bfc276a9fdf6a))
- **lint:** enforce jsdoc of widgets + exported functions in core closes [#30](https://github.com/AmadeusITGroup/AgnosUI/issues/30) ([#52](https://github.com/AmadeusITGroup/AgnosUI/issues/52)) ([f922011](https://github.com/AmadeusITGroup/AgnosUI/commit/f922011fe2dcd2a378673a6b7b5a641260dc1953))
- main mobile menu ([fa1bcb6](https://github.com/AmadeusITGroup/AgnosUI/commit/fa1bcb6da05b9abb1c5c267a2199d7372cb3f7d4))
- making auUse synchronous ([8478008](https://github.com/AmadeusITGroup/AgnosUI/commit/84780082cd1bf1cfddda072f1176c267ded9df67))
- markdown doc ([#365](https://github.com/AmadeusITGroup/AgnosUI/issues/365)) ([88f02c7](https://github.com/AmadeusITGroup/AgnosUI/commit/88f02c7d3315bba914cb90ddb860c94cdf151d52))
- **menu:** Add collapsible sections to side menu ([8d1a68d](https://github.com/AmadeusITGroup/AgnosUI/commit/8d1a68d9a30787186aa1db14d78d7e6ba11cdf60))
- **mermaid:** Integrate mermaid in markdown renderer ([#413](https://github.com/AmadeusITGroup/AgnosUI/issues/413)) ([259f1df](https://github.com/AmadeusITGroup/AgnosUI/commit/259f1dfd6f1f377a60aa6cfc158523945c727540))
- move the framework selection into the side menu instead of component page header ([71821e1](https://github.com/AmadeusITGroup/AgnosUI/commit/71821e151c0025161f407637beb76e8bfbb416f8))
- navigation manager ([#177](https://github.com/AmadeusITGroup/AgnosUI/issues/177)) ([f36bcde](https://github.com/AmadeusITGroup/AgnosUI/commit/f36bcded8ba1c31937ab112679a1b9b5e99992b3))
- **navManager:** add focusFirstLeft/focusFirstRight and fix navManager e2e test on Mac ([873ad1d](https://github.com/AmadeusITGroup/AgnosUI/commit/873ad1d6f4cd3a2015a92d6cf60aec3739a71fdd))
- **pagination:** Demo add first pagination Ex ([#40](https://github.com/AmadeusITGroup/AgnosUI/issues/40)) ([54c829b](https://github.com/AmadeusITGroup/AgnosUI/commit/54c829bd181a151d2a089f9badc22b1e52b6d88a))
- release the website into the wild ([fe80de2](https://github.com/AmadeusITGroup/AgnosUI/commit/fe80de2eef6bd90abc4b40870daf379b4362975d))
- remove eslint disable from svelte samples ([f3642d4](https://github.com/AmadeusITGroup/AgnosUI/commit/f3642d44d74d5b223d12152d1d01ed206a61293c))
- removing dispatch-style events in Svelte ([#272](https://github.com/AmadeusITGroup/AgnosUI/issues/272)) ([3b6947a](https://github.com/AmadeusITGroup/AgnosUI/commit/3b6947a5ec24af524529378d12026bfd0fe6759e))
- resizable iframe + link headers ([#77](https://github.com/AmadeusITGroup/AgnosUI/issues/77)) ([ce2ab44](https://github.com/AmadeusITGroup/AgnosUI/commit/ce2ab443dc21c91bfdf119112f619c83e2df7e07))
- run core outside of Angular zone ([#188](https://github.com/AmadeusITGroup/AgnosUI/issues/188)) ([24d49aa](https://github.com/AmadeusITGroup/AgnosUI/commit/24d49aa5d03a2e69994f5cad2dff19ae7276189a))
- **select:** positioning ([#312](https://github.com/AmadeusITGroup/AgnosUI/issues/312)) ([8a8d8a6](https://github.com/AmadeusITGroup/AgnosUI/commit/8a8d8a64ec05af47c9b98da24430ec52df4dad4e))
- set up self-hosted renovate ([ff83ff7](https://github.com/AmadeusITGroup/AgnosUI/commit/ff83ff7208da195446dc11e38c583f0a6e9f4fc9))
- setup wireit ([#353](https://github.com/AmadeusITGroup/AgnosUI/issues/353)) ([1b764c3](https://github.com/AmadeusITGroup/AgnosUI/commit/1b764c3b2b6c323cadbab1116bbcf9c463eed318))
- **slider:** Add decimal values support for slider ([e32c608](https://github.com/AmadeusITGroup/AgnosUI/commit/e32c60830473eb55a263b1b71e166bb2eb1f2dc3))
- **slider:** Add props for showing min, max and value labels ([c935a7d](https://github.com/AmadeusITGroup/AgnosUI/commit/c935a7d62decccd1bfaa3f98c44b94aaaedad78e))
- **slider:** Add RTL support ([890047b](https://github.com/AmadeusITGroup/AgnosUI/commit/890047bccf410fe7bfe299718af29c6ad02c793f))
- **slider:** Add slider component ([#182](https://github.com/AmadeusITGroup/AgnosUI/issues/182)) ([07d66a9](https://github.com/AmadeusITGroup/AgnosUI/commit/07d66a98e08172215c89bf9c0fd5f78469174428))
- **slider:** add style mixin + css modification ([#234](https://github.com/AmadeusITGroup/AgnosUI/issues/234)) ([585e2d5](https://github.com/AmadeusITGroup/AgnosUI/commit/585e2d528eddd161a7b96ab547f8e6fa9470cfc8))
- **slider:** Add touch events to slider ([422cff6](https://github.com/AmadeusITGroup/AgnosUI/commit/422cff626f0b2942374d6b149272d76af6761081))
- slight README.md change ([8021ed8](https://github.com/AmadeusITGroup/AgnosUI/commit/8021ed8f78a319bc7f7431efaad651be2cbc794f))
- speed up stackblitz install by a LOT ([9a058f9](https://github.com/AmadeusITGroup/AgnosUI/commit/9a058f947ead96f204a20bc5d120abd5e0b2e86b))
- **style-bootstrap:** slider style refactor + style-bootstrap package ([#218](https://github.com/AmadeusITGroup/AgnosUI/issues/218)) ([21b11f3](https://github.com/AmadeusITGroup/AgnosUI/commit/21b11f3ff8cdfcd4677a2f66d573608eee086ad0))
- **style:** add prefix + customization + sizing ([#412](https://github.com/AmadeusITGroup/AgnosUI/issues/412)) ([00431f2](https://github.com/AmadeusITGroup/AgnosUI/commit/00431f2a4f7d0e5dd093d805db52d3473230c2fa))
- support and enforce number and boolean transform functions in angular ([b7f4e21](https://github.com/AmadeusITGroup/AgnosUI/commit/b7f4e21c06ad7fb72bfddbc07e77141bb10f0fa2))
- update angular logo + dialog display on mobile ([fb89d26](https://github.com/AmadeusITGroup/AgnosUI/commit/fb89d26c488077b9dec0e29c9921440a6baa8c1c))
- useDirectives ([#311](https://github.com/AmadeusITGroup/AgnosUI/issues/311)) ([4e25c1a](https://github.com/AmadeusITGroup/AgnosUI/commit/4e25c1a9a47d234c938aaed51bc7c479bf66b024))
- view transitions on demo website ([17f9a97](https://github.com/AmadeusITGroup/AgnosUI/commit/17f9a97311813777164905b2fd7b80ee3f427cee))

### Bug Fixes

- **Accordion:** clean unused code ([#164](https://github.com/AmadeusITGroup/AgnosUI/issues/164)) ([b30e71b](https://github.com/AmadeusITGroup/AgnosUI/commit/b30e71b71c8cea612d27b106e2b979aa8d5091d8))
- adapt the type of widget factories for slots in headless packages ([#165](https://github.com/AmadeusITGroup/AgnosUI/issues/165)) ([70ab1d0](https://github.com/AmadeusITGroup/AgnosUI/commit/70ab1d03866ca0d46581bf6c96d4fcdc2610cf05))
- add path to renovate config + set renovate platform ([771065b](https://github.com/AmadeusITGroup/AgnosUI/commit/771065b7512339e481e552d1337b2553f77c64e9))
- adding back the service worker ([f4dadf4](https://github.com/AmadeusITGroup/AgnosUI/commit/f4dadf48b502a7dc3a4f6a9e178e66d93fd51753))
- **alert:** Add alert-dismissible class ([16d8c1f](https://github.com/AmadeusITGroup/AgnosUI/commit/16d8c1fc28a454a434f2fec616b741386beaebe6))
- angular budget error when building with coverage instrumentation ([#250](https://github.com/AmadeusITGroup/AgnosUI/issues/250)) ([a081136](https://github.com/AmadeusITGroup/AgnosUI/commit/a08113600f1dc92cc16de68d514f73ff8fa5a22c))
- angular config types ([d6b76ee](https://github.com/AmadeusITGroup/AgnosUI/commit/d6b76ee629fb0e0b5f176a14964645bec5b04e93))
- angular logo ([8c7f46a](https://github.com/AmadeusITGroup/AgnosUI/commit/8c7f46a02d53fc3a0b3b296a3df887efee8d932a))
- angular types ([4300462](https://github.com/AmadeusITGroup/AgnosUI/commit/4300462eb4ffb4f27c5bae81f6f655901f7a7899))
- **angular:** workaround for a bug in Angular when updating to v16.2.4 ([b0d09e0](https://github.com/AmadeusITGroup/AgnosUI/commit/b0d09e0b5fed133d2fe4518aea3a17b90046cfae))
- api and playground on local ([60065ae](https://github.com/AmadeusITGroup/AgnosUI/commit/60065ae0d8e1ee4741ab3fb4cbc7c07ef053d65b))
- api default config for slider ([787b1e0](https://github.com/AmadeusITGroup/AgnosUI/commit/787b1e0c18cd69ae75d149d7dc82f8687e8143ed))
- bootstrap links in stackblitz ([d0ab8b7](https://github.com/AmadeusITGroup/AgnosUI/commit/d0ab8b798ba71209c60ede0993e69f3398534f84))
- **build:** code coverage ([d8b100b](https://github.com/AmadeusITGroup/AgnosUI/commit/d8b100b76fa7c3174b45efe9ea90e697a01c6338))
- **build:** computation of doc folder based on the version number ([#110](https://github.com/AmadeusITGroup/AgnosUI/issues/110)) ([946dd24](https://github.com/AmadeusITGroup/AgnosUI/commit/946dd241c8d05a712c08c343770d944b5670736a))
- check version number does not start with v ([#189](https://github.com/AmadeusITGroup/AgnosUI/issues/189)) ([d806214](https://github.com/AmadeusITGroup/AgnosUI/commit/d806214b622e3c9be916ff6ec22ec62eb3dccba2))
- color contrast in demo website ([#37](https://github.com/AmadeusITGroup/AgnosUI/issues/37)) ([e419c85](https://github.com/AmadeusITGroup/AgnosUI/commit/e419c85db643bf17f5ce8e7e0c93389b7beea845))
- correct title / description for installation guide ([95b224e](https://github.com/AmadeusITGroup/AgnosUI/commit/95b224e0fadca94540fac148d5e9895309c1e8b4))
- **coverage:** better code coverage ([#51](https://github.com/AmadeusITGroup/AgnosUI/issues/51)) ([ac5ecf4](https://github.com/AmadeusITGroup/AgnosUI/commit/ac5ecf439e0c5502b3d455f396408a2f0f82e0ff))
- **demo:** add tabs nowrap ([a06c135](https://github.com/AmadeusITGroup/AgnosUI/commit/a06c13590777f87e5e57deb5ac0a71ab7f09b62d))
- **demo:** keep component active in the menu even when not on "Examples" tab ([8274c70](https://github.com/AmadeusITGroup/AgnosUI/commit/8274c707b306d3fbc2eeca9e5df17a1469d89623))
- **demo:** react custom demo was not consistent with angular and svelte ([8bc8c0a](https://github.com/AmadeusITGroup/AgnosUI/commit/8bc8c0a593f97c5ce5010b986b5329af9bd6339a))
- **demo:** version number displayed in the demo site ([909f58a](https://github.com/AmadeusITGroup/AgnosUI/commit/909f58ae8b036771496cc2b172c815821729c731))
- deployment to gh-pages, list of versions now published in versions.json ([bac770c](https://github.com/AmadeusITGroup/AgnosUI/commit/bac770cdfd6f53c92a60c81883871875fac59b96))
- **deps:** fixing issue with dependencies ([f373f4d](https://github.com/AmadeusITGroup/AgnosUI/commit/f373f4db998bcc0a07312c17ac2700fed51b06ea))
- **deps:** update all non-major dependencies ([95271bb](https://github.com/AmadeusITGroup/AgnosUI/commit/95271bbbafabd00339dba91d0fa832ac703b906c))
- **deps:** update all non-major dependencies ([d7ab68d](https://github.com/AmadeusITGroup/AgnosUI/commit/d7ab68dfbe447a9e90fa55ab4506476c510c37e6))
- **deps:** update all non-major dependencies ([9d72d8c](https://github.com/AmadeusITGroup/AgnosUI/commit/9d72d8c30da3715637868e08243fe0a3a642594d))
- **deps:** update all non-major dependencies ([e2096a7](https://github.com/AmadeusITGroup/AgnosUI/commit/e2096a78a87ae8864d03cb92ac4cb1cb26c784d2))
- **deps:** update all non-major dependencies ([7645f10](https://github.com/AmadeusITGroup/AgnosUI/commit/7645f10dab8330e40763c6c11134d8b343924878))
- **deps:** update all non-major dependencies ([ae9cd0f](https://github.com/AmadeusITGroup/AgnosUI/commit/ae9cd0f5cdc30ce9ca13487a24cbe75d8e1b16db))
- **deps:** update all non-major dependencies ([#113](https://github.com/AmadeusITGroup/AgnosUI/issues/113)) ([f049d4b](https://github.com/AmadeusITGroup/AgnosUI/commit/f049d4bf44f2045c94c6ed1d2e56b276369d5796))
- **deps:** update all non-major dependencies ([#169](https://github.com/AmadeusITGroup/AgnosUI/issues/169)) ([02c60e8](https://github.com/AmadeusITGroup/AgnosUI/commit/02c60e8d65583fef00208a4f21b9582e5671724f))
- **deps:** update all non-major dependencies ([#215](https://github.com/AmadeusITGroup/AgnosUI/issues/215)) ([65aafc5](https://github.com/AmadeusITGroup/AgnosUI/commit/65aafc5bcef9aa41409fd5e548f1cfe83be60d67))
- **deps:** update dependency @amadeus-it-group/tansu to v1 ([701d3c5](https://github.com/AmadeusITGroup/AgnosUI/commit/701d3c50be534012643ca33844edd5d95fd46074))
- display of readonly rating on android ([#81](https://github.com/AmadeusITGroup/AgnosUI/issues/81)) ([44be31d](https://github.com/AmadeusITGroup/AgnosUI/commit/44be31d7fc24c57cd92d9c7086cd2e917a9e96ee))
- **doc:** createPagination option is for pagination ([#126](https://github.com/AmadeusITGroup/AgnosUI/issues/126)) ([e3886cb](https://github.com/AmadeusITGroup/AgnosUI/commit/e3886cb6f9a43038b65edf09ba923d1e2a30ca6f))
- **e2e:** use expect.poll to wait for the state to match expectations ([#166](https://github.com/AmadeusITGroup/AgnosUI/issues/166)) ([6321bfa](https://github.com/AmadeusITGroup/AgnosUI/commit/6321bfadc5a800753323eca338d8abdde1de9ed6))
- eslint not working in vscode for some files in Angular ([f6018a7](https://github.com/AmadeusITGroup/AgnosUI/commit/f6018a7c47bed80ac6f274bbbb3f72da3e2e81f7))
- eslint plugin error reporting with bindings ([#247](https://github.com/AmadeusITGroup/AgnosUI/issues/247)) ([3fd0f2e](https://github.com/AmadeusITGroup/AgnosUI/commit/3fd0f2e253d39b84f47cfae290ad434d82285b55))
- eslint-plugin issue with types comparison ([baa93b6](https://github.com/AmadeusITGroup/AgnosUI/commit/baa93b69276481602bf24b12a4b692c16fc8099f))
- explicitly set repositories for renovate ([44d3ece](https://github.com/AmadeusITGroup/AgnosUI/commit/44d3ece2f528419c4985bf69a4f26b3508f0e042))
- file format + errors reported by svelte-check after minor upgrade ([ac1508c](https://github.com/AmadeusITGroup/AgnosUI/commit/ac1508c987de48c2f2a9ae1c359e132bd5795d64))
- fixing e2e tests ([#287](https://github.com/AmadeusITGroup/AgnosUI/issues/287)) ([ec0d9b5](https://github.com/AmadeusITGroup/AgnosUI/commit/ec0d9b57d46eca5ea74bb6a0843ef6bad3ef01d5))
- fixing typo preventing correct type-checking for the Alert in svelte ([6f912ae](https://github.com/AmadeusITGroup/AgnosUI/commit/6f912aee7623e956da64929e04989ce4024d869f))
- generation of exports on windows ([#319](https://github.com/AmadeusITGroup/AgnosUI/issues/319)) ([00d8e12](https://github.com/AmadeusITGroup/AgnosUI/commit/00d8e12461592d3403213b70436366e0ce171dbe))
- generic alert flicker ([#53](https://github.com/AmadeusITGroup/AgnosUI/issues/53)) ([c058661](https://github.com/AmadeusITGroup/AgnosUI/commit/c0586612febefb07f22165f544fe2b47a2a532e4))
- height of scrollable content container ([3f429fb](https://github.com/AmadeusITGroup/AgnosUI/commit/3f429fbc8375f5e03064b968fef56ffaf4cdadee))
- improve slider e2e test reliability ([#331](https://github.com/AmadeusITGroup/AgnosUI/issues/331)) ([f1e24f2](https://github.com/AmadeusITGroup/AgnosUI/commit/f1e24f214a6bd03fd193a3767e846af835c57ff3))
- incorrect usage of <slot> in accordion sample ([#271](https://github.com/AmadeusITGroup/AgnosUI/issues/271)) ([9c14c0a](https://github.com/AmadeusITGroup/AgnosUI/commit/9c14c0a20de16f7f0eeb742fb5732be005c8765c))
- incorrect usage of <slot> in accordion samples ([#273](https://github.com/AmadeusITGroup/AgnosUI/issues/273)) ([430f3bb](https://github.com/AmadeusITGroup/AgnosUI/commit/430f3bb9b5c6a778b5022d92b55eb302b47be39d))
- indicate to svelte-aware tooling that headless and lib are svelte libraries ([a511084](https://github.com/AmadeusITGroup/AgnosUI/commit/a51108441b6b822a254b4b511df00eb823380808))
- initial 500 error when navigating from home page ([43fa1c2](https://github.com/AmadeusITGroup/AgnosUI/commit/43fa1c290c42213bf5b02a6b95c95f48339ce08b))
- landing page on mobile [#35](https://github.com/AmadeusITGroup/AgnosUI/issues/35) ([#36](https://github.com/AmadeusITGroup/AgnosUI/issues/36)) ([509b90e](https://github.com/AmadeusITGroup/AgnosUI/commit/509b90ecd29ea2ff55415c0818c81400ca264604))
- links script on windows ([627ae87](https://github.com/AmadeusITGroup/AgnosUI/commit/627ae8720156b82bbb9f2b1aaa76e4e21302711d))
- markdown rendering on follow-up navigation ([d422d5f](https://github.com/AmadeusITGroup/AgnosUI/commit/d422d5f9f884385061a6398875dc85c36ac6ed46))
- md breakpoint display ([#406](https://github.com/AmadeusITGroup/AgnosUI/issues/406)) ([2396994](https://github.com/AmadeusITGroup/AgnosUI/commit/2396994c7c8c046995c30f1396b863a3c34522fb))
- modal props validation ([#275](https://github.com/AmadeusITGroup/AgnosUI/issues/275)) ([eba66fb](https://github.com/AmadeusITGroup/AgnosUI/commit/eba66fb86603a88c5e7f9275c445bcf2bee722c5))
- package and README not present in @agnos-ui/svelte ([219414d](https://github.com/AmadeusITGroup/AgnosUI/commit/219414d26eef730c14c2d267bc2c46cff9bef4f7))
- portal directive should not move element when not needed ([#270](https://github.com/AmadeusITGroup/AgnosUI/issues/270)) ([a684409](https://github.com/AmadeusITGroup/AgnosUI/commit/a684409032576512ef9762b8902ef75483d4325e))
- removing loading="lazy" on demo samples iframe (as Firefox bugs with it) ([f116a16](https://github.com/AmadeusITGroup/AgnosUI/commit/f116a16fa0cfe3066d795253201c9d6f2141efab))
- removing useless re-exports ([42373fe](https://github.com/AmadeusITGroup/AgnosUI/commit/42373fef59d086784e53c4469f75974de177dd5c))
- renovate github action version ([5f3c352](https://github.com/AmadeusITGroup/AgnosUI/commit/5f3c35265d1de5844836ac19e22bcdccb91d95e8))
- replacing context.getSourceCode() by context.sourceCode in eslint-plugin ([92f8ea8](https://github.com/AmadeusITGroup/AgnosUI/commit/92f8ea88c669c83e7981300614b355ef6198fb2f))
- **responsiveness:** Main content takes 50% space, menu are shrinked accordingly. ([dce178c](https://github.com/AmadeusITGroup/AgnosUI/commit/dce178cf8def9ae8e048f3ca0b782aecec86d7d4))
- scroll back to top on navigation ([9ca108f](https://github.com/AmadeusITGroup/AgnosUI/commit/9ca108f6f20c7f5f2fb5892ff1303cebb5e7701e))
- service worker cache collision on same domain ([#159](https://github.com/AmadeusITGroup/AgnosUI/issues/159)) ([38bceff](https://github.com/AmadeusITGroup/AgnosUI/commit/38bceff9020e41d99de62287a231b79a53982c69))
- **service-worker:** fetch resource if cache does not hold it ([25c56e4](https://github.com/AmadeusITGroup/AgnosUI/commit/25c56e4310a8f3f07b4352a878230b12d8ec7001))
- setVersion + warning on stdinout listeners ([b506936](https://github.com/AmadeusITGroup/AgnosUI/commit/b506936e3027cb43ac4dd74b63a89a3505b7c67e))
- slider e2e test stability ([#318](https://github.com/AmadeusITGroup/AgnosUI/issues/318)) ([c7071d4](https://github.com/AmadeusITGroup/AgnosUI/commit/c7071d4386f77a8aee3f8210f57a909c7f3c6830))
- slider e2e test stability and readability improvement ([#310](https://github.com/AmadeusITGroup/AgnosUI/issues/310)) ([142ae61](https://github.com/AmadeusITGroup/AgnosUI/commit/142ae61503adc6d883e7e115ce212e5ee9ac0df6))
- **slider:** Allow slider click through progress ([142113c](https://github.com/AmadeusITGroup/AgnosUI/commit/142113c864ecbebaa083cca59f973eb439dcd638))
- **slider:** Bind min, max and stepSize to clean value ([053dd77](https://github.com/AmadeusITGroup/AgnosUI/commit/053dd77b9fa6ec8fad8c96931ec5ff1ab98c153f))
- **slider:** Remove margin block and align labels for vertical ([c9ba24b](https://github.com/AmadeusITGroup/AgnosUI/commit/c9ba24bb372e3a5233ceb0d3e1b315339cd919ff))
- **slider:** Request bounding rect for click and touch ([86eeea7](https://github.com/AmadeusITGroup/AgnosUI/commit/86eeea73840599d6fc657ab4b36c1bdf354dce6b))
- **slider:** style bootstrap font-weight + margin ([#429](https://github.com/AmadeusITGroup/AgnosUI/issues/429)) ([9187e92](https://github.com/AmadeusITGroup/AgnosUI/commit/9187e92b4d84fd95640191f1469ba6e87ee5e538))
- stackblitz with css ([e23893f](https://github.com/AmadeusITGroup/AgnosUI/commit/e23893fceb1c3b809dc7b316589418223cc7ae22))
- **svelte:** partly fixes SSR with svelte ([d4d2c19](https://github.com/AmadeusITGroup/AgnosUI/commit/d4d2c1991401c11a0880c2b70ff0e260b3650ea6))
- toAngularSignal test with Angular 17.1.0 ([95d367d](https://github.com/AmadeusITGroup/AgnosUI/commit/95d367d42170ba54e876ddbfa0f432064b990388))
- types for react ([e6d32d8](https://github.com/AmadeusITGroup/AgnosUI/commit/e6d32d8905ae6ebf0bef8b21bcdfe71b4c2b83df))
- typo in github renovate file pattern ([dabdfdc](https://github.com/AmadeusITGroup/AgnosUI/commit/dabdfdc9be454ede9438158082a7dec846843331))
- use capture for focustrack utility ([17c329e](https://github.com/AmadeusITGroup/AgnosUI/commit/17c329e34859bf1a865c63fa617f98e33506cfd8))
- use minimatch pattern ([cb4c3b5](https://github.com/AmadeusITGroup/AgnosUI/commit/cb4c3b5864e907c08761d3f50eac111c07455f7e))
- use twitter-x bootstrap icon for twitter link ([#179](https://github.com/AmadeusITGroup/AgnosUI/issues/179)) ([d73d7e3](https://github.com/AmadeusITGroup/AgnosUI/commit/d73d7e379f0fa1d7e2a31a08011ff4fbc31438e3))
- woopsie on relative navigation ([ffe820b](https://github.com/AmadeusITGroup/AgnosUI/commit/ffe820b290ec7cea0dbfdc0b2d7c732fe496576d))
