# Deep Learning Time Series Forecasting
[![PRsWelcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)


List of state of the art papers focus on deep learning and resources, code and experiments using deep learning for time series forecasting. Classic methods vs Deep Learning methods, Competitions...

## [Table of Contents]()

* [Papers](#Papers)
* [Conferences](#Conferences)
* [Competitions](#Competitions)
* [Code](#Code)
* [Theory-Resource](#Theory-Resource)
* [Code Resource](#Code-Resource)
* [Datasets](#Datasets)


## Papers

### 2021

- [Autoformer: Decomposition Transformers with Auto-Correlation for Long-Term Series Forecasting](https://arxiv.org/abs/2106.13008)

  - Haixu Wu, et al.
  - [[Code](https://github.com/thuml/Autoformer)]

- [Long Range Probabilistic Forecasting in Time-Series using High Order Statistics](https://arxiv.org/pdf/2111.03394.pdf)

  - Prathamesh Deshpande, et al.
  - \[[Code](https://github.com/pratham16cse/AggForecaster)\]

- [Online Multi-Agent Forecasting with Interpretable Collaborative Graph Neural Networks](https://arxiv.org/pdf/2107.00894.pdf)

  - Maosen Li, et al.
  - Code not yet.

- [End-to-End Learning of Coherent Probabilistic Forecasts for Hierarchical Time Series](http://proceedings.mlr.press/v139/rangapuram21a/rangapuram21a.pdf)

  -  Syama Sundar Rangapuram, et al.
  - Code not yet.

- [Neural basis expansion analysis with exogenous variables:Forecasting electricity prices with NBEATSx](https://arxiv.org/pdf/2104.05522.pdf)

  - Kin G. Olivares, et al.
  - [[Code](https://github.com/cchallu/nbeatsx)]

- [Autoregressive Denoising Diffusion Models for Multivariate Probabilistic Time Series Forecasting](https://arxiv.org/pdf/2101.12072.pdf) **reference**

  - Kashif Rasul, et al.
  - [[Code](https://github.com/zalandoresearch/pytorch-ts)]

- [An Experimental Review on Deep Learning Architectures for Time Series Forecasting](https://www.researchgate.net/publication/347133536_An_Experimental_Review_on_Deep_Learning_Architectures_for_Time_Series_Forecasting)

  - Pedro Lara-Benítez, et al.
  - [[Code](https://github.com/pedrolarben/TimeSeriesForecasting-DeepLearning)]

- [Long Horizon Forecasting With Temporal Point Processes](https://arxiv.org/pdf/2101.02815.pdf)

  - Prathamesh Deshpande, et al.
  - [[Code](https://github.com/pratham16cse/DualTPP)]

- [Informer: Beyond Efficient Transformer for Long Sequence Time-Series Forecasting](https://arxiv.org/pdf/2012.07436.pdf) `AAAI 2021`

  - Haoyi Zhou, et al.
  - [[Code](https://github.com/zhouhaoyi/Informer2020)]

### 2020

- [CHALLENGES AND APPROACHES TO TIME-SERIES FORECASTING IN DATA CENTER TELEMETRY: A SURVEY](https://arxiv.org/pdf/2101.04224.pdf)

  - Shruti Jadon, et al.
  - Code not yet.

- [Forecasting and Anomaly Detection approaches using LSTM and LSTM Autoencoder techniques with the applications in supply chain management](https://www.sciencedirect.com/science/article/abs/pii/S026840122031481X)

  - H.D. Nguyen, et al.
  - Code not yet.

- [Physics-constrained Deep Recurrent Neural Models of Building Thermal Dynamics](https://www.climatechange.ai/papers/neurips2020/41/paper.pdf)

  - Ján Drgona, et al.
  - Code not yet.

- [MiniRocket: A Very Fast (Almost) Deterministic Transform for Time Series Classification](https://arxiv.org/pdf/2012.08791.pdf)

  - Angus Dempster, et al.
  - [[Code](https://github.com/angus924/minirocket)]

- [Learning to Select the Best Forecasting Tasks for Clinical Outcome Prediction](https://proceedings.neurips.cc/paper/2020/file/abc99d6b9938aa86d1f30f8ee0fd169f-Paper.pdf)

  - Yuan Xue, et al.
  - Code not yet.

- [Real-World Anomaly Detection by using Digital
Twin Systems and Weakly-Supervised Learning](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=9179030)

  - Castellani Andrea, et al.
  - ```Honda Research Institute Europe GmbH```
  - Code not yet.

- [Inter-Series Attention Model for COVID-19 Forecasting](https://arxiv.org/pdf/2010.13006.pdf) **Good reference**

  - Xiaoyong Jin, et al.
  - [[Code](https://github.com/Gandor26/covid-open)]

- [MODEL SELECTION IN RECONCILING HIERARCHICAL TIME SERIES](https://arxiv.org/pdf/2010.10742.pdf)

  - M. ABOLGHASEMI, et al.
  - [[Code](https://github.com/mahdiabolghasemi/Conditional-reconciliation-in-HF)]

- [A Strong Baseline for Weekly Time Series Forecasting](https://arxiv.org/pdf/2010.08158.pdf)

  - Rakshitha Godahewa, et al.
  - [[Code](https://github.com/rakshitha123/WeeklyForecasting)]

- [Structural Forecasting for Tropical Cyclone Intensity Prediction: Providing Insight with Deep Learning](https://arxiv.org/pdf/2010.05783.pdf)

  - Trey McNeely, et al.
  - Code not yet.

- [Modeling Heterogeneous Seasonality With Recurrent Neural Networks Using IoT Time Series Data for Defrost Detection and Anomaly Analysis](https://dash.harvard.edu/bitstream/handle/1/37365638/KHETARPAL-DOCUMENT-2020.pdf?sequence=1&isAllowed=y) **Good Reference**

  - Khetarpal, Suraj.
  - Code not yet.

- [An Examination of the State-of-the-Art for Multivariate Time Series Classification](https://www.researchgate.net/profile/Georgiana_Ifrim/publication/344501445_An_Examination_of_the_State-of-the-Art_for_Multivariate_Time_Series_Classification/links/5f7cdfb2458515b7cf6c4efd/An-Examination-of-the-State-of-the-Art-for-Multivariate-Time-Series-Classification.pdf)

  - Bhaskar Dhariyal, et al.
  - Code noy yet.

- [Rank Position Forecasting in Car Racing](https://arxiv.org/pdf/2010.01707.pdf)

  - Bo Peng, et al.
  - Code not yet.

- [Mixed Membership Recurrent Neural Networks for Modeling Customer Purchases](http://www.columbia.edu/~jwp2128/Papers/FazelniaIbrahimetal2020.pdf)

  - Ghazal Fazelnia, et al.
  - Code not yet.

- [An analysis of deep neural networks for predicting trends in time series data](https://arxiv.org/pdf/2009.07943.pdf)

  - Kouame Kouassi and Deshendran Moodley.
  - Code not yet.

- [Automatic Forecasting using Gaussian Processes](https://arxiv.org/pdf/2009.08102.pdf)

  - G. Corani
  - Code not yet.

- [Attention based Multi-Modal New Product Sales Time-series Forecasting](https://dl.acm.org/doi/10.1145/3394486.3403362)

  - Vijay Ekambaram
  - Code not yet.

- [Demand Forecasting of individual Probability Density Functions with Machine Learning](https://arxiv.org/pdf/2009.07052.pdf)

  - Felix Wick, et al.
  - Code not yet.

- [A Time-Series Forecasting Performance Comparison for Neural Networks with State Space and ARIMA Models](http://www.ieomsociety.org/detroit2020/papers/37.pdf)

   - Milton Soto-Ferrari
   - Code not yet.

- [Short-term Time Series Forecasting of Concrete Sewer Pipe Surface Temperature](https://www.researchgate.net/profile/Karthick_Thiyagarajan7/publication/344199272_Short-term_Time_Series_Forecasting_of_Concrete_Sewer_Pipe_Surface_Temperature/links/5f5b0b4492851c07895d48fc/Short-term-Time-Series-Forecasting-of-Concrete-Sewer-Pipe-Surface-Temperature.pdf)

  - Karthick Thiyagarajan, et al.
  - Code not yet.

- [Multivariate Time-series Anomaly Detection via Graph Attention Network](https://arxiv.org/pdf/2009.02040.pdf)

  - Hang Zhao, et al.
  - Code not yet.

- [Graph Neural Networks for Model Recommendation using Time Series Data](https://arxiv.org/pdf/2009.03474.pdf)

  - Aleksandr Pletnev, et al.
  - Code not yet.

- [Kaggle forecasting competitions: An overlooked learning opportunity](https://www.sciencedirect.com/science/article/pii/S0169207020301114)

  - Casper Solheim Bojer and Jens Peder Meldgaard.
  - [[Code](https://github.com/cbojer/kaggle-project)]

- [Forecasting with Multiple Seasonality](https://arxiv.org/pdf/2008.12340.pdf)

  - Tianyang Xie and Jie Ding.
  - Code not yet.

- [LAVARNET: Neural network modeling of causal variable relationships for multivariate time series forecasting](https://arxiv.org/pdf/2009.00945.pdf)

  - Christos Koutlis, et al.
  - Code not yet.

- [Forecasting Hierarchical Time Series with a Regularized Embedding Space](https://kdd-milets.github.io/milets2020/papers/MiLeTS2020_paper_13.pdf)

  - Jeffrey L. Gleason.
  - [[Code](https://github.com/jlgleason/hts-constrained-embeddings)]

- [Forecasting the Evolution of Hydropower Generation](https://dl.acm.org/doi/abs/10.1145/3394486.3403337)

  - Fan Zhou, et al.
  - [[Code](https://github.com/Anewnoob/DeepHydro)]

- [Deep State-Space Generative Model For Correlated Time-to-Event Predictions](https://dl.acm.org/doi/abs/10.1145/3394486.3403206)

  - Yuan Xue, et al.
  - Code not yet.

- [Short-term forecasting of the COVID-19 pandemic using Google Trends data: Evidence from 158 countries](https://mpra.ub.uni-muenchen.de/102315/1/MPRA_paper_102315.pdf)

  - Fantazzini, Dean.
  - Code not yet.

- [Scalable Low-Rank Autoregressive Tensor Learning for Spatiotemporal Traffic Data Imputation](https://arxiv.org/pdf/2008.03194.pdf)

  - Xinyu Chen, et al.
  - [[Code](https://github.com/xinychen/tensor-learning)]

- [clairvoyance: a Unified, End-to-End AutoML Pipeline for Medical Time Series](https://www.vanderschaar-lab.com/papers/2020_Clairvoyance.pdf)

  - Daniel Jarrett, et al.
  - Code not yet.

- [Speed Anomalies and Safe Departure Times from Uber Movement Data](http://urban.cs.wpi.edu/urbcomp2020/file/08.pdf)

  - Nabil Al Nahin Ch, et al.
  - Code not yet.

- [Forecasting AI Progress: A Research Agenda](https://arxiv.org/pdf/2008.01848.pdf)

  - Ross Gruetzemacher, et al.
  - Review

- [Improving the Accuracy of Global Forecasting Models using Time Series Data Augmentation](https://arxiv.org/abs/2008.02663)

  - Kasun Bandara, et al.
  - Code not yet.

- [Interpretable Sequence Learning for COVID-19 Forecasting](https://arxiv.org/pdf/2008.00646.pdf)

  - Sercan O. Arık, et al.
  - [[Code](https://github.com/reichlab/covid19-forecast-hub)]

- [Relation-aware Meta-learning for Market Segment Demand Prediction with Limited Records](https://arxiv.org/pdf/2008.00181.pdf) **meta-learning**

  - Jiatu Shi, et al.
  - Code not yet.

- [Forecasting Economic Recession through Share Price in the Logistics Industry with Artificial Intelligence (AI)](https://www.mdpi.com/2079-3197/8/3/70/pdf)

  - YM Tang, et al.
  - Code not yet.

- [PRINCIPLES AND ALGORITHMS FOR FORECASTING GROUPS OF TIME SERIES: LOCALITY AND GLOBALITY](https://arxiv.org/pdf/2008.00444.pdf)

  - Pablo Montero-Manso and Rob J Hyndman
  - Code not yet.

- [Multi-stream RNN for Merchant Transaction Prediction](https://arxiv.org/pdf/2008.01670.pdf)

  - Zhongfang Zhuang, et al.
  - `KDD 2020 Workshop on Machine Learning in Finance`
  - Code not yet.

- [Prediction of hierarchical time series using structured regularization and its application to artificial neural networks](https://arxiv.org/pdf/2007.15159.pdf)

  - Tomokaze Shiratori, et al.
  - Code not yet.

- [Cold-Start Promotional Sales Forecasting through Gradient Boosted-based Contrastive Explanations](https://ieeexplore.ieee.org/abstract/document/9149573)

  - Carlos Aguilar-Palacios, et al.
  - [[Code](https://github.com/CarlitosDev/contrastiveExplanation/tree/master/contrastiveRegressor)]

- [Anomaly Detection at Scale: The Case for Deep Distributional Time Series Models](https://arxiv.org/pdf/2007.15541.pdf)

  - Fadhel Ayed, et al.
  - `Amazon Research`
  - [[Code](https://github.com/awslabs/gluon-ts/tree/distribution_anomaly_detection/distribution_anomaly_detection)]

- [Demand Forecasting in the Presence of Privileged Information](https://staff.fnwi.uva.nl/m.derijke/wp-content/papercite-data/pdf/ariannezhad-2020-demand.pdf)

  - Mozhdeh Ariannezhad, et al.
  - [[Code](https://github.com/mzhariann/PIANN)]

- [Seasonal Self-evolving Neural Networks Based Short-term Wind Farm Generation Forecast](https://www.researchgate.net/publication/342976923_Seasonal_Self-evolving_Neural_Networks_Based_Short-term_Wind_Farm_Generation_Forecast)

  - Yunchuan Liu, et al.
  - Code not yet.

- [Distributed ARIMA Models for Ultra-long Time Series](https://arxiv.org/pdf/2007.09577.pdf) **Spark**

  - Xiaoqian Wang, et al.
  - [[Code](https://github.com/xqnwang/darima)]

- [Adversarial Attacks on Probabilistic Autoregressive Forecasting Models](https://arxiv.org/abs/2003.03778)

  - Raphaël Dang-Nhu, et al.
  - [[Code](https://github.com/eth-sri/probabilistic-forecasts-attacks)]

- [Superiority of Simplicity: A Lightweight Model for Network Device Workload Prediction](https://arxiv.org/pdf/2007.03568.pdf) **LSTM application**

  - Alexander Acker, et al.
  - [[Code](https://github.com/citlab/fed_challenge)]

- [Adaptive Graph Convolutional Recurrent Network for Traffic Forecasting](https://arxiv.org/pdf/2007.02842.pdf)

  - Lei Bai, et al.
  - [[Code](https://github.com/LeiBAI/AGCRN)]

- [Dynamic Multi-Scale Convolutional Neural Network for Time Series Classification](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=9115645)

  - BIN QIAN, et al.
  - Code not yet.

- [Neural Architecture Search for Time Series Classification](https://germain-forestier.info/publis/ijcnn2020.pdf)

  - Hojjat Rakhshani, et al.
  - [[Code](https://github.com/ML-MHs/IJCNN2020)]

- [Frequentist Uncertainty in Recurrent Neural Networks via Blockwise Influence Functions](https://arxiv.org/pdf/2006.13707.pdf)

  - Ahmed M. Alaa and Mihaela van der Schaar.
  - Code not yet.

- [Time Series Regression](https://arxiv.org/pdf/2006.12672.pdf)

  - Chang Wei Tan, et al.
  - [[Code](https://github.com/ChangWeiTan/TSRegression)]

- [Forecasting Supplier Delivery Performance with Recurrent Neural Networks](https://odr.chalmers.se/bitstream/20.500.12380/300824/1/Master_s_Thesis_Johan_Ramne_.pdf)

  - Johan Ramne
  - Master Thesis.

- [Markovian RNN: An Adaptive Time Series Prediction Network with HMM-based Switching for Nonstationary Environments](https://arxiv.org/pdf/2006.10119.pdf)

  - Fatih Ilhan, et al.
  - Code not yet.

- [Resilient Neural Forecasting Systems](https://dl.acm.org/doi/pdf/10.1145/3399579.3399869)

  - Michael Bohlke-Schneider, et al.
  - `Amazon Research`
  - Code not yet.

- [Dynamic Neural Relational Inference for Forecasting Trajectories](http://openaccess.thecvf.com/content_CVPRW_2020/papers/w66/Graber_Dynamic_Neural_Relational_Inference_for_Forecasting_Trajectories_CVPRW_2020_paper.pdf)

  - Colin Graber and Alexander Schwing
  - `CVPR 2020`
  - [[Code](https://github.com/cgraber/cvpr_dNRI)]

- [Traffic transformer: Capturing the continuity and periodicity of time series for traffic forecasting](https://onlinelibrary.wiley.com/doi/abs/10.1111/tgis.12644)

  - Ling Cai, et al.
  - Code not yet.

- [Stanza: A Nonlinear State Space Model for Probabilistic Inference in Non-Stationary Time Series](https://arxiv.org/pdf/2006.06553.pdf)

   - Anna K. Yanchenko and Sayan Mukherjee.
   - Code not yet.

- [Neuroevolution Strategy for Time Series Prediction](https://www.scirp.org/journal/paperinformation.aspx?paperid=100727)

   - George Naskos, et al.
   - Code not yet.

- [COVID-19: A Comparison of Time Series Methods to Forecast Percentage of Active Cases per Population](https://www.mdpi.com/2076-3417/10/11/3880)

  - Vasilis Papastefanopoulos, et al.
  - [[Code](https://github.com/ML-Upatras/COVID-19-A-comparison-of-time-series-methods-foractive-cases-forecasting)]

- [A machine learning approach for forecasting hierarchical time series](https://arxiv.org/pdf/2006.00630.pdf)

  - Paolo Mancuso, et al.
  - Code not yet.

- [ProbCast: Open-source Production, Evaluation and Visualisation of Probabilistic Forecasts](http://www.jethrobrowell.com/uploads/4/5/4/0/45405281/probcast___pmaps2020.pdf)

  - Jethro Browell and Ciaran Gilbert.
  - [[Code](https://github.com/jbrowell/ProbCast)]

- [Exploring Clinical Time Series Forecasting with Meta-Features in Variational Recurrent Models](https://ecole-itn.eu/wp-content/uploads/2020/05/IJCNN2020_Sibghat_Final.pdf)**meta-learning**

  - Sibghat Ullah, et al.
  - [[Code](https://github.com/SibghatUllah13/VRNNs-for-Clinical-Time-Series-Forecasting)]

- [Semisupervised Deep State-Space Model for Plant Growth Modeling](https://spj.sciencemag.org/plantphenomics/2020/4261965/)

  - S. Shibata, et al.
  - Code not yet.

- [EFFECTIVE AND EFFICIENT COMPUTATION WITH MULTIPLE-TIMESCALE SPIKING RECURRENT NEURAL NETWORKS](https://arxiv.org/pdf/2005.11633.pdf)

  - Bojian Yin, et al.
  - Code not yet.

- [Multivariate time series forecasting via attention-based encoder–decoder framework](https://www.sciencedirect.com/science/article/abs/pii/S0925231220300606)

  - Shengdong Du, et al.
  - `Neurocomputing`
  - Code not yet.

- [A Novel LSTM for Multivariate Time Series with Massive Missingness](https://www.mdpi.com/1424-8220/20/10/2832)

  - Nazanin Fouladgar and Kary Främling.
  - Code not yet.

- [N-BEATS: NEURAL BASIS EXPANSION ANALYSIS FOR INTERPRETABLE TIME SERIES FORECASTING](https://arxiv.org/pdf/1905.10437.pdf)` ICLR 2020`

  - Boris N. Oreshkin, et al.
  - Code not yet.

- [How to Learn from Others: Transfer Machine Learning with Additive Regression Models to Improve Sales Forecasting](https://arxiv.org/pdf/2005.10698.pdf)**good new approach**

  - Robin Hirt, et al.
  - Code not yet.

- [The Hybrid Forecasting Method SVR-ESAR for Covid-19](https://www.medrxiv.org/content/medrxiv/early/2020/05/22/2020.05.20.20103200.full.pdf)

  - Juan Frausto Solis, et al.
  - Code not yet.

- [Forecasting the Short-Term Metro Ridership With Seasonal and Trend Decomposition Using Loess and LSTM Neural Networks](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=9094173)

  - DEWANG CHEN, et al.
  - Code not yet.

- [The Effectiveness of Discretization in Forecasting: An Empirical Study on Neural Time Series Models](https://arxiv.org/pdf/2005.10111.pdf)

  - Stephan Rabanser, et al.
  - `AWS AI Labs`
  - Code not yet.

- [FORECASTING WITH SKTIME: DESIGNING SKTIME’S NEW FORECASTING API AND APPLYING IT TO REPLICATE AND EXTEND THE M4 STUDY](https://arxiv.org/pdf/2005.08067.pdf)

  - Markus Löning and Franz J. Király.
  - [[Code](https://github.com/sktime/sktime-dl)]

- [LSTM-MSNet: Leveraging Forecasts on Sets of Related Time Series with Multiple Seasonal Patterns](https://arxiv.org/pdf/1909.04293.pdf)

  - Kasun Bandara, et al.
  - [[Code](https://github.com/kasungayan/LSTMMSNet)]

- [A NETWORK-BASED TRANSFER LEARNING APPROACH TO IMPROVE SALES FORECASTING OF NEW PRODUCTS](https://arxiv.org/pdf/2005.06978.pdf)

  - Karb, Tristan, et al.
  - Code not yet.

- [DSANet: Dual Self-Attention Network for Multivariate Time Series Forecasting](https://dl.acm.org/doi/10.1145/3357384.3358132) **Good new approach**

  - Siteng Huang, et al.
  - [[Code](https://github.com/bighuang624/DSANet)]

- [An Approach for Complex Event Streams Processing and Forecasting](https://fruct.org/publications/fruct26/files/Moro.pdf)

  - Viktor Morozov, Mikhail Petrovskiy.
  - Code not yet.

- [Knowledge Enhanced Neural Fashion Trend Forecasting](https://arxiv.org/pdf/2005.03297.pdf)

  - Yunshan Ma, et al.
  - Code not yet.

- [Augmented Out-of-Sample Comparison Method for Time Series Forecasting Techniques](https://link.springer.com/chapter/10.1007/978-3-030-47358-7_30)

  - Igor Ilic, et al.
  - Code not yet.

- [Enhancing High Frequency Technical Indicators Forecasting Using Shrinking Deep Neural Networks](https://ieeexplore.ieee.org/abstract/document/9081393) `ICIM 2020`

  - Xiaoyu Tan, et al.
  - Code not yet.

- [Time Series Forecasting With Deep Learning: A Survey](https://arxiv.org/pdf/2004.13408.pdf) **Good summary**

  - Bryan Lim and Stefan Zohren
  - Survey

- [Neural forecasting: Introduction and literature overview](https://arxiv.org/pdf/2004.10240.pdf)

   - Konstantinos Benidis, et al.
   - Not is a overview.

- [Take a NAP: Non-Autoregressive Prediction for Pedestrian Trajectories](https://arxiv.org/pdf/2004.09760.pdf)

   - Hao Xue, et al.
   - Code not yet.

- [Orbit: Probabilistic Forecast with Exponential Smoothing](https://arxiv.org/pdf/2004.08492.pdf)

   - Edwin Ng, et a.
   - Code is available upon request.

- [Daily retail demand forecasting using machine learning with emphasis on calendric special days](https://www.sciencedirect.com/science/article/abs/pii/S0169207020300224)

   - Jakob Huber and Heiner Stuckenschmidt.
   - Code not yet.

- [FORECASTING IN MULTIVARIATE IRREGULARLY SAMPLED TIME SERIES WITH MISSING VALUES](https://arxiv.org/pdf/2004.03398.pdf)

   - Shivam Srivastava, et al.
   - Code not yet.
   - **IBM Almaden Research Center**.

- [Multi-label Prediction in Time Series Data using Deep Neural Networks](https://arxiv.org/pdf/2001.10098.pdf)

   - Wenyu Zhang, et al.
   - Code not yet.

- [TraDE: Transformers for Density Estimation](https://arxiv.org/pdf/2004.02441.pdf)

   - Rasool Fakoor, et al.
   - Code not yet.

- [Deep Probabilistic Modelling of Price Movements for High-Frequency Trading](https://arxiv.org/pdf/2004.01498.pdf)

   - Ye-Sheen Lim and Denise Gorse.
   - Code not yet.

- [Deep State Space Models for Nonlinear System Identification](https://arxiv.org/pdf/2003.14162.pdf)

   - Daniel Gedon, et al.
   - Code not yet.

- [Zero-shot and few-shot time series forecasting with ordinal regression recurrent neural networks](https://arxiv.org/pdf/2003.12162.pdf)

   - Bernardo Perez Orozco and  Stephen J. Roberts.
   - [[Code](https://github.com/bperezorozco/ordinal_tsf)]

- [Financial Time Series Representation Learning](https://arxiv.org/pdf/2003.12194.pdf)

   - Philippe Chatigny, et al.
   - Code not yet.

- [G-Net: A Deep Learning Approach to G-computation for Counterfactual Outcome Prediction Under Dynamic Treatment Regimes](https://arxiv.org/pdf/2003.10551.pdf)

  - Rui Li, et al.
  - - ```IBM research and MIT```
  - Code not yet.

- [Deep Markov Spatio-Temporal Factorization](https://arxiv.org/pdf/2003.09779.pdf)

  - Amirreza Farnoosh, et al.
  - Code not yet.

- [Harmonic Recurrent Process for Time Series Forecasting](https://cs.nju.edu.cn/zhouzh/zhouzh.files/publication/ecai20hr.pdf)

  - Shao-Qun Zhang and Zhi-Hua Zhou.
  - Code not yet.

- [Elastic Machine Learning Algorithms in Amazon SageMaker](https://ssc.io/pdf/modin711s.pdf)

  - Edo Liberty, et al.
  - Code not yet.

- [Time Series Data Augmentation for Deep Learning: A Survey](https://arxiv.org/pdf/2002.12478.pdf)

  - Qingsong Wen, et al.
  - Code not yet.

- [Block Hankel Tensor ARIMA for Multiple Short Time Series Forecasting](https://arxiv.org/pdf/2002.12135.pdf)```AAAI 2020```**meta-learning**

  - QIQUAN SHI, et al.
  - [[Code](https://github.com/huawei-noah/BHT-ARIMA)]

- [Learnings from Kaggle's Forecasting Competitions](https://www.researchgate.net/publication/339362837_Learnings_from_Kaggle's_Forecasting_Competitions)

  - Casper Solheim Bojer, et al.
  - Code not yet.

- [An Industry Case of Large-Scale Demand Forecasting of Hierarchical Components](https://ieeexplore.ieee.org/abstract/document/8999262)

  - Rodrigo Rivera-Castro, et al.
  - Code not yet.

- [Multi-variate Probabilistic Time Series Forecasting via Conditioned Normalizing Flows](https://arxiv.org/pdf/2002.06103.pdf)

  - Kashif Rasul, et al.
  - [[Code](https://github.com/zalandoresearch/pytorch-ts)].

- [ForecastNet: A Time-Variant Deep Feed-Forward Neural Network Architecture for Multi-Step-Ahead Time-Series Forecasting](https://arxiv.org/pdf/2002.04155.pdf)

  - Joel Janek Dabrowski, et al.
  - Code not yet.

- [Anomaly detection for Cybersecurity: time series forecasting and deep learning](https://pdfs.semanticscholar.org/810b/dfa0f63f03473be79556b90dc79a88a1f769.pdf)`Good review about forecasting`

  - Giordano Colò.
  - Code not yet.

- [Event-Driven Continuous Time Bayesian Networks](https://krvarshney.github.io/pubs/BhattacharjyaSGMVS_aaai2020.pdf)

  - Debarun Bhattacharjya, et al.
  - `Research AI, IBM`
  - Code not yet.

- [Joint Modeling of Local and Global Temporal Dynamics for Multivariate Time Series Forecasting with Missing Values](https://arxiv.org/pdf/1911.10273.pdf)```AAAI 2020```

  - Xianfeng Tang, et al.
  - ```IBM Research, NY```
  - Code not yet.

- [Topology-Based Clusterwise Regression for User Segmentation and Demand Forecasting](https://ieeexplore.ieee.org/abstract/document/8964133)

  - Rodrigo Rivera-Castro, et al.
  - Code not yet.

- [Evolutionary LSTM-FCN networks for pattern classification in industrial processes](https://www.sciencedirect.com/science/article/abs/pii/S2210650219301270)

  - Patxi Ortego, et al.
  - Code not yet.

- [Forecasting Multivariate Time-Series Data Using LSTM and Mini-Batches](https://rd.springer.com/chapter/10.1007/978-3-030-37309-2_10)

  - Athar Khodabakhsh, et al.
  - Code not yet.

- [Tensorized LSTM with Adaptive Shared Memory for Learning Trends in Multivariate Time Series](https://faculty.ist.psu.edu/xzz89/publications/AAAI20.pdf)```AAAI 2020```

  - Dongkuan Xu, et al.
  - [[Code](https://github.com/DerronXu/DeepTrends/tree/master)]

- **[RELATIONAL STATE-SPACE MODEL FOR STOCHASTIC MULTI-OBJECT SYSTEMS](https://arxiv.org/pdf/2001.04050.pdf)**```ICLR 2020```

  - Fan Yang, et al.
  - Code not yet.

- [For2For: Learning to forecast from forecasts](https://arxiv.org/pdf/2001.04601.pdf)

  - Zhao, Shi, et al.
  - Code not yet.

- [Self-boosted Time-series Forecasting with Multi-task and Multi-view Learning](https://arxiv.org/pdf/1909.08181.pdf) `AAAI 2020`

  - Long H. Nguyen, et al.
  - Code not yet

### 2019

- [Enhancing the Locality and Breaking the Memory Bottleneck of Transformer on Time Series Forecasting](https://www.aminer.cn/pub/5db9297a47c8f766461f7974/enhancing-the-locality-and-breaking-the-memory-bottleneck-of-transformer-on-time?anchor=conclusion) **Reference**

  - Shiyang Li, et al.
  - [[Code](https://github.com/mlpotter/Transformer_Time_Series)]

- [Forecasting Big Time Series: Theory and Practice](https://dl.acm.org/doi/pdf/10.1145/3292500.3332289)`KDD 2019` **Relevant tutorial**

  - Christos Faloutsos, et al.
  - [[Code](https://lovvge.github.io/Forecasting-Tutorial-KDD-2019/)]

- [Deep Uncertainty Quantification: A Machine Learning Approach for Weather Forecasting](http://urban-computing.com/pdf/kdd19-BinWang.pdf)

  - Bin Wang, et al.
  - [[Code](https://github.com/BruceBinBoxing/Deep_Learning_Weather_Forecasting)]

- [A hybrid method of exponential smoothing and recurrent neural networks for time series forecasting](https://www.researchgate.net/publication/334556784_A_hybrid_method_of_exponential_smoothing_and_recurrent_neural_networks_for_time_series_forecasting)

  - Slawek Smyl
  - `Winning submission of the M4 forecasting competition`
  - [[Code](https://github.com/Mcompetitions/M4-methods/tree/slaweks_ES-RNN/118%20-%20slaweks17)]

- [Think Globally, Act Locally: A Deep Neural Network Approach to High-Dimensional Time Series Forecasting](https://arxiv.org/pdf/1905.03806.pdf)`NeurIPS 2019`

  - Rajat Sen, et al.
  - `Amazon`
  - [[Code](https://github.com/rajatsen91/deepglo)]

- [Deep Landscape Forecasting for Real-time Bidding Advertising](https://arxiv.org/abs/1905.03028) `KDD 2019`

  - Kan Ren, et al.
  - [[Code](https://github.com/rk2900/DLF)]

- [Similarity Preserving Representation Learning for Time Series Clustering](https://arxiv.org/pdf/1702.03584.pdf)

  - Qi Lei, et al.
  - ```IBM research```
  - [[Code](https://github.com/cecilialeiqi/SPIRAL)]

- [DSANet: Dual Self-Attention Network for Multivariate Time Series Forecasting](https://dl.acm.org/doi/abs/10.1145/3357384.3358132)

  - Siteng Huang, et al.
  - Code not yet.

- [Enhancing Time Series Momentum Strategies Using Deep Neural Networks](https://arxiv.org/pdf/1904.04912.pdf)

  - Bryan Lim, et al.
  - Code not yet.

- [DYNAMIC TIME LAG REGRESSION: PREDICTING WHAT & WHEN](https://hal.inria.fr/hal-02422148/document)

  - Mandar Chandorkar, et al.
  - Code not yet.

- [Time-series Generative Adversarial Networks](https://papers.nips.cc/paper/8789-time-series-generative-adversarial-networks.pdf)`NeurIPS 2019`

  - Jinsung Yoon. et al.
  - Code not yet.

- [Temporal Fusion Transformers for Interpretable Multi-horizon Time Series Forecasting](https://arxiv.org/pdf/1912.09363.pdf)

  - Bryan Lim, et al.
  - ```Google Research```
  - [[Code](https://github.com/google-research/google-research/tree/master/tft)]


- [Deep Amortized Variational Inference for Multivariate Time Series Imputation with Latent Gaussian Process Models](https://openreview.net/pdf?id=H1xXYy3VKr)

  - Vincent Fortuin, et al.
  - Code not yet.

- [Deep Physiological State Space Model for Clinical Forecasting](https://arxiv.org/pdf/1912.01762.pdf)

  - Yuan Xue, et al.
  - not yet

- [AR-Net: A simple Auto-Regressive Neural Network for time-series](https://arxiv.org/abs/1911.12436)

  - Oskar Triebe, et al.
  -  ```Facebook Research```
  - Code not yet.

- [Learning Time-series Data of Industrial Design Optimization using Recurrent Neural Networks](https://ecole-itn.eu/wp-content/uploads/2019/11/LMID_Sneha_finalversion.pdf)

  - Sneha Saha, et al.
  - ```Honda Research Institute Europe GmbH```
  - Code not yet.


- [RobustSTL: A Robust Seasonal-Trend Decomposition Algorithm for Long Time Series](https://arxiv.org/abs/1812.01767)

  - Qingsong Wen, et al.
  - [[Code](https://github.com/LeeDoYup/RobustSTL)]

- [Constructing Gradient Controllable Recurrent Neural Networks Using Hamiltonian Dynamics](https://arxiv.org/pdf/1911.05035.pdf)

  - Konstantin Rusch, et al.
  - Code not yet.

- [SOM-VAE: Interpretable Discrete Representation Learning on Time Series](https://openreview.net/pdf?id=rygjcsR9Y7)`ICLR 2019`

  - Vincent Fortuin, et al.
  - [[Code](https://github.com/ratschlab/SOM-VAE)]

- [Unsupervised Scalable Representation Learning for Multivariate Time Series](https://arxiv.org/abs/1901.10738)`NeurIPS 2019`  [In Applications -- Time Series Analysis ](https://nips.cc/Conferences/2019/Schedule?showParentSession=15627)

  - Jean-Yves Franceschi, et al.
  - [[Code](https://github.com/White-Link/UnsupervisedScalableRepresentationLearningTimeSeries)]

- [Factorized Inference in Deep Markov Models for Incomplete Multimodal Time Series](https://arxiv.org/pdf/1905.13570v1.pdf)

  - Zhi-Xuan Tan, et al.
  - Code not yet.

- [You May Not Need Order in Time Series Forecasting](https://arxiv.org/pdf/1910.09620.pdf)

  - Yunkai Zhang, et al.
  - Code not yet

  <p align="center">
  <img src="https://github.com/Alro10/deep-learning-time-series/blob/master/YMN_order.png" alt="alt text" width="80%" height="60%">
  </p>

- [Shape and Time Distortion Loss for Training Deep Time Series Forecasting Models](https://arxiv.org/pdf/1909.09020.pdf)`NeurIPS2019`

  - Vincent Le Guen and Nicolas Thome.
  - [[Code](https://github.com/vincent-leguen/STDL)]

- [Dynamic Local Regret for Non-convex Online Forecasting](https://arxiv.org/pdf/1910.07927.pdf)`NeurIPS 2019`

  - Sergul Aydore, et al.
  - [[Code](https://github.com/Timbasa/Dynamic_Local_Regret_for_Non-convex_Online_Forecasting_NeurIPS2019)]

- [Bayesian Temporal Factorization for Multidimensional Time Series Prediction](https://arxiv.org/pdf/1910.06366.pdf)

  - Xinyu Chen, and Lijun Sun
  - [[Code and data](https://github.com/xinychen/transdim)]

- [Probabilistic sequential matrix factorization](https://arxiv.org/pdf/1910.03906.pdf)

  - Ömer Deniz Akyildiz, et al.
  - Code not yet

- [Sequential VAE-LSTM for Anomaly Detection on Time Series](https://arxiv.org/pdf/1910.03818.pdf)

  - Run-Qing Chen, et al.
  - Code not yet

- [High-Dimensional Multivariate Forecasting with Low-Rank Gaussian Copula Processes](https://arxiv.org/pdf/1910.03002.pdf)`NeurIPS 2019`

  - David Salinas, et al.
  - Code not yet

- [Recurrent Neural Filters: Learning Independent Bayesian Filtering Steps for Time Series Prediction](https://arxiv.org/pdf/1901.08096.pdf)

  - Bryan Lim, et al.
  - Code not yet

- [LHCnn: A Novel Efficient Multivariate Time Series Prediction Framework Utilizing Convolutional Neural Networks](https://ieeexplore.ieee.org/abstract/document/8855402)

  - Chengxi Liu, et al.
  - Code not yet

- [SKTIME: A UNIFIED INTERFACE FOR MACHINE LEARNING WITH TIME SERIE](https://arxiv.org/pdf/1909.07872.pdf)

  - [[Code](https://github.com/alan-turing-institute/sktime)]


- **[Recurrent Neural Networks for Time Series Forecasting: Current Status and Future Directions](https://arxiv.org/pdf/1909.00590.pdf)**

  - [[Code](https://github.com/HansikaPH/time-series-forecasting)]

- [Evaluation of statistical and machine learning models for time series prediction: Identifying the state-of-the-art and the best conditions for the use of each model](https://www.researchgate.net/profile/Antonio_Parmezan/publication/330742498_Evaluation_of_statistical_and_machine_learning_models_for_time_series_prediction_Identifying_the_state-of-the-art_and_the_best_conditions_for_the_use_of_each_model/links/5c558145a6fdccd6b5dc3e2e/Evaluation-of-statistical-and-machine-learning-models-for-time-series-prediction-Identifying-the-state-of-the-art-and-the-best-conditions-for-the-use-of-each-model.pdf)

   - Antonio Rafael Sabino Parmezan, Vinicius M. A. Souza and Gustavo E. A. P. A. Batista. USP


- [Explainable Deep Neural Networks for Multivariate Time Series Predictions](https://www.ijcai.org/proceedings/2019/0932.pdf) `IJCAI 2019`

  - Roy Assaf and Anika Schumann.
  - ```IBM Research, Zurich```
  - Code not yet


- [Outlier Detection for Time Series with Recurrent Autoencoder Ensembles](https://www.ijcai.org/proceedings/2019/0378.pdf) `IJCAI 2019`

  - [[Code](https://github.com/tungk/OED)]

- [Learning Interpretable Deep State Space Model for Probabilistic Time Series Forecasting](https://www.ijcai.org/proceedings/2019/0402.pdf) `IJCAI 2019`

  - Code not yet

- [Deep Factors for Forecasting](https://arxiv.org/pdf/1905.12417.pdf) `ICML 2019`

  - Yuyang Wang, et al.
  - Code not yet

- [Probabilistic Forecasting with Spline Quantile Function RNNs](http://proceedings.mlr.press/v89/gasthaus19a/gasthaus19a.pdf)

  - Code not yet

- [Deep learning for time series classification: a review](https://arxiv.org/abs/1809.04356)

  - Code not yet

- [Multivariate LSTM-FCNs for Time Series Classification](https://arxiv.org/abs/1801.04503)

  - Code not yet

- [Criteria for classifying forecasting methods](https://www.sciencedirect.com/science/article/pii/S0169207019301529)

  - Code not yet

- [GluonTS: Probabilistic Time Series Models in Python](https://arxiv.org/abs/1906.05264)

   - [[Code](https://gluon-ts.mxnet.io)]

- [DeepAR: Probabilistic Forecasting with Autoregressive Recurrent Networks](https://arxiv.org/abs/1704.04110)

  - David Salinas, et al.
  - Code not yet

### 2018

- [An overview and comparative analysis of Recurrent Neural Networks for Short Term Load Forecasting](https://arxiv.org/pdf/1705.04378.pdf)

  - Filippo Maria Bianchi, et al.
  - Code not yet.

- [Statistical and Machine Learning forecasting methods: Concerns and ways forward](https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0194889)

  - Spyros Makridakis, et al.
  - Code not yet.

- [Attend and Diagnose: Clinical Time Series Analysis Using Attention Models](https://www.aaai.org/ocs/index.php/AAAI/AAAI18/paper/viewFile/16325/16790) `AAAI 2018`

  - Huan Song, Deepta Rajan, et al.
  - not yet.

- [Precision and Recall for Time Series](http://papers.nips.cc/paper/7462-precision-and-recall-for-time-series) `NeurIPS2018`

  - Nesime Tatbul, et al.
  - Code not yet.

- [Deep State Space Models for Time Series Forecasting](https://papers.nips.cc/paper/8004-deep-state-space-models-for-time-series-forecasting.pdf) `NeurIPS2018`

  - Code not yet

- [Deep Factors with Gaussian Processes for Forecasting](https://arxiv.org/abs/1812.00098)

  - `Third workshop on Bayesian Deep Learning (NeurIPS 2018)`
  - [[Code](https://aws.amazon.com/blogs/machine-learning/now-available-in-amazon-sagemaker-deepar-algorithm-for-more-accurate-time-series-forecasting/)]

- [DIFFUSION CONVOLUTIONAL RECURRENT NEURAL NETWORK: DATA-DRIVEN TRAFFIC FORECASTING](https://arxiv.org/pdf/1707.01926.pdf)`ICLR 2018`

  - Yaguang Li, et al.
  - [[Code](https://github.com/liyaguang/DCRNN)]

- [DEEP TEMPORAL CLUSTERING: FULLY UNSUPERVISED LEARNING OF TIME-DOMAIN FEATURES](https://arxiv.org/pdf/1802.01059.pdf)

  - Naveen Sai Madiraju, et al.
  - [[Code-unofficial implementation ](https://github.com/FlorentF9/DeepTemporalClustering)]

- [Modeling Long- and Short-Term Temporal Patterns with Deep Neural Networks](https://arxiv.org/pdf/1703.07015.pdf)

  - Guokun Lai, Wei-Cheng Chang, Yiming Yang, Hanxiao Liu
  - [[Code](https://github.com/laiguokun/LSTNet)]

- [Forecasting Treatment Responses Over Time Using Recurrent Marginal Structural Networks](http://papers.nips.cc/paper/7977-forecasting-treatment-responses-over-time-using-recurrent-marginal-structural-networks.pdf) `NeurIPS 2018`

  - Bryan Lim. et al.
  - [Code](https://github.com/sjblim/rmsn_nips_2018)

- [A Memory-Network Based Solution for Multivariate Time-Series Forecasting](https://arxiv.org/pdf/1809.02105.pdf)

  - Yen-Yu Chang, et al.
  - [Code-unofficial implementation](https://github.com/Maple728/MTNet)]

### 2017

- [Deep learning with long short-term memory networks for financial market predictions](https://www.econstor.eu/bitstream/10419/157808/1/886576210.pdf)

  - Fischer, Thomas and Krauss, Christopher.
  - Code not yet.

- [Discriminative State-Space Models](https://papers.nips.cc/paper/7150-discriminative-state-space-models.pdf)`NIPS 2017`

  - Vitaly Kuznetsov and Mehryar Mohri.
  - Code not yet.

- [Hybrid Neural Networks for Learning the Trend in Time Series](https://www.ijcai.org/Proceedings/2017/0316.pdf)**review**

  - Tao Lin, et al.
  - Code not yet.

### 2016

- [Data Preprocessing and Augmentation for Multiple Short Time Series Forecasting with Recurrent Neural Networks](https://www.researchgate.net/publication/309385800_Data_Preprocessing_and_Augmentation_for_Multiple_Short_Time_Series_Forecasting_with_Recurrent_Neural_Networks)

   - Slawek Smyl and Karthik Kuber
   - Code not yet.

- [Temporal Regularized Matrix Factorization for High-dimensional Time Series Prediction](https://papers.nips.cc/paper/6160-temporal-regularized-matrix-factorization-for-high-dimensional-time-series-prediction)`NIPS 2016`

  - Hsiang-Fu Yu, et al.
  - [[Code](https://github.com/rofuyu/exp-trmf-nips16)]

- [Time Series Prediction and Online Learning](http://proceedings.mlr.press/v49/kuznetsov16.pdf)`JMLR 2016`

  - Vitaly Kuznetsov and Mehryar Mohri.
  - Code not yet.

- [Deep neural networks, gradient-boosted trees, random forests: Statistical arbitrage on the S&P 500](https://ideas.repec.org/p/zbw/iwqwdp/032016.html)

  - Krauss, Christopher, et al.
  - Code not yet.

### Comparative: Classical methods vs Deep Learning methods

- [Forecasting economic and financial time series: ARIMA VS. LSTM](https://arxiv.org/pdf/1803.06386.pdf)

- [A comparative study between LSTM and ARIMA for sales forecasting in retail](https://pdfs.semanticscholar.org/e58c/7343ea25d05f6d859d66d6bb7fb91ecf9c2f.pdf)

- [ARIMA/SARIMA vs LSTM with Ensemble learning Insights for Time Series Data](https://towardsdatascience.com/arima-sarima-vs-lstm-with-ensemble-learning-insights-for-time-series-data-509a5d87f20a)


## Conferences

- Machine learning
   * [NeurIPS](https://nips.cc/)
   * [ICML](https://icml.cc/)
   * [ICLR](https://iclr.cc/)

- Artificial intelligence
   * [AAAI](https://www.aaai.org/)
   * [AISTATS](https://www.aistats.org/)
   * [ICANN](https://e-nns.org/icann2019/)
   * [IJCAI](https://www.ijcai.org/)
   * [UAI](http://www.auai.org/)

## Competitions

- [M5 Competition](https://mofc.unic.ac.cy/m5-competition/)
- [M4 Competition](https://github.com/Mcompetitions/M4-methods)

## Code

- [Notebooks](https://github.com/Alro10/deep-learning-time-series/tree/master/notebooks)
- [Code]()

## Theory-Resource

- [Time Series Forecasting Best Practices & Examples from Microsoft](https://github.com/microsoft/forecasting)

- [Attention-for-time-series-classification-and-forecasting](https://towardsdatascience.com/attention-for-time-series-classification-and-forecasting-261723e0006d)

- [Deep learning for high dimensional time series-blog](https://towardsdatascience.com/deep-learning-for-high-dimensional-time-series-7a72b033a7e0)

- [Deep Learning AI-Optimization](https://deeplearning.ai/ai-notes/optimization/)

- [Backpropagation for LSTM](https://towardsdatascience.com/back-to-basics-deriving-back-propagation-on-simple-rnn-lstm-feat-aidan-gomez-c7f286ba973d)

- [Stock Market Prediction by Recurrent Neural Network on LSTM Model](https://blog.usejournal.com/stock-market-prediction-by-recurrent-neural-network-on-lstm-model-56de700bff68)

- [Decoupling Hierarchical Recurrent Neural Networks With Locally Computable Losses](https://arxiv.org/pdf/1910.05245.pdf)

- [Time Series Analysis with Deep Learning : Simplified](https://towardsdatascience.com/time-series-analysis-with-deep-learning-simplified-5c444315d773)

- [ML techniques applied to stock prices](https://towardsdatascience.com/machine-learning-techniques-applied-to-stock-price-prediction-6c1994da8001)

- [Forecasting: Principles and Practice: Slides](https://github.com/robjhyndman/ETC3550Slides)**Good material**

## Code-Resource

- [Transformer Time Series Prediction](https://github.com/oliverguhr/transformer-time-series-prediction)

- [DeepSeries: Deep Learning Models for time series prediction.](https://github.com/EvilPsyCHo/Deep-Time-Series-Prediction)

- [varstan: An R package for Bayesian analysis of structured time series models with Stan](https://arxiv.org/pdf/2005.10361.pdf)

- [Time-series Generative Adversarial Networks: tsgan](https://github.com/firmai/tsgan)

- [Deep4cast: Forecasting for Decision Making under Uncertainty](https://github.com/MSRDL/Deep4Cast)

- [fireTS: sklean style package for multi-variate time-series prediction.](https://github.com/jxx123/fireTS)

- [EpiSoon: Forecasting the effective reproduction number over short timescales](https://github.com/epiforecasts/EpiSoon)

- [Electric Load Forecasting](https://github.com/pyaf/load_forecasting): Load forecasting on Delhi area electric power load using ARIMA, RNN, LSTM and GRU models.

- [Time Series and Forecasting in R](https://github.com/rstudio-conf-2020/time-series-forecasting)

- [TimeseriesAI](https://github.com/timeseriesAI/timeseriesAI): Practical Deep Learning for Time Series / Sequential Data using fastai/ Pytorch.

- [TimescaleDB](https://github.com/timescale/timescaledb): An open-source time-series SQL database optimized for fast ingest and complex queries. Packaged as a PostgreSQL extension.

- [TSstudio: Tools for time series analysis and forecasting ](https://github.com/RamiKrispin/TSstudio)

- [Prophet: Automatic Forecasting Procedure](https://github.com/facebook/prophet)

- [pyts: a Python package for time series classification](https://github.com/johannfaouzi/pyts)

- [Using attentive neural processes for forecasting power usage](https://github.com/wassname/attentive-neural-processes)

- [Non-Gaussian forecasting using fable - R](https://robjhyndman.com/hyndsight/fable2/)

- [SKTIME](https://github.com/alan-turing-institute/sktime)

- [Papers with code - Multivariate time series forecasting](https://paperswithcode.com/task/multivariate-time-series-forecasting)

- [DeepAR by Amazon](https://docs.aws.amazon.com/sagemaker/latest/dg/deepar.html)

- [DFGP by Amazon](https://aws.amazon.com/blogs/machine-learning/now-available-in-amazon-sagemaker-deepar-algorithm-for-more-accurate-time-series-forecasting/)

- https://www.kaggle.com/c/demand-forecasting-kernels-only

- https://www.kaggle.com/c/favorita-grocery-sales-forecasting

- https://www.kaggle.com/c/grupo-bimbo-inventory-demand

- https://www.kaggle.com/c/recruit-restaurant-visitor-forecasting

- [Predicting/hypothesizing the findings of the M4 Competition](https://www.sciencedirect.com/science/article/pii/S0169207019301098)

- [pytorch-forecasting](https://github.com/jdb78/pytorch-forecasting): A Python package for time series forecasting with PyTorch. It includes state-of-the-art network architectures

## Datasets

- [A curated list of awesome time series databases](https://github.com/xephonhq/awesome-time-series-database)

- [Electricity dataset from UCI](https://archive.ics.uci.edu/ml/datasets/ElectricityLoadDiagrams20112014)

- [Traffic dataset from UCI](https://archive.ics.uci.edu/ml/datasets/PEMS-SF)

- [Air quality from UCI](http://archive.ics.uci.edu/ml/datasets/Air+Quality)

- [Seattle freeway traffic speed](https://github.com/zhiyongc/Seattle-Loop-Data)

- [Kaggle-Web Traffic Time Series Forecasting](https://www.kaggle.com/c/web-traffic-time-series-forecasting)
